/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexItemsInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractRPTItemDiffIndexControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RPTItemDiffIndexControllerBean
extends AbstractRPTItemDiffIndexControllerBean {
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        this.constructor((RPTItemDiffIndexInfo)model, ctx);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        this.constructor((RPTItemDiffIndexInfo)model, ctx);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, model);
        this.constructor((RPTItemDiffIndexInfo)model, ctx);
        this.modifyFormulaDispense(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    private void modifyFormulaDispense(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        StringBuffer oql1 = new StringBuffer();
        oql1.append("update t_csl_formulaDispense set flastUpdateUserID = '");
        oql1.append(ctx.getCaller().toString());
        oql1.append("' , FLastUpdateTime = Timestamp'");
        oql1.append(CslRptUtil.getTime());
        oql1.append("' where fdiffindexid = '");
        oql1.append(pk.toString());
        oql1.append("'");
        DbUtil.execute((Context)ctx, (String)oql1.toString());
    }

    private void constructor(RPTItemDiffIndexInfo info, Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> data;
        String formula = info.getFormula();
        ArrayList itemList = new ArrayList();
        String tempStr = null;
        String dnumber = null;
        String str = null;
        String curYear = null;
        String curPeriod = null;
        RPTItemDiffIndexItemsInfo itemInfo = null;
        String pattern = "Item\\([^\\s^\\)]{1,}\\)|DItem\\([^\\s^\\)]{1,}\\)";
        Pattern patt = Pattern.compile(pattern);
        boolean isDItem = false;
        ArrayList<String> items = new ArrayList<String>();
        Matcher matcher = patt.matcher(formula);
        while (matcher.find()) {
            items.add(matcher.group());
        }
        int length = items.size();
        for (int i = 0; i < length; ++i) {
            String itemFormula = (String)items.get(i);
            isDItem = itemFormula.indexOf("DItem") >= 0;
            String[] s = itemFormula.split(",");
            if (isDItem) {
                if (s.length != 6) {
                    throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"274_RPTItemDiffIndexControllerBean", (Locale)ctx.getOriginLocale())));
                }
                itemFormula = itemFormula.substring(6, itemFormula.length() - 1);
                s = itemFormula.split(",");
                tempStr = s[0];
                dnumber = s[1];
                curYear = s[2];
                curPeriod = s[3];
            } else {
                if (s.length != 5) {
                    throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"274_RPTItemDiffIndexControllerBean", (Locale)ctx.getOriginLocale())));
                }
                itemFormula = itemFormula.substring(5, itemFormula.length() - 1);
                s = itemFormula.split(",");
                tempStr = s[0];
                curYear = s[1];
                curPeriod = s[2];
            }
            str = tempStr.substring(1, tempStr.length() - 1).trim();
            if (isDItem && dnumber != null) {
                dnumber = dnumber.substring(1, dnumber.length() - 1).trim();
            }
            if (!curYear.toString().equals("0") || !curPeriod.toString().equals("0")) continue;
            data = new HashMap<String, String>(4);
            data.put("item", str);
            data.put("ditem", dnumber);
            if (itemList.contains(data)) continue;
            itemList.add(data);
        }
        String oql = null;
        IRPTItem irptItem = RPTItemFactory.getLocalInstance(ctx);
        info.getItems().clear();
        for (int j = 0; j < itemList.size(); ++j) {
            itemInfo = new RPTItemDiffIndexItemsInfo();
            data = (HashMap<String, String>)itemList.get(j);
            oql = "SELECT id WHERE number = '" + data.get("item") + "'";
            if (!irptItem.exists(oql)) continue;
            itemInfo.setItem(irptItem.getRPTItemInfo(oql));
            itemInfo.setDynaItem((String)data.get("ditem"));
            info.getItems().add(itemInfo);
        }
    }

    @Override
    protected void _freezeItem(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        RPTItemDiffIndexInfo info = (RPTItemDiffIndexInfo)this.getValue(ctx, id);
        info.setIsFreezed(true);
        this.update(ctx, id, (CoreBaseInfo)info);
    }

    @Override
    protected void _unFreezeItem(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        RPTItemDiffIndexInfo info = (RPTItemDiffIndexInfo)this.getValue(ctx, id);
        info.setIsFreezed(false);
        this.update(ctx, id, (CoreBaseInfo)info);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RPTItemDiffIndexInfo info = this.getRPTItemDiffIndexInfo(ctx, pk);
        return info.getNumber() + " " + info.getName();
    }

    private void addnewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
    }

    private void updateCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        RPTItemDiffIndexInfo dataBaseInfo = (RPTItemDiffIndexInfo)info;
        EntityViewInfo view = this.buildIsNumExistView(dataBaseInfo);
        RPTItemDiffIndexCollection rptItemDiffIndexCollection = this.getRPTItemDiffIndexCollection(ctx, view);
        if (rptItemDiffIndexCollection.size() > 0) {
            RPTItemDiffIndexInfo infoInDB = rptItemDiffIndexCollection.get(0);
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{infoInDB.getNumber(), infoInDB.getTrackRecordCreator().getName()});
        }
    }

    private EntityViewInfo buildIsNumExistView(RPTItemDiffIndexInfo dataBaseInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("trackRecordCreator.name"));
        coll.add(new SelectorItemInfo("number"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select number where id = '");
        oql.append(pk.toString());
        oql.append("'");
        RPTItemDiffIndexInfo info = RPTItemDiffIndexFactory.getLocalInstance(ctx).getRPTItemDiffIndexInfo(oql.toString());
        String number = info.getNumber();
        super._delete(ctx, pk);
        StringBuffer oql1 = new StringBuffer();
        oql1.append("delete from t_csl_formulaDispense where FFormulaNumber = '");
        oql1.append(StringUtil.replaceAll(number, "'", "''"));
        oql1.append("' and FFormulaType = ");
        oql1.append(2);
        DbUtil.execute((Context)ctx, (String)oql1.toString());
    }

    @Override
    protected void _updateMaintainCU(Context ctx, String id, String cuId) throws BOSException, EASBizException {
        String sql = "update T_CSL_ItemDiffIndex set FMaintainCUId = ? where FId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{cuId, id});
    }
}

