/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.IReportClass;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassCollection;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractReportClassControllerBean;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class ReportClassControllerBean
extends AbstractReportClassControllerBean {
    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemInfo sorter = new SorterItemInfo("number");
        sorter.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorter);
        return super._getCollection(ctx, svcCtx, viewInfo);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (ReportClassInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (ReportClassInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    private void addnewCheck(Context ctx, ReportClassInfo model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, (IObjectValue)model);
        this._checkNumberDup(ctx, (IObjectValue)model);
        this._checkNameBlank(ctx, (IObjectValue)model);
        this._checkNameDup(ctx, (IObjectValue)model);
    }

    private void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this.numberCanUpdate(ctx, pk, model);
        this._checkNameDup(ctx, model);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void numberCanUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ReportClassInfo info = (ReportClassInfo)model;
        IRowSet rs = null;
        StringBuffer sbSQL = new StringBuffer();
        ArrayList<String> lstParams = new ArrayList<String>();
        sbSQL.append("SELECT Count(*) cnt \r\n").append("FROM T_CSL_RptItem \r\n").append("WHERE FReportClassID = ? ");
        lstParams.add(pk.toString());
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])lstParams.toArray());
            while (rs.next()) {
                if (rs.getInt("cnt") <= 0) continue;
                sbSQL.delete(0, sbSQL.length());
                sbSQL.append("SELECT FNumber fNumber \r\n").append("FROM T_CSL_ReportClass \r\n").append("WHERE FID = ? \r\n");
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])lstParams.toArray());
                    while (rs.next()) {
                        String s = rs.getString("fNumber");
                        if (s.equals(info.getNumber())) continue;
                        throw new ServerException(ServerException.NUMBER_CAN_NOT_UPDATE);
                    }
                }
                catch (SQLException e1) {
                    throw new SQLDataException(e1);
                    return;
                }
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteCheck(ctx, pk);
        super._delete(ctx, pk);
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        this._isReferenced(ctx, pk);
    }

    @Override
    protected void _importDataFromXsl(Context ctx, boolean isOverride, IObjectValue model) throws BOSException, EASBizException {
        IReportClass iRptItem = ReportClassFactory.getLocalInstance(ctx);
        ReportClassInfo rptItemInfo = (ReportClassInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("select r.fid,r.FTrackRecordCreatorID,c.fname_" + ctx.getLocale() + " from T_CSL_ReportClass r inner join T_ORG_Company c on r.FTrackRecordCreatorID = c.fid where r.fnumber = ?");
        Object[] params = new Object[]{rptItemInfo.getNumber()};
        if (isOverride) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                if (rs.next()) {
                    this.doDataRepeatInCreateOrg(ctx, rptItemInfo.getNumber(), rs);
                    rptItemInfo.setId(BOSUuid.read((String)rs.getString(1)));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        iRptItem.submit((CoreBaseInfo)rptItemInfo);
    }

    private void doDataRepeatInCreateOrg(Context ctx, String num, IRowSet rs) throws SQLException, SundryException {
        if (!rs.getString(2).equals(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString())) {
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{num, rs.getString(3)});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        ReportClassInfo dataBaseInfo = (ReportClassInfo)info;
        EntityViewInfo view = this.buildIsNumExistView(dataBaseInfo);
        ReportClassCollection reportClassCollection = this.getReportClassCollection(ctx, view);
        if (reportClassCollection.size() > 0) {
            ReportClassInfo infoInDB = reportClassCollection.get(0);
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{infoInDB.getNumber(), infoInDB.getTrackRecordCreator().getName()});
        }
    }

    private EntityViewInfo buildIsNumExistView(ReportClassInfo dataBaseInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("trackRecordCreator.name"));
        coll.add(new SelectorItemInfo("number"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }
}

