/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IShareRela;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaInfo;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ShareRelaImport
extends AbstractDataTransmission {
    private static final String NUMBER_EXP = "1";
    private Set<String> investeeCompanySet = new HashSet<String>();
    private Map<String, BigDecimal> investeeCompanyMap = new HashMap<String, BigDecimal>();
    private Set<String> notBizUnitCompanySet = new HashSet<String>();
    private Map<String, Date> investeeCompanyChangeDateMap = new HashMap<String, Date>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ShareRelaFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ShareRelaInfo info = (ShareRelaInfo)coreBaseInfo;
            this.importDataFromXsl(ctx, (IObjectValue)info);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void importDataFromXsl(Context ctx, IObjectValue model) throws BOSException, EASBizException, TaskExternalException {
        Object[] params;
        String name;
        StringBuffer sql;
        IShareRela iShareRela = ShareRelaFactory.getLocalInstance(ctx);
        ShareRelaInfo info = (ShareRelaInfo)model;
        String investeeCompanyId = info.getInvesteeCompany().getId().toString();
        if (!this.investeeCompanySet.contains(investeeCompanyId)) {
            sql = new StringBuffer();
            sql.append("select s.fid from T_CSL_ShareRela s ");
            sql.append("where s.FInvesteeCompanyID = ?");
            Object[] params2 = new Object[]{investeeCompanyId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params2);
            try {
                if (rs.next()) {
                    throw new ServerException(ServerException.COMPANY_DUP);
                }
                this.investeeCompanySet.add(investeeCompanyId);
                this.investeeCompanyMap.put(investeeCompanyId, info.getShareScale());
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        sql = new StringBuffer();
        sql.append("select s.fid from T_CSL_ShareRela s  \t \n");
        sql.append("where s.FInvesteeCompanyID = ? \t\t \t \n");
        if (info.isIsOut()) {
            sql.append("and s.FOuterShareHolder = ? \t\t \n");
            name = info.getOuterShareHolder();
            params = new Object[]{investeeCompanyId, name};
        } else {
            sql.append("and s.FShareHolderID = ? \t\t\t \n");
            name = info.getShareHolder().getName();
            params = new Object[]{investeeCompanyId, info.getShareHolder().getId().toString()};
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            if (rs.next()) {
                throw new SundryException(SundryException.RECORDEXISTINORG, new Object[]{info.getInvesteeCompany().getName(), name});
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        BigDecimal sumShareScale = this.investeeCompanyMap.get(investeeCompanyId).add(info.getShareScale());
        this.investeeCompanyMap.put(investeeCompanyId, sumShareScale);
        if (sumShareScale.doubleValue() > 100.0) {
            throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Count_Rule", (Locale)ctx.getOriginLocale())));
        }
        Date changeDate = info.getChangeDate();
        if (this.investeeCompanyChangeDateMap.containsKey(investeeCompanyId) && !this.investeeCompanyChangeDateMap.get(investeeCompanyId).equals(changeDate)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"entryHasNotSameChangeDate", (Locale)ctx.getOriginLocale()));
        }
        if (info.getShareScale().doubleValue() <= 0.0 || info.getShareScale().doubleValue() > 100.0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Count_Rule", (Locale)ctx.getOriginLocale()));
        }
        iShareRela.submit((CoreBaseInfo)info);
        this.investeeCompanyChangeDateMap.put(investeeCompanyId, changeDate);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ShareRelaInfo info = new ShareRelaInfo();
        String isOuterShareHolder = this.fecthData(hsData, "FIsOuterShareHolder");
        if (StringUtil.isEmptyString((String)isOuterShareHolder)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"isOuterShareHolderNull", (Locale)ctx.getOriginLocale()));
        }
        if (ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"22_ReportWorktableUI", (Locale)ctx.getOriginLocale()).equals(isOuterShareHolder)) {
            info.setIsOut(true);
        } else if (ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"21_ReportWorktableUI", (Locale)ctx.getOriginLocale()).equals(isOuterShareHolder)) {
            info.setIsOut(false);
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"isOuterShareHolderRule", (Locale)ctx.getOriginLocale()));
        }
        String investeeCompanyNumber = this.fecthData(hsData, "FInvesteeCompany");
        if (StringUtil.isEmptyString((String)investeeCompanyNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"tarComNumberNull", (Locale)ctx.getOriginLocale()));
        }
        CompanyOrgUnitInfo investeeCompany = this.getCompanyInfo(ctx, investeeCompanyNumber = investeeCompanyNumber.replaceAll(" ", ""));
        if (investeeCompany == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"tarCompanyNull", (Locale)ctx.getOriginLocale()));
        }
        info.setInvesteeCompany(investeeCompany);
        String ShareHolderNumber = this.fecthData(hsData, "FShareHolderNumber");
        if (StringUtil.isEmptyString((String)ShareHolderNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"shareHolderNumberNull", (Locale)ctx.getOriginLocale()));
        }
        ShareHolderNumber = ShareHolderNumber.replaceAll(" ", "");
        if (info.isIsOut()) {
            info.setOuterShareHolder(ShareHolderNumber);
        } else {
            CompanyOrgUnitInfo shareHolder = this.getCompanyInfo(ctx, ShareHolderNumber);
            if (shareHolder == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"shareHolderNull", (Locale)ctx.getOriginLocale()));
            }
            info.setShareHolder(shareHolder);
        }
        String shareScale = this.fecthData(hsData, "FShareScale");
        if (StringUtil.isEmptyString((String)shareScale)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"shareScaleNull", (Locale)ctx.getOriginLocale()));
        }
        BigDecimal shareScaleValue = null;
        try {
            shareScaleValue = new BigDecimal(shareScale);
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"shareScaleError", (Locale)ctx.getOriginLocale()));
        }
        if (shareScaleValue.compareTo(new BigDecimal("0")) < 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Inner_NotMinus", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{ShareHolderNumber}));
        }
        info.setShareScale(shareScaleValue);
        String changeDateStr = this.fecthData(hsData, "FChangeDate");
        if (StringUtil.isEmptyString((String)changeDateStr)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"changeDateNull", (Locale)ctx.getOriginLocale()));
        }
        Date changeDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy-MM-dd");
        try {
            changeDate = sdf.parse(changeDateStr);
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"changeDateError", (Locale)ctx.getOriginLocale()));
        }
        info.setChangeDate(changeDate);
        String remark = this.fecthData(hsData, "FRemark");
        if (!StringUtil.isEmptyString((String)remark)) {
            info.setRemark(remark);
        }
        info.setIsLatest(true);
        if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            try {
                ObjectStringPK companyPK = new ObjectStringPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
                info.setTrackRecordCreator(company);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        return info;
    }

    private boolean getBooleanFromAlias(String bool, Context ctx) {
        if (StringUtils.isEmpty((String)bool)) {
            return false;
        }
        String upperCase = bool.toUpperCase(Locale.ENGLISH);
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_Yes", (Locale)ctx.getOriginLocale()).equals(upperCase) || ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_True", (Locale)ctx.getOriginLocale()).equals(upperCase) || "Y".equals(upperCase) || "TRUE".equals(upperCase);
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, String number) throws TaskExternalException {
        try {
            if (this.notBizUnitCompanySet.contains(number)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"companyIsNotBizUnit", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{number}));
            }
            CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where number = '" + number + "'");
            if (!info.isIsBizUnit()) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"companyIsNotBizUnit", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{number}));
            }
            return info;
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"companyUnitNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{number}));
        }
    }

    private String fecthData(Hashtable htData, String key) {
        DataToken dataToken = (DataToken)htData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            boolean isOut = Boolean.TRUE.equals(rs.getObject("isOut"));
            this.setData(result, "FIsOuterShareHolder", isOut ? ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"22_ReportWorktableUI", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"21_ReportWorktableUI", (Locale)ctx.getOriginLocale()));
            this.setData(result, "FInvesteeCompany", rs.getObject("investeeCompany.number"));
            this.setData(result, "FShareHolderNumber", isOut ? rs.getObject("outerShareHolder") : rs.getObject("shareHolder.number"));
            this.setData(result, "FShareScale", rs.getObject("shareScale"));
            this.setData(result, "FChangeDate", sf.format(rs.getObject("changeDate")));
            this.setData(result, "FRemark", rs.getObject("remark"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)value));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gr.cslrpt.ShareRelaForExportQuery";
    }

    public int getSubmitType() {
        return 0;
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gr.cslrpt.ShareRelaForExportQuery"));
        super.setContextParameter((Map)param);
    }

    private void verifyInput() throws Exception {
    }
}

