/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SumRptCalculate {
    public Map calculateByItem(Context ctx, IObjectPK reportID, Vector companys, Map sheets, boolean includeDiffTable, boolean bySumReport, String dataCollectNumber, boolean isGroupcommitted, AdjustCollection adjustColl, int rptYear, int rptPeriod) throws EASBizException, BOSException {
        return this.calculateByItem(ctx, reportID, companys, sheets, includeDiffTable, bySumReport, dataCollectNumber, isGroupcommitted, adjustColl, rptYear, rptPeriod, null);
    }

    public Map calculateByItem(Context ctx, IObjectPK reportID, Vector companys, Map sheets, boolean includeDiffTable, boolean bySumReport, String dataCollectNumber, boolean isGroupcommitted, AdjustCollection adjustColl, int rptYear, int rptPeriod, Map fastMergerParamMap) throws EASBizException, BOSException {
        if (reportID == null || reportID.toString().trim().length() == 0) {
            return null;
        }
        ICslReport cslRpt = CslReportFactory.getLocalInstance(ctx);
        CslReportInfo report = null;
        report = cslRpt.getCslReportInfo(reportID, this.getSelectors());
        if (report == null || sheets == null) {
            return null;
        }
        ItemDataCondition condition = new ItemDataCondition();
        condition = CSLParamUtil.getSysParams(ctx, condition);
        PeriodCollection periods = null;
        boolean isSupport13Period = condition.isSupport13Period();
        boolean isMergeByFiscalPeriod = condition.isMergeByFiscalPeriod();
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, report);
        }
        condition.setOrgTreeId(report.getOrgTree().getId().toString());
        condition.setOrgTreeNumber(report.getOrgTree().getNumber());
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            condition.setDataCollectNumber(dataCollectNumber);
        }
        ArrayList companyNumbers = CslRptUtil.vectorToArrayList(companys);
        StringBuffer buf = new StringBuffer("select fid from t_org_baseunit where ");
        String orgUnitString = CSLServerHelper.getOrStringByList(companyNumbers, null, "FNumber");
        buf.append(orgUnitString);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        ArrayList<String> companyIDs = new ArrayList<String>();
        try {
            while (rs.next()) {
                companyIDs.add(rs.getString("fid"));
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        condition.setOrgUnit(companyIDs);
        condition.setTargetCurrency(report.getCurrency().getId().toString());
        RptPeriodTypeEnum rptPeriodType = report.getPeriodType();
        int periodType = rptPeriodType.getValue();
        condition.setRptPeriodType(periodType);
        boolean isSupportGroupReport = true;
        List adjustIdsFilter = new ArrayList();
        if (fastMergerParamMap != null) {
            if (fastMergerParamMap.get("isSupportGroupReport") != null && !((Boolean)fastMergerParamMap.get("isSupportGroupReport")).booleanValue()) {
                isSupportGroupReport = false;
            }
            if (fastMergerParamMap.get("fastMergeSoluId") != null) {
                condition.setFastMergeSoluId((String)fastMergerParamMap.get("fastMergeSoluId"));
            }
            if (fastMergerParamMap.get("isRelateExistData_adjust") != null && fastMergerParamMap.get("adjustTypeIds") != null && !(adjustIdsFilter = (List)fastMergerParamMap.get("adjustTypeIds")).isEmpty()) {
                condition.setAdjustTypeFilter(adjustIdsFilter);
            }
        }
        condition.setSupportGroupReport(isSupportGroupReport);
        condition.setIsAdjusted(true);
        if (isGroupcommitted) {
            condition.setCommitStatus(3);
        } else {
            condition.setCommitStatus(-1);
        }
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArray[1] = bySumReport ? (isSupportGroupReport ? 2 : 31) : (isSupportGroupReport ? 3 : 34);
        int[] dataSrc = nArray;
        condition.setDataSourceString(dataSrc);
        int reportYear = report.getYear();
        short reportPeriod = report.getPeriod();
        ItemFormula itemFormula = null;
        IItemDataProvider ie = ItemDataProviderFactory.getLocalInstance(ctx);
        ItemDataCondition diffTableCondition = new ItemDataCondition();
        if (includeDiffTable) {
            try {
                diffTableCondition = (ItemDataCondition)condition.clone();
                ArrayList<String> list = new ArrayList<String>();
                list.add(report.getOrgUnit().getNumber());
                diffTableCondition.setOrgUnit(list);
                diffTableCondition.setCommitStatus(1);
                diffTableCondition.setDataSource(8);
                diffTableCondition.setIsAdjusted(false);
            }
            catch (CloneNotSupportedException list) {
                // empty catch block
            }
        }
        HashMap<String, ItemDataCondition> mapConditions = new HashMap<String, ItemDataCondition>();
        HashMap<String, ArrayList<String>> mapItems = new HashMap<String, ArrayList<String>>();
        StringBuffer key = new StringBuffer();
        for (String tableID : sheets.keySet()) {
            HashMap curSheet;
            if (tableID == null || tableID.trim().length() == 0 || (curSheet = (HashMap)sheets.get(tableID)) == null || curSheet.size() == 0) continue;
            for (Point position : curSheet.keySet()) {
                ArrayList<String> items;
                itemFormula = (ItemFormula)curSheet.get(position);
                try {
                    condition = (ItemDataCondition)condition.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                if (!itemFormula.isValidity()) continue;
                RptCalcHelper.offsetYearAndPeriod(isMergeByFiscalPeriod, isSupport13Period, rptPeriodType, reportYear, reportPeriod, itemFormula, periods);
                key.setLength(0);
                key.append(itemFormula.getDataElementNumber()).append("-");
                key.append(itemFormula.getValueType()).append("-");
                key.append(itemFormula.getYear()).append("-");
                key.append(itemFormula.getPeriod()).append("-");
                key.append(report.getDataCollectNumber());
                condition.setDataElement(DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber()));
                condition.setValueType(itemFormula.getValueType());
                condition.setRptYearStart(itemFormula.getYear());
                condition.setRptPeriodStart(itemFormula.getPeriod());
                condition.setRptYearEnd(itemFormula.getYear());
                condition.setRptPeriodEnd(itemFormula.getPeriod());
                condition.setDataCollectNumber(report.getDataCollectNumber());
                Object orgTreeId = null;
                String string = key.toString();
                if (mapConditions.get(string) == null) {
                    mapConditions.put(string, condition);
                }
                if ((items = (ArrayList<String>)mapItems.get(string)) == null) {
                    items = new ArrayList<String>();
                    mapItems.put(string, items);
                }
                items.add(itemFormula.getItemNumber());
                if (!includeDiffTable) continue;
                diffTableCondition.setItemNumberStart(itemFormula.getItemNumber());
                diffTableCondition.setItemNumberEnd(itemFormula.getItemNumber());
                diffTableCondition.setDataElement(DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber()));
                diffTableCondition.setValueType(itemFormula.getValueType());
                diffTableCondition.setRptYearStart(itemFormula.getYear());
                diffTableCondition.setRptPeriodStart(itemFormula.getPeriod());
                diffTableCondition.setRptYearEnd(itemFormula.getYear());
                diffTableCondition.setRptPeriodEnd(itemFormula.getPeriod());
                diffTableCondition.setDataCollectNumber(report.getDataCollectNumber());
                BigDecimal value = ie.getAcctItem(diffTableCondition, false);
                curSheet.put(position, value);
            }
        }
        String treeid = "";
        boolean isHasQuoteAdjust = this.isHasQuoteAdjust(adjustColl);
        StringBuffer adjustKey = new StringBuffer();
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        for (Map.Entry entry : mapConditions.entrySet()) {
            String keyString = (String)entry.getKey();
            condition = (ItemDataCondition)entry.getValue();
            List items = (List)mapItems.get(keyString);
            condition.setItemList(itemFieldMapped.getHiberMapInfoByItemNumbers(items));
            Map mapValue = ie.getAcctItems(condition);
            if (isHasQuoteAdjust) {
                this.mergeAdjustAndItemDataValue(ctx, adjustColl, rptYear, rptPeriod, condition, true, key, treeid, adjustKey, keyString, mapValue);
            }
            entry.setValue(mapValue);
        }
        for (String tableID : sheets.keySet()) {
            HashMap hashMap;
            if (tableID == null || tableID.trim().length() == 0 || (hashMap = (HashMap)sheets.get(tableID)) == null || hashMap.size() == 0) continue;
            for (Point position : hashMap.keySet()) {
                itemFormula = (ItemFormula)hashMap.get(position);
                if (itemFormula.isValidity()) {
                    RptCalcHelper.offsetYearAndPeriod(isMergeByFiscalPeriod, isSupport13Period, rptPeriodType, reportYear, reportPeriod, itemFormula, periods);
                    key.setLength(0);
                    key.append(itemFormula.getDataElementNumber()).append("-");
                    key.append(itemFormula.getValueType()).append("-");
                    key.append(itemFormula.getYear()).append("-");
                    key.append(itemFormula.getPeriod()).append("-");
                    key.append(report.getDataCollectNumber());
                    Object orgTreeId = null;
                    String keyString = key.toString();
                    Map mapValue = (Map)mapConditions.get(keyString);
                    if (mapValue != null) {
                        Object diffResult;
                        BigDecimal result = (BigDecimal)mapValue.get(itemFormula.getItemNumber());
                        if (result != null) {
                            diffResult = hashMap.get(position);
                            if (diffResult != null && diffResult instanceof BigDecimal) {
                                result = result.add((BigDecimal)diffResult);
                            }
                            hashMap.put(position, result);
                            continue;
                        }
                        diffResult = hashMap.get(position);
                        if (diffResult != null && diffResult instanceof BigDecimal) continue;
                        hashMap.put(position, null);
                        continue;
                    }
                    hashMap.put(position, null);
                    continue;
                }
                hashMap.put(position, null);
            }
        }
        return sheets;
    }

    private void mergeAdjustAndItemDataValue(Context ctx, AdjustCollection adjustColl, int rptYear, int rptPeriod, ItemDataCondition condition, boolean isAdjustSeparate, StringBuffer key, String treeid, StringBuffer adjustKey, String keyString, Map mapValue) {
        for (int i = 0; i < adjustColl.size(); ++i) {
            AdjustInfo info = adjustColl.get(i);
            AdjustEntryCollection entryColl = info.getEntries();
            for (int s = 0; s < entryColl.size(); ++s) {
                AdjustEntryInfo entryInfo = entryColl.get(s);
                adjustKey.setLength(0);
                adjustKey.append(DataElementProvider.getDataElementNumber(ctx, entryInfo.getDataElement())).append("-");
                adjustKey.append(info.getValueType().getValue()).append("-");
                adjustKey.append(rptYear).append("-");
                adjustKey.append(rptPeriod).append("-");
                adjustKey.append(info.getDataCollectNumber());
                if (!isAdjustSeparate) {
                    key.append("-").append(treeid);
                }
                if (!keyString.equals(adjustKey.toString())) continue;
                boolean isGroupByCompany = condition.isGroupByCompany();
                if (isGroupByCompany) {
                    for (Map.Entry mapEntry : mapValue.entrySet()) {
                        String mapKey = (String)mapEntry.getKey();
                        String itemNumber = mapKey.split("!")[0];
                        if (!itemNumber.equals(entryInfo.getItem().getNumber())) continue;
                        if (entryInfo.getDebit() != null) {
                            mapValue.put(mapKey, ((BigDecimal)mapEntry.getValue()).add(entryInfo.getDebit()));
                        }
                        if (entryInfo.getCredit() == null) continue;
                        mapValue.put(mapKey, ((BigDecimal)mapEntry.getValue()).add(entryInfo.getCredit()));
                    }
                    continue;
                }
                if (!mapValue.containsKey(entryInfo.getItem().getNumber())) continue;
                if (entryInfo.getDebit() != null) {
                    if (mapValue.get(entryInfo.getItem().getNumber()) == null) {
                        mapValue.put(entryInfo.getItem().getNumber(), entryInfo.getDebit());
                    } else {
                        mapValue.put(entryInfo.getItem().getNumber(), ((BigDecimal)mapValue.get(entryInfo.getItem().getNumber())).add(entryInfo.getDebit()));
                    }
                }
                if (entryInfo.getCredit() == null) continue;
                if (mapValue.get(entryInfo.getItem().getNumber()) == null) {
                    mapValue.put(entryInfo.getItem().getNumber(), entryInfo.getCredit());
                    continue;
                }
                mapValue.put(entryInfo.getItem().getNumber(), ((BigDecimal)mapValue.get(entryInfo.getItem().getNumber())).add(entryInfo.getCredit()));
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        return this.getSelectors(true);
    }

    public SelectorItemCollection getSelectors(boolean WidthData) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        if (WidthData) {
            sic.add(new SelectorItemInfo("data"));
        }
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("fastMergeSoluId"));
        return sic;
    }

    private boolean isHasQuoteAdjust(AdjustCollection adjustColl) {
        return adjustColl != null && adjustColl.size() > 0;
    }
}

