/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.netfile.ftp.FTPClient;
import com.kingdee.bos.service.netfile.ftp.FTPTransferType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ResultStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.TimeImportException;
import com.kingdee.eas.fi.gr.cslrpt.TimeImportReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.TimeImportReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.TimeImportReportLogFactory;
import com.kingdee.eas.fi.gr.cslrpt.TimeImportReportLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.UpdateReportTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractTimeImportReportControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.upload.AllReportsCompletedEvent;
import com.kingdee.eas.fi.gr.cslrpt.upload.OneReportCompletedEvent;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadReportListener;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoader;
import com.kingdee.eas.fi.gr.cslrpt.util.DNFFile;
import com.kingdee.eas.fi.gr.cslrpt.util.FTPUpDown;
import com.kingdee.eas.fi.gr.cslrpt.util.UPFFile;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class TimeImportReportControllerBean
extends AbstractTimeImportReportControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.TimeImportReportControllerBean");
    private static final String MAPITEM_UPFFILE = "MAPITEM_UPFFILE";
    private static final String MAPITEM_RESULT = "MAPITEM_RESULT";
    private static final String MAPITEM_REPORTLIST = "MAPITEM_REPORTLIST";

    @Override
    protected void _caclSolu(Context ctx, String pk) throws BOSException, EASBizException {
        Object ftpClient;
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"277_TimeImportReportControllerBean", (Locale)ctx.getOriginLocale()));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)pk.toString());
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        TimeImportReportCollection col = this.getTimeImportReportCollection(ctx, view);
        if (col == null || col.size() == 0) {
            return;
        }
        TimeImportReportInfo timingInfo = col.get(0);
        if (timingInfo.getIsForbid() == 0) {
            return;
        }
        String pFtpServer = timingInfo.getServerAddr();
        String pFtpPort = "21";
        String currDirec = timingInfo.getCurrDirectory();
        String pFtpUserName = timingInfo.getUserName();
        String pFtpPassword = timingInfo.getPassPort();
        String ftpServer = null;
        String ftpPort = null;
        String ftpUserName = null;
        String ftpPassword = null;
        ftpServer = pFtpServer;
        ftpPort = pFtpPort.trim().equals("") ? "21" : pFtpPort;
        ftpUserName = pFtpUserName.trim().equals("") ? "Anonymous" : pFtpUserName;
        ftpPassword = pFtpPassword;
        String directory = System.getProperty("user.home");
        String userFile = "userConfig_Temp_Temp";
        String fullFilePath = FilenameUtils.normalize((String)(directory + File.separator + userFile));
        File saveFileDir = new File(fullFilePath);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"278_TimeImportReportControllerBean", (Locale)ctx.getOriginLocale()) + saveFileDir.toString()));
        if (saveFileDir.exists()) {
            File[] childFile = saveFileDir.listFiles();
            for (int i = 0; i < childFile.length; ++i) {
                childFile[i].delete();
            }
            saveFileDir.delete();
        }
        if (UpdateReportTypeEnum.Excel.equals((Object)timingInfo.getUpdateReportType())) {
            ftpClient = null;
            try {
                ftpClient = new FTPClient(ftpServer, Integer.parseInt(ftpPort));
                logger.info((Object)"before login");
                ftpClient.login(ftpUserName, ftpPassword);
                logger.info((Object)"after login");
                ftpClient.chdir("\\");
                logger.info((Object)"after chadir");
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
            this.importExcelFile(ctx, timingInfo, (FTPClient)ftpClient, saveFileDir, pFtpServer, currDirec);
        } else if (UpdateReportTypeEnum.UPF.equals((Object)timingInfo.getUpdateReportType())) {
            ftpClient = null;
            try {
                logger.info((Object)"init ftp");
                ftpClient = new FTPUpDown(ftpServer, ftpPort, ftpUserName, ftpPassword);
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
            this.importUPFFile(ctx, timingInfo, (FTPUpDown)ftpClient, saveFileDir, pFtpServer, currDirec);
        }
    }

    private void importExcelFile(Context ctx, final TimeImportReportInfo timingInfo, FTPClient ftp, File saveFileDir, final String serverAdd, final String currDirec) throws BOSException, EASBizException {
        UpLoader uploder = UpLoader.getInstance(ctx);
        final HashMap<String, Context> map = new HashMap<String, Context>();
        map.put("ctx", ctx);
        uploder.addUpLoadReportListener(new UpLoadReportListener(){

            @Override
            public void onOneReportCompleted(OneReportCompletedEvent evt) throws EASBizException, BOSException {
                TimeImportReportLogInfo logInfo;
                Timestamp time = new Timestamp(System.currentTimeMillis());
                if (evt.getUpLoadResultItemInfo().isStateSucess()) {
                    logInfo = new TimeImportReportLogInfo();
                    logInfo.setUpdateReportType(UpdateReportTypeEnum.Excel);
                    logInfo.setResultStatus(ResultStatusEnum.SUCCESS);
                    TimeImportReportControllerBean.this.setLog(logInfo, time, serverAdd + System.getProperty("file.separator") + currDirec, evt.getUpLoadResultItemInfo().getExcelName(), ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"280_TimeImportReportControllerBean", (Locale)((Context)map.get("ctx")).getOriginLocale()));
                    TimeImportReportControllerBean.this.writeLog(map, timingInfo, logInfo);
                }
                if (evt.getUpLoadResultItemInfo().isStateError()) {
                    logInfo = new TimeImportReportLogInfo();
                    logInfo.setUpdateReportType(UpdateReportTypeEnum.Excel);
                    logInfo.setResultStatus(ResultStatusEnum.FAILURE);
                    TimeImportReportControllerBean.this.setLog(logInfo, time, serverAdd + System.getProperty("file.separator") + currDirec, evt.getUpLoadResultItemInfo().getExcelName(), evt.getUpLoadResultItemInfo().getErrorMsg());
                    TimeImportReportControllerBean.this.writeLog(map, timingInfo, logInfo);
                }
                if (evt.getUpLoadResultItemInfo().isStateException()) {
                    logInfo = new TimeImportReportLogInfo();
                    logInfo.setUpdateReportType(UpdateReportTypeEnum.Excel);
                    logInfo.setResultStatus(ResultStatusEnum.FAILURE);
                    TimeImportReportControllerBean.this.setLog(logInfo, time, serverAdd + System.getProperty("file.separator") + currDirec, evt.getUpLoadResultItemInfo().getExcelName(), evt.getUpLoadResultItemInfo().getExceptionMsg());
                    TimeImportReportControllerBean.this.writeLog(map, timingInfo, logInfo);
                }
            }

            @Override
            public void onAllReportsCompleted(AllReportsCompletedEvent evt) {
            }
        });
        boolean isCreate = saveFileDir.mkdir();
        if (isCreate) {
            try {
                logger.info((Object)"before__downFile");
                this.downExcelFile(ftp, currDirec, saveFileDir.getPath());
            }
            catch (Exception e) {
                logger.info((Object)"catch__downFile", (Throwable)e);
            }
            try {
                logger.info((Object)"before__upload");
                uploder.upload(saveFileDir.getPath());
            }
            catch (Exception e) {
                logger.info((Object)"catch_after__upload", (Throwable)e);
                logger.info((Object)e);
            }
        } else {
            Timestamp time = new Timestamp(System.currentTimeMillis());
            TimeImportReportLogInfo logInfo = new TimeImportReportLogInfo();
            logInfo.setUpdateReportType(UpdateReportTypeEnum.Excel);
            logInfo.setResultStatus(ResultStatusEnum.FAILURE);
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"281_TimeImportReportControllerBean", (Locale)ctx.getOriginLocale()) + saveFileDir.toString();
            this.setLog(logInfo, time, serverAdd + System.getProperty("file.separator") + currDirec, "", msg);
            HashMap<String, Context> ctxmap = new HashMap<String, Context>();
            ctxmap.put("ctx", ctx);
            this.writeLog(ctxmap, timingInfo, logInfo);
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"282_TimeImportReportControllerBean", (Locale)ctx.getOriginLocale()));
        }
    }

    private void downExcelFile(FTPClient ftpClient, String ftpPath, String localPath) throws Exception {
        if (ftpPath.equals("456")) {
            logger.info((Object)"is 456");
        }
        try {
            ftpClient.setType(FTPTransferType.BINARY);
            if (!StringUtils.isEmpty((String)ftpPath) && this.checkFolderIsExist(ftpClient, ftpPath)) {
                ftpClient.chdir(ftpPath);
            }
            logger.info((Object)"before create exclName");
            String[] excelName = ftpClient.dir();
            logger.info((Object)("after create exclName " + excelName[0]));
            for (int i = 0; i < excelName.length; ++i) {
                logger.info((Object)("begin find exclName" + excelName[i]));
                if (!excelName[i].endsWith(".xls")) continue;
                logger.info((Object)("find exclName" + excelName[i]));
                logger.info((Object)(localPath + System.getProperty("file.separator") + excelName[i]));
                ftpClient.get(localPath + System.getProperty("file.separator") + excelName[i], excelName[i]);
            }
        }
        catch (Exception e) {
            logger.info((Object)"=================1", (Throwable)e);
            throw e;
        }
    }

    private void importUPFFile(Context ctx, TimeImportReportInfo timingInfo, FTPUpDown ftp, File saveFileDir, String serverAdd, String currDirec) throws BOSException, EASBizException {
        boolean isCreate = saveFileDir.mkdir();
        if (isCreate) {
            List filenames = new ArrayList();
            try {
                logger.info((Object)"before__downFile");
                filenames = this.downUPFFile(ctx, ftp, currDirec, saveFileDir.getPath());
                logger.info((Object)"after downFile");
            }
            catch (Exception e) {
                logger.info((Object)"catch__downFile", (Throwable)e);
            }
            try {
                logger.info((Object)"before import");
                this.doImportUPF(ctx, timingInfo, saveFileDir.getPath(), filenames, serverAdd, currDirec);
                logger.info((Object)"finish import");
            }
            catch (Exception e) {
                logger.info((Object)"catch_after__import", (Throwable)e);
                logger.info((Object)e);
            }
        } else {
            Timestamp time = new Timestamp(System.currentTimeMillis());
            TimeImportReportLogInfo logInfo = new TimeImportReportLogInfo();
            logInfo.setUpdateReportType(UpdateReportTypeEnum.UPF);
            logInfo.setResultStatus(ResultStatusEnum.FAILURE);
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"281_TimeImportReportControllerBean", (Locale)ctx.getOriginLocale()) + saveFileDir.toString();
            this.setLog(logInfo, time, serverAdd + System.getProperty("file.separator") + currDirec, "", msg);
            HashMap<String, Context> ctxmap = new HashMap<String, Context>();
            ctxmap.put("ctx", ctx);
            this.writeLog(ctxmap, timingInfo, logInfo);
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"282_TimeImportReportControllerBean", (Locale)ctx.getOriginLocale()));
        }
    }

    private List downUPFFile(Context ctx, FTPUpDown ftpClient, String ftpPath, String localPath) throws Exception {
        ArrayList filenames = new ArrayList();
        try {
            logger.info((Object)"before download upf");
            String[] fileFilter = null;
            DateFormat df = DateFormat.getDateInstance(2, Locale.CHINA);
            Date now = new Date();
            int[] yearAndPeriod = RPTDateUtil.getPeriod(now, RptPeriodTypeEnum.DAILY);
            Date date = RPTDateUtil.getPeriodLastDate(yearAndPeriod[0], yearAndPeriod[1], RptPeriodTypeEnum.DAILY);
            fileFilter = this.getFileFilter(df, date, RptPeriodTypeEnum.DAILY.getName());
            logger.info((Object)"download this period daily report");
            filenames.addAll(ftpClient.downFiles(ctx, ftpPath, fileFilter, localPath));
            yearAndPeriod = RPTDateUtil.getRptYearAndPeriod(yearAndPeriod[0], yearAndPeriod[1], 1, 0, -1);
            date = RPTDateUtil.getPeriodLastDate(yearAndPeriod[0], yearAndPeriod[1], RptPeriodTypeEnum.DAILY);
            fileFilter = this.getFileFilter(df, date, RptPeriodTypeEnum.DAILY.getName());
            logger.info((Object)"download last period daily report");
            filenames.addAll(ftpClient.downFiles(ctx, ftpPath, fileFilter, localPath));
            yearAndPeriod = RPTDateUtil.getPeriod(now, RptPeriodTypeEnum.WEEKLY);
            date = RPTDateUtil.getPeriodLastDate(yearAndPeriod[0], yearAndPeriod[1], RptPeriodTypeEnum.WEEKLY);
            fileFilter = this.getFileFilter(df, date, RptPeriodTypeEnum.WEEKLY.getName());
            logger.info((Object)"download this period weekly report");
            filenames.addAll(ftpClient.downFiles(ctx, ftpPath, fileFilter, localPath));
            yearAndPeriod = RPTDateUtil.getRptYearAndPeriod(yearAndPeriod[0], yearAndPeriod[1], 2, 0, -1);
            date = RPTDateUtil.getPeriodLastDate(yearAndPeriod[0], yearAndPeriod[1], RptPeriodTypeEnum.WEEKLY);
            fileFilter = this.getFileFilter(df, date, RptPeriodTypeEnum.WEEKLY.getName());
            logger.info((Object)"download last period weekly report");
            filenames.addAll(ftpClient.downFiles(ctx, ftpPath, fileFilter, localPath));
            yearAndPeriod = RPTDateUtil.getPeriod(now, RptPeriodTypeEnum.MONTHLY);
            date = RPTDateUtil.getPeriodLastDate(yearAndPeriod[0], yearAndPeriod[1], RptPeriodTypeEnum.MONTHLY);
            fileFilter = this.getFileFilter(df, date, RptPeriodTypeEnum.MONTHLY.getName());
            logger.info((Object)"download this period monthly report");
            filenames.addAll(ftpClient.downFiles(ctx, ftpPath, fileFilter, localPath));
            yearAndPeriod = RPTDateUtil.getRptYearAndPeriod(yearAndPeriod[0], yearAndPeriod[1], 3, 0, -1);
            date = RPTDateUtil.getPeriodLastDate(yearAndPeriod[0], yearAndPeriod[1], RptPeriodTypeEnum.MONTHLY);
            fileFilter = this.getFileFilter(df, date, RptPeriodTypeEnum.MONTHLY.getName());
            logger.info((Object)"download last period monthly report");
            filenames.addAll(ftpClient.downFiles(ctx, ftpPath, fileFilter, localPath));
        }
        catch (Exception e) {
            logger.info((Object)"=================1", (Throwable)e);
            throw e;
        }
        return filenames;
    }

    private String[] getFileFilter(DateFormat df, Date date, String rptPeriodTypeName) {
        String[] fileFilter = new String[]{df.format(date) + "_" + rptPeriodTypeName + "." + "UPF", df.format(date) + "_" + rptPeriodTypeName + "_" + "ACTUALDATA" + "." + "UPF", df.format(date) + "_" + rptPeriodTypeName + "_" + "BUDGETDATA" + "." + "UPF"};
        return fileFilter;
    }

    private HashMap getCompanyUPFMap(String localPath, List filenames) {
        HashMap result = new HashMap();
        for (int i = 0; i < filenames.size(); ++i) {
            List<HashMap<String, Object>> list;
            String shortname = (String)filenames.get(i);
            String file = localPath + System.getProperty("file.separator") + shortname;
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put(MAPITEM_UPFFILE, new UPFFile(file, DNFFile.getDNF_PASSWORD()));
            itemMap.put(MAPITEM_RESULT, new StringBuffer());
            if (result.containsKey(shortname)) {
                list = (List)result.get(shortname);
                list.add(itemMap);
                result.put(shortname, list);
                continue;
            }
            list = new ArrayList();
            list.add(itemMap);
            result.put(shortname, list);
        }
        return result;
    }

    private void doImportUPF(Context ctx, TimeImportReportInfo timingInfo, String localPath, List filenames, String serverAdd, String currDirec) throws Exception {
        HashMap<String, Context> ctxmap = new HashMap<String, Context>();
        ctxmap.put("ctx", ctx);
        HashMap map = this.getCompanyUPFMap(localPath, filenames);
        for (String element : map.keySet()) {
            List elementList = (List)map.get(element);
            for (int i = 0; i < elementList.size(); ++i) {
                Map upfMap = (Map)elementList.get(i);
                UPFFile upf = (UPFFile)upfMap.get(MAPITEM_UPFFILE);
                CslReportCollection reports = upf.getCslReportCollection();
                if (reports == null) {
                    Timestamp time = new Timestamp(System.currentTimeMillis());
                    TimeImportReportLogInfo logInfo = new TimeImportReportLogInfo();
                    logInfo.setUpdateReportType(UpdateReportTypeEnum.UPF);
                    logInfo.setResultStatus(ResultStatusEnum.FAILURE);
                    String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"283_TimeImportReportControllerBean", (Locale)ctx.getOriginLocale());
                    this.setLog(logInfo, time, serverAdd + System.getProperty("file.separator") + currDirec, element, msg);
                    this.writeLog(ctxmap, timingInfo, logInfo);
                    upfMap.remove(MAPITEM_UPFFILE);
                    continue;
                }
                for (int k = 0; k < reports.size(); ++k) {
                    Book book = reports.get(k).getBook();
                    book.setCalculate(false);
                    for (int w = 0; w < book.getSheetCount(); ++w) {
                        Sheet.ICellsIterator it = book.getSheet(w).getCellsIterator(null, false, true);
                        while (it.hasNext()) {
                            Cell cell = it.next();
                            String formula = cell.getFormula();
                            if (StringUtils.isEmpty((String)formula) || formula.trim().charAt(0) != '=') continue;
                            try {
                                Expression expression = ExcelFormulaPaserHelper.parse((String)formula);
                                if (!this.isCustomerFunction(expression)) continue;
                                Object obj1 = cell.getValue().getValue();
                                cell.setFormula(null);
                                cell.setValue(new Variant(obj1));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    reports.get(k).setBook(book);
                }
                List<Object> list = Arrays.asList(reports.toArray());
                upfMap.put(MAPITEM_REPORTLIST, list);
                upfMap.remove(MAPITEM_UPFFILE);
            }
        }
        Map resultMap = CslReportFactory.getLocalInstance(ctx).importCSLReport(map);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        for (String element : resultMap.keySet()) {
            StringBuffer msg = (StringBuffer)resultMap.get(element);
            TimeImportReportLogInfo logInfo = new TimeImportReportLogInfo();
            logInfo.setUpdateReportType(UpdateReportTypeEnum.UPF);
            logInfo.setResultStatus(ResultStatusEnum.SUCCESS);
            this.setLog(logInfo, time, serverAdd + System.getProperty("file.separator") + currDirec, element, msg.toString());
            this.writeLog(ctxmap, timingInfo, logInfo);
        }
    }

    private boolean isCustomerFunction(Expression exp) {
        if (exp instanceof FunctionExpr) {
            FunctionExpr fun = (FunctionExpr)exp;
            String name = fun.funcionName;
            if (name.equalsIgnoreCase("Acct") || name.equalsIgnoreCase("AcctCash") || name.equalsIgnoreCase("AcctExt")) {
                return true;
            }
            for (int i = 0; i < fun.parameters.size(); ++i) {
                if (!this.isCustomerFunction((Expression)fun.parameters.get(i))) continue;
                return true;
            }
        } else if (exp instanceof BinaryOperationExpr) {
            if (this.isCustomerFunction(((BinaryOperationExpr)exp).left)) {
                return true;
            }
            if (this.isCustomerFunction(((BinaryOperationExpr)exp).right)) {
                return true;
            }
        } else if (exp instanceof UnaryOperationExpr && this.isCustomerFunction(((UnaryOperationExpr)exp).operand)) {
            return true;
        }
        return false;
    }

    private boolean checkFolderIsExist(FTPClient ftpClient, String pFolder) throws Exception {
        String folder = pFolder.trim();
        if (folder.startsWith("\\")) {
            folder = folder.substring(1);
        }
        if (folder.endsWith("\\")) {
            folder = folder.substring(0, folder.length() - 1);
        }
        String strLayer = "..";
        if (folder.indexOf("\\") > 0) {
            String[] folders = folder.split("\\\\");
            for (int i = 1; i < folders.length; ++i) {
                strLayer = strLayer + ",";
            }
        }
        boolean result = false;
        try {
            ftpClient.chdir(folder);
            ftpClient.chdir(strLayer);
            result = true;
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    @Override
    protected void _forbid(Context ctx, List list) throws BOSException, EASBizException {
        Connection con = null;
        Statement st = null;
        con = super.getConnection(ctx);
        StringBuffer s = new StringBuffer();
        try {
            st = con.createStatement();
            for (int i = 0; i < list.size(); ++i) {
                s.append("update T_CSL_TimeImportReport set FIsForbid = ").append(0);
                s.append(" where fid = '").append(list.get(i).toString()).append("'");
                st.addBatch(s.toString());
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            logger.info((Object)e);
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)st, (Connection)con);
        }
    }

    @Override
    protected void _unForbid(Context ctx, List list) throws BOSException, EASBizException {
        Connection con = null;
        Statement st = null;
        con = super.getConnection(ctx);
        StringBuffer s = new StringBuffer();
        try {
            st = con.createStatement();
            for (int i = 0; i < list.size(); ++i) {
                s.append("update T_CSL_TimeImportReport set FIsForbid = ").append(1);
                s.append(" where fid = '").append(list.get(i).toString()).append("'");
                st.addBatch(s.toString());
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            logger.info((Object)e);
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)st, (Connection)con);
        }
    }

    private void setLog(TimeImportReportLogInfo logInfo, Timestamp time, String path, String fileName, String erroMessage) {
        logInfo.setTime(time);
        logInfo.setPath(path);
        logInfo.setFileName(fileName);
        logInfo.setFailureReason(erroMessage);
    }

    private void writeLog(HashMap map, TimeImportReportInfo timingInfo, TimeImportReportLogInfo logInfo) throws EASBizException, BOSException {
        logInfo.setSchedule(timingInfo);
        if (logInfo.getTime() != null || logInfo.getPath() != null || logInfo.getFileName() != null || logInfo.getFailureReason() != null) {
            try {
                TimeImportReportLogFactory.getLocalInstance((Context)map.get("ctx")).addnew(logInfo);
            }
            catch (EASBizException e) {
                logger.info((Object)e);
                throw new EASBizException(TimeImportException.ADDNEWLOG, new Object[]{e});
            }
            catch (BOSException e) {
                logger.info((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._update(ctx, pk, model);
    }

    private void addnewCheck(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        TimeImportReportInfo model = (TimeImportReportInfo)info;
        this._checkNumberDup(ctx, null, (IObjectValue)model);
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        TimeImportReportInfo info = (TimeImportReportInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("number", (Object)info.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1");
        boolean exist = this.exists(ctx, filter);
        if (exist) {
            throw new TimeImportException(TimeImportException.ISNUMBERDUP);
        }
        return true;
    }
}

