/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.app.IUnionVersionBizHandler;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportServiceFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.VersionCheckFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.UnionCheckVersionDataNew;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnionBeforeVersion
implements IUnionVersionBizHandler {
    private static final Logger logger = CoreUIObject.getLogger(UnionBeforeVersion.class);
    private Map checkedParentUnit = new HashMap();
    private boolean isCheckFlag = true;
    private List sumRptList = new ArrayList();
    private List adjustList = new ArrayList();
    private List elimList = new ArrayList();
    private List rptreceiveList = new ArrayList();
    private List fastMergeSoluList = new ArrayList();
    private List<Map<String, List<String>>> fastSoluList = new ArrayList<Map<String, List<String>>>();
    private List hisSumRptList = new ArrayList();
    private List hisAdjustList = new ArrayList();
    private List hisElimList = new ArrayList();
    private List hisRptList = new ArrayList();
    private static final int rptSrcTypeAll = 999;
    List<String> interCheckageIdList = new ArrayList<String>();
    List<String> exchCheckageIdList = new ArrayList<String>();

    private void init() {
        this.checkedParentUnit = new HashMap();
        this.isCheckFlag = true;
        this.sumRptList = new ArrayList();
        this.adjustList = new ArrayList();
        this.elimList = new ArrayList();
        this.rptreceiveList = new ArrayList();
        this.fastMergeSoluList = new ArrayList();
        this.fastSoluList = new ArrayList<Map<String, List<String>>>();
        this.hisSumRptList = new ArrayList();
        this.hisAdjustList = new ArrayList();
        this.hisElimList = new ArrayList();
        this.hisRptList = new ArrayList();
    }

    public Map onStartingUnion(Context ctx, String oldTreeId, String newTreeId, Timestamp date) throws Exception {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        OrgTreeInfo tree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(newTreeId));
        if (tree.isIsForBudget()) {
            ret.put("state", Boolean.TRUE);
            return ret;
        }
        this.init();
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS"});
        boolean isMergeByFiscalPeriod = values[0];
        boolean isSupportOtherDS = values[1];
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            List companys = UnionBeforeVersion.checkCompanyPeriodType(ctx, newTreeId);
            if (companys.size() > 0) {
                ret.put("state", new Boolean(false));
                this.getResultMap(ret, true);
                Map result = (Map)ret.get("result");
                result.put("companyNames", companys);
                return ret;
            }
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)newTreeId));
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        String datesql = UnionBeforeVersion.getSqlByDateMore(date, null, periods, isMergeByFiscalPeriod);
        ret.put("state", new Boolean(this.isCheckFlag));
        if (CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_ORGTREECHECKNOTNEW")) {
            this.checkVersionData(ctx, oldTreeId, newTreeId, date, datesql);
            if (!this.isCheckFlag) {
                ret.put("state", new Boolean(this.isCheckFlag));
                this.getResultMap(ret, false);
                return ret;
            }
        } else {
            UnionCheckVersionDataNew checkVersionNew = new UnionCheckVersionDataNew();
            checkVersionNew.checkUnionVersionDataNew(ctx, oldTreeId, newTreeId, date, datesql);
            try {
                this.checkInterExchCheckage(ctx, oldTreeId, newTreeId, datesql);
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            if (!checkVersionNew.isPassCheck() || !this.isCheckFlag) {
                ret.put("state", false);
                checkVersionNew.getResultMap(ret, false);
                Map result = (Map)ret.get("result");
                result.put("interCheck", this.interCheckageIdList);
                result.put("exchCheck", this.exchCheckageIdList);
                return ret;
            }
            if (checkVersionNew.isHasShow() && !VersionCheckFacadeFactory.getLocalInstance(ctx).isOrgTreeChecked(newTreeId)) {
                ret.put("state", false);
                checkVersionNew.getResultMap(ret, false);
                return ret;
            }
            VersionCheckFacadeFactory.getLocalInstance(ctx).deleteCheckOrgTree(newTreeId);
        }
        this.checkedParentUnit.clear();
        UnionVersionUtil.updateData(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.repairRptReceivedData(ctx, newTreeId);
        UnionVersionUtil.repairDataAfterVersioning(ctx, newTreeId, date, periods, isMergeByFiscalPeriod, 1);
        return ret;
    }

    public Map onStartingUnionBefore(Context ctx, String oldTreeId, String newTreeId, Timestamp date) throws Exception {
        long curTime = System.currentTimeMillis();
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        this.init();
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS"});
        final boolean isMergeByFiscalPeriod = values[0];
        boolean isSupportOtherDS = values[1];
        PeriodCollection curPeriods = null;
        if (isMergeByFiscalPeriod) {
            List companys = UnionBeforeVersion.checkCompanyPeriodType(ctx, newTreeId);
            if (companys.size() > 0) {
                ret.put("state", new Boolean(false));
                this.getResultMap(ret, true);
                Map result = (Map)ret.get("result");
                result.put("companyNames", companys);
                return ret;
            }
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)newTreeId));
            curPeriods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        final PeriodCollection periods = curPeriods;
        String datesql = UnionBeforeVersion.getSqlByDateMore(date, null, periods, isMergeByFiscalPeriod);
        ret.put("state", new Boolean(this.isCheckFlag));
        if (CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_ORGTREECHECKNOTNEW")) {
            this.checkVersionData(ctx, oldTreeId, newTreeId, date, datesql);
            ret.put("state", new Boolean(this.isCheckFlag));
            if (!this.isCheckFlag) {
                this.getResultMap(ret, false);
                return ret;
            }
        } else {
            UnionCheckVersionDataNew checkVersionNew = new UnionCheckVersionDataNew();
            checkVersionNew.checkUnionVersionDataNew(ctx, oldTreeId, newTreeId, date, datesql);
            if (!checkVersionNew.isPassCheck()) {
                checkVersionNew.getResultMap(ret, false);
                ret.put("state", false);
                return ret;
            }
            if (checkVersionNew.isHasShow() && !VersionCheckFacadeFactory.getLocalInstance(ctx).isOrgTreeChecked(newTreeId)) {
                ret.put("state", false);
                checkVersionNew.getResultMap(ret, false);
                return ret;
            }
            VersionCheckFacadeFactory.getLocalInstance(ctx).deleteCheckOrgTree(newTreeId);
        }
        this.checkedParentUnit.clear();
        logger.error((Object)("---------------cslReport onStartingUnion check time:" + (System.currentTimeMillis() - curTime)));
        final Context curCtx = ctx;
        final String curOldTreeId = oldTreeId;
        final String curNewTreeId = newTreeId;
        final Timestamp curDate = date;
        Thread updataThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String key = curOldTreeId + "0";
                try {
                    UnionVersionUtil.UnionVersionThreadMap.remove(curOldTreeId);
                    UnionVersionUtil.UnionVersionThreadMap.remove(key);
                    UnionVersionUtil.UnionVersionThreadMap.put(curOldTreeId, this);
                    long curTime = System.currentTimeMillis();
                    CslReportServiceFacadeFactory.getLocalInstance(curCtx).updateUnionVersionData(curOldTreeId, curNewTreeId, curDate, periods, isMergeByFiscalPeriod);
                    logger.error((Object)("---------------cslReport onStartingUnion update time:" + (System.currentTimeMillis() - curTime)));
                }
                catch (Throwable e) {
                    logger.error((Object)"updataThread error", e);
                    UnionVersionUtil.UnionVersionThreadMap.put(key, (Object)new BOSException(e));
                    logger.error((Object)("---------------start UnionVersionThreadMap0:" + UnionVersionUtil.UnionVersionThreadMap.toString()));
                }
                finally {
                    UnionVersionUtil.UnionVersionThreadMap.remove(curOldTreeId);
                }
            }
        };
        updataThread.start();
        return ret;
    }

    public Map onStartingUnionAfter(Context ctx, String oldTreeId, String newTreeId, Timestamp date, boolean isSuccess) throws BOSException, EASBizException {
        logger.error((Object)("---------------start UnionVersionThreadMap1:" + UnionVersionUtil.UnionVersionThreadMap.toString()));
        UnionVersionUtil.UnionVersionThreadMap.put(oldTreeId + "1", isSuccess);
        while (UnionVersionUtil.UnionVersionThreadMap.containsKey(oldTreeId)) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {}
        }
        String key = oldTreeId + "0";
        if (UnionVersionUtil.UnionVersionThreadMap.containsKey(key)) {
            BOSException exption = (BOSException)((Object)UnionVersionUtil.UnionVersionThreadMap.get(key));
            UnionVersionUtil.UnionVersionThreadMap.remove(key);
            throw exption;
        }
        return null;
    }

    private void checkVersionDataNotSupportDS(Context ctx, String oldTreeId, Timestamp date, String datesql) throws BOSException {
        this.checkGroupRpt(ctx, oldTreeId, null, datesql, date, "BUDGETDATA");
        this.checkElimination(ctx, oldTreeId, null, datesql, date, "BUDGETDATA");
    }

    private void checkVersionData(Context ctx, String oldTreeId, String newTreeId, Timestamp date, String datesql) throws BOSException, SQLException, EASBizException {
        this.checkedParentUnit = new HashMap();
        StringBuffer oql = new StringBuffer();
        oql.append("select c.FUnitId as cFUnitId,d.FUnitId as dFUnitId from ");
        oql.append("(select a.FUnitId, b.FNumber from t_org_structure a ");
        oql.append(" join t_org_baseUnit b on a.FUnitId = b.FId");
        oql.append(" where a.FTreeId = ? and a.FLevel = 1 and a.FIsLeaf = 0) c,");
        oql.append("(select a.FUnitId, b.FNumber from t_org_structure a ");
        oql.append(" join t_org_baseUnit b on a.FUnitId = b.FId");
        oql.append(" where a.FTreeId = ? and a.FLevel = 1 and a.FIsLeaf = 0) d");
        oql.append("  where d.FNumber=c.FNumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])new Object[]{oldTreeId, newTreeId});
        if (rowSet.next()) {
            String topOldUnitId = rowSet.getString("cFUnitId");
            String topNewUnitId = rowSet.getString("dFUnitId");
            this.checkUnionIsChanged(ctx, topOldUnitId, topNewUnitId, oldTreeId, newTreeId, datesql, date);
        }
        try {
            this.checkInterExchCheckage(ctx, oldTreeId, newTreeId, datesql);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void getResultMap(Map ret, boolean isDeleteBudget) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("type", new Integer(isDeleteBudget ? 1 : 3));
        result.put("sum", this.sumRptList);
        result.put("adjust", this.adjustList);
        result.put("elim", this.elimList);
        result.put("normal", this.rptreceiveList);
        result.put("fastMergeSolu", this.fastMergeSoluList);
        result.put("fastSolu", this.fastSoluList);
        result.put("interCheck", this.interCheckageIdList);
        result.put("exchCheck", this.exchCheckageIdList);
        ret.put("result", result);
    }

    private void checkUnionIsChanged(Context ctx, String oldUnitId, String newUnitId, String oldTreeId, String newTreeId, String datesql, Timestamp date) throws BOSException, EASBizException {
        String oldId;
        boolean checkParent = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select s.FUnitId, b.FNumber from t_org_structure s");
        sql.append(" join t_org_baseunit b on s.FUnitId = b.FId");
        sql.append(" where s.FTreeId = ? and b.FIsGrouping = ?");
        sql.append(" and s.FParentId in (");
        sql.append(" select FId from t_org_structure");
        sql.append(" where FUnitId = ? and FTreeId = ?)");
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select s.FUnitId, b.FNumber from t_org_structure s");
        sql2.append(" join t_org_baseunit b on s.FUnitId = b.FId");
        sql2.append(" where s.FTreeId = ? and b.FIsGrouping = ?");
        Object[] params = new Object[]{oldTreeId, new Integer(0), oldUnitId, oldTreeId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        ArrayList<String> oldCompanys = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String unitid = rowSet.getString("FUnitId");
                oldCompanys.add(unitid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        params = new Object[]{newTreeId, new Integer(0), newUnitId, newTreeId};
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        ArrayList<String> newCompanys = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String unitid = rowSet.getString("FUnitId");
                newCompanys.add(unitid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        params = new Object[]{newTreeId, new Integer(0)};
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])params);
        ArrayList<String> allCompanys = new ArrayList<String>();
        ArrayList<String> moveCompanys = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String unitid = rowSet.getString("FUnitId");
                allCompanys.add(unitid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Iterator iter = oldCompanys.iterator();
        while (iter.hasNext()) {
            String oldCompanyId = (String)iter.next();
            if (newCompanys.contains(oldCompanyId)) {
                newCompanys.remove(oldCompanyId);
                iter.remove();
                continue;
            }
            if (!allCompanys.contains(oldCompanyId)) continue;
            iter.remove();
            moveCompanys.add(oldCompanyId);
        }
        if (!oldCompanys.isEmpty()) {
            this.whenDelCompany(ctx, oldTreeId, oldUnitId, oldCompanys, datesql, date);
            checkParent = true;
        }
        if (!newCompanys.isEmpty()) {
            this.whenAddCompany(ctx, oldTreeId, oldUnitId, datesql, date);
            checkParent = true;
        }
        if (!moveCompanys.isEmpty()) {
            this.whenMoveCompany(ctx, oldTreeId, oldUnitId, oldCompanys, datesql, date);
            checkParent = true;
        }
        params = new Object[]{oldTreeId, new Integer(1), oldUnitId, oldTreeId};
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        HashMap<String, String> oldUnions = new HashMap<String, String>();
        try {
            while (rowSet.next()) {
                String unitid = rowSet.getString("FUnitId");
                String number = rowSet.getString("FNumber");
                oldUnions.put(number, unitid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        params = new Object[]{newTreeId, new Integer(1), newUnitId, newTreeId};
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        HashMap<String, String> newUnions = new HashMap<String, String>();
        try {
            while (rowSet.next()) {
                String unitid = rowSet.getString("FUnitId");
                String number = rowSet.getString("FNumber");
                newUnions.put(number, unitid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Iterator iter2 = oldUnions.keySet().iterator();
        while (iter2.hasNext()) {
            String oldNumber = (String)iter2.next();
            if (!newUnions.containsKey(oldNumber)) continue;
            oldId = (String)oldUnions.get(oldNumber);
            String newId = (String)newUnions.get(oldNumber);
            iter2.remove();
            newUnions.remove(oldNumber);
            this.checkUnionIsChanged(ctx, oldId, newId, oldTreeId, newTreeId, datesql, date);
        }
        if (!oldUnions.isEmpty()) {
            this.whenDelUnion(ctx, oldTreeId, oldUnitId, datesql, date);
            for (String oldNumber : oldUnions.keySet()) {
                oldId = (String)oldUnions.get(oldNumber);
                try {
                    if (this.isMoved(ctx, oldTreeId, newTreeId, oldId, datesql, date)) {
                        continue;
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                this.deleteUnion(ctx, oldTreeId, newTreeId, oldId, datesql, date);
            }
            checkParent = true;
        }
        if (!newUnions.isEmpty()) {
            this.whenAddUnion(ctx, oldTreeId, oldUnitId, datesql, date);
            checkParent = true;
        }
        if (checkParent) {
            this.whenCheckParent(ctx, oldTreeId, oldUnitId, datesql, date);
        }
    }

    private boolean isMoved(Context ctx, String oldTreeId, String newTreeId, String unitId, String datesql, Timestamp date) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select s.FTreeId,s.FUnitId from t_org_structure s join t_org_baseunit b on s.funitid = b.fid");
        sql.append(" where s.FTreeId = ? and b.FNumber in (");
        sql.append(" select FNumber from t_org_baseunit where FId = ?)");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newTreeId, unitId});
        if (rowSet.next()) {
            String newUnitId = rowSet.getString("FUnitId");
            this.checkUnionIsChanged(ctx, unitId, newUnitId, oldTreeId, newTreeId, datesql, date);
            return true;
        }
        return false;
    }

    private void deleteUnion(Context ctx, String oldTreeId, String newTreeId, String oldUnitId, String datesql, Timestamp date) throws EASBizException, BOSException {
        this.checkSingleRpt(ctx, oldTreeId, oldUnitId, datesql, date, "ACTUALDATA");
        this.whenDelUnion(ctx, oldTreeId, oldUnitId, datesql, date);
        StringBuffer sql = new StringBuffer();
        sql.append("select s.FUnitId, b.FNumber from t_org_structure s");
        sql.append(" join t_org_baseunit b on s.FUnitId = b.FId");
        sql.append(" where s.FTreeId = ? and b.FIsGrouping = ?");
        sql.append(" and s.FParentId in (");
        sql.append(" select FId from t_org_structure");
        sql.append(" where FUnitId = ? and FTreeId = ?)");
        Object[] params = new Object[]{oldTreeId, new Integer(1), oldUnitId, oldTreeId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("FUnitId");
                if (this.isMoved(ctx, oldTreeId, newTreeId, id, datesql, date)) continue;
                this.deleteUnion(ctx, oldTreeId, newTreeId, id, datesql, date);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void whenAddCompany(Context ctx, String treeId, String unitId, String datesql, Timestamp date) throws BOSException, EASBizException {
        this.checkGroupRpt(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
        this.checkElimination(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
    }

    private void whenMoveCompany(Context ctx, String treeId, String unitId, List companyIds, String datesql, Timestamp date) throws BOSException, EASBizException {
        this.checkGroupRpt(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
        this.checkElimination(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
    }

    private void whenDelCompany(Context ctx, String treeId, String unitId, List companyIds, String datesql, Timestamp date) throws BOSException, EASBizException {
        this.checkGroupNormalRpt(ctx, treeId, companyIds, datesql, date, "ACTUALDATA");
        this.checkGroupRpt(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
        this.checkAdjust(ctx, treeId, unitId, companyIds, datesql, date, "ACTUALDATA");
        this.checkElimination(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
    }

    private void whenAddUnion(Context ctx, String treeId, String unitId, String datesql, Timestamp date) throws EASBizException, BOSException {
        this.checkGroupRpt(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
        this.checkElimination(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
    }

    private void whenDelUnion(Context ctx, String treeId, String unitId, String datesql, Timestamp date) throws BOSException, EASBizException {
        this.checkGroupRpt(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
        this.checkElimination(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
    }

    private void whenCheckParent(Context ctx, String treeId, String unitId, String datesql, Timestamp date) throws BOSException, EASBizException {
        try {
            this.checkGroupRpt(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
            this.checkElimination(ctx, treeId, unitId, datesql, date, "ACTUALDATA");
            this.checkedParentUnit.put(unitId, new Boolean(true));
            StringBuffer sql = new StringBuffer();
            sql.append("select b.FUnitId from t_org_structure a join t_org_structure b");
            sql.append(" on a.FParentId = b.FId");
            sql.append(" where a.FTreeId = ? and b.FTreeId = ? and a.FUnitId = ?");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId, treeId, unitId});
            if (rowSet.next()) {
                String parentId = rowSet.getString("FUnitId");
                this.whenCheckParent(ctx, treeId, parentId, datesql, date);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkSingleRpt(Context ctx, String treeId, String orgUnitId, String datesql, Timestamp date, String dataCollectNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FId from t_csl_rptreceived");
        sql.append(" where FOrgTreeID = '").append(treeId).append("' ");
        sql.append(" and FReportID in (");
        sql.append(" select FId from t_csl_cslreport");
        sql.append(" where FSourceType in (1,7,10)");
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            sql.append(" and FDataCollectNumber='").append(dataCollectNumber).append("' ");
        }
        sql.append(" and FReportDate >= Date'").append(date).append("' ");
        sql.append(" and ").append(datesql);
        sql.append(" and FOrgUnitId in (");
        sql.append(" select s.FUnitId from t_org_structure s");
        sql.append(" join t_org_baseunit b on s.FUnitId = b.FId");
        sql.append(" where s.FTreeId = ? and b.FIsGrouping = 0");
        sql.append(" and s.FParentId in (");
        sql.append(" select FId from t_org_structure");
        sql.append(" where FUnitId = ? and FTreeId = ?)))");
        Object[] param = new Object[]{treeId, orgUnitId, treeId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rowSet.next()) {
                this.rptreceiveList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (rowSet.size() > 0) {
            this.isCheckFlag = false;
        }
    }

    private void checkGroupNormalRpt(Context ctx, String treeId, List companyIds, String datesql, Timestamp date, String dataCollectNumber) throws BOSException {
        List curRptreceiveList = UnionVersionUtil.getGroupNormalRpts(ctx, treeId, companyIds, datesql, date, dataCollectNumber);
        if (curRptreceiveList != null && curRptreceiveList.size() > 0) {
            this.rptreceiveList.addAll(curRptreceiveList);
            curRptreceiveList.clear();
            this.isCheckFlag = false;
        }
    }

    private void checkHisData(Context ctx, String treeId) throws BOSException {
        this.checkHisRpt(ctx, treeId);
        this.checkHisAdjust(ctx, treeId);
        this.checkHisElimination(ctx, treeId);
    }

    private void checkHisRpt(Context ctx, String treeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.FId from t_csl_hisCslreport c join t_csl_hisRptReceived r on c.FID=r.FReportId ");
        sql.append(" where r.FOrgTreeId = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId});
        try {
            while (rowSet.next()) {
                this.hisRptList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (rowSet.size() > 0) {
            this.isCheckFlag = false;
        }
    }

    private void checkHisAdjust(Context ctx, String treeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from t_csl_hisAdjust where FOrgBoundId = ? ");
        Object[] param = new Object[]{treeId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rowSet.next()) {
                this.hisAdjustList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (rowSet.size() > 0) {
            this.isCheckFlag = false;
        }
    }

    private void checkHisElimination(Context ctx, String treeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FId from t_csl_hisElimination where FOrgBoundId = ? ");
        Object[] param = new Object[]{treeId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rowSet.next()) {
                this.hisElimList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (rowSet.size() > 0) {
            this.isCheckFlag = false;
        }
    }

    private void checkGroupRpt(Context ctx, String treeId, String unitId, String datesql, Timestamp date, String dataCollectNumber) throws BOSException {
        this.checkGroupRpt(ctx, treeId, unitId, datesql, date, 999, dataCollectNumber);
    }

    private void checkGroupRpt(Context ctx, String treeId, String orgUnitId, String datesql, Timestamp date, int rpttype, String dataCollectNumber) throws BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(orgUnitId);
        List curSumRptList = UnionVersionUtil.getGroupRpt(ctx, treeId, ids, datesql, date, rpttype, dataCollectNumber);
        if (curSumRptList != null && !curSumRptList.isEmpty()) {
            this.sumRptList.addAll(curSumRptList);
            curSumRptList.clear();
            this.isCheckFlag = false;
        }
    }

    private void checkAdjust(Context ctx, String treeId, String orgUnitId, List companyIds, String datesql, Timestamp date, String dataCollectNumber) throws BOSException {
        List curAdjustList = UnionVersionUtil.getAdjust(ctx, treeId, orgUnitId, companyIds, datesql, date, dataCollectNumber);
        if (curAdjustList != null && !curAdjustList.isEmpty()) {
            this.adjustList.addAll(curAdjustList);
            curAdjustList.clear();
            this.isCheckFlag = false;
        }
    }

    private void checkElimination(Context ctx, String treeId, String orgUnitId, String datesql, Timestamp date, String dataCollectNumber) throws BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(orgUnitId);
        List curElimList = UnionVersionUtil.getElimination(ctx, treeId, ids, datesql, date, dataCollectNumber);
        if (curElimList != null && !curElimList.isEmpty()) {
            this.elimList.addAll(curElimList);
            curElimList.clear();
            this.isCheckFlag = false;
        }
    }

    private void checkFastMergeSolu(Context ctx, String treeId, String orgUnitId) throws BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(orgUnitId);
        Map fastMergeSolus = UnionVersionUtil.getFastMergeSolu(ctx, treeId, ids);
        if (fastMergeSolus != null && !fastMergeSolus.isEmpty()) {
            this.fastSoluList.add(fastMergeSolus);
            this.isCheckFlag = false;
        }
    }

    private String getLastOrgTree(Context ctx, OrgTreeInfo tree) throws EASBizException, BOSException {
        String oldTreeId = null;
        Timestamp date = tree.getStartDate();
        Date preday = RPTDateUtil.getPreDay(date);
        StringBuffer treesql = new StringBuffer();
        treesql.append("select top 1 FId, FNumber from t_org_tree");
        treesql.append(" where FNumber = '").append(tree.getNumber());
        treesql.append("' and FEndDate <= ").append(CslRptUtil.formatDateForSql(preday));
        treesql.append(" order by FEndDate desc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)treesql.toString());
        try {
            if (rowSet.next()) {
                oldTreeId = rowSet.getString("FId");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return oldTreeId;
    }

    public Map onUnstartingUnion(Context ctx, String treeId) throws Exception {
        this.init();
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        OrgTreeInfo tree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(treeId));
        if (tree.isIsForBudget()) {
            result.put("state", Boolean.TRUE);
            return result;
        }
        Timestamp date = tree.getStartDate();
        String oldTreeId = this.getLastOrgTree(ctx, tree);
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS"});
        boolean isMergeByFiscalPeriod = values[0];
        boolean isSupportOtherDS = values[1];
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, tree);
        }
        String datesql = UnionBeforeVersion.getSqlByDateMore(tree.getStartDate(), null, periods, isMergeByFiscalPeriod);
        if (oldTreeId == null) {
            this.checkNormalOnUnstart(ctx, treeId);
            this.checkGroupOnUnstart(ctx, treeId, datesql);
            this.checkEliminationOnUnstart(ctx, treeId, datesql);
            this.checkAdjustOnUnstart(ctx, treeId, datesql);
            this.checkFastMergeSolutionOnUnStart(ctx, treeId);
            if (!(this.sumRptList.isEmpty() && this.elimList.isEmpty() && this.adjustList.isEmpty() && this.rptreceiveList.isEmpty() && this.fastMergeSoluList.isEmpty())) {
                result.put("state", Boolean.FALSE);
                HashMap<String, Object> temp = new HashMap<String, Object>(8);
                temp.put("type", new Integer(3));
                temp.put("sum", this.sumRptList);
                temp.put("adjust", this.adjustList);
                temp.put("elim", this.elimList);
                temp.put("normal", this.rptreceiveList);
                temp.put("fastMergeSolu", this.fastMergeSoluList);
                result.put("result", temp);
                return result;
            }
            result.put("state", Boolean.TRUE);
            StringBuffer sql = new StringBuffer();
            sql.append("delete t_csl_rptreceived where FOrgTreeId = '");
            sql.append(treeId).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else {
            if (!isSupportOtherDS) {
                this.checkHisData(ctx, treeId);
                if (!(this.hisSumRptList.isEmpty() && this.hisElimList.isEmpty() && this.hisAdjustList.isEmpty() && this.hisRptList.isEmpty())) {
                    result.put("state", Boolean.FALSE);
                    HashMap<String, Object> temp = new HashMap<String, Object>(8);
                    temp.put("type", new Integer(2));
                    temp.put("hissum", this.sumRptList);
                    temp.put("hisadjust", this.adjustList);
                    temp.put("hiselim", this.elimList);
                    temp.put("hisnormal", this.rptreceiveList);
                    result.put("result", temp);
                    return result;
                }
            }
            this.checkVersionDataOnUnstart(ctx, treeId, date, oldTreeId, periods, isMergeByFiscalPeriod);
            if (!(this.sumRptList.isEmpty() && this.elimList.isEmpty() && this.adjustList.isEmpty() && this.rptreceiveList.isEmpty() && this.fastSoluList.isEmpty())) {
                result.put("state", Boolean.FALSE);
                HashMap<String, Object> temp = new HashMap<String, Object>(8);
                temp.put("type", new Integer(3));
                temp.put("sum", this.sumRptList);
                temp.put("adjust", this.adjustList);
                temp.put("elim", this.elimList);
                temp.put("normal", this.rptreceiveList);
                temp.put("fastSolu", this.fastSoluList);
                result.put("result", temp);
                return result;
            }
            result.put("state", Boolean.TRUE);
            this.checkedParentUnit.clear();
            UnionVersionUtil.rollbackHistory(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
            UnionVersionUtil.rollbackData(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
            this.deleteRemovedOrgUnitRecord(ctx);
            UnionVersionUtil.repairRptReceivedData(ctx, oldTreeId);
            UnionVersionUtil.repairDataAfterVersioning(ctx, oldTreeId, date, periods, isMergeByFiscalPeriod, 0);
        }
        TemplateDispenseNewUtil.deleteDispenseByOrgTree((Context)ctx, (OrgTreeInfo)tree);
        return result;
    }

    private void deleteRemovedOrgUnitRecord(Context ctx) throws BOSException {
        if (this.fastSoluList != null && this.fastSoluList.size() > 0) {
            ArrayList<String> orgUnits = new ArrayList<String>();
            for (Map<String, List<String>> map : this.fastSoluList) {
                for (String soluid : map.keySet()) {
                    List<String> unitids = map.get(soluid);
                    for (String unitid : unitids) {
                        if (orgUnits.contains(unitid)) continue;
                        orgUnits.add(unitid);
                    }
                }
            }
            this.deleteOrgUnitsOfFastSolu(ctx, orgUnits);
        }
    }

    private void deleteOrgUnitsOfFastSolu(Context ctx, List<String> orgUnits) throws BOSException {
        if (orgUnits != null && orgUnits.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append(" delete from T_CSL_FastMergeOrgUnit \n");
            sql.append(" where forgUnitid in (").append(CslRptUtil.collection2String(orgUnits, ",", true)).append(") \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void checkVersionDataOnUnstart(Context ctx, String treeId, Timestamp date, String oldTreeId, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, SQLException, EASBizException {
        this.checkedParentUnit = new HashMap();
        StringBuffer oql = new StringBuffer();
        oql.append("select a.FUnitId, b.FNumber from t_org_structure a ");
        oql.append(" join t_org_baseUnit b on a.FUnitId = b.FId");
        oql.append(" where a.FTreeId = ? and a.FLevel = 1 and a.FIsLeaf = 0");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])new Object[]{treeId});
        if (rowSet.next()) {
            String topUnitId = rowSet.getString("FUnitId");
            String topNumber = rowSet.getString("FNumber");
            IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])new Object[]{oldTreeId});
            if (rowSet2.next()) {
                String topOldUnitId = rowSet2.getString("FUnitId");
                String topOldNumber = rowSet2.getString("FNumber");
                if (topNumber.equals(topOldNumber)) {
                    String datesql = UnionBeforeVersion.getSqlByDateMore(date, null, periods, isMergeByFiscalPeriod);
                    this.checkUnionIsChanged(ctx, topUnitId, topOldUnitId, treeId, oldTreeId, datesql, date);
                }
            }
        }
        oql = new StringBuffer();
        oql.append("select rpt.FID as FID from t_csl_cslreport rpt ");
        oql.append(" where rpt.forgtreeid = '" + treeId + "'  ");
        oql.append(" and " + UnionBeforeVersion.getSqlByDateMore(date, null, periods, isMergeByFiscalPeriod));
        oql.append(" and rpt.fsourcetype in (2,3,4,8,11,12)");
        oql.append(" and rpt.FTemplateId not in (");
        oql.append(" select FDispenseSrcID from t_csl_templetDispense ");
        oql.append(" where FOrgBoundID = '" + oldTreeId + "')");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        while (rowSet.next()) {
            String id = rowSet.getString("FId");
            if (this.sumRptList.contains(id)) continue;
            this.sumRptList.add(id);
        }
    }

    private void checkAdjustOnUnstart(Context ctx, String treeId, String datesql) throws BOSException, SQLDataException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from t_csl_adjust");
        sql.append(" where FOrgBoundId = ? ");
        sql.append(" and ").append(datesql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId});
        try {
            while (rowSet.next()) {
                this.adjustList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkEliminationOnUnstart(Context ctx, String treeId, String datesql) throws BOSException, SQLDataException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from t_csl_elimination");
        sql.append(" where FOrgBoundId = ? ");
        sql.append(" and ").append(datesql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId});
        try {
            while (rowSet.next()) {
                this.elimList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkFastMergeSolutionOnUnStart(Context ctx, String treeId) throws BOSException, SQLDataException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid ");
        sql.append(" from T_CSL_FastMergeSolu where FOrgBoundID = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId});
        try {
            while (rowSet.next()) {
                this.fastMergeSoluList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkGroupOnUnstart(Context ctx, String treeId, String datesql) throws BOSException, SQLDataException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from t_csl_cslreport where fsourcetype in (2,3,4,8,11,12) \r\n");
        sql.append("AND FOrgTreeId = ? ");
        sql.append(" and ").append(datesql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId});
        try {
            while (rowSet.next()) {
                this.sumRptList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkNormalOnUnstart(Context ctx, String treeId) throws BOSException, SQLDataException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select r.FId ").append(" from t_csl_cslreport c join t_csl_rptreceived r on c.fid=r.freportid ").append(" where r.forgtreeid=? ").append(" and c.fsourcetype in (1,7,10)");
        sql.append(" and not exists(select 1 from t_csl_rptreceived rc where rc.freportid=r.FReportID and rc.FOrgTreeID<>'");
        sql.append(treeId).append("')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId});
        try {
            while (rowSet.next()) {
                this.rptreceiveList.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void onCreatingNewUnion(Context ctx, String oldTreeId) throws Exception {
        OrgTreeInfo tree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(oldTreeId));
        if (tree.isIsForBudget()) {
            return;
        }
        String sql = "select top 1 FId from t_csl_cslreport where FOrgTreeId = '" + oldTreeId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            return;
        }
        sql = "select top 1 t1.FId from t_csl_cslreport t1,t_csl_rptReceived t2 where t1.forgtreeid=t2.forgtreeid And t2.FOrgTreeId = '" + oldTreeId + "'";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            return;
        }
        sql = "select top 1 FId from t_csl_rptReceived where FOrgTreeId = '" + oldTreeId + "'";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            return;
        }
        sql = "select top 1 FId from t_csl_adjust where FOrgBoundId = '" + oldTreeId + "'";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            return;
        }
        sql = "select top 1 FId from t_csl_elimination where FOrgBoundId = '" + oldTreeId + "'";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            return;
        }
        sql = "select top 1 FId from T_CSL_FastMergeSolu where FOrgBoundId = '" + oldTreeId + "'";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            return;
        }
        throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"UnionVersion_NoBusinessData", (Locale)ctx.getOriginLocale())));
    }

    public static String getSqlByDateMore(Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) {
        return UnionBeforeVersion.getSqlByDateMore(date, null, periods, isMergeByFiscalPeriod);
    }

    public static String getSqlByDateMore(Timestamp date, String tableAlias, PeriodCollection periods, boolean isMergeByFiscalPeriod) {
        if (date == null) {
            return null;
        }
        tableAlias = StringUtils.isEmpty((String)tableAlias) ? "" : tableAlias + ".";
        StringBuffer result = new StringBuffer();
        int[] period = FiscalPeriodHelper.getPeriod(date, RptPeriodTypeEnum.DAILY, periods, isMergeByFiscalPeriod);
        result.append("((").append(tableAlias).append("FYear > ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(1);
        result.append(") or (").append(tableAlias).append("FYear = ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriod >= ").append(period[1]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(1);
        period = FiscalPeriodHelper.getPeriod(date, RptPeriodTypeEnum.WEEKLY, periods, isMergeByFiscalPeriod);
        result.append(") or (").append(tableAlias).append("FYear > ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(2);
        result.append(") or (").append(tableAlias).append("FYear = ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriod >= ").append(period[1]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(2);
        period = FiscalPeriodHelper.getPeriod(date, RptPeriodTypeEnum.MONTHLY, periods, isMergeByFiscalPeriod);
        result.append(") or (").append(tableAlias).append("FYear > ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(3);
        result.append(") or (").append(tableAlias).append("FYear = ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriod >= ").append(period[1]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(3);
        period = FiscalPeriodHelper.getPeriod(date, RptPeriodTypeEnum.QUARTERLY, periods, isMergeByFiscalPeriod);
        result.append(") or (").append(tableAlias).append("FYear > ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(4);
        result.append(") or (").append(tableAlias).append("FYear = ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriod >= ").append(period[1]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(4);
        period = FiscalPeriodHelper.getPeriod(date, RptPeriodTypeEnum.SEMIYEARLY, periods, isMergeByFiscalPeriod);
        result.append(") or (").append(tableAlias).append("FYear > ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(5);
        result.append(") or (").append(tableAlias).append("FYear = ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriod >= ").append(period[1]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(5);
        period = FiscalPeriodHelper.getPeriod(date, RptPeriodTypeEnum.YEARLY, periods, isMergeByFiscalPeriod);
        result.append(") or (").append(tableAlias).append("FYear >= ").append(period[0]);
        result.append(" and ").append(tableAlias).append("FPeriodType = ").append(6);
        result.append("))");
        return result.toString();
    }

    public static String getSqlByDate(Timestamp date) {
        if (date == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int[] period = RPTDateUtil.getPeriod(date, RptPeriodTypeEnum.DAILY);
        result.append("((FYear = ").append(period[0]);
        result.append(" and FPeriod = ").append(period[1]);
        result.append(" and FPeriodType = ").append(1);
        period = RPTDateUtil.getPeriod(date, RptPeriodTypeEnum.WEEKLY);
        result.append(") or (FYear = ").append(period[0]);
        result.append(" and FPeriod = ").append(period[1]);
        result.append(" and FPeriodType = ").append(2);
        period = RPTDateUtil.getPeriod(date, RptPeriodTypeEnum.MONTHLY);
        result.append(") or (FYear = ").append(period[0]);
        result.append(" and FPeriod = ").append(period[1]);
        result.append(" and FPeriodType = ").append(3);
        period = RPTDateUtil.getPeriod(date, RptPeriodTypeEnum.QUARTERLY);
        result.append(") or (FYear = ").append(period[0]);
        result.append(" and FPeriod = ").append(period[1]);
        result.append(" and FPeriodType = ").append(4);
        period = RPTDateUtil.getPeriod(date, RptPeriodTypeEnum.SEMIYEARLY);
        result.append(") or (FYear = ").append(period[0]);
        result.append(" and FPeriod = ").append(period[1]);
        result.append(" and FPeriodType = ").append(5);
        period = RPTDateUtil.getPeriod(date, RptPeriodTypeEnum.YEARLY);
        result.append(") or (FYear = ").append(period[0]);
        result.append(" and FPeriod = ").append(period[1]);
        result.append(" and FPeriodType = ").append(6);
        result.append("))");
        return result.toString();
    }

    public static List checkCompanyPeriodType(Context ctx, String orgTreeId) throws BOSException {
        ArrayList<String> companys = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select baseunit.fname_").append(ctx.getLocale()).append(" as name from t_org_baseunit baseunit ");
        sql.append("join  t_org_structure structure on structure.FUnitId = baseunit.FId ");
        sql.append("join t_org_tree orgTree1 on  structure.ftreeid=orgTree1.fid and orgTree1.fid='").append(orgTreeId).append("'");
        sql.append("join t_org_tree orgTree on  orgTree.fnumber=orgTree1.fnumber ");
        sql.append("join t_csl_orgtreeperiod orgtreePeriod on orgtreePeriod.forgtreeid=orgTree.fid ");
        sql.append("where baseunit.FIsGrouping =0  ");
        sql.append("and ( not exists(select 1 from T_ORG_Company where FId= baseunit.fId) ");
        sql.append("or  exists(select 1 from T_ORG_Company where FId= baseunit.fId and orgtreePeriod.FperiodTypeId!=FAccountPeriodID)) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                companys.add(rowSet.getString("name"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return companys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInterExchCheckage(Context ctx, String oldTreeId, String newTreeId, String datesql) throws Exception {
        String createSql = "create table t_csl_checkagelog(fid varchar(44))";
        String checkageIdTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSql);
        try {
            this.checkInterExchCheckage(ctx, oldTreeId, newTreeId, datesql, checkageIdTable, true);
            DbUtil.execute((Context)ctx, (String)("delete from " + checkageIdTable));
            this.checkInterExchCheckage(ctx, oldTreeId, newTreeId, datesql, checkageIdTable, false);
            if (!this.interCheckageIdList.isEmpty() || !this.exchCheckageIdList.isEmpty()) {
                this.isCheckFlag = false;
            }
        }
        finally {
            if (checkageIdTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(checkageIdTable);
            }
        }
    }

    private void checkInterExchCheckage(Context ctx, String oldTreeId, String newTreeId, String datesql, String tmpTableName, boolean isInter) throws Exception {
        String checkageTable = isInter ? "T_CSL_InterDataCheckage" : "t_csl_exchcheckage";
        String checkageEntryTable = isInter ? "T_CSL_DataCheckageEntry" : "t_csl_exchcheckageentry";
        StringBuffer sql = new StringBuffer(300);
        sql.append(" insert into ").append(tmpTableName).append("\n").append(" select fid from (").append(" select max(chkentry.fid) fid,chkentry.fcheckageid fcheckageid \n").append("  from ").append(checkageTable).append(" chk \n").append(" inner join ").append(checkageEntryTable).append(" chkentry on chk.fid=chkentry.fcheckageid \n").append(" where chk.forgboundid='" + oldTreeId + "' \n").append(" and ").append(datesql).append(" group by chkentry.fcheckageid ) a \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        HashMap<String, String> company_strLongNumbers_new = new HashMap<String, String>();
        sql.setLength(0);
        sql.append("select distinct orgstr.funitid funitid,orgstr.flongnumber flongnumber \n");
        sql.append(" from ").append(checkageEntryTable).append(" chkentry  \n");
        sql.append(" inner join t_org_structure orgstr on orgstr.funitid=chkentry.fcompanyid or orgstr.funitid=chkentry.ftargetcompanyid \n");
        sql.append(" where chkentry.fid in(select fid from ").append(tmpTableName).append(" ids) \n");
        sql.append(" and orgstr.ftreeid='").append(newTreeId).append("' \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            while (rowSet.next()) {
                company_strLongNumbers_new.put(rowSet.getString("funitid"), rowSet.getString("flongnumber"));
            }
        }
        sql.setLength(0);
        HashMap<String, String> company_strLongNumbers_old = new HashMap<String, String>();
        sql.append("select distinct orgstr.funitid funitid,orgstr.flongnumber flongnumber \n");
        sql.append(" from ").append(checkageEntryTable).append(" chkentry  \n");
        sql.append(" inner join t_org_structure orgstr on orgstr.funitid=chkentry.fcompanyid or orgstr.funitid=chkentry.ftargetcompanyid \n");
        sql.append(" where chkentry.fid in(select fid from ").append(tmpTableName).append(" ids) \n");
        sql.append(" and orgstr.ftreeid='").append(oldTreeId).append("' \n");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            while (rowSet.next()) {
                company_strLongNumbers_old.put(rowSet.getString("funitid"), rowSet.getString("flongnumber"));
            }
        }
        sql.setLength(0);
        sql.append("select distinct chk.fid fid,chkentry.fcompanyid fcompanyid,chkentry.ftargetcompanyid ftargetcompanyid \n");
        sql.append(" from  ").append(checkageTable).append(" chk  \n");
        sql.append(" inner join ").append(checkageEntryTable).append(" chkentry on chk.fid=chkentry.fcheckageid \n");
        sql.append(" where chkentry.fid in(select fid from ").append(tmpTableName).append(" ids) \n");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            String companyId = null;
            String targetCompanyId = null;
            String parentLongNumer_new = null;
            String id = null;
            String parentLongNumer_old = null;
            HashMap<String, String> catchNew = new HashMap<String, String>();
            HashMap<String, String> catchOld = new HashMap<String, String>();
            while (rowSet.next()) {
                companyId = rowSet.getString("fcompanyid");
                targetCompanyId = rowSet.getString("ftargetcompanyid");
                id = rowSet.getString("fid");
                parentLongNumer_new = (String)catchNew.get(companyId + targetCompanyId);
                if (parentLongNumer_new == null) {
                    parentLongNumer_new = this.getParentLongNumber(companyId, targetCompanyId, company_strLongNumbers_new);
                    catchNew.put(companyId + targetCompanyId, parentLongNumer_new);
                }
                if ((parentLongNumer_old = (String)catchOld.get(companyId + targetCompanyId)) == null) {
                    parentLongNumer_old = this.getParentLongNumber(companyId, targetCompanyId, company_strLongNumbers_old);
                    catchOld.put(companyId + targetCompanyId, parentLongNumer_old);
                }
                if (!StringUtils.isEmpty((String)parentLongNumer_new) && parentLongNumer_new.equals(parentLongNumer_old)) continue;
                if (isInter) {
                    this.interCheckageIdList.add(id);
                    continue;
                }
                this.exchCheckageIdList.add(id);
            }
        }
    }

    public String getParentLongNumber(String companyId, String targetCompanyId, Map<String, String> orgLongNumber) {
        String[] tarComLongNumbers;
        String companyLongNumber = orgLongNumber.get(companyId);
        String targCompanyLongNumber = orgLongNumber.get(targetCompanyId);
        StringBuffer parentLongNumber = new StringBuffer();
        if (companyLongNumber == null || targCompanyLongNumber == null) {
            return parentLongNumber.toString();
        }
        String[] compLongNumbers = companyLongNumber.split("!");
        int arrLength = compLongNumbers.length > (tarComLongNumbers = targCompanyLongNumber.split("!")).length ? tarComLongNumbers.length : compLongNumbers.length;
        for (int i = 0; i < arrLength && compLongNumbers[i].equals(tarComLongNumbers[i]); ++i) {
            if (parentLongNumber.length() > 0) {
                parentLongNumber.append("!");
            }
            parentLongNumber.append(compLongNumbers[i]);
        }
        return parentLongNumber.toString();
    }
}

