/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UnionCheckVersionDataNew {
    Map<String, Map<String, OrgStructureInfo>> oldParentId_childs = new HashMap<String, Map<String, OrgStructureInfo>>();
    Map<String, Map<String, OrgStructureInfo>> newParentId_childs = new HashMap<String, Map<String, OrgStructureInfo>>();
    Map<String, OrgStructureInfo> oldNumber_orgs = new HashMap<String, OrgStructureInfo>();
    Map<String, OrgStructureInfo> newNumber_orgs = new HashMap<String, OrgStructureInfo>();
    private Set<String> deleteCompanyIds = new HashSet<String>();
    private Set<String> checkUnionForShowIds = new HashSet<String>();
    private Set<String> deleteUnionIds = new HashSet<String>();
    private Set<String> checkUnionForShowNumbers = new HashSet<String>();
    private Set<String> deleteUnionNumbers = new HashSet<String>();
    private Set<String> checkParentUnionNumbers = new HashSet<String>();
    private List sumRptList = new ArrayList();
    private List adjustList = new ArrayList();
    private List elimList = new ArrayList();
    private List rptreceiveList = new ArrayList();
    private List sumRptListForShow = new ArrayList();
    private List elimListForShow = new ArrayList();
    private String newTreeId = null;

    public void checkUnionVersionDataNew(Context ctx, String oldTreeId, String newTreeId, Timestamp date, String datesql) throws Exception {
        String newTopNumber;
        OrgStructureCollection oldStructColl = this.getOrgStructureCollection(ctx, oldTreeId);
        OrgStructureCollection newStructColl = this.getOrgStructureCollection(ctx, newTreeId);
        String oldTopNumber = this.initOrgStructureMap(oldStructColl, this.oldParentId_childs, this.oldNumber_orgs);
        if (oldTopNumber.equals(newTopNumber = this.initOrgStructureMap(newStructColl, this.newParentId_childs, this.newNumber_orgs))) {
            this.checkUnionChanged(ctx, oldTopNumber, newTopNumber, oldTreeId, newTreeId, date, datesql);
        }
        this.oldParentId_childs.clear();
        this.newParentId_childs.clear();
        this.newNumber_orgs.clear();
        this.checkParentUnionChanged();
        this.unionNumbersToIds(this.deleteUnionNumbers, this.deleteUnionIds);
        this.unionNumbersToIds(this.checkUnionForShowNumbers, this.checkUnionForShowIds);
        this.initHandleData(ctx, oldTreeId, newTreeId, date, datesql);
        this.oldNumber_orgs.clear();
        this.newTreeId = newTreeId;
    }

    public void getResultMap(Map ret, boolean isDeleteBudget) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", new Integer(isDeleteBudget ? 1 : 3));
        result.put("sum", this.sumRptList);
        result.put("adjust", this.adjustList);
        result.put("elim", this.elimList);
        result.put("normal", this.rptreceiveList);
        result.put("sum_show", this.sumRptListForShow);
        result.put("elim_show", this.elimListForShow);
        result.put("OrgTreeID", this.newTreeId);
        ret.put("result", result);
    }

    private void initHandleData(Context ctx, String oldTreeId, String newTreeId, Timestamp date, String datesql) throws Exception {
        if (!this.deleteCompanyIds.isEmpty()) {
            ArrayList<String> companyIds = new ArrayList<String>();
            companyIds.addAll(this.deleteCompanyIds);
            this.rptreceiveList.addAll(UnionVersionUtil.getGroupNormalRpts(ctx, oldTreeId, companyIds, datesql, date, "ACTUALDATA"));
            this.adjustList.addAll(UnionVersionUtil.getAdjust(ctx, oldTreeId, null, companyIds, datesql, date, "ACTUALDATA"));
        }
        if (!this.deleteUnionIds.isEmpty()) {
            this.sumRptList.addAll(UnionVersionUtil.getGroupRpt(ctx, oldTreeId, this.deleteUnionIds, datesql, date, 999, "ACTUALDATA"));
            this.elimList.addAll(UnionVersionUtil.getElimination(ctx, oldTreeId, this.deleteUnionIds, datesql, date, "ACTUALDATA"));
        }
        if (!this.checkUnionForShowIds.isEmpty()) {
            this.sumRptListForShow.addAll(UnionVersionUtil.getGroupRpt(ctx, oldTreeId, this.checkUnionForShowIds, datesql, date, 999, "ACTUALDATA"));
            this.elimListForShow.addAll(UnionVersionUtil.getElimination(ctx, oldTreeId, this.checkUnionForShowIds, datesql, date, "ACTUALDATA"));
        }
    }

    private void unionNumbersToIds(Set<String> numbers, Set<String> ids) throws Exception {
        for (String number : numbers) {
            ids.add(this.oldNumber_orgs.get(number).getUnit().getId().toString());
        }
        numbers.clear();
    }

    private void checkParentUnionChanged() throws Exception {
        for (String number : this.deleteUnionNumbers) {
            this.parentUnionChanged(number);
        }
        HashSet<String> checkUnionForShowNumbersCopy = new HashSet<String>();
        checkUnionForShowNumbersCopy.addAll(this.checkUnionForShowNumbers);
        for (String number : checkUnionForShowNumbersCopy) {
            this.parentUnionChanged(number);
        }
        checkUnionForShowNumbersCopy.clear();
        this.checkParentUnionNumbers.clear();
    }

    private void parentUnionChanged(String number) throws Exception {
        OrgStructureInfo info = this.oldNumber_orgs.get(number);
        if (info.getParent() != null && !StringUtils.isEmpty((String)info.getParent().getUnit().getNumber())) {
            String parentNubmer = info.getParent().getUnit().getNumber();
            if (this.checkParentUnionNumbers.contains(parentNubmer)) {
                return;
            }
            if (!this.deleteUnionNumbers.contains(parentNubmer)) {
                this.checkUnionForShowNumbers.add(parentNubmer);
            }
            this.checkParentUnionNumbers.add(parentNubmer);
            this.parentUnionChanged(parentNubmer);
        }
    }

    public boolean isPassCheck() {
        return this.sumRptList.isEmpty() && this.adjustList.isEmpty() && this.elimList.isEmpty() && this.rptreceiveList.isEmpty();
    }

    public boolean isHasShow() {
        return !this.sumRptListForShow.isEmpty() || !this.elimListForShow.isEmpty();
    }

    private void checkUnionChanged(Context ctx, String oldNumber, String newNumber, String oldTreeId, String newTreeId, Timestamp date, String datesql) throws Exception {
        String oldTopId = this.oldNumber_orgs.get(oldNumber).getId().toString();
        String newTopId = this.newNumber_orgs.get(newNumber).getId().toString();
        Map<String, OrgStructureInfo> oldNumber_Childs = this.oldParentId_childs.get(oldTopId);
        Map<String, OrgStructureInfo> newNumber_Childs = this.newParentId_childs.get(newTopId);
        HashMap<String, OrgStructureInfo> tmpNewNumber_Childs = new HashMap<String, OrgStructureInfo>();
        if (newNumber_Childs == null && oldNumber_Childs == null) {
            return;
        }
        if (newNumber_Childs == null || oldNumber_Childs == null) {
            this.checkUnionForShowNumbers.add(oldNumber);
            return;
        }
        tmpNewNumber_Childs.putAll(newNumber_Childs);
        for (String number : oldNumber_Childs.keySet()) {
            if (!newNumber_Childs.containsKey(number)) {
                if (this.newNumber_orgs.containsKey(number)) {
                    if (!oldNumber_Childs.get(number).getUnit().isIsUnion()) {
                        this.checkUnionForShowNumbers.add(oldNumber);
                        continue;
                    }
                    this.checkUnionChanged(ctx, number, number, oldTreeId, newTreeId, date, datesql);
                    continue;
                }
                if (!oldNumber_Childs.get(number).getUnit().isIsUnion()) {
                    this.deleteCompanyIds.add(oldNumber_Childs.get(number).getUnit().getId().toString());
                } else {
                    this.deleteUnion(ctx, number, oldTreeId, newTreeId, date, datesql);
                }
                this.checkUnionForShowNumbers.add(oldNumber);
                continue;
            }
            tmpNewNumber_Childs.remove(number);
            if (!oldNumber_Childs.get(number).getUnit().isIsUnion()) continue;
            this.checkUnionChanged(ctx, number, number, oldTreeId, newTreeId, date, datesql);
        }
        if (!tmpNewNumber_Childs.isEmpty()) {
            this.checkUnionForShowNumbers.add(this.oldNumber_orgs.get(oldNumber).getUnit().getNumber());
            tmpNewNumber_Childs.clear();
        }
    }

    private void deleteUnion(Context ctx, String oldNumber, String oldTreeId, String newTreeId, Timestamp date, String datesql) throws Exception {
        String oldId = this.oldNumber_orgs.get(oldNumber).getUnit().getId().toString();
        this.deleteUnionNumbers.add(this.oldNumber_orgs.get(oldNumber).getUnit().getNumber());
        Map<String, OrgStructureInfo> oldNumber_Childs = this.oldParentId_childs.get(oldId);
        if (oldNumber_Childs != null) {
            OrgStructureInfo info = null;
            for (String number : oldNumber_Childs.keySet()) {
                info = this.newNumber_orgs.get(number);
                if (info == null) {
                    if (oldNumber_Childs.get(number).getUnit().isIsUnion()) {
                        this.deleteUnion(ctx, number, oldTreeId, newTreeId, date, datesql);
                        continue;
                    }
                    this.deleteCompanyIds.add(oldNumber_Childs.get(number).getUnit().getId().toString());
                    this.checkUnionForShowNumbers.add(oldNumber);
                    continue;
                }
                if (info.getUnit().isIsUnion()) {
                    this.checkUnionChanged(ctx, number, number, oldTreeId, newTreeId, date, datesql);
                    continue;
                }
                this.checkUnionForShowNumbers.add(oldNumber);
            }
        }
    }

    private String initOrgStructureMap(OrgStructureCollection structColl, Map<String, Map<String, OrgStructureInfo>> parentId_childs, Map<String, OrgStructureInfo> number_orgs) throws Exception {
        OrgStructureInfo curOrgInfo = null;
        String topNumber = null;
        Map<String, OrgStructureInfo> orgStructureMap = null;
        for (int i = 0; i < structColl.size(); ++i) {
            curOrgInfo = structColl.get(i);
            number_orgs.put(curOrgInfo.getUnit().getNumber(), curOrgInfo);
            if (curOrgInfo.getLevel() == 1 && curOrgInfo.getUnit().isIsUnion()) {
                topNumber = curOrgInfo.getUnit().getNumber();
            }
            if (curOrgInfo.getParent() == null || curOrgInfo.getParent().getId() == null) continue;
            orgStructureMap = parentId_childs.get(curOrgInfo.getParent().getId().toString());
            if (orgStructureMap == null) {
                orgStructureMap = new HashMap<String, OrgStructureInfo>();
                parentId_childs.put(curOrgInfo.getParent().getId().toString(), orgStructureMap);
            }
            orgStructureMap.put(curOrgInfo.getUnit().getNumber(), curOrgInfo);
        }
        structColl.clear();
        return topNumber;
    }

    private OrgStructureCollection getOrgStructureCollection(Context ctx, String orgTreeid) throws Exception {
        return OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select level,unit.number,unit.isUnion,unit.id,parent.id,parent.unit.number where tree.id='" + orgTreeid + "'");
    }
}

