/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems.CheckLogService;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;

public abstract class AbstractTempTblServer {
    private String tempTblName;
    public Context _ctx;
    public static final int MAX_PARAMS_SIZE = 200;
    protected CheckLogService log = new CheckLogService();

    public boolean haveRecords() throws BOSException {
        if (StringUtils.isEmpty((String)this.tempTblName)) {
            return false;
        }
        String sql = "select top 1 * from " + this.tempTblName;
        IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    public abstract void insertData2TempTbl() throws BOSException, EASBizException;

    public abstract void createTable() throws BOSException;

    public String getTempTblName() {
        return this.tempTblName;
    }

    public void setTempTblName(String tempTblName) {
        this.tempTblName = tempTblName;
    }

    protected String createTempTable(String createSql, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        try {
            String tableName = pool.createTempTable(createSql);
            pool.createIndex(tableName, columns, false, false);
            return tableName;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void releaseDefaultTmpTbl() {
        this.releaseTempTable(this.tempTblName);
    }

    public void releaseTempTable(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        TempTablePool.getInstance((Context)this._ctx).releaseTable(tableName);
    }
}

