/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems.AbstractTempTblServer;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class CompanyDispensedTemplateTempTblServer
extends AbstractTempTblServer {
    private List _companyIDs;
    private String _templateID;
    private String _orgBoundID;
    private String companyTmpTblName;

    public CompanyDispensedTemplateTempTblServer(Context ctx, List companyIDs, String templateID, String orgBoundID) {
        this._ctx = ctx;
        this._companyIDs = companyIDs;
        this._templateID = templateID;
        this._orgBoundID = orgBoundID;
    }

    @Override
    public void insertData2TempTbl() throws BOSException, EASBizException {
        if (this._companyIDs == null || this._companyIDs.size() <= 0) {
            return;
        }
        String group = TemplateFactory.getLocalInstance((Context)this._ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(this._templateID)).getGroup();
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert into ").append(this.getTempTblName()).append("\n").append(" SELECT distinct t1.fgroup, \n").append(" concat(rtrim(convert(varchar(50),max(TO_INT(substring(fversionnumber,1,charindex('.',fversionnumber)-1))))||''),'.0') FVERSIONNUMBER \n").append(" FROM ").append(TemplateDispenseNewUtil.getDisTable((Context)this._ctx, (String)this._orgBoundID)).append(" tmpDisp \n").append(" INNER JOIN T_RPT_Template t1 ON tmpDisp.FDispenseSrcID = t1.FID  \n").append(" where t1.FID <> ? and tmpDisp.ForgBoundID = ? and t1.fgroup <> ? \n").append(" and t1.FisFreezed = 0 and tmpDisp.FCompanyID in(");
        if (this._companyIDs.size() > 200) {
            this.insertCompanyIDs2Tbl();
        }
        sql.append(this.getCompanySqlStr()).append(") \n");
        this.specialHandle(sql);
        sql.append(" GROUP BY t1.fgroup, tmpDisp.FCompanyID");
        this.log.startTime();
        DbUtil.execute((Context)this._ctx, (String)sql.toString(), (Object[])new Object[]{this._templateID, this._orgBoundID, group});
        this.log.endTime();
        this.log.printLog("CompanyDispensedTemplateTempTblServer.insertData2TempTbl()", sql.toString(), new Object[]{this._templateID, this._orgBoundID, group});
    }

    private void specialHandle(StringBuffer sql) throws EASBizException, BOSException {
        TemplateInfo info = TemplateFactory.getLocalInstance((Context)this._ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(this._templateID));
        if (info == null) {
            return;
        }
        RptTmpTypeEnum tmpType = info.getTemplateType();
        String addSql = "";
        addSql = tmpType == RptTmpTypeEnum.MULTIDYNAMICCSLREPORT || tmpType == RptTmpTypeEnum.DYNAMICNORMALREPORT ? "15,10" : (tmpType == RptTmpTypeEnum.MULTIDYNAMICSUMREPORT || tmpType == RptTmpTypeEnum.DYNAMICSUMREPORT ? "17,11" : "" + tmpType.getValue());
        sql.append(" and t1.FTemplateType in (" + addSql + ") and t1.FperiodType = ").append(info.getPeriodType().getValue());
    }

    public String getCompanySqlStr() {
        if (this._companyIDs.size() > 200) {
            return "select FCompanyID from " + this.companyTmpTblName;
        }
        return CslRptUtil.AryToItemString(this._companyIDs);
    }

    @Override
    public void createTable() throws BOSException {
        String tmpSql = "create Table T_TMP_OTHERTPLS(FGROUP nvarchar(36),FVERSIONNUMBER nvarchar(80))";
        String tableName = this.createTempTable(tmpSql, "FGROUP,FVERSIONNUMBER", false, false);
        this.setTempTblName(tableName);
    }

    private void insertCompanyIDs2Tbl() throws BOSException {
        this.companyTmpTblName = this.createCompanyTempTbl();
        String insertSql = "insert into " + this.companyTmpTblName + " values(?)";
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this._ctx);
            ps = conn.prepareStatement(insertSql);
            int batchCount = 0;
            int size = this._companyIDs.size();
            for (int k = 0; k < size; ++k) {
                String companyID = (String)this._companyIDs.get(k);
                ps.setString(1, companyID);
                ps.addBatch();
                if (++batchCount < 1000 && k + 1 != size) continue;
                ps.executeBatch();
                batchCount = 0;
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private String createCompanyTempTbl() throws BOSException {
        String sql = "create table T_TMP_COMPANYIDS(FCOMPANYID NVARCHAR(44))";
        return this.createTempTable(sql, "FCOMPANYID", false, false);
    }

    @Override
    public void releaseDefaultTmpTbl() {
        super.releaseDefaultTmpTbl();
        this.releaseTempTable(this.companyTmpTblName);
    }
}

