/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems.AbstractTempTblServer;
import com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems.CompanyDispensedTemplateTempTblServer;
import com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems.TemplateAuditTempTblServer;
import com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems.TemplateDispenseTempTblServer;
import com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems.TemplateItemDataTempTblServer;
import com.kingdee.eas.fi.gr.cslrpt.app.chcksingletmpitems.TemplateUnForbidTempTblServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TempTableManager {
    public static final String TEMPLATE_ITEM_LIST = "TEMPLATE_ITEM_LIST";
    public static final String TEMPLATE_DISPENSE_LIST = "TEMPLATE_DISPENSE_LIST";
    private final Context _ctx;
    private final String _orgBoundID;
    private final List _companyIDs;
    private final String _templateID;
    private Map tempTblServers;
    private final String _entryType;

    public TempTableManager(Context ctx, String orgBoundID, List companyIDs, String templateID, String entryType) {
        this._ctx = ctx;
        this._orgBoundID = orgBoundID;
        this._companyIDs = companyIDs;
        this._templateID = templateID;
        this._entryType = entryType;
        this.tempTblServers = new HashMap(2);
    }

    public void initTempTblService() {
        TemplateItemDataTempTblServer server = "AUDIT".equals(this._entryType) ? new TemplateAuditTempTblServer(this._ctx, this._templateID) : ("UNFORBID".equals(this._entryType) ? new TemplateUnForbidTempTblServer(this._ctx, this._templateID) : new TemplateDispenseTempTblServer(this._ctx, this._templateID));
        this.tempTblServers.put(TEMPLATE_ITEM_LIST, server);
        this.tempTblServers.put(TEMPLATE_DISPENSE_LIST, new CompanyDispensedTemplateTempTblServer(this._ctx, this._companyIDs, this._templateID, this._orgBoundID));
    }

    public void generateTemporaryData() throws BOSException, EASBizException {
        AbstractTempTblServer server = this.getServer(TEMPLATE_ITEM_LIST);
        server.createTable();
        server.insertData2TempTbl();
        if (!server.haveRecords()) {
            return;
        }
        server = this.getServer(TEMPLATE_DISPENSE_LIST);
        server.createTable();
        server.insertData2TempTbl();
    }

    public boolean hasRecord() throws BOSException, EASBizException {
        boolean hasRecord = true;
        for (Map.Entry entry : this.tempTblServers.entrySet()) {
            AbstractTempTblServer server = (AbstractTempTblServer)entry.getValue();
            if (hasRecord = hasRecord && server.haveRecords()) continue;
            return false;
        }
        return hasRecord;
    }

    private AbstractTempTblServer getServer(String key) {
        return (AbstractTempTblServer)this.tempTblServers.get(key);
    }

    public String getTempTblName(String key) {
        return ((AbstractTempTblServer)this.tempTblServers.get(key)).getTempTblName();
    }

    public String getCompanySqlStr() {
        return ((CompanyDispensedTemplateTempTblServer)this.getServer(TEMPLATE_DISPENSE_LIST)).getCompanySqlStr();
    }

    public void clear() {
        if (this.tempTblServers != null) {
            for (Map.Entry entry : this.tempTblServers.entrySet()) {
                AbstractTempTblServer server = (AbstractTempTblServer)entry.getValue();
                server.releaseDefaultTmpTbl();
            }
            this.tempTblServers.clear();
        }
    }
}

