/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.ConvertModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtByUserDefinedRate;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtParamsManager;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ExchangeRateUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.HistoryExchRateConvtUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class ConvtUtil {
    protected static Logger logger = Logger.getLogger((String)ConvtUtil.class.getName());
    public static ThreadLocal convtCalcFormula = new ThreadLocal();
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    public static boolean isLogConvtFormula = false;
    public static Map<String, String> currencyMap = new HashMap<String, String>();
    public static Map<String, String> exchTableMap = new HashMap<String, String>();
    public static String exchRateMsg = null;
    public static String rptItemYearInitMsg = null;
    public static String acctItemMsg = null;
    public static String hisRateMsg = null;
    public static String hisRateMsgSum1 = null;
    public static String hisRateMsgSum2 = null;
    public static String userDefinedRate = null;

    public static void initResourceName(Context ctx, ConvtParamsManager paramsManager, CslReportInfo report) {
        try {
            isLogConvtFormula = CSLParamUtil.getBooleanCslParamValue(ctx, "isLogConvtFormula");
            if (!isLogConvtFormula) {
                return;
            }
            if (paramsManager.getTargetCurrencyInfo() != null && paramsManager.getTargetCurrencyInfo().getId() != null) {
                currencyMap.put(paramsManager.getTargetCurrencyInfo().getId().toString(), paramsManager.getTargetCurrencyInfo().getName());
            }
            if (report != null && report.getCurrency() != null && report.getCurrency().getId() != null) {
                currencyMap.put(report.getCurrency().getId().toString(), report.getCurrency().getName());
            }
            if (paramsManager.getExchangeTableInfo() != null && paramsManager.getExchangeTableInfo().getId() != null) {
                exchTableMap.put(paramsManager.getExchangeTableInfo().getId().toString(), paramsManager.getExchangeTableInfo().getName());
            }
            Locale locale = ctx.getOriginLocale();
            String path = "com.kingdee.eas.fi.gr.cslrpt.ConvertRate";
            exchRateMsg = ResourceBase.getString((String)path, (String)"138_exchRateMsg", (Locale)locale);
            rptItemYearInitMsg = ResourceBase.getString((String)path, (String)"139_rptItemYearInitMsg", (Locale)locale);
            acctItemMsg = ResourceBase.getString((String)path, (String)"140_acctItemMsg", (Locale)locale);
            hisRateMsg = ResourceBase.getString((String)path, (String)"143_hisRateMsg", (Locale)locale) + "\n";
            hisRateMsgSum1 = ResourceBase.getString((String)path, (String)"143_hisRateMsgSum1", (Locale)locale);
            hisRateMsgSum2 = ResourceBase.getString((String)path, (String)"143_hisRateMsgSum2", (Locale)locale);
            userDefinedRate = ResourceBase.getString((String)path, (String)"144_userDefinedRate", (Locale)locale);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public static String buildUserDefinedRateDetail(String yearPeriod) {
        if (!isLogConvtFormula || userDefinedRate == null) {
            return null;
        }
        try {
            MessageFormat format = new MessageFormat(userDefinedRate);
            if (yearPeriod != null) {
                return format.format(new Object[]{yearPeriod});
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    public static String buildHisRateDetail(String convtValue, String date, boolean isChangeAmount) {
        if (!isLogConvtFormula || hisRateMsgSum1 == null || hisRateMsgSum2 == null) {
            return null;
        }
        try {
            MessageFormat format = new MessageFormat(isChangeAmount ? hisRateMsgSum1 : hisRateMsgSum2);
            if (date != null) {
                return format.format(new Object[]{convtValue, convtValue, date});
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    public static String buildHisRateDetail(String convtValue, Date date) {
        if (!isLogConvtFormula || hisRateMsg == null) {
            return null;
        }
        try {
            MessageFormat format = new MessageFormat(hisRateMsg);
            if (date != null) {
                return format.format(new Object[]{convtValue, sdf.format(date)});
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    public static String buildAcctItemDetail(ItemDataCondition condition) {
        if (!isLogConvtFormula || acctItemMsg == null) {
            return null;
        }
        try {
            MessageFormat format = new MessageFormat(acctItemMsg);
            return format.format(new Object[]{condition.getItemList() == null ? condition.getItemNumberStart() : condition.getItemList().toString(), "" + condition.getRptYearStart() + condition.getRptPeriodStart() + "-" + condition.getRptYearEnd() + condition.getRptPeriodEnd()});
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public static String buildYearInitDetail(Map mapParams) {
        if (!isLogConvtFormula || rptItemYearInitMsg == null) {
            return null;
        }
        try {
            MessageFormat format = new MessageFormat(rptItemYearInitMsg);
            return format.format(new Object[]{mapParams.get("Year"), mapParams.get("KEY_ITEM_NUMBER")});
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public static String buildRateDetail(String exchTableId, String currencyId, String targetCurrencyId, Date availTime, Date date) {
        if (!isLogConvtFormula || exchRateMsg == null) {
            return null;
        }
        try {
            MessageFormat format = new MessageFormat(exchRateMsg);
            return format.format(new Object[]{exchTableMap.get(exchTableId), currencyMap.get(currencyId), currencyMap.get(targetCurrencyId), sdf.format(availTime), sdf.format(date)});
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public static String getConvtCalcFormulaValue() {
        if (!isLogConvtFormula) {
            return null;
        }
        try {
            Object obj = convtCalcFormula.get();
            if (obj != null) {
                return ((StringBuffer[])obj)[0].toString();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    public static String getConvtCalcFormulaDetail() {
        if (!isLogConvtFormula) {
            return null;
        }
        try {
            Object obj = convtCalcFormula.get();
            if (obj != null) {
                return ((StringBuffer[])obj)[1].toString();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    public static void setCellLinkFormula(Object cell, String linkFormula, String formualDetail) {
        if (!isLogConvtFormula) {
            return;
        }
        try {
            if (linkFormula != null) {
                if (cell instanceof Range) {
                    ((Range)cell).setUserObject(CslConstant.CalcFormulaKey, (Object)linkFormula);
                    ((Range)cell).setUserObject(CslConstant.CalcFormulaKeyDetail, (Object)formualDetail);
                } else if (cell instanceof Cell) {
                    ((Cell)cell).setUserObject(CslConstant.CalcFormulaKey, (Object)linkFormula);
                    ((Cell)cell).setUserObject(CslConstant.CalcFormulaKeyDetail, (Object)formualDetail);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public static void setConvtCalcFormula(String value, String detail) {
        ConvtUtil.setConvtCalcFormula(value, detail, "+");
    }

    public static void setConvtCalcFormula(String value, String detail, String split) {
        if (!isLogConvtFormula) {
            return;
        }
        try {
            Object obj = convtCalcFormula.get();
            StringBuffer values = null;
            StringBuffer details = null;
            if (obj == null || value == null) {
                values = new StringBuffer();
                details = new StringBuffer();
                convtCalcFormula.set(new StringBuffer[]{values, details});
            } else {
                values = ((StringBuffer[])obj)[0];
                details = ((StringBuffer[])obj)[1];
            }
            if (value != null) {
                if (values.length() > 0 && split != null && values.charAt(values.length() - 1) != '+') {
                    values.append(split);
                }
                values.append(value);
            }
            if (detail != null) {
                details.append(detail).append("\n");
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public static BigDecimal convertValueForAdjustOrElim(Context ctx, BigDecimal curValue, ConvertModeEnum convertMode, int dataElementValue, String itemNumber, IObjectValue bizInfo, ConvtParamsManager pm) throws EASBizException, BOSException {
        BigDecimal curExgRate = null;
        block0 : switch (convertMode.getValue()) {
            case 2: {
                switch (dataElementValue) {
                    case 1: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByLastPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 2: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm, convertMode);
                        break block0;
                    }
                    case 3: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByYear(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm, convertMode);
                        break block0;
                    }
                    case 4: {
                        curExgRate = ExchangeRateUtil.getEndBalanceAvgExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 5: {
                        curExgRate = ExchangeRateUtil.getExchgRateByYearFirst(ctx, ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (dataElementValue) {
                    case 1: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByLastPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 2: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm, convertMode);
                        break block0;
                    }
                    case 3: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByYear(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm, convertMode);
                        break block0;
                    }
                    case 4: {
                        curExgRate = ExchangeRateUtil.getEndBalanceAvgExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 5: {
                        curExgRate = ExchangeRateUtil.getExchgRateByYearFirst(ctx, ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (dataElementValue) {
                    case 1: {
                        curExgRate = ExchangeRateUtil.getExchgRateByPeriodFirst(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 2: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 3: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 4: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 5: {
                        curExgRate = ExchangeRateUtil.getExchgRateByYearFirst(ctx, ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (dataElementValue) {
                    case 1: {
                        curExgRate = ExchangeRateUtil.getExchgRateByPeriodFirst(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 2: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 3: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 4: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, ConvtUtil.getBizPeriodType(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                    case 5: {
                        curExgRate = ExchangeRateUtil.getExchgRateByYearFirst(ctx, ConvtUtil.getBizCurrencyInfo(bizInfo), pm);
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                curValue = ConvtUtil.convtValueByUserDefinedRate(ctx, curValue, dataElementValue, itemNumber, bizInfo, pm);
                return curValue;
            }
            default: {
                throw new BOSException("Code Error:error convert mode!");
            }
        }
        if (curValue != null && curExgRate != null) {
            curValue = pm.checkIsChangeSrc2targCurrencyId(ConvtUtil.getBizCurrencyInfo(bizInfo).getId().toString()) ? curValue.divide(curExgRate, curExgRate.scale(), 4) : curValue.multiply(curExgRate);
        }
        return curValue;
    }

    public static BigDecimal convertValueForRpt(Context ctx, BigDecimal curValue, Map mapInitYearData, ConvertModeEnum convertMode, int dataElementValue, CslReportInfo report, ItemFormula curFormula, Map mapItemData, String orgTreeNumber, String orgTreeId, OrgTreeInfo orgTreeInfo, ConvtParamsManager pm, int sheetType) throws EASBizException, BOSException {
        if (!pm.isFromReportSystem()) {
            BigDecimal result;
            if ((report.getSourceType().getValue() == 1 || report.getSourceType().getValue() == 10 || report.getSourceType().getValue() == 7) && curFormula.getYearOffSet() == -1 && dataElementValue == 3 && curFormula.getValueType() == 1) {
                result = null;
                result = ConvtUtil.getConvtInitYearData(ctx, curFormula, report, orgTreeNumber, orgTreeId, dataElementValue, pm);
                if (result != null) {
                    return result;
                }
            } else if (report.getSourceType().getValue() == 3 && curFormula.getYearOffSet() == -1 && dataElementValue == 3 && curFormula.getValueType() == 1) {
                result = null;
                result = ConvtUtil.getConvtComBineInitYearData(ctx, curFormula, report, dataElementValue, pm);
                if (result != null) {
                    return result;
                }
            }
        }
        if (dataElementValue == 5) {
            BigDecimal bdValue;
            HashMap<String, Object> mapParams;
            if (report.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || report.getSourceType().equals((Object)RptSrcTypeEnum.SUM)) {
                mapParams = new HashMap<String, Object>(16);
                mapParams.put("OrgTreeID", orgTreeInfo.getId().toString());
                mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
                mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
                mapParams.put("KEY_CURRENCY_ID", pm.getTargetCurrencyInfo().getId().toString());
                mapParams.put("Year", new Integer(curFormula.getYear()));
                mapParams.put("DataElement", new Integer(5));
                mapParams.put("ValueType", new Integer(1));
                mapParams.put("KEY_ITEM_NUMBER", curFormula.getItemNumber());
                mapParams.put("KEY_CONVERTSTATUS", new Integer(ConvertStatusEnum.Converted.getValue()));
                mapParams.put("KEY_DATACOLLECT_NUMBER", report.getDataCollectNumber());
                bdValue = ItemDataYearInitFactory.getLocalInstance(ctx).getYearInitValue(mapParams);
                if (bdValue != null) {
                    ConvtUtil.setConvtCalcFormula(String.valueOf(bdValue), bdValue + "=" + ConvtUtil.buildYearInitDetail(mapParams));
                    return bdValue;
                }
            } else {
                mapParams = new HashMap(16);
                mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
                mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
                mapParams.put("KEY_CURRENCY_ID", pm.getTargetCurrencyInfo().getId().toString());
                mapParams.put("Year", new Integer(curFormula.getYear()));
                mapParams.put("DataElement", new Integer(5));
                mapParams.put("ValueType", new Integer(1));
                mapParams.put("KEY_ITEM_NUMBER", curFormula.getItemNumber());
                mapParams.put("KEY_CONVERTSTATUS", new Integer(ConvertStatusEnum.Converted.getValue()));
                if (orgTreeInfo != null) {
                    mapParams.put("OrgTreeID", orgTreeInfo.getId().toString());
                }
                mapParams.put("KEY_DATACOLLECT_NUMBER", report.getDataCollectNumber());
                bdValue = ItemDataYearInitFactory.getLocalInstance(ctx).getYearInitValue(mapParams);
                ConvtUtil.setConvtCalcFormula(String.valueOf(bdValue), bdValue + "=" + ConvtUtil.buildYearInitDetail(mapParams), "+");
                if (bdValue != null) {
                    return bdValue;
                }
            }
        }
        Date tmpDate = pm.getEndDate();
        if (!pm.isMergeByFiscalPeriod()) {
            pm.setEndDate(curFormula.getDay());
        }
        if (convertMode.getValue() == 2 || convertMode.getValue() == 6) {
            pm.setCurConvertMode(String.valueOf(2));
            if (dataElementValue == 3 && pm.getAvgConvertType() == 1) {
                return ConvtUtil.getYTDAmountAddPrePeriodConverted(ctx, mapItemData, report, curFormula, tmpDate, pm, sheetType, convertMode);
            }
        }
        BigDecimal curExgRate = null;
        switch (convertMode.getValue()) {
            case 3: {
                pm.setCurConvertMode(String.valueOf((Object)convertMode));
                curValue = HistoryExchRateConvtUtil.caclConvertValueByHistoryExchgRate(ctx, report, curFormula, curValue, mapInitYearData, dataElementValue, orgTreeInfo, pm);
                break;
            }
            case 4: {
                return ConvtUtil.convtValueByUserDefinedRate(ctx, curValue, dataElementValue, curFormula.getItemNumber(), (IObjectValue)report, pm);
            }
            default: {
                curExgRate = ConvtUtil.getExgRate(ctx, convertMode, dataElementValue, report.getPeriodType(), report.getCurrency(), pm);
            }
        }
        if (curValue != null && convertMode.getValue() != 3) {
            if (!pm.checkIsChangeSrc2targCurrencyId(report.getSourceCurrency().getId().toString())) {
                ConvtUtil.setConvtCalcFormula(curValue + "*" + curExgRate, null, "+");
                curValue = curValue.multiply(curExgRate);
            } else {
                int precision = 2;
                if (pm.getTargetCurrencyInfo() != null && pm.getTargetCurrencyInfo().getPrecision() != 0) {
                    precision = pm.getTargetCurrencyInfo().getPrecision();
                }
                ConvtUtil.setConvtCalcFormula("=" + curValue + "/" + curExgRate, null);
                curValue = curValue.divide(curExgRate, precision, 4);
            }
        }
        pm.setEndDate(tmpDate);
        return curValue;
    }

    public static BigDecimal getExgRate(Context ctx, ConvertModeEnum convertMode, int dataElementValue, RptPeriodTypeEnum periodType, CurrencyInfo currency, ConvtParamsManager pm) throws EASBizException, BOSException {
        return ConvtUtil.getExgRate(ctx, convertMode, dataElementValue, periodType, currency, pm, false);
    }

    public static BigDecimal getExgRate(Context ctx, ConvertModeEnum convertMode, int dataElementValue, RptPeriodTypeEnum periodType, CurrencyInfo currency, ConvtParamsManager pm, boolean isGetReview) throws EASBizException, BOSException {
        pm.setGetReview(isGetReview);
        BigDecimal curExgRate = null;
        block0 : switch (convertMode.getValue()) {
            case 2: {
                pm.setCurConvertMode(String.valueOf((Object)convertMode));
                switch (dataElementValue) {
                    case 1: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByLastPeriod(ctx, periodType, currency, pm);
                        break block0;
                    }
                    case 2: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByCurPeriod(ctx, periodType, currency, pm, convertMode);
                        break block0;
                    }
                    case 3: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByYear(ctx, periodType, currency, pm, convertMode);
                        break block0;
                    }
                    case 4: {
                        curExgRate = ExchangeRateUtil.getEndBalanceAvgExchgRateByCurPeriod(ctx, periodType, currency, pm);
                        break block0;
                    }
                    case 5: {
                        curExgRate = ExchangeRateUtil.getExchgRateByYearFirst(ctx, currency, pm);
                        break block0;
                    }
                    case 6: {
                        int y = pm.getYear();
                        pm.setYear(y - 1);
                        Date ed = pm.getEndDate();
                        Calendar c = Calendar.getInstance();
                        c.setTime(ed);
                        c.add(1, -1);
                        pm.setYear(y - 1);
                        pm.setEndDate(c.getTime());
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByYear(ctx, periodType, currency, pm, convertMode);
                        pm.setYear(y);
                        pm.setEndDate(ed);
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                pm.setCurConvertMode(String.valueOf(2));
                switch (dataElementValue) {
                    case 1: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByLastPeriod(ctx, periodType, currency, pm);
                        break block0;
                    }
                    case 2: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByCurPeriod(ctx, periodType, currency, pm, convertMode);
                        break block0;
                    }
                    case 3: {
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByYear(ctx, periodType, currency, pm, convertMode);
                        break block0;
                    }
                    case 4: {
                        curExgRate = ExchangeRateUtil.getEndBalanceAvgExchgRateByCurPeriod(ctx, periodType, currency, pm);
                        break block0;
                    }
                    case 5: {
                        curExgRate = ExchangeRateUtil.getExchgRateByYearFirst(ctx, currency, pm);
                        break block0;
                    }
                    case 6: {
                        int y = pm.getYear();
                        Date ed = pm.getEndDate();
                        Calendar c = Calendar.getInstance();
                        c.setTime(ed);
                        c.add(1, -1);
                        pm.setYear(y - 1);
                        pm.setEndDate(c.getTime());
                        pm.setYear(y - 1);
                        curExgRate = ExchangeRateUtil.getAvgExchgRateByYear(ctx, periodType, currency, pm, convertMode);
                        pm.setYear(y);
                        pm.setEndDate(ed);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                pm.setCurConvertMode(String.valueOf((Object)convertMode));
                switch (dataElementValue) {
                    case 1: {
                        curExgRate = ExchangeRateUtil.getExchgRateByPeriodFirst(ctx, periodType, currency, pm);
                        break block0;
                    }
                    case 2: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, periodType, currency, pm);
                        break block0;
                    }
                    case 3: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, periodType, currency, pm);
                        break block0;
                    }
                    case 4: {
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, periodType, currency, pm);
                        break block0;
                    }
                    case 5: {
                        curExgRate = ExchangeRateUtil.getExchgRateByYearFirst(ctx, currency, pm);
                        break block0;
                    }
                    case 6: {
                        int y = pm.getYear();
                        Date ed = pm.getEndDate();
                        Calendar c = Calendar.getInstance();
                        c.setTime(ed);
                        c.add(1, -1);
                        pm.setYear(y - 1);
                        pm.setEndDate(c.getTime());
                        curExgRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, periodType, currency, pm);
                        pm.setYear(y);
                        pm.setEndDate(ed);
                        break block0;
                    }
                }
                break;
            }
            default: {
                throw new BOSException("Code Error:error convert mode!");
            }
        }
        return curExgRate;
    }

    public static boolean isExistUserDefinedRate(Context ctx, BigDecimal curValue, int dataElementValue, String itemNumber, IObjectValue bizInfo, ConvtParamsManager pm) throws EASBizException, BOSException {
        BigDecimal afterConvValue = null;
        try {
            afterConvValue = ConvtUtil.convtValueByUserDefinedRate(ctx, curValue, dataElementValue, itemNumber, bizInfo, pm);
        }
        catch (Exception e) {
            return false;
        }
        return afterConvValue != null;
    }

    public static BigDecimal convtValueByUserDefinedRate(Context ctx, BigDecimal curValue, int dataElementValue, String itemNumber, IObjectValue bizInfo, ConvtParamsManager pm) throws EASBizException, BOSException {
        DataElementInfo dataElement = DataElementProvider.getDataElementInfo(ctx, dataElementValue);
        int dataElimentVal = dataElement.getInterSeq();
        String dataElemName = dataElement.getName();
        Map curParams = ConvtUtil.wrapperParams(bizInfo);
        if (!pm.hasInitUserDefinedRateData()) {
            ConvtByUserDefinedRate help = new ConvtByUserDefinedRate();
            help.InitParamsByReport(curParams, pm.getTargetCurrencyInfo().getId().toString(), pm.getStrExChgdRateTblID(), ctx);
            help.preparedUserDefinedRate();
            pm.userDefinedRateHelper = help;
        }
        if (!pm.userDefinedRateHelper.equales(ConvtUtil.getBizCurrencyInfo(bizInfo).getId().toString(), ConvtUtil.getBizPeriodType(bizInfo).getValue())) {
            pm.userDefinedRateHelper.InitParamsByReport(curParams, pm.getTargetCurrencyInfo().getId().toString(), pm.getStrExChgdRateTblID(), ctx);
            pm.userDefinedRateHelper.preparedUserDefinedRate();
        }
        try {
            curValue = pm.userDefinedRateHelper.convertValue(curValue, pm.getEndDate(), dataElimentVal, ConvtUtil.getBizDataCollectNumb(bizInfo), ConvtUtil.getBizCurrencyInfo(bizInfo).getId().toString(), pm.getStrExChgdRateTblID());
        }
        catch (Exception e) {
            logger.error((Object)"convertValue error.", (Throwable)e);
            if (e instanceof ServerException) {
                throw new ServerException(ServerException.NOT_FOUND_USERDEFINEDRATE, new Object[]{itemNumber, dataElemName});
            }
            throw new BOSException((Throwable)e);
        }
        return curValue;
    }

    private static Map wrapperParams(IObjectValue bizInfo) throws BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("YEAR", ConvtUtil.getBizYear(bizInfo));
        params.put("PERIOD", ConvtUtil.getBizPeriod(bizInfo));
        params.put("PERIODTYPE", ConvtUtil.getBizPeriodType(bizInfo));
        params.put("SRCCURRENCY", ConvtUtil.getBizCurrencyInfo(bizInfo));
        params.put("DCNUMBER", ConvtUtil.getBizDataCollectNumb(bizInfo));
        return params;
    }

    private static BigDecimal getConvtComBineInitYearData(Context ctx, ItemFormula itemFormula, CslReportInfo report, int dataElementValue, ConvtParamsManager pm) throws BOSException, EASBizException {
        BigDecimal result = null;
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        IItemDataProvider ie = ItemDataProviderFactory.getLocalInstance(ctx);
        ItemDataCondition condition = new ItemDataCondition();
        condition.setOrgTreeNumber(report.getOrgTree().getNumber());
        ArrayList<String> companys = new ArrayList<String>();
        companys.add(report.getOrgUnit().getNumber());
        condition.setOrgUnitNumber(companys);
        condition.setCurrency(report.getSourceCurrency().getNumber());
        condition.setTargetCurrency(pm.getTargetCurrencyInfo().getNumber());
        RptPeriodTypeEnum rptPeriodType = report.getPeriodType();
        int periodType = rptPeriodType.getValue();
        condition.setRptPeriodType(periodType);
        condition.setIsAdjusted(true);
        condition.setCommitStatus(3);
        condition.setDataSource(3);
        boolean isExist = ConvtUtil.getLastYearreport(ctx, report, itemFormula, 1, pm);
        if (isExist) {
            condition.setDataElement(dataElementValue);
            condition.setValueType(itemFormula.getValueType());
            condition.setRptYearStart(itemFormula.getYear());
            condition.setRptPeriodStart(itemFormula.getPeriod());
            condition.setRptYearEnd(itemFormula.getYear());
            condition.setRptPeriodEnd(itemFormula.getPeriod());
            condition.setDataSource(3);
            condition.setCurrency(report.getSourceCurrency().getId().toString());
            condition.setTargetCurrency(pm.getTargetCurrencyInfo().getId().toString());
            condition.setDataSource(3);
            condition.setDataCollectNumber(report.getDataCollectNumber());
            ArrayList<String> lstItem = new ArrayList<String>();
            lstItem.add(itemFormula.getItemNumber());
            condition.setItemList(itemFieldMapped.getHiberMapInfoByItemNumbers(lstItem));
            Map mapData = ie.getAcctItems(condition);
            if (mapData.containsKey(itemFormula.getItemNumber()) && mapData.get(itemFormula.getItemNumber()) != null) {
                result = (BigDecimal)mapData.get(itemFormula.getItemNumber());
                convtCalcFormula.set("acctitem:" + condition.toMap().toString());
            }
        } else {
            HashMap<String, Object> mapParams = new HashMap<String, Object>(16);
            mapParams.put("OrgTreeID", report.getOrgTree().getId().toString());
            mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
            mapParams.put("KEY_CURRENCY_ID", pm.getTargetCurrencyInfo().getId().toString());
            mapParams.put("KEY_SOURCECURRENCY_ID", report.getSourceCurrency().getId().toString());
            mapParams.put("Year", new Integer(itemFormula.getYear()));
            mapParams.put("DataElement", new Integer(dataElementValue));
            mapParams.put("ValueType", new Integer(1));
            mapParams.put("KEY_CONVERTSTATUS", new Integer(1));
            mapParams.put("KEY_ITEM_NUMBER", itemFormula.getItemNumber());
            mapParams.put("Period", new Integer(report.getPeriod()));
            mapParams.put("KEY_DATACOLLECT_NUMBER", report.getDataCollectNumber());
            result = ItemDataYearInitFactory.getLocalInstance(ctx).getYearInitValue(mapParams);
            convtCalcFormula.set("YearInit:" + ((Object)mapParams).toString());
        }
        return result;
    }

    private static boolean getLastYearreport(Context ctx, CslReportInfo report, ItemFormula itemFormula, int convertStatus, ConvtParamsManager pm) throws BOSException, EASBizException {
        String strOrgTreeID = report.getOrgTree().getId().toString();
        StringBuffer sql = new StringBuffer();
        Object[] param = new Object[13];
        sql.append(" select top 1 c.fid \r\n");
        sql.append(" from t_csl_templetItemList list \r\n");
        sql.append(" inner join t_csl_cslreport c on list.FTemplateID = c.ftemplateid \r\n");
        sql.append(" inner join t_csl_rptreceived r on c.fid=r.freportid");
        sql.append(" where c.fperiod = ?");
        sql.append(" and c.FSourceCurrencyID= ?");
        sql.append(" and c.fcurrencyid= ?");
        sql.append(" and list.FDataElement= ?");
        sql.append(" and list.FValueType= ?");
        sql.append(" and r.forgtreeId= ?");
        sql.append(" and c.FOrgUnitID= ?");
        sql.append(" and c.FConvertStatus = ?");
        sql.append(" and c.FDataCollectNumber = ?");
        sql.append(" and list.fitemNumber= ?");
        sql.append(" and c.fcommittedStatus = ?");
        sql.append(" and c.fsourceType= ?");
        sql.append(" and c.fyear= ?");
        param[0] = new Integer(report.getPeriod());
        param[1] = report.getSourceCurrency().getId().toString();
        param[2] = pm.getTargetCurrencyInfo().getId().toString();
        param[3] = new Integer(DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber()));
        param[4] = new Integer(itemFormula.getValueType());
        param[5] = strOrgTreeID;
        param[6] = report.getOrgUnit().getId().toString();
        param[7] = new Integer(convertStatus);
        param[8] = report.getDataCollectNumber();
        param[9] = itemFormula.getItemNumber();
        param[10] = new Integer(3);
        param[11] = new Integer(3);
        param[12] = new Integer(itemFormula.getYear());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static BigDecimal getConvtInitYearData(Context ctx, ItemFormula itemFormula, CslReportInfo report, String orgTreeNumber, String orgTreeId, int dataElementValue, ConvtParamsManager pm) throws EASBizException, BOSException {
        BigDecimal result = null;
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        Map mapOrgTree = UnionVersionUtil.getOrgTreeByPeriods(ctx, orgTreeNumber, itemFormula.getYear(), itemFormula.getYear(), itemFormula.getPeriod(), itemFormula.getPeriod(), report.getPeriodType().getValue());
        String strOrgTreeID = null;
        Set set = mapOrgTree.keySet();
        Iterator ite = set.iterator();
        if (ite.hasNext()) {
            strOrgTreeID = ite.next().toString();
        }
        IItemDataProvider ie = ItemDataProviderFactory.getLocalInstance(ctx);
        ItemDataCondition condition = new ItemDataCondition();
        StringBuffer sql = new StringBuffer();
        Object[] param = new Object[12];
        sql.append(" select top 1 c.fid \r\n");
        sql.append(" from t_csl_templetItemList list \r\n");
        sql.append(" inner join t_csl_cslreport c on list.FTemplateID = c.ftemplateid \r\n");
        sql.append(" inner join t_csl_rptreceived r on c.fid=r.freportid");
        sql.append(" where c.fperiod = ?");
        sql.append(" and c.FSourceCurrencyID= ?");
        sql.append(" and c.fcurrencyid= ?");
        sql.append(" and list.FDataElement= ?");
        sql.append(" and list.FValueType= ?");
        sql.append(" and r.forgtreeId= ?");
        sql.append(" and c.FOrgUnitID= ?");
        sql.append(" and c.FConvertStatus = ?");
        sql.append(" and list.fitemNumber= ?");
        sql.append(" and c.fcommittedStatus = ?");
        sql.append(" and c.fsourceType= ?");
        sql.append(" and c.fyear= ?");
        param[0] = new Integer(report.getPeriod());
        param[1] = report.getSourceCurrency().getId().toString();
        param[2] = pm.getTargetCurrencyInfo().getId().toString();
        param[3] = new Integer(dataElementValue);
        param[4] = new Integer(itemFormula.getValueType());
        param[5] = strOrgTreeID;
        param[6] = report.getOrgUnit().getId().toString();
        param[7] = new Integer(1);
        param[8] = itemFormula.getItemNumber();
        param[9] = new Integer(3);
        param[10] = new Integer(1);
        param[11] = new Integer(itemFormula.getYear());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            if (rs.next()) {
                condition.setOrgTreeNumber(orgTreeNumber);
                ArrayList<String> companys = new ArrayList<String>();
                companys.add(report.getOrgUnit().getNumber());
                condition.setOrgUnit(companys);
                RptPeriodTypeEnum rptPeriodType = report.getPeriodType();
                int periodType = rptPeriodType.getValue();
                condition.setRptPeriodType(periodType);
                condition.setCommitStatus(3);
                condition.setDataElement(dataElementValue);
                condition.setValueType(itemFormula.getValueType());
                condition.setRptYearStart(itemFormula.getYear());
                condition.setRptPeriodStart(itemFormula.getPeriod());
                condition.setRptYearEnd(itemFormula.getYear());
                condition.setRptPeriodEnd(itemFormula.getPeriod());
                condition.setCurrency(report.getSourceCurrency().getNumber());
                condition.setTargetCurrency(pm.getTargetCurrencyInfo().getNumber());
                condition.setDataSource(1);
                condition.setDataCollectNumber(report.getDataCollectNumber());
                ArrayList<String> lstItem = new ArrayList<String>();
                lstItem.add(itemFormula.getItemNumber());
                condition.setItemList(itemFieldMapped.getHiberMapInfoByItemNumbers(lstItem));
                result = ie.getAcctItem(condition, false);
                ConvtUtil.setConvtCalcFormula(String.valueOf(result), ConvtUtil.buildAcctItemDetail(condition));
            } else {
                HashMap<String, Object> mapParams = new HashMap<String, Object>(16);
                mapParams.put("OrgTreeID", orgTreeId);
                mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
                mapParams.put("KEY_CURRENCY_ID", pm.getTargetCurrencyInfo().getId().toString());
                mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
                mapParams.put("Year", new Integer(itemFormula.getYear()));
                mapParams.put("DataElement", new Integer(dataElementValue));
                mapParams.put("ValueType", new Integer(1));
                mapParams.put("KEY_CONVERTSTATUS", new Integer(1));
                mapParams.put("KEY_ITEM_NUMBER", itemFormula.getItemNumber());
                mapParams.put("Period", new Integer(report.getPeriod()));
                mapParams.put("KEY_DATACOLLECT_NUMBER", report.getDataCollectNumber());
                result = ItemDataYearInitFactory.getLocalInstance(ctx).getYearInitValue(mapParams);
                ConvtUtil.setConvtCalcFormula(String.valueOf(result), "YearInit:" + ((Object)mapParams).toString());
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        return result;
    }

    private static BigDecimal getYTDAmountAddPrePeriodConverted(Context ctx, Map mapItemData, CslReportInfo report, ItemFormula curFormula, Date tmpDate, ConvtParamsManager pm, int sheetType, ConvertModeEnum convertMode) throws EASBizException, BOSException {
        BigDecimal curValue = null;
        int dataElementValue = DataElementProvider.getDataElementInnerValue(ctx, curFormula.getDataElementNumber());
        if (curFormula.getYearOffSet() < 0) {
            curValue = ConvtUtil.getPeriodConvertedItemValue(ctx, curFormula, report, dataElementValue, curFormula.getPeriod(), pm, sheetType, (String)mapItemData.get("itemPreKey"));
            if (curValue == null || curValue.compareTo(SysConstant.BIGZERO) == 0) {
                curValue = ConvtUtil.getEditYearInitValue(ctx, report, curFormula, pm);
            }
            pm.setEndDate(tmpDate);
            return curValue;
        }
        if (curFormula.getPeriodOffSet() < 0) {
            curValue = ConvtUtil.getPeriodConvertedItemValue(ctx, curFormula, report, 2, curFormula.getPeriod(), pm, sheetType, (String)mapItemData.get("itemPreKey"));
        } else {
            String curPeriodAMOUNTItemkey = ConvtUtil.buildCurPeriodItemKey(ctx, mapItemData, curFormula);
            BigDecimal curExgRate = ExchangeRateUtil.getAvgExchgRateByCurPeriod(ctx, report.getPeriodType(), report.getCurrency(), pm, convertMode);
            curValue = (BigDecimal)mapItemData.get(curPeriodAMOUNTItemkey);
            if (curValue != null) {
                String srcCurrencyId = report.getCurrency().getId().toString();
                if (pm.checkIsChangeSrc2targCurrencyId(srcCurrencyId)) {
                    int precision = 2;
                    if (pm.getTargetCurrencyInfo() != null && pm.getTargetCurrencyInfo().getPrecision() != 0) {
                        precision = pm.getTargetCurrencyInfo().getPrecision();
                    }
                    ConvtUtil.setConvtCalcFormula(curValue + "/" + curExgRate, null);
                    curValue = curValue.divide(curExgRate, precision, 4);
                } else {
                    ConvtUtil.setConvtCalcFormula(curValue + "*" + curExgRate, null);
                    curValue = curValue.multiply(curExgRate);
                }
            }
            if (curValue == null) {
                curValue = SysConstant.BIGZERO;
            }
        }
        BigDecimal prePeriodConvertedValue = null;
        if (curFormula.getPeriod() != 1) {
            prePeriodConvertedValue = ConvtUtil.getPeriodConvertedItemValue(ctx, curFormula, report, dataElementValue, curFormula.getPeriod() - 1, pm, sheetType, (String)mapItemData.get("itemPreKey"));
            if (prePeriodConvertedValue == null || prePeriodConvertedValue.compareTo(SysConstant.BIGZERO) == 0) {
                report.setPeriod((short)(report.getPeriod() - 1));
                prePeriodConvertedValue = ConvtUtil.getEditYearInitValue(ctx, report, curFormula, pm);
                report.setPeriod((short)(report.getPeriod() + 1));
            }
            if (curValue == null) {
                ConvtUtil.setConvtCalcFormula(String.valueOf(prePeriodConvertedValue), null, "+");
                curValue = prePeriodConvertedValue;
            } else {
                ConvtUtil.setConvtCalcFormula(String.valueOf(prePeriodConvertedValue), null, "+");
                curValue = prePeriodConvertedValue.add(curValue);
            }
        }
        pm.setEndDate(tmpDate);
        return curValue;
    }

    private static BigDecimal getEditYearInitValue(Context ctx, CslReportInfo report, ItemFormula curFormula, ConvtParamsManager paramsManager) throws EASBizException, BOSException {
        OrgTreeInfo receivedOrgTreeInfo = ConvtUtil.getReceivedOrgTreeInfo(ctx, report);
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("OrgTreeID", receivedOrgTreeInfo.getId().toString());
        mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
        mapParams.put("KEY_CURRENCY_ID", paramsManager.getTargetCurrencyInfo().getId().toString());
        mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
        mapParams.put("Year", new Integer(curFormula.getYear()));
        mapParams.put("DataElement", new Integer(3));
        mapParams.put("ValueType", new Integer(1));
        mapParams.put("KEY_CONVERTSTATUS", new Integer(1));
        mapParams.put("KEY_ITEM_NUMBER", curFormula.getItemNumber());
        mapParams.put("Period", new Integer(report.getPeriod()));
        BigDecimal curValue = ItemDataYearInitFactory.getLocalInstance(ctx).getYearInitValue(mapParams);
        if (curValue == null) {
            curValue = SysConstant.BIGZERO;
        }
        ConvtUtil.setConvtCalcFormula(String.valueOf(curValue), ConvtUtil.buildYearInitDetail(mapParams));
        return curValue;
    }

    private static String buildCurPeriodItemKey(Context ctx, Map mapItemData, ItemFormula curFormula) throws EASBizException, BOSException {
        String itemPreKey = (String)mapItemData.get("itemPreKey");
        int index = itemPreKey.lastIndexOf("@");
        String curPeriodAMOUNTItemkey = null;
        if (index == -1) {
            curPeriodAMOUNTItemkey = itemPreKey + "-" + 2 + "-" + curFormula.getValueType();
        } else {
            curPeriodAMOUNTItemkey = itemPreKey.substring(0, itemPreKey.lastIndexOf("-"));
            String sheetType = itemPreKey.substring(index + 1, itemPreKey.length());
            if (Integer.parseInt(sheetType) == 10 || Integer.parseInt(sheetType) == 20) {
                curPeriodAMOUNTItemkey = curPeriodAMOUNTItemkey + "-" + 2;
            }
        }
        return curPeriodAMOUNTItemkey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BigDecimal getPeriodConvertedItemValue(Context ctx, ItemFormula itemFormula, CslReportInfo report, int dataElementValue, int period, ConvtParamsManager pm, int sheetType, String itemKey) throws EASBizException, BOSException {
        OrgTreeInfo receivedOrgTreeInfo = ConvtUtil.getReceivedOrgTreeInfo(ctx, report);
        BigDecimal result = null;
        if (sheetType == 30 || sheetType == 40 || sheetType == 20 || sheetType == 10) {
            String[] params = itemKey.substring(0, itemKey.lastIndexOf("@")).split("\\-");
            String tableName = "";
            switch (sheetType) {
                case 30: 
                case 40: {
                    tableName = "t_csl_investItemData";
                    break;
                }
                case 20: {
                    tableName = "t_csl_ExchItemData";
                    break;
                }
                case 10: {
                    tableName = "t_csl_InterItemData";
                    break;
                }
                default: {
                    throw new BOSException("Not support Report'SheetType->" + sheetType + " Exception!!");
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" select Fmoney from ").append(tableName);
            sql.append(" where FItemNumber = '").append(params[0]).append("'");
            sql.append(" and FTargetCompanyID = '").append(params[1]).append("'");
            sql.append(" and FYear = ").append(itemFormula.getYear());
            sql.append(" and FPeriod = ").append(period);
            sql.append(" and FDataElement = ").append(dataElementValue);
            sql.append(" and FPeriodType = ").append(report.getPeriodType().getValue());
            sql.append(" and FCompanyId = '").append(report.getOrgUnit().getId().toString()).append("'");
            sql.append(" and FCurrencyId = '").append(report.getCurrency().getId().toString()).append("'");
            sql.append(" and FCommitStatus = '").append(3).append("'");
            sql.append(" and FTargetCurrencyId = '").append(pm.getTargetCurrencyInfo().getId().toString()).append("'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rowSet.next()) return result;
                result = rowSet.getBigDecimal("Fmoney");
                ConvtUtil.setConvtCalcFormula(String.valueOf(result), CSLReportGroupEnum.ELIMINATION.getAlias() + itemFormula.getYear() + period + dataElementValue);
                return result;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rowSet);
            }
        } else {
            IItemDataProvider iItemDataProvider = ItemDataProviderFactory.getLocalInstance(ctx);
            ItemDataCondition condition = new ItemDataCondition();
            condition.setOrgTreeNumber(receivedOrgTreeInfo.getNumber());
            ArrayList<String> companys = new ArrayList<String>();
            companys.add(report.getOrgUnit().getNumber());
            condition.setOrgUnit(companys);
            RptPeriodTypeEnum rptPeriodType = report.getPeriodType();
            int periodType = rptPeriodType.getValue();
            condition.setRptPeriodType(periodType);
            condition.setCommitStatus(3);
            condition.setItemNumberStart(itemFormula.getItemNumber());
            condition.setItemNumberEnd(itemFormula.getItemNumber());
            condition.setRptPeriodStart(itemFormula.getPeriod());
            condition.setRptPeriodStart(period);
            condition.setDataElement(dataElementValue);
            condition.setValueType(itemFormula.getValueType());
            condition.setRptYearStart(itemFormula.getYear());
            condition.setRptYearEnd(itemFormula.getYear());
            condition.setRptPeriodEnd(period);
            condition.setCurrency(report.getSourceCurrency().getNumber());
            condition.setTargetCurrency(pm.getTargetCurrencyInfo().getNumber());
            condition.setDataSource(report.getSourceType().getValue());
            condition.setDataCollectNumber(report.getDataCollectNumber());
            result = iItemDataProvider.getAcctItem(condition, false);
            ConvtUtil.setConvtCalcFormula("", result + "=" + ConvtUtil.buildAcctItemDetail(condition));
        }
        return result;
    }

    private static OrgTreeInfo getReceivedOrgTreeInfo(Context ctx, CslReportInfo report) throws EASBizException, BOSException {
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select t.fnumber,t.fid from t_csl_rptreceived r inner join t_csl_cslreport c on r.freportid=c.fid ");
        sql1.append(" inner join t_org_tree t on r.forgTreeid = t.fid");
        sql1.append(" where c.fid=");
        sql1.append("'").append(report.getId().toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
        OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
        try {
            if (rowSet.next()) {
                orgTreeInfo.setId(BOSUuid.read((String)rowSet.getString("fid")));
                orgTreeInfo.setNumber(rowSet.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return orgTreeInfo;
    }

    public static boolean isDynamicReport(CslReportInfo report) {
        boolean isDynaReport = false;
        if (report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE)) {
            isDynaReport = true;
        }
        return isDynaReport;
    }

    public static Map getSheetTypes(Context ctx, String reportId) throws BOSException {
        String sql = "select FReportClass, FSheetId from t_rpt_rptSheetPara where FReportID = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{reportId});
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try {
            while (rowSet.next()) {
                String sheetId = rowSet.getString("FSheetId");
                int type = rowSet.getInt("FReportClass");
                result.put(sheetId, new Integer(type));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static boolean calRepForForeignConvtItem(Sheet sheet, ConvtParamsManager pm) throws EASBizException, BOSException {
        boolean isAutoRun = false;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(null, false, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (cell.getUserObjectValue("Foreign_Conv_Bala") == null) continue;
            String formula = (String)cell.getUserObjectValue("Foreign_Conv_Bala");
            if (cell.getUserObjectValue("SumItem define error!") != null) {
                throw new ServerException(ServerException.SUMITEM_DEFINE_ERROR, new Object[]{formula.toString()});
            }
            if (formula == null || formula.trim().length() <= 0 || !pm.isForeignItem(cell)) continue;
            cell.setFormula(formula);
            isAutoRun = true;
        }
        return isAutoRun;
    }

    private static RptPeriodTypeEnum getBizPeriodType(IObjectValue bizInfo) throws BOSException {
        if (bizInfo instanceof AdjustInfo) {
            return ((AdjustInfo)bizInfo).getPeriodType();
        }
        if (bizInfo instanceof EliminationInfo) {
            return ((EliminationInfo)bizInfo).getPeriodType();
        }
        if (bizInfo instanceof CslReportInfo) {
            return ((CslReportInfo)bizInfo).getPeriodType();
        }
        throw new BOSException("bizInfo not support  to convert!");
    }

    private static CurrencyInfo getBizCurrencyInfo(IObjectValue bizInfo) throws BOSException {
        if (bizInfo instanceof AdjustInfo) {
            return ((AdjustInfo)bizInfo).getCurrency();
        }
        if (bizInfo instanceof EliminationInfo) {
            return ((EliminationInfo)bizInfo).getCurrency();
        }
        if (bizInfo instanceof CslReportInfo) {
            return ((CslReportInfo)bizInfo).getCurrency();
        }
        throw new BOSException("bizInfo not support  to convert!");
    }

    private static Integer getBizYear(IObjectValue bizInfo) throws BOSException {
        if (bizInfo instanceof AdjustInfo) {
            return new Integer(((AdjustInfo)bizInfo).getYear());
        }
        if (bizInfo instanceof EliminationInfo) {
            return new Integer(((EliminationInfo)bizInfo).getYear());
        }
        if (bizInfo instanceof CslReportInfo) {
            return new Integer(((CslReportInfo)bizInfo).getYear());
        }
        throw new BOSException("bizInfo not support  to convert!");
    }

    private static Integer getBizPeriod(IObjectValue bizInfo) throws BOSException {
        if (bizInfo instanceof AdjustInfo) {
            return new Integer(((AdjustInfo)bizInfo).getPeriod());
        }
        if (bizInfo instanceof EliminationInfo) {
            return new Integer(((EliminationInfo)bizInfo).getPeriod());
        }
        if (bizInfo instanceof CslReportInfo) {
            return new Integer(((CslReportInfo)bizInfo).getPeriod());
        }
        throw new BOSException("bizInfo not support  to convert!");
    }

    private static String getBizDataCollectNumb(IObjectValue bizInfo) throws BOSException {
        if (bizInfo instanceof AdjustInfo) {
            return ((AdjustInfo)bizInfo).getDataCollectNumber();
        }
        if (bizInfo instanceof EliminationInfo) {
            return ((EliminationInfo)bizInfo).getDataCollectNumber();
        }
        if (bizInfo instanceof CslReportInfo) {
            return ((CslReportInfo)bizInfo).getDataCollectNumber();
        }
        throw new BOSException("bizInfo not support  to convert!");
    }

    public static boolean requestCheckControlLock(Context ctx, Uuid requestId, String actionName, String mutexName) throws BOSException {
        IMutexServiceControl imc = null;
        imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter param = new MutexParameter();
        param.setRequestId(requestId);
        param.setActionName(actionName);
        param.setMutexName(mutexName);
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        boolean ret = false;
        ret = imc.requestMutex(param);
        if (!ret) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Msg_CurrentRecordLocked", (Locale)ctx.getOriginLocale()));
        }
        return true;
    }

    public static void releaseCheckControlLock(Context ctx, Uuid requestId) throws BOSException {
        IMutexServiceControl imc = null;
        imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        imc.releaseMutex(requestId);
    }
}

