/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.ConvertModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.ConvtFormulaOpTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportConvertUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.SysDataElementEnum;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.CslReportServiceFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.AbstractCslConvt;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.FunctionItemData;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.RptItemData;
import com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula.FillFormulaUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formula.FormulaRuntimeEnvCalC;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReportConvtImp
extends AbstractCslConvt {
    private static Logger logger = Logger.getLogger(ReportConvtImp.class);

    public ReportConvtImp() {
        super("REPORT");
    }

    public ReportConvtImp(String convtType) {
        super(convtType);
    }

    @Override
    public String excConvert(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        String ACTION_NAME = "CoverByReport";
        CslReportInfo report = (CslReportInfo)info;
        boolean isDynaReport = ConvtUtil.isDynamicReport(report);
        CslReportInfo beforeAdjustRptId = report;
        CslReportInfo adjustedReport = null;
        boolean isAdjust = this.paramsManager.isAdjust();
        String reportId = report.getId().toString();
        Uuid requestId = Uuid.create();
        boolean isGenerate = false;
        try {
            isGenerate = ConvtUtil.requestCheckControlLock(ctx, requestId, ACTION_NAME, ACTION_NAME + reportId);
            if (isDynaReport && !this.paramsManager.isFromReportSystem()) {
                adjustedReport = this.getDynaAdjustedReport(ctx, report);
            }
            this.checkIfExistsConvertRpt(ctx, report, adjustedReport);
            CslReportInfo adjustedOldReport = (CslReportInfo)report.clone();
            if (adjustedReport != null && isDynaReport && isAdjust) {
                report = adjustedReport;
                this.setInfoValue(report, beforeAdjustRptId);
            }
            CslReportInfo oldReport = (CslReportInfo)report.clone();
            RPTDataServiceFactory.getLocalInstance(ctx).checkSumItemFormulaForConvt(report);
            int currencyScale = this.paramsManager.getTargetCurrencyInfo().getPrecision();
            if (currencyScale == 0) {
                currencyScale = 2;
            }
            Map mapItemData = null;
            Map interItemData = null;
            Map exchItemData = null;
            Map investItemData = null;
            if (this.paramsManager.isMergeByFiscalPeriod() && this.paramsManager.isFromReportSystem() && this.paramsManager.getFiscalPeriods() == null && report.getCompany() != null) {
                this.paramsManager.setFiscalPeriods(FiscalPeriodHelper.getPeriodCollection(ctx, report.getCompany().getId().toString()));
            }
            if (isDynaReport) {
                mapItemData = this.paramsManager.getItemDataProviderInterFace().getDynaItemDataByReportID(report.getId().toString());
            } else {
                mapItemData = this.paramsManager.getItemDataProviderInterFace().getItemDataByReportID(report.getId().toString());
                interItemData = this.paramsManager.getItemDataProviderInterFace().getInterItemDataByReportID(report.getId().toString());
                exchItemData = this.paramsManager.getItemDataProviderInterFace().getExchItemDataByReportID(report.getId().toString());
                investItemData = this.paramsManager.getItemDataProviderInterFace().getInvestItemDataByReportID(report.getId().toString());
            }
            if (!(mapItemData != null && mapItemData.size() > 0 || interItemData != null && !interItemData.isEmpty() || exchItemData != null && !exchItemData.isEmpty() || investItemData != null && !investItemData.isEmpty())) {
                throw new ServerException(ServerException.NOT_FOUND_ITEMDATA);
            }
            boolean isNeedInsertAdjust = false;
            Map mapAdjItemData = null;
            if (isAdjust && mapItemData != null) {
                if (isDynaReport) {
                    if (adjustedReport == null) {
                        mapAdjItemData = this.paramsManager.getItemDataProviderInterFace().getDynaItemDataFromAdjust(this.paramsManager.getOrgTreeInfo().getId().toString(), report.getOrgUnit().getId().toString(), report.getCurrency().getId().toString(), report.getSourceType().getValue(), report, report.getDataCollectNumber());
                        for (Object obj : mapAdjItemData.keySet()) {
                            if (mapItemData != null && mapItemData.containsKey(obj)) continue;
                            isNeedInsertAdjust = true;
                            break;
                        }
                    }
                } else {
                    mapAdjItemData = this.paramsManager.getItemDataProviderInterFace().getItemDataFromAdjust(this.paramsManager.getOrgTreeInfo().getId().toString(), report.getOrgUnit().getId().toString(), report.getCurrency().getId().toString(), report.getSourceType().getValue(), report, report.getDataCollectNumber());
                }
                mapItemData = this.getAdjItemData(ctx, mapItemData, mapAdjItemData);
            }
            Book book = null;
            try {
                book = report.getBook();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            String orgTreeNumber = "";
            String orgTreeId = "";
            int sheetCount = book.getSheetCount();
            if (sheetCount > 0) {
                boolean bAutoRun = book.isAutoCalculate();
                boolean isAutoRun = true;
                book.setCalculate(false);
                Map sheetTypes = ConvtUtil.getSheetTypes(ctx, report.getId().toString());
                StringBuffer sql1 = new StringBuffer();
                sql1.append("select t.fnumber,t.fid from t_csl_rptreceived r inner join t_csl_cslreport c on r.freportid=c.fid ");
                sql1.append(" inner join t_org_tree t on r.forgTreeid = t.fid");
                sql1.append(" where c.fid= ? ");
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])new Object[]{report.getId().toString()});
                try {
                    if (rs1.next()) {
                        orgTreeNumber = rs1.getString("fnumber");
                        orgTreeId = rs1.getString("fid");
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                ConvtUtil.initResourceName(ctx, this.paramsManager, report);
                for (int i = 0; i < sheetCount; ++i) {
                    Integer type;
                    Sheet sheet = book.getSheet(i);
                    String sheetId = sheet.getID();
                    int sheetType = 0;
                    if (sheetTypes.containsKey(sheetId) && (type = (Integer)sheetTypes.get(sheetId)) != null) {
                        sheetType = type;
                    }
                    if (sheetType == 10) {
                        this.convertInterSheet(ctx, sheet, report, interItemData, currencyScale, sheetType, orgTreeNumber, orgTreeId, this.paramsManager.getOrgTreeInfo(), sheetType);
                    } else if (sheetType == 20) {
                        this.convertInterSheet(ctx, sheet, report, exchItemData, currencyScale, sheetType, orgTreeNumber, orgTreeId, this.paramsManager.getOrgTreeInfo(), sheetType);
                    } else if (sheetType == 30 || sheetType == 40) {
                        this.convertInterSheet(ctx, sheet, report, investItemData, currencyScale, sheetType, orgTreeNumber, orgTreeId, this.paramsManager.getOrgTreeInfo(), sheetType);
                    } else {
                        if (isNeedInsertAdjust) {
                            if ((report.getOrgTree() == null || report.getOrgTree().getId() == null) && orgTreeId != null) {
                                OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
                                orgTreeInfo.setId(BOSUuid.read((String)orgTreeId));
                                report.setOrgTree(orgTreeInfo);
                            }
                            CslReportServiceFacadeControllerBean insert = new CslReportServiceFacadeControllerBean();
                            insert.insertAdjustNotInReport(ctx, report, sheet);
                        }
                        this.convertCommonSheet(ctx, sheet, report, mapItemData, isDynaReport, currencyScale, orgTreeNumber, orgTreeId, this.paramsManager.getOrgTreeInfo(), sheetType);
                    }
                    if (ConvtUtil.calRepForForeignConvtItem(sheet, this.paramsManager)) continue;
                    isAutoRun = false;
                }
                if (bAutoRun || isAutoRun) {
                    book.setCalculate(bAutoRun);
                }
            }
            boolean isCommonRpt = false;
            if (!this.paramsManager.isFromReportSystem() && report.getOrgTree() == null) {
                report.setOrgTree(this.paramsManager.getOrgTreeInfo());
                isCommonRpt = true;
            }
            report.setSourceCurrency(report.getCurrency());
            report.setCurrency(this.paramsManager.getTargetCurrencyInfo());
            ReportCalculateContext calcContext = null;
            try {
                BookProperties p = BookProperties.loadFromBook((Book)book);
                CSLPropertyAdapter adapter = new CSLPropertyAdapter();
                RptSrcTypeEnum srcType = report.getSourceType();
                if (srcType.getValue() != 2 && srcType.getValue() != 3 && srcType.getValue() != 4 && srcType.getValue() != 11 && srcType.getValue() != 12 && srcType.getValue() != 8) {
                    report.setSourceType(RptSrcTypeEnum.COMMITREPORT);
                }
                adapter.initReportProperties((IObjectValue)report, ctx);
                report.setSourceType(srcType);
                calcContext = new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null);
                calcContext.setPermission(new ChecFmlParamPermissionUtil(ctx));
                FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            book.calc();
            report.setId(null);
            try {
                report.setBook(book);
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
            if (isCommonRpt && (mapAdjItemData == null || mapAdjItemData.isEmpty() || mapAdjItemData.get("isInclude") == null || !((Boolean)mapAdjItemData.get("isInclude")).booleanValue()) && adjustedReport == null) {
                report.setOrgTree(null);
            }
            report.setCreator(null);
            report.setLastUpdateUser(null);
            report.setLastUpdateTime(null);
            report.setSourceRpt(adjustedOldReport);
            report.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            report.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
            report.setConvertStatus(ConvertStatusEnum.Converted);
            report.setIsCommitReport(false);
            if (mapAdjItemData != null && !mapAdjItemData.isEmpty() && mapAdjItemData.get("isInclude") != null && ((Boolean)mapAdjItemData.get("isInclude")).booleanValue() || adjustedReport != null) {
                report.setAdjustStatus(AdjustStatusEnum.ADJUSTED);
            }
            if (String.valueOf(1).equals(this.paramsManager.cslcyAfterStatus())) {
                report.setCommitTime(null);
                report.setAuditor(null);
                report.setAuditTime(null);
                report.setReceiveTime(null);
                report.setCreateTime(null);
            }
            if (report.containsKey("addedPerporty")) {
                SumRptAddedPerportyInfo addedPerporty = (SumRptAddedPerportyInfo)info.get("addedPerporty");
                addedPerporty.setId(null);
                addedPerporty.setReport(null);
            }
            IObjectPK pk = this.paramsManager.getCslReportInterFace().submit((CoreBaseInfo)report);
            this.processFillYearInitData(ctx, report, false);
            this.processDiffFormulas(ctx, report, orgTreeNumber, orgTreeId, pk, calcContext);
            if (!String.valueOf(1).equals(this.paramsManager.cslcyAfterStatus())) {
                this.updateRptComitStatus(ctx, oldReport, pk);
                this.setItemDataStatus(ctx, pk.toString(), oldReport.getCommittedStatus().getValue());
            } else {
                this.setItemDataStatus(ctx, pk.toString(), 1);
            }
            String string = pk.getKeyValue("id").toString();
            return string;
        }
        catch (BOSException e) {
            String errorMsg = e.getLocalizedMessage();
            throw new BOSException(errorMsg);
        }
        finally {
            if (isGenerate) {
                ConvtUtil.releaseCheckControlLock(ctx, requestId);
            }
        }
    }

    private void processFillYearInitData(Context ctx, CslReportInfo report, boolean isCurrentSheet) throws BOSException, EASBizException {
        Book book = null;
        try {
            book = report.getBook();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        CslRptUtil.fillYearInitData(ctx, report.getId().toString(), book, isCurrentSheet);
        try {
            report.setBook(book);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        this.paramsManager.getCslReportInterFace().update((IObjectPK)new ObjectStringPK(report.getId().toString()), (CoreBaseInfo)report);
    }

    private void processDiffFormulas(Context ctx, CslReportInfo report, String orgTreeNumber, String orgTreeId, IObjectPK pk, ReportCalculateContext calcContext) throws BOSException, EASBizException {
        HashMap<String, String> itemDataMap = new HashMap<String, String>();
        List formulaList = this.getconvDiffFormulasByTempID(ctx, report, itemDataMap);
        Map[] diffValueMap = null;
        if (formulaList != null && formulaList.size() > 0) {
            ParameterContext parameterContext = this.getFillItemParameter(ctx, formulaList, orgTreeId, orgTreeNumber, report);
            formulaList = this.deComposeFormula(formulaList, itemDataMap, parameterContext, ctx, report);
            Map itemOrgTreeRelaMap = this.rptDataOrgTreeRelationNew(formulaList, orgTreeId, orgTreeNumber);
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(pk.toString());
            IObjectCollection bizCollection = this.getBizCollectionByIdList(ctx, idList);
            CslReportInfo convDiffReport = (CslReportInfo)bizCollection.getObject(0);
            diffValueMap = this.calcConvDiffFormulaValues(ctx, report, formulaList, report.getCurrency(), itemOrgTreeRelaMap, parameterContext);
            this.updateBookConvDiffItemValue(ctx, diffValueMap, convDiffReport, calcContext);
        }
    }

    private List deComposeFormula(List formulaList, Map<String, String> itemDataMap, ParameterContext parameterContext, Context ctx, CslReportInfo report) throws BOSException, EASBizException {
        try {
            for (int i = 0; i < formulaList.size(); ++i) {
                boolean hasNesting = false;
                String[] formulaStr = (String[])formulaList.get(i);
                String srcFormulaStr = new String(formulaStr[1]);
                Expression stmt = ExcelFormulaPaserHelper.parse((String)formulaStr[1]);
                List<FunctionItemData> functionItemDataStrList = this.sortExpressionByFunctionItemEleType(stmt);
                for (FunctionItemData FunctionItemData2 : functionItemDataStrList) {
                    if (!ValueTypeEnum.MONEY.getName().equalsIgnoreCase(FunctionItemData2.getDataType()) || !itemDataMap.keySet().contains(FunctionItemData2.getItemDataStr())) continue;
                    hasNesting = true;
                    this.setFormulaReslutList(stmt, functionItemDataStrList, formulaStr, itemDataMap, parameterContext, ctx);
                    break;
                }
                if (!hasNesting) continue;
                Expression resultExpression = ExcelFormulaPaserHelper.parse((String)formulaStr[1]);
                List<FunctionItemData> rptItemDataList = this.sortExpressionByFunctionItemEleType(resultExpression);
                Set<String> itemDataSet = itemDataMap.keySet();
                for (FunctionItemData functionItemData : rptItemDataList) {
                    if (!ValueTypeEnum.MONEY.getName().equalsIgnoreCase(functionItemData.getDataType()) || !"Item".equalsIgnoreCase(functionItemData.getFunctionName()) || !itemDataSet.contains(functionItemData.getItemDataStr())) continue;
                    String[] formulaStrSplitArry = formulaStr[0].split("!");
                    String dataElementStr = formulaStrSplitArry[2];
                    SysDataElementEnum dataElement = SysDataElementEnum.getEnum(dataElementStr);
                    if (dataElement != null) {
                        dataElementStr = dataElement.toString();
                    }
                    throw new ServerException(ServerException.ITEM_NESTING, new Object[]{formulaStrSplitArry[1], dataElementStr, srcFormulaStr});
                }
            }
        }
        catch (ServerException e) {
            this.paramsManager.getCslReportInterFace().delete((IObjectPK)new ObjectStringPK(report.getId().toString()));
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"deComposeFormula_error", (Throwable)e);
            return this.getconvDiffFormulasByTempID(ctx, report, itemDataMap);
        }
        return formulaList;
    }

    private void setFormulaReslutList(Expression stmt, List<FunctionItemData> functionItemDataStrList, String[] formulaStr, Map<String, String> itemDataMap, ParameterContext parameterContext, Context ctx) throws Exception {
        if (stmt instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)stmt;
            if ("Item".equalsIgnoreCase(functionExpr.funcionName)) {
                if (!this.isSamePeriod(functionExpr, ctx, parameterContext)) {
                    return;
                }
                String dataType = ((StringExpr)functionExpr.parameters.get((int)4)).value;
                String itemDataStr = this.getItemDataStr(functionExpr);
                if (ValueTypeEnum.MONEY.getName().equalsIgnoreCase(dataType) && itemDataMap.containsKey(itemDataStr)) {
                    Expression newExpression;
                    String formual = itemDataMap.get(itemDataStr);
                    stmt = newExpression = ExcelFormulaPaserHelper.parse((String)formual);
                }
            }
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression childExpr = ((BinaryOperationExpr)stmt).left;
            stmt = this.getNewExpression(stmt, childExpr, itemDataMap, parameterContext, ctx, "left");
            childExpr = ((BinaryOperationExpr)stmt).right;
            stmt = this.getNewExpression(stmt, childExpr, itemDataMap, parameterContext, ctx, "right");
        }
        formulaStr[1] = stmt.toString();
    }

    private List<FunctionItemData> sortExpressionByFunctionItemEleType(Expression stmt) throws CheckFormulaException {
        ArrayList<FunctionItemData> result;
        block11: {
            block10: {
                result = new ArrayList<FunctionItemData>();
                if (!(stmt instanceof FunctionExpr)) break block10;
                String funName = ((FunctionExpr)stmt).funcionName;
                String item = null;
                String dataEle = "";
                String dataType = "";
                FunctionExpr expr = (FunctionExpr)stmt;
                List param = expr.parameters;
                if (!funName.equalsIgnoreCase("Item")) break block11;
                item = ((StringExpr)param.get((int)0)).value;
                int dataeleIndex = 3;
                if (param.get(dataeleIndex) instanceof StringExpr) {
                    dataEle = ((StringExpr)param.get((int)dataeleIndex)).value;
                } else if (param.get(dataeleIndex) instanceof IntExpr) {
                    dataEle = ((IntExpr)param.get((int)dataeleIndex)).value.toString();
                }
                dataType = ((StringExpr)param.get((int)4)).value;
                FunctionItemData fItemData = new FunctionItemData(funName, item, dataEle, dataType);
                if (!result.contains(fItemData)) {
                    result.add(fItemData);
                }
                break block11;
            }
            if (stmt instanceof BinaryOperationExpr) {
                FunctionItemData fItemData;
                int i;
                Expression expr = ((BinaryOperationExpr)stmt).left;
                List<FunctionItemData> list = this.sortExpressionByFunctionItemEleType(expr);
                for (i = 0; i < list.size(); ++i) {
                    fItemData = list.get(i);
                    if (result.contains(fItemData)) continue;
                    result.add(fItemData);
                }
                expr = ((BinaryOperationExpr)stmt).right;
                list = this.sortExpressionByFunctionItemEleType(expr);
                for (i = 0; i < list.size(); ++i) {
                    fItemData = list.get(i);
                    if (result.contains(fItemData)) continue;
                    result.add(fItemData);
                }
            } else if (stmt instanceof UnaryOperationExpr) {
                Expression expr = ((UnaryOperationExpr)stmt).operand;
                List<FunctionItemData> list = this.sortExpressionByFunctionItemEleType(expr);
                for (int i = 0; i < list.size(); ++i) {
                    FunctionItemData fItemData = list.get(i);
                    if (result.contains(fItemData)) continue;
                    result.add(fItemData);
                }
            }
        }
        return result;
    }

    private boolean isSamePeriod(FunctionExpr fExpr, Context ctx, ParameterContext parameterContext) {
        int[] offsetYearAndPeriod;
        int yearOffset = ((IntExpr)fExpr.parameters.get((int)1)).value.intValue();
        int periodOffset = ((IntExpr)fExpr.parameters.get((int)2)).value.intValue();
        if (yearOffset == 0 && periodOffset == 0) {
            return true;
        }
        CslReportInfo reportInfo = (CslReportInfo)parameterContext.getAttribute("cslReportInfo");
        Boolean isMergeByFiscalPeriod = (Boolean)parameterContext.getAttribute("isMergeByFiscalPeriod");
        Boolean isSupport13Period = (Boolean)parameterContext.getAttribute("isSupport13Period");
        PeriodCollection periodCollection = (PeriodCollection)parameterContext.getAttribute("periodCollection");
        int[] yearAndPeriod = FillFormulaUtil.getRptYearAndPeriod(ctx, reportInfo, periodCollection, 0, 0, isSupport13Period, isMergeByFiscalPeriod);
        return yearAndPeriod[0] == (offsetYearAndPeriod = FillFormulaUtil.getRptYearAndPeriod(ctx, reportInfo, periodCollection, yearOffset, periodOffset, isSupport13Period, isMergeByFiscalPeriod))[0] && yearAndPeriod[1] == offsetYearAndPeriod[1];
    }

    private String getItemDataStr(FunctionExpr fExpr) {
        String item = ((StringExpr)fExpr.parameters.get((int)0)).value;
        String dataEle = null;
        int dataeleIndex = 3;
        if (fExpr.parameters.get(dataeleIndex) instanceof StringExpr) {
            dataEle = ((StringExpr)fExpr.parameters.get((int)dataeleIndex)).value;
        } else if (fExpr.parameters.get(dataeleIndex) instanceof IntExpr) {
            dataEle = ((IntExpr)fExpr.parameters.get((int)dataeleIndex)).value.toString();
        }
        return item.concat(dataEle);
    }

    private Expression getNewExpression(Expression parentExpression, Expression childExpr, Map<String, String> itemDataMap, ParameterContext parameterContext, Context ctx, String position) throws Exception {
        if (childExpr instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)childExpr;
            if ("Item".equalsIgnoreCase(functionExpr.funcionName)) {
                if (!this.isSamePeriod(functionExpr, ctx, parameterContext)) {
                    return parentExpression;
                }
                String dataType = ((StringExpr)functionExpr.parameters.get((int)4)).value;
                String itemDataStr = this.getItemDataStr(functionExpr);
                if (ValueTypeEnum.MONEY.getName().equalsIgnoreCase(dataType) && itemDataMap.containsKey(itemDataStr)) {
                    String formual = itemDataMap.get(itemDataStr);
                    Expression newExpression = ExcelFormulaPaserHelper.parse((String)formual);
                    if ("left".equals(position)) {
                        ((BinaryOperationExpr)parentExpression).left = newExpression;
                    } else if ("right".equals(position)) {
                        ((BinaryOperationExpr)parentExpression).right = newExpression;
                    }
                }
                return parentExpression;
            }
        } else if (childExpr instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)childExpr).left;
            childExpr = this.getNewExpression(childExpr, expr, itemDataMap, parameterContext, ctx, "left");
            expr = ((BinaryOperationExpr)childExpr).right;
            childExpr = this.getNewExpression(childExpr, expr, itemDataMap, parameterContext, ctx, "right");
            if ("left".equals(position)) {
                ((BinaryOperationExpr)parentExpression).left = childExpr;
            } else if ("right".equals(position)) {
                ((BinaryOperationExpr)parentExpression).right = childExpr;
            }
            return parentExpression;
        }
        return parentExpression;
    }

    private void updateRptComitStatus(Context ctx, CslReportInfo oldReport, IObjectPK pk) throws BOSException {
        StringBuffer _sql = new StringBuffer("update T_Csl_CslReport set");
        _sql.append(" FAuditedStatus = ?");
        _sql.append(",FCommittedStatus = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[]{new Integer(oldReport.getAuditedStatus().getValue()), new Integer(oldReport.getCommittedStatus().getValue()), pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    private List formulaListToItemList(List formulaList) throws BOSException, EASBizException {
        ArrayList itemDataList = new ArrayList();
        try {
            for (int i = 0; i < formulaList.size(); ++i) {
                String[] formulaStr = (String[])formulaList.get(i);
                Expression stmt = ExcelFormulaPaserHelper.parse((String)formulaStr[1]);
                itemDataList.addAll(this.sortExpressionByItemAndElE(stmt));
            }
        }
        catch (Exception e) {
            throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, e, new Object[]{""});
        }
        return itemDataList;
    }

    private Map rptDataOrgTreeRelationNew(List formulaList, String treeId, String treeNum) throws EASBizException, BOSException {
        List itemDataList = this.formulaListToItemList(formulaList);
        HashMap<RptItemData, OrgTreeInfo> itemOrgTreeRelaMap = new HashMap<RptItemData, OrgTreeInfo>();
        if (itemDataList == null || itemDataList.size() == 0) {
            return itemOrgTreeRelaMap;
        }
        OrgTreeInfo orgTree = new OrgTreeInfo();
        orgTree.setId(BOSUuid.read((String)treeId));
        orgTree.setNumber(treeNum);
        for (int i = 0; i < itemDataList.size(); ++i) {
            RptItemData itemData = (RptItemData)itemDataList.get(i);
            itemOrgTreeRelaMap.put(itemData, orgTree);
        }
        return itemOrgTreeRelaMap;
    }

    private Map rptDataOrgTreeRelation(Context ctx, List formulaList, int year, int period, String companyId, String sourceCurrencyId, String currencyId) throws BOSException, EASBizException {
        List itemDataList = this.formulaListToItemList(formulaList);
        HashMap<RptItemData, OrgTreeInfo> itemOrgTreeRelaMap = new HashMap<RptItemData, OrgTreeInfo>();
        if (itemDataList == null || itemDataList.size() == 0) {
            return itemOrgTreeRelaMap;
        }
        StringBuffer strSQL = new StringBuffer();
        RptItemData itemData = null;
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuffer inSQL = new StringBuffer("(");
        for (int i = 0; i < itemDataList.size(); ++i) {
            itemData = (RptItemData)itemDataList.get(i);
            inSQL.append("(itemList.Fitemnumber=? and dataeLe.fnumber=?)  or ");
            paramList.add(itemData.getRptItem());
            paramList.add(itemData.getDataElement());
        }
        inSQL.delete(inSQL.length() - 3, inSQL.length());
        inSQL.append(" )");
        strSQL.append("select distinct tree.fnumber treeNumber,tree.fid treeId,itemList.Fitemnumber ItemNumber,dataeLe.fnumber dataNumber from t_csl_cslreport rpt \r\n");
        strSQL.append("\t inner join T_rpt_template tmp1 on rpt.ftemplateid=tmp1.fid \r\n");
        strSQL.append("\t inner join  T_rpt_template tmp2 on tmp1.fgroup =tmp2.fgroup  \r\n");
        strSQL.append("\t inner join t_Csl_Templetitemlist itemList on itemList.ftemplateid=tmp2.fid  \r\n");
        strSQL.append("\t inner join t_csl_rptreceived r on r.freportid=rpt.fid   \r\n");
        strSQL.append("\t inner join t_org_tree tree on r.forgTreeid = tree.fid   \r\n");
        strSQL.append("\t inner join T_CSL_DataElement dataeLe on itemList.fDataElement=dataeLe.finterseq  \r\n");
        strSQL.append("\t where    \r\n").append(inSQL);
        strSQL.append("\t and  rpt.fcompanyid=? and  rpt.fyear=?  and rpt.fperiod=? and rpt.fsourcecurrencyid=?   \r\n");
        strSQL.append("\t and rpt.fcurrencyid=?   \r\n");
        paramList.add(companyId);
        paramList.add(new Integer(year));
        paramList.add(new Integer(period));
        paramList.add(sourceCurrencyId);
        paramList.add(currencyId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])paramList.toArray());
        OrgTreeInfo orgTree = null;
        try {
            while (rs.next()) {
                orgTree = new OrgTreeInfo();
                itemData = new RptItemData(rs.getString("ItemNumber"), rs.getString("dataNumber"));
                orgTree.setId(BOSUuid.read((String)rs.getString("treeId")));
                orgTree.setNumber(rs.getString("treeNumber"));
                itemOrgTreeRelaMap.put(itemData, orgTree);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return itemOrgTreeRelaMap;
    }

    private ParameterContext getFillItemParameter(Context ctx, List formulaList, String orgTreeId, String orgTreeNumber, CslReportInfo report) throws BOSException, EASBizException {
        Object formulaValuesMap = null;
        if (formulaList == null || formulaList.size() == 0) {
            return null;
        }
        ParameterContext parameterContext = new ParameterContext(ctx);
        report.setCurrency(this.paramsManager.getTargetCurrencyInfo());
        parameterContext.setAttribute("cslReportInfo", report);
        parameterContext.setAttribute("periodCollection", this.paramsManager.getFiscalPeriods());
        parameterContext.setAttribute("isMergeByFiscalPeriod", new Boolean(this.paramsManager.isMergeByFiscalPeriod()));
        parameterContext.setAttribute("isSupport13Period", new Boolean(this.paramsManager.isSupport13Period()));
        if (this.paramsManager.getOrgTreeInfo() != null && this.paramsManager.getOrgTreeInfo().getNumber() != null) {
            parameterContext.setAttribute("orgTreeInfo", this.paramsManager.getOrgTreeInfo());
        } else {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)orgTreeId));
            orgTree.setNumber(orgTreeNumber);
            parameterContext.setAttribute("orgTreeInfo", orgTree);
        }
        return parameterContext;
    }

    private void updateBookConvDiffItemValue(Context ctx, Map[] formulaValuesMap, CslReportInfo report, ReportCalculateContext calcContext) throws BOSException, EASBizException {
        if (formulaValuesMap == null || formulaValuesMap[0].size() == 0) {
            return;
        }
        Book book = null;
        boolean isAutoCalc = false;
        try {
            book = report.getBook();
            FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
            isAutoCalc = book.isAutoCalculate();
            book.setAutoCalculate(false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        block4: for (Map.Entry entry : formulaValuesMap[0].entrySet()) {
            String[] str;
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key) || key.split("!").length < 3 || book.getSheetByID((str = key.split("!"))[0]) == null) continue;
            Sheet.ICellsIterator cellItor = book.getSheetByID(str[0]).getCellsIterator(null, false, true);
            while (cellItor.hasNext()) {
                Object curFormula;
                Cell cell = cellItor.next();
                if (cell.getUserObject("ITEM") == null) continue;
                Range range = cell.getSheet().getRange(cell);
                ItemFormula formula = (ItemFormula)range.getUserObject("ITEM");
                if (this.isDItemReport(report.getTemplate())) {
                    if (!str[1].equals(formula.getDItemNumber()) || !str[2].equals(formula.getDataElementNumber())) continue;
                    cell.setValue(new Variant(entry.getValue()));
                    if (formulaValuesMap[1] == null || !formulaValuesMap[1].containsKey(key)) continue block4;
                    curFormula = formulaValuesMap[1].get(key);
                    ConvtUtil.setCellLinkFormula(cell, "", curFormula != null ? (String)curFormula : null);
                    continue block4;
                }
                if (!str[1].equals(formula.getItemNumber()) || !str[2].equals(formula.getDataElementNumber())) continue;
                cell.setValue(new Variant(entry.getValue()));
                if (formulaValuesMap[1] == null || !formulaValuesMap[1].containsKey(key)) continue block4;
                curFormula = formulaValuesMap[1].get(key);
                ConvtUtil.setCellLinkFormula(cell, "", curFormula != null ? (String)curFormula : null);
                continue block4;
            }
        }
        try {
            book.calc();
            report.setBook(book);
            book.setAutoCalculate(isAutoCalc);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        this.paramsManager.getCslReportInterFace().update((IObjectPK)new ObjectStringPK(report.getId().toString()), (CoreBaseInfo)report);
    }

    private boolean isDItemReport(TemplateInfo templateInfo) {
        boolean isDItem = templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICSUMREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT);
        return isDItem;
    }

    private List sortExpressionByItemAndElE(Expression stmt) throws CheckFormulaException {
        ArrayList<RptItemData> result;
        block15: {
            block13: {
                List param;
                String dataEle;
                String item;
                String funName;
                block14: {
                    result = new ArrayList<RptItemData>();
                    if (!(stmt instanceof FunctionExpr)) break block13;
                    funName = ((FunctionExpr)stmt).funcionName;
                    item = null;
                    dataEle = "";
                    FunctionExpr expr = (FunctionExpr)stmt;
                    param = expr.parameters;
                    if (!funName.equalsIgnoreCase("Item")) break block14;
                    item = ((StringExpr)param.get((int)0)).value;
                    int dataeleIndex = 3;
                    if (param.get(dataeleIndex) instanceof StringExpr) {
                        dataEle = ((StringExpr)param.get((int)dataeleIndex)).value;
                    } else if (param.get(dataeleIndex) instanceof IntExpr) {
                        dataEle = ((IntExpr)param.get((int)dataeleIndex)).value.toString();
                    }
                    RptItemData itemData = new RptItemData(item, dataEle);
                    if (result.contains(itemData)) break block15;
                    result.add(itemData);
                    break block15;
                }
                if (!funName.equalsIgnoreCase("DItem")) break block15;
                item = ((StringExpr)param.get((int)0)).value;
                int dataeleIndex = 4;
                if (param.get(dataeleIndex) instanceof StringExpr) {
                    dataEle = ((StringExpr)param.get((int)dataeleIndex)).value;
                } else if (param.get(dataeleIndex) instanceof IntExpr) {
                    dataEle = ((IntExpr)param.get((int)dataeleIndex)).value.toString();
                }
                RptItemData itemData = new RptItemData(item, dataEle);
                if (!result.contains(itemData)) {
                    result.add(itemData);
                }
                break block15;
            }
            if (stmt instanceof BinaryOperationExpr) {
                RptItemData itemData;
                int i;
                Expression expr = ((BinaryOperationExpr)stmt).left;
                List list = this.sortExpressionByItemAndElE(expr);
                for (i = 0; i < list.size(); ++i) {
                    itemData = (RptItemData)list.get(i);
                    if (result.contains(itemData)) continue;
                    result.add(itemData);
                }
                expr = ((BinaryOperationExpr)stmt).right;
                list = this.sortExpressionByItemAndElE(expr);
                for (i = 0; i < list.size(); ++i) {
                    itemData = (RptItemData)list.get(i);
                    if (result.contains(itemData)) continue;
                    result.add(itemData);
                }
            } else if (stmt instanceof UnaryOperationExpr) {
                Expression expr = ((UnaryOperationExpr)stmt).operand;
                List list = this.sortExpressionByItemAndElE(expr);
                for (int i = 0; i < list.size(); ++i) {
                    RptItemData itemData = (RptItemData)list.get(i);
                    if (result.contains(itemData)) continue;
                    result.add(itemData);
                }
            }
        }
        return result;
    }

    private List getconvDiffFormulasByTempID(Context ctx, CslReportInfo cslRptInfo, Map<String, String> itemDataMap) throws BOSException {
        if (this.isDItemReport(cslRptInfo.getTemplate())) {
            return null;
        }
        SQLBuilder buffer = new SQLBuilder();
        buffer.append("\tSELECT rptitem.fnumber||dataeLe.fnumber itemDataStr, (((itemList.FSheetID || '!') || rptitem.FNumber || '!') || dataeLe.FNumber) FSUMPOSITION, ");
        buffer.append("  diff.FFormula, TO_CHAR(itemList.FPOSX)||'!'||TO_CHAR(itemList.FPOSY) FPos FROM T_CSL_RptItem rptitem ");
        buffer.append(" INNER JOIN T_CSL_RptItemConvDifference diff ON diff.frptitemid=rptitem.FId ");
        buffer.append(" INNER JOIN T_CSL_DataElement dataeLe ON diff.fDataElementid=dataeLe.FId ");
        buffer.append(" INNER JOIN T_CSL_TempletItemlist itemList ON itemList.FItemNumber =rptitem.FNumber AND itemList.fDataElement=dataeLe.FInterSeq ");
        buffer.append(" INNER JOIN T_RPT_RptSheetPara para ON para.fsheetid = itemList.FSheetId  AND para.FReportID = itemList.FTemplateId ");
        buffer.append(" WHERE rptitem.FSpecsumFormula IS NULL AND rptitem.FIsFreezed = 0 ");
        buffer.append("   AND para.FReportClass =").append((Object)1);
        buffer.append("   AND itemList.Ftemplateid IN (SELECT CASE WHEN FGroupTemplateId IS NULL THEN FId ELSE FGroupTemplateId END ");
        buffer.append("  FROM T_RPT_Template WHERE FId = ? )", (Object)cslRptInfo.getTemplate().getId().toString());
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
        String[] arrformula = null;
        String formula = "";
        ArrayList<String[]> formulaList = new ArrayList<String[]>();
        try {
            while (rowSet.next()) {
                arrformula = new String[3];
                arrformula[0] = rowSet.getString("FSUMPOSITION");
                formula = rowSet.getString("FFormula");
                if (StringUtils.isEmpty((String)formula)) continue;
                arrformula[1] = formula.trim().startsWith("=") ? formula.trim().substring(1) : formula;
                arrformula[2] = rowSet.getString("FPos");
                formulaList.add(arrformula);
                itemDataMap.put(rowSet.getString("itemDataStr"), formula);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return formulaList;
    }

    private Map[] calcConvDiffFormulaValues(Context ctx, CslReportInfo reportInfo, List fillFormulaList, CurrencyInfo currency, Map itemOrgTreeRelaMap, ParameterContext parameterContext) throws BOSException, EASBizException {
        FormulaRuntimeEnvCalC formulaCalc = new FormulaRuntimeEnvCalC(ctx, reportInfo, currency, itemOrgTreeRelaMap);
        return formulaCalc.fillBookAndCalc(fillFormulaList, parameterContext);
    }

    private void convertCommonSheet(Context ctx, Sheet curTable, CslReportInfo report, Map mapItemData, boolean isDynaReport, int currencyScale, String orgTreeNumber, String orgTreeId, OrgTreeInfo orgTreeInfo, int sheetType) throws BOSException, EASBizException {
        ConvertModeEnum convertMode = null;
        String strItemNumber = "";
        BigDecimal curValue = null;
        HashMap mapInitYearData = new HashMap();
        boolean isSupport13Period = this.paramsManager.isSupport13Period();
        boolean isRefreshAdjustFormula = this.paramsManager.isRefreshAdjustFormula();
        boolean isAdjust = this.paramsManager.isAdjust();
        Sheet.ICellsIterator cellsIterator = curTable.getCellsIterator(null, false, true);
        while (cellsIterator.hasNext()) {
            curValue = null;
            Cell cell = cellsIterator.next();
            ItemFormula curFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (curFormula == null || isDynaReport && !curFormula.isDItem() && DynamicTemplateUtility.isBasePointCell((Cell)cell) || curFormula.isDItem() && StringUtils.isEmpty((String)curFormula.getDItemNumber()) || curFormula.getValueType() == 3) continue;
            this.refreshFormula(cell, isRefreshAdjustFormula, isAdjust);
            if (this.paramsManager.isMergeByFiscalPeriod()) {
                FiscalPeriodHelper.getRptYearAndPeriod(this.paramsManager.getFiscalPeriods(), curFormula, report.getYear(), report.getPeriod(), report.getPeriodType(), this.paramsManager.isMergeByFiscalPeriod());
            } else {
                RPTDate13Util.getRptYearAndPeriod(curFormula, report.getYear(), report.getPeriod(), report.getPeriodType(), isSupport13Period);
            }
            strItemNumber = curFormula.getItemNumber();
            if (strItemNumber == null) continue;
            String key = null;
            key = isDynaReport ? strItemNumber.toUpperCase() + "-" + curFormula.getDItemNumber() + "-" + curFormula.getYear() + "-" + curFormula.getPeriod() : strItemNumber.toUpperCase() + "-" + curFormula.getYear() + "-" + curFormula.getPeriod();
            if (mapItemData == null) {
                mapItemData = new HashMap<String, String>();
            }
            mapItemData.put("itemPreKey", key);
            key = key + "-" + DataElementProvider.getDataElementInnerValue(ctx, curFormula.getDataElementNumber()) + "-" + curFormula.getValueType();
            curValue = (BigDecimal)mapItemData.get(key);
            ConvtUtil.setConvtCalcFormula(null, null);
            if (!StringUtils.isEmpty((String)strItemNumber) && curFormula.getValueType() == 1) {
                if (this.paramsManager.isTotalItem(strItemNumber) && !curFormula.isDItem()) continue;
                if (!this.paramsManager.hasDispensedConvtMode(strItemNumber)) {
                    throw new ServerException(ServerException.ITEM_NOT_FOUND_CONVERTMODE, new Object[]{strItemNumber});
                }
                if (!this.paramsManager.isDontConvtMode(strItemNumber)) {
                    convertMode = this.paramsManager.getConvtModeByItemNum(strItemNumber);
                    if (convertMode.equals((Object)ConvertModeEnum.HISTORYEXCHANGERATE) && isDynaReport) {
                        convertMode = ConvertModeEnum.ENDPERIODEXCHANGERATE;
                    }
                    int dataElementValue = this.getDataElementValueByConvertMode(ctx, curFormula, convertMode);
                    curValue = ConvtUtil.convertValueForRpt(ctx, curValue, mapInitYearData, convertMode, dataElementValue, report, curFormula, mapItemData, orgTreeNumber, orgTreeId, orgTreeInfo, this.paramsManager, sheetType);
                }
            }
            cell.setValue(Variant.nullVariant);
            if (curValue != null) {
                curValue = curValue.setScale(currencyScale, 4);
                cell.setValue(new Variant((Object)curValue));
            }
            ConvtUtil.setCellLinkFormula(cell, ConvtUtil.getConvtCalcFormulaValue(), ConvtUtil.getConvtCalcFormulaDetail());
        }
    }

    private void convertInterSheet(Context ctx, Sheet curTable, CslReportInfo report, Map mapItemData, int currencyScale, int sheetType, String orgTreeNumber, String orgTreeId, OrgTreeInfo orgTreeInfo, int cslReportType) throws BOSException, EASBizException {
        ConvertModeEnum convertMode = null;
        String strItemNumber = "";
        BigDecimal curValue = null;
        HashMap mapInitYearData = new HashMap();
        boolean isSupport13Period = this.paramsManager.isSupport13Period();
        boolean isRefreshAdjustFormula = this.paramsManager.isRefreshAdjustFormula();
        boolean isAdjust = this.paramsManager.isAdjust();
        int left = CslRptUtil.getBasePosition_Left(curTable);
        int top = CslRptUtil.getBasePosition_Top(curTable);
        if (left < 0 || top < 0) {
            throw new ServerException(ServerException.NOT_EXISTS_BASEPOINT);
        }
        int rowCount = curTable.getMaxRowIndex() + 1;
        int colCount = curTable.getMaxColIndex() + 1;
        Range curCell = null;
        for (int k = top + 1; k < rowCount; ++k) {
            ItemFormula fv;
            Range cv = curTable.getRange(k, left);
            if (cv == null || (fv = (ItemFormula)cv.getUserObject("ITEM")) == null || fv.getExt("16") == null) continue;
            String targetCompanyId = fv.getExt("16");
            for (int l = left + 1; l < colCount; ++l) {
                ItemFormula fh;
                Range ch = curTable.getRange(top, l);
                if (ch == null || (fh = (ItemFormula)ch.getUserObject("ITEM")) == null || fh.getExt("0") == null) continue;
                curValue = null;
                curCell = curTable.getRange(k, l);
                curCell.setIgnoreProtected(true);
                this.refreshFormula(curCell, isRefreshAdjustFormula, isAdjust);
                ItemFormula curFormula = (ItemFormula)fh.clone();
                if (this.paramsManager.isMergeByFiscalPeriod()) {
                    FiscalPeriodHelper.getRptYearAndPeriod(this.paramsManager.getFiscalPeriods(), curFormula, report.getYear(), report.getPeriod(), report.getPeriodType(), this.paramsManager.isMergeByFiscalPeriod());
                } else {
                    RPTDate13Util.getRptYearAndPeriod(curFormula, report.getYear(), report.getPeriod(), report.getPeriodType(), isSupport13Period);
                }
                strItemNumber = curFormula.getItemNumber();
                if (strItemNumber == null) continue;
                String key = strItemNumber + "-" + targetCompanyId + "-" + report.getYear() + "-" + report.getPeriod();
                key = key + "-" + DataElementProvider.getDataElementInnerValue(ctx, fh.getDataElementNumber());
                String itemPreKey = key + "@" + String.valueOf(sheetType);
                mapItemData.put("itemPreKey", itemPreKey);
                curValue = (BigDecimal)mapItemData.get(key);
                ConvtUtil.setConvtCalcFormula(null, null);
                if (!StringUtils.isEmpty((String)strItemNumber)) {
                    if (this.paramsManager.isTotalItem(strItemNumber)) continue;
                    if (!this.paramsManager.hasDispensedConvtMode(strItemNumber)) {
                        throw new ServerException(ServerException.ITEM_NOT_FOUND_CONVERTMODE, new Object[]{strItemNumber});
                    }
                    convertMode = this.paramsManager.getConvtModeByItemNum(strItemNumber);
                    if (!this.paramsManager.isDontConvtMode(strItemNumber)) {
                        if (convertMode.equals((Object)ConvertModeEnum.HISTORYEXCHANGERATE) && (cslReportType == 30 || cslReportType == 40)) {
                            curFormula.putExt("needByTargetCompany", "true");
                            curFormula.putExt("16", targetCompanyId);
                        } else if (convertMode.equals((Object)ConvertModeEnum.HISTORYEXCHANGERATE)) {
                            convertMode = ConvertModeEnum.ENDPERIODEXCHANGERATE;
                        }
                        int dataElementValue = this.getDataElementValueByConvertMode(ctx, curFormula, convertMode);
                        curValue = ConvtUtil.convertValueForRpt(ctx, curValue, mapInitYearData, convertMode, dataElementValue, report, curFormula, mapItemData, orgTreeNumber, orgTreeId, orgTreeInfo, this.paramsManager, sheetType);
                    }
                }
                curCell.setValue(Variant.nullVariant);
                if (curValue != null) {
                    curValue = curValue.setScale(currencyScale, 4);
                    curCell.setValue(new Variant((Object)curValue));
                }
                ConvtUtil.setCellLinkFormula(curCell, ConvtUtil.getConvtCalcFormulaValue(), ConvtUtil.getConvtCalcFormulaDetail());
            }
        }
    }

    private int getDataElementValueByConvertMode(Context ctx, ItemFormula curFormula, ConvertModeEnum convertMode) throws BOSException, EASBizException {
        int dataElementValue = DataElementProvider.getDataElementInnerValue(ctx, curFormula.getDataElementNumber());
        String deNumber = curFormula.getDataElementNumber();
        DataElementInfo dataElement = DataElementProvider.getDataElementInfo(ctx, deNumber);
        if (dataElement != null && dataElement.getInterSeq() > 100 && !ConvertModeEnum.USERDIFINEDEXCHAGERATE.equals((Object)convertMode) && (dataElementValue = this.paramsManager.getdataElementByMapping(dataElement.getNumber())) == -1) {
            convertMode = ConvertModeEnum.ENDPERIODEXCHANGERATE;
            dataElementValue = 4;
        }
        return dataElementValue;
    }

    @Override
    public IObjectCollection getBizCollectionByIdList(Context ctx, List idList) throws BOSException, EASBizException {
        int i;
        CslReportCollection clReports = null;
        if (idList != null && idList.size() > 0) {
            StringBuffer strFilterMask = new StringBuffer();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            for (i = 0; i < idList.size(); ++i) {
                filter.getFilterItems().add(new FilterItemInfo("id", idList.get(i)));
                if (strFilterMask.length() > 0) {
                    strFilterMask.append(" or ");
                }
                strFilterMask.append("#" + i);
            }
            filter.setMaskString(strFilterMask.toString());
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getSelectorCollection());
            clReports = this.paramsManager.getCslReportInterFace().getCslReportCollection(view);
        }
        if (clReports == null || clReports.size() <= 0) {
            throw new ServerException(ServerException.NOT_FOUND_CONVERT_REPORT);
        }
        StringBuffer ids = new StringBuffer();
        String idString = null;
        for (int i2 = 0; i2 < clReports.size(); ++i2) {
            ids.append("'" + ((CslReportInfo)clReports.getObject(i2)).getId().toString() + "',");
        }
        idString = clReports.size() > 0 ? ids.substring(0, ids.length() - 1) : "''";
        SumRptAddedPerportyCollection col = SumRptAddedPerportyFactory.getLocalInstance(ctx).getSumRptAddedPerportyCollection("where report in (" + idString + ")");
        block2: for (i = 0; i < clReports.size(); ++i) {
            CslReportInfo info = (CslReportInfo)clReports.getObject(i);
            if (info.containsKey("addedPerporty")) continue;
            for (int j = 0; j < col.size(); ++j) {
                if (!info.getId().toString().equals(col.get(j).getReport())) continue;
                info.put("addedPerporty", col.get(j));
                continue block2;
            }
        }
        return clReports;
    }

    @Override
    public String getExceptionReport(IObjectValue info, Exception e) {
        StringBuffer error = new StringBuffer();
        CslReportInfo cslRpt = (CslReportInfo)info;
        Locale locale = ContextUtils.getOriginalLocaleFromEnv();
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Cyconvt_Company", (Locale)locale)).append(cslRpt.getOrgUnit().getName());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Cyconvt_ReportName", (Locale)locale)).append(cslRpt.getName());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Cyconvt_ReportType", (Locale)locale)).append(RptSrcTypeEnum.NORMAL.equals((Object)cslRpt.getSourceType()) ? RptSrcTypeEnum.COMMITREPORT.getAlias() : cslRpt.getSourceType().getAlias());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Cyconvt_Currency", (Locale)locale)).append(cslRpt.getSourceCurrency().getName());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Cyconvt_Error", (Locale)locale)).append(e.getLocalizedMessage());
        error.append("\n");
        return error.toString();
    }

    private CslReportInfo getDynaAdjustedReport(Context ctx, CslReportInfo report) throws BOSException, EASBizException {
        boolean isdyna = ConvtUtil.isDynamicReport(report);
        if (!isdyna) {
            return report;
        }
        ICslReport csl = this.paramsManager.getCslReportInterFace();
        CslReportInfo temp = null;
        String whereSql = " select id where orgunit.id='" + report.getOrgUnit().getId().toString() + "' and year=" + report.getYear() + " and period=" + report.getPeriod() + " and periodtype=" + report.getPeriodType().getValue() + " and template.id='" + report.getTemplate().getId().toString() + "' and currency.id='" + report.getCurrency().getId().toString() + "' and sourceCurrency.id='" + report.getSourceCurrency().getId().toString() + "' and dataCollectNumber='" + report.getDataCollectNumber() + "' and orgTree.id='" + this.paramsManager.getOrgTreeInfo().getId().toString() + "' and adjustStatus=1 and isSaveAs=0";
        if (csl.exists(whereSql)) {
            CslReportInfo rpt = csl.getCslReportInfo(whereSql);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String strFilterMask = "#0";
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)rpt.getId().toString()));
            filter.setMaskString(strFilterMask.toString());
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getSelectorCollection());
            CslReportCollection col = csl.getCslReportCollection(view);
            if (col != null && col.size() == 1) {
                temp = col.get(0);
                return CslReportConvertUtil.getReportFromAjustedReport(temp);
            }
            return null;
        }
        return null;
    }

    private SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection cl = new SelectorItemCollection();
        cl.add(new SelectorItemInfo("*"));
        cl.add(new SelectorItemInfo("currency.id"));
        cl.add(new SelectorItemInfo("currency.precision"));
        cl.add(new SelectorItemInfo("currency.name"));
        cl.add(new SelectorItemInfo("currency.number"));
        cl.add(new SelectorItemInfo("sourceCurrency.id"));
        cl.add(new SelectorItemInfo("sourceCurrency.name"));
        cl.add(new SelectorItemInfo("sheetParam.*"));
        cl.add(new SelectorItemInfo("rptDate"));
        cl.add(new SelectorItemInfo("orgTree.number"));
        cl.add(new SelectorItemInfo("orgTree.name"));
        cl.add(new SelectorItemInfo("orgUnit.id"));
        cl.add(new SelectorItemInfo("orgUnit.number"));
        cl.add(new SelectorItemInfo("orgUnit.name"));
        cl.add(new SelectorItemInfo("company.number"));
        cl.add(new SelectorItemInfo("company.name"));
        cl.add(new SelectorItemInfo("template.templateType"));
        cl.add(new SelectorItemInfo("template.groupTemplate"));
        cl.add(new SelectorItemInfo("template.groupTemplate.id"));
        cl.add(new SelectorItemInfo("template.id"));
        cl.add(new SelectorItemInfo("dataCollect.*"));
        return cl;
    }

    private void checkIfExistsConvertRpt(Context ctx, CslReportInfo report, CslReportInfo adjustedReport) throws BOSException, EASBizException {
        if (report == null) {
            return;
        }
        String oql = null;
        if (adjustedReport != null) {
            oql = "select id where SourceRpt.ID = '" + adjustedReport.getId().toString() + "' and Currency.Id = '" + this.paramsManager.getTargetCurrencyInfo().getId() + "'";
        }
        if (oql != null && this.paramsManager.getCslReportInterFace().exists(oql)) {
            this.deleteReport(ctx, oql);
        }
        oql = "select id where SourceRpt.ID = '" + report.getId().toString() + "' and Currency.Id = '" + this.paramsManager.getTargetCurrencyInfo().getId() + "'";
        if (this.paramsManager.getCslReportInterFace().exists(oql)) {
            this.deleteReport(ctx, oql);
        }
    }

    private void deleteReport(Context ctx, String oql) throws BOSException, EASBizException, SQLDataException {
        int i;
        CslReportCollection infoList = this.paramsManager.getCslReportInterFace().getCslReportCollection(oql);
        List strIdList = this.getStringIdList(infoList);
        IObjectPK[] pkList = this.getPKArray(infoList);
        oql = "select id where SourceRpt.Id in (" + CslRptUtil.AryToItemString(strIdList) + ") and AdjustStatus = 1";
        if (this.paramsManager.getCslReportInterFace().exists(oql)) {
            CslReportCollection adjustLisst = this.paramsManager.getCslReportInterFace().getCslReportCollection(oql);
            this.updateReportStatusForDelete(ctx, adjustLisst);
            IObjectPK[] adjustPkList = this.getPKArray(adjustLisst);
            for (i = 0; i < adjustPkList.length; ++i) {
                this.paramsManager.getCslReportInterFace().delete(adjustPkList[i]);
            }
        }
        oql = "select id where SourceRpt.Id in (" + CslRptUtil.AryToItemString(strIdList) + ") and AdjustStatus = 10";
        if (this.paramsManager.getCslReportInterFace().exists(oql)) {
            CslReportCollection caliAdjustList = this.paramsManager.getCslReportInterFace().getCslReportCollection(oql);
            this.updateReportStatusForDelete(ctx, caliAdjustList);
            IObjectPK[] caliadjustPkList = this.getPKArray(caliAdjustList);
            for (i = 0; i < caliadjustPkList.length; ++i) {
                this.paramsManager.getCslReportInterFace().delete(caliadjustPkList[i]);
            }
        }
        this.updateReportStatusForDelete(ctx, infoList);
        for (int i2 = 0; i2 < pkList.length; ++i2) {
            this.paramsManager.getCslReportInterFace().delete(pkList[i2]);
        }
    }

    private List getStringIdList(CslReportCollection infoList) {
        ArrayList<String> idList = new ArrayList<String>();
        int size = infoList.size();
        for (int i = 0; i < size; ++i) {
            idList.add(infoList.get(i).getId().toString());
        }
        return idList;
    }

    private IObjectPK[] getPKArray(CslReportCollection infoList) {
        int size = infoList.size();
        IObjectPK[] paArray = new IObjectPK[size];
        for (int i = 0; i < size; ++i) {
            paArray[i] = new ObjectStringPK(infoList.get(i).getId().toString());
        }
        return paArray;
    }

    private void updateReportStatusForDelete(Context ctx, CslReportCollection infoList) throws BOSException, SQLDataException {
        List idList = this.getStringIdList(infoList);
        SQLBuilder builder = new SQLBuilder();
        builder.append("update T_Csl_CslReport set FAuditedStatus = 1, FCommittedStatus = 1").append(" where FId in ", (Collection)idList);
        DbUtil.execute((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            this.setItemDataStatus(ctx, idList.get(i).toString(), 1);
        }
    }

    private void setItemDataStatus(Context ctx, String reportId, int commitStatus) throws SQLDataException {
        StringBuffer strSQL = new StringBuffer();
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        Statement st = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            strSQL = new StringBuffer();
            strSQL.append("UPDATE T_CSL_ITEMDATA \r\n");
            strSQL.append("SET FCommitStatus = ");
            strSQL.append(commitStatus);
            if (commitStatus == 1) {
                strSQL.append(",FCommitDate = null \r\n");
            } else {
                strSQL.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
            }
            strSQL.append("WHERE FReportID = '" + reportId + "'");
            st.addBatch(strSQL.toString());
            strSQL = new StringBuffer();
            strSQL.append(" UPDATE T_CSL_ITEMDATAENTRY \r\n");
            strSQL.append(" SET FCommitStatus = ");
            strSQL.append(commitStatus);
            strSQL.append(" WHERE FReportID = '" + reportId + "'");
            st.addBatch(strSQL.toString());
            strSQL = new StringBuffer();
            strSQL.append("UPDATE T_CSL_DynaItemData \r\n");
            strSQL.append("SET FCommitStatus = ");
            strSQL.append(commitStatus);
            strSQL.append("WHERE FReportID = '" + reportId + "'");
            st.addBatch(strSQL.toString());
            strSQL = new StringBuffer();
            strSQL.append("Update T_CSL_InterItemData \r\n");
            strSQL.append("SET FCommitStatus =");
            strSQL.append(commitStatus);
            if (commitStatus == 1) {
                strSQL.append(",FCommitDate = null \r\n");
            } else {
                strSQL.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
            }
            strSQL.append("WHERE FReport = '" + reportId + "'");
            st.addBatch(strSQL.toString());
            strSQL = new StringBuffer();
            strSQL.append("Update T_CSL_ExchItemData \r\n");
            strSQL.append("SET FCommitStatus =");
            strSQL.append(commitStatus);
            if (commitStatus == 1) {
                strSQL.append(",FCommitDate = null \r\n");
            } else {
                strSQL.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
            }
            strSQL.append("WHERE FReport = '" + reportId + "'");
            st.addBatch(strSQL.toString());
            strSQL = new StringBuffer();
            strSQL.append("Update T_CSL_InvestItemData \r\n");
            strSQL.append("SET FCommitStatus =");
            strSQL.append(commitStatus);
            if (commitStatus == 1) {
                strSQL.append(",FCommitDate = null \r\n");
            } else {
                strSQL.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
            }
            strSQL.append("WHERE FReportID = '" + reportId + "'");
            st.addBatch(strSQL.toString());
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e2) {
            try {
                throw new SQLDataException(e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
    }

    private void setInfoValue(CslReportInfo report, CslReportInfo oldReport) {
        report.setAdjustStatus(AdjustStatusEnum.BEFOREADJUST);
        report.setAuditedStatus(oldReport.getAuditedStatus());
        report.setAuditor(oldReport.getAuditor());
        report.setAuditTime(oldReport.getAuditTime());
        report.setCommittedStatus(oldReport.getCommittedStatus());
        report.setCheckedStatus(oldReport.getCheckedStatus());
        report.setCommitor(oldReport.getCommitor());
        report.setCommitTime(oldReport.getCommitTime());
    }

    private Map getAdjItemData(Context ctx, Map mapItemData, Map mapAdjItemData) throws EASBizException, BOSException {
        Boolean isInclude = false;
        if (mapAdjItemData == null || mapAdjItemData.isEmpty()) {
            return mapItemData;
        }
        for (Object key : mapItemData.keySet()) {
            if (mapAdjItemData.get(key) == null) continue;
            BigDecimal value = (BigDecimal)mapAdjItemData.get(key);
            Object itemDataValue = mapItemData.get(key);
            if (itemDataValue != null) {
                BigDecimal bdData = ((BigDecimal)itemDataValue).add(value);
                mapItemData.put(key, bdData);
            } else {
                mapItemData.put(key, value);
            }
            isInclude = true;
        }
        for (Object key : mapAdjItemData.keySet()) {
            if (mapItemData.containsKey(key)) continue;
            BigDecimal value = (BigDecimal)mapAdjItemData.get(key);
            mapItemData.put(key, value);
        }
        mapAdjItemData.put("isInclude", isInclude);
        return mapItemData;
    }

    private void handleCsRefFormula(String formula, Object cell) {
        if (formula.toUpperCase().indexOf("CSREF") == -1 && formula.toUpperCase().indexOf("ACCTITEM") == -1 && formula.toUpperCase().indexOf("DYITEM") == -1) {
            return;
        }
        Expression stmt = null;
        try {
            stmt = ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Exception e) {
            return;
        }
        if (stmt == null) {
            return;
        }
        Expression expression = this.handleExpression(stmt);
        this.setCellFormula("=" + expression.toString(), cell);
    }

    private Expression handleExpression(Expression stmt) {
        if (stmt instanceof FunctionExpr) {
            FunctionExpr expr = (FunctionExpr)stmt;
            List param = expr.parameters;
            for (int i = 0; i < param.size(); ++i) {
                Object p = param.get(i);
                if (!(p instanceof FunctionExpr) && !(p instanceof BinaryOperationExpr) && !(p instanceof UnaryOperationExpr)) continue;
                this.handleExpression((Expression)p);
            }
            this.clearParamValue(((FunctionExpr)stmt).funcionName, param);
            return stmt;
        }
        if (stmt instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)stmt).left;
            this.handleExpression(expr);
            expr = ((BinaryOperationExpr)stmt).right;
            this.handleExpression(expr);
            return stmt;
        }
        if (stmt instanceof UnaryOperationExpr) {
            Expression expr = ((UnaryOperationExpr)stmt).operand;
            this.handleExpression(expr);
            return stmt;
        }
        return null;
    }

    private void clearParamValue(String fn, List param) {
        if ("AcctItem".equalsIgnoreCase(fn)) {
            Object o1 = param.get(2);
            Object o2 = param.get(3);
            if (o1 instanceof StringExpr && o2 instanceof StringExpr) {
                ((StringExpr)o1).value = "";
                ((StringExpr)o2).value = "";
            }
        } else if ("csRef".equalsIgnoreCase(fn)) {
            Object o1 = param.get(8);
            Object o2 = param.get(9);
            if (o1 instanceof StringExpr && o2 instanceof StringExpr) {
                ((StringExpr)o1).value = "";
                ((StringExpr)o2).value = "";
            }
        } else if ("dyItem".equalsIgnoreCase(fn)) {
            Object o1 = param.get(2);
            Object o2 = param.get(3);
            if (o1 instanceof StringExpr && o2 instanceof StringExpr) {
                ((StringExpr)o1).value = "";
                ((StringExpr)o2).value = "";
            }
        }
    }

    private void setCellFormula(String formula, Object cell) {
        if (cell instanceof Cell) {
            ((Cell)cell).setFormula(formula);
            this.setFormula((Cell)cell, formula);
        } else {
            ((Range)cell).setFormula(formula);
            this.setFormula((Range)cell, formula);
        }
    }

    private void refreshFormula(Cell cell, boolean isRefreshAdjustFormula, boolean isAdjust) {
        if (cell.hasFormula()) {
            String formula = cell.getFormula();
            this.refreshFormula(cell, isRefreshAdjustFormula, isAdjust, formula);
        }
    }

    private void refreshFormula(Range cell, boolean isRefreshAdjustFormula, boolean isAdjust) {
        if (cell.isHasFormula()) {
            String formula = cell.getFormula();
            this.refreshFormula(cell, isRefreshAdjustFormula, isAdjust, formula);
        }
    }

    private void refreshFormula(Object cell, boolean isRefreshAdjustFormula, boolean isAdjust, String formula) {
        if (isRefreshAdjustFormula && isAdjust) {
            if (CslRptUtil.isRefreshFormula(formula)) {
                this.setCellFormula(formula, cell);
            }
        } else {
            ConvtFormulaOpTypeEnum formulaOpType = this.paramsManager.getFormulaOpType();
            if (formulaOpType == null) {
                if (CslRptUtil.isDebarFormulaForConvt(formula) && CslRptUtil.isKeepIfFormulaForConvt(formula)) {
                    this.setCellFormula(null, cell);
                } else {
                    this.handleCsRefFormula(formula, cell);
                }
            } else {
                String param_Formula = this.paramsManager.getFormula();
                switch (formulaOpType.getValue()) {
                    case 1: {
                        if (CslRptUtil.isFormulaForConvtStrContainsFormula(formula, param_Formula) || CslRptUtil.isSumItemFormula(formula)) {
                            this.handleCsRefFormula(formula, cell);
                            break;
                        }
                        this.setCellFormula(null, cell);
                        break;
                    }
                    case 2: {
                        if (CslRptUtil.isFormulaForConvtStrContainsFormula(formula, param_Formula)) {
                            this.setCellFormula(null, cell);
                            break;
                        }
                        this.handleCsRefFormula(formula, cell);
                        break;
                    }
                }
            }
        }
    }

    private void setFormula(Cell cell, String formula) {
        if (this.paramsManager.isSupportOtherDS()) {
            cell.setUserObject("0", (Object)formula);
            cell.setUserObject("1", (Object)formula);
        }
    }

    private void setFormula(Range range, String formula) {
        if (this.paramsManager.isSupportOtherDS()) {
            range.setUserObject("0", (Object)formula);
            range.setUserObject("1", (Object)formula);
        }
    }
}

