/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.innertrade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.InterCheckControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InterExchReportValChgChecker {
    private final Map<Object, Object> _param;
    private boolean _isByCompany = false;
    private String _companyId = null;
    private String _targetCompanyId = null;
    private Context _ctx;

    public InterExchReportValChgChecker(Map<Object, Object> params, Context ctx) {
        this._param = params;
        this._ctx = ctx;
        this.parseParam();
    }

    private void parseParam() {
        this._isByCompany = (Boolean)this._param.get("isByCompany");
        this._companyId = (String)this._param.get("companyId");
        this._targetCompanyId = (String)this._param.get("targetCompanyId");
    }

    public Map check() throws EASBizException, BOSException {
        if (!CSLParamUtil.isCheckInterExchRptIsCheckage(this._ctx)) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer checkMsg = new StringBuffer();
        SQLBuilder sql = new SQLBuilder();
        List<String> tmpTbls = null;
        try {
            String elimType;
            tmpTbls = this.getSQLBuilder(sql);
            IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            String formatMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"CheckFormatMsg", (Locale)this._ctx.getOriginLocale());
            HashSet<String> ids = new HashSet<String>();
            String string = elimType = ElimTypeEnum.ComeAndGo.equals((Object)((ElimTypeEnum)((Object)this._param.get("elimType")))) ? "WL-" : "JY-";
            while (rs.next()) {
                ids.add(rs.getString("fid"));
                checkMsg.append(MessageFormat.format(formatMsg, elimType + rs.getString("chkNumber"), rs.getString("itemNum"), rs.getString("dataElementName"), rs.getString("companyName"), rs.getString("currName"), rs.getString("rptName")));
                checkMsg.append("\n");
            }
            result.put("msg", checkMsg.toString());
            result.put("ids", ids);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTbls != null && !tmpTbls.isEmpty() && !DebugLogger.isDebug) {
                TempTablePool tablePool = TempTablePool.getInstance((Context)this._ctx);
                for (String tmpTbl : tmpTbls) {
                    tablePool.releaseTable(tmpTbl);
                }
            }
        }
        return result;
    }

    public static String getCheckageIds(Context ctx, InterCheckControllerBean.CommonTable common, List<String> tmpTbls, Map<Object, Object> param, String ids) throws Exception {
        TempTablePool tablePool = TempTablePool.getInstance((Context)ctx);
        String idsTmp = tablePool.createTempTable("create table t_csl_Ids(FId varchar(44),fcompanyid varchar(44),ftargetCompanyID varchar(44), Fdc int)");
        tmpTbls.add(idsTmp);
        SQLBuilder sbSQL = new SQLBuilder();
        sbSQL.append(" insert into ").append(idsTmp).append("(FId,fcompanyid,ftargetCompanyID,Fdc)");
        sbSQL.append(" select distinct m.fid,e.Fcompanyid,e.ftargetCompanyId,");
        sbSQL.append(" case when (m.fisolddata=1 and e.fcompanyId>=e.ftargetCompanyId) or (m.fisolddata=0 and e.fdebit<>0) then 1 else 0 end ");
        sbSQL.append(" From ").append(common.getMasterTable()).append(" m   \n");
        sbSQL.append(" JOIN ").append(common.getEntryTable()).append(" e ON m.fid=e.fcheckageid \r\n");
        if (param != null) {
            Boolean isByCompany = (boolean)((Boolean)param.get("isByCompany"));
            String companyId = (String)param.get("companyId");
            Object targetCompanyId = null;
            sbSQL.append(" WHERE m.fcheckedstatus in(0,2)  \n");
            sbSQL.append(" AND m.FOrgBoundId= ? ", param.get("orgTreeId"));
            sbSQL.append(" AND m.FPeriodType= ? ", param.get("periodType"));
            sbSQL.append(" AND m.FYear = ? ", param.get("year"));
            sbSQL.append(" AND m.FPeriod = ? ", param.get("period"));
            if (!isByCompany.booleanValue()) {
                sbSQL.append(" AND (m.FOrgUnitId IS NULL OR m.FOrgUnitId =? ", param.get("orgUnitId")).append(") \n");
            } else if (targetCompanyId != null) {
                sbSQL.append(" and ((e.fcompanyid= ? ", (Object)companyId).append(" and e.ftargetcompanyid= ? ", targetCompanyId).append(" ) \n");
                sbSQL.append(" or (e.fcompanyid= ? ", targetCompanyId).append(" and e.ftargetcompanyid= ? ", (Object)companyId).append(" )) \n");
            } else {
                sbSQL.append(" and (e.fcompanyid= ? ", (Object)companyId).append(" or e.ftargetcompanyid= ? ", (Object)companyId).append(" ) \n");
            }
            if (param.get("solutionNumber") != null) {
                ArrayList templateList = new ArrayList();
                templateList = (ArrayList)param.get("templateList");
                if (templateList != null && templateList.size() > 0) {
                    sbSQL.append(" and m.FTempletID in ", (Collection)templateList);
                }
            }
        } else if (ids != null) {
            sbSQL.append(" WHERE m.fid in ").append(ids);
        }
        sbSQL.append(" and e.fbeforeadjustdata<>0 and e.fbeforeadjustdata is not null ");
        DbUtil.execute((Context)ctx, (String)sbSQL.getSQL(), (Object[])sbSQL.getParams());
        sbSQL.reset();
        sbSQL.append(" insert into ").append(idsTmp).append("(FId,fcompanyid,ftargetCompanyID,Fdc)");
        sbSQL.append(" select fid,ftargetCompanyID,fcompanyid, case when Fdc=1 then 0 else 1 end ");
        sbSQL.append(" from ").append(idsTmp);
        sbSQL.append(" where fid in  (");
        sbSQL.append(" \tselect FId from ").append(idsTmp).append(" group by fid having count(1)<=1  ");
        sbSQL.append(") ");
        DbUtil.execute((Context)ctx, (String)sbSQL.getSQL(), (Object[])sbSQL.getParams());
        return idsTmp;
    }

    public static String buildExistCheckagesByTemplate(Context ctx, String idsTmp, InterCheckControllerBean.CommonTable common, List<String> tmpTbls) throws Exception {
        TempTablePool tablePool = TempTablePool.getInstance((Context)ctx);
        String checkagesTmp = tablePool.createTempTable("create table t_csl_Ids(fid varchar(44),fcompanyId varchar(44),ftargetCompanyid varchar(44),fitemId varchar(44),FCurrencyId varchar(44),fdataelement int,fbeforeadjustdata NUMERIC(21,6))");
        tmpTbls.add(checkagesTmp);
        SQLBuilder sbSQL = new SQLBuilder();
        sbSQL.append(" insert into ").append(checkagesTmp).append("(fid,fcompanyId,ftargetCompanyid,fitemId,FCurrencyId,fdataelement,fbeforeadjustdata)");
        sbSQL.append(" \tselect m.fid,company.fcompanyid,company.ftargetcompanyId,tmpe.fitemid,m.FCurrencyId,tmpe.fdataelement,isnull(e.fbeforeadjustdata,0) \n");
        sbSQL.append(" \tfrom t_csl_elimTempletEntry tmpe \n");
        sbSQL.append(" \tinner join ").append(common.getMasterTable()).append(" m on tmpe.FTempletId=m.FTempletId \n ");
        sbSQL.append(" \tleft join ").append(idsTmp).append(" company on company.fid=m.fid and company.fdc=1 \n ");
        sbSQL.append("  left JOIN ").append(common.getEntryTable()).append(" e ON m.fid=e.fcheckageid and tmpe.fitemId = e.fitemId and tmpe.fdataelement=e.fdataelement");
        sbSQL.append(" and ((m.fisolddata=1 and e.fcompanyId>=e.ftargetCompanyId) or (m.fisolddata=0 and e.fdebit<>0)) \n");
        sbSQL.append(" \twhere m.fid in(select fid from ").append(idsTmp).append(") \n");
        sbSQL.append(" and (m.fisolddata=1 or (m.fisolddata=0 and tmpe.fdc=1)) ");
        sbSQL.append(" union all ");
        sbSQL.append(" \tselect m.fid,company.fcompanyid,company.ftargetcompanyId,tmpe.fitemid,m.FCurrencyId,tmpe.fdataelement,isnull(e.fbeforeadjustdata,0) \n");
        sbSQL.append(" \tfrom t_csl_elimTempletEntry tmpe \n");
        sbSQL.append(" \tinner join ").append(common.getMasterTable()).append(" m on tmpe.FTempletId=m.FTempletId \n ");
        sbSQL.append(" \tinner join ").append(idsTmp).append(" company on company.fid=m.fid and company.fdc=0 \n ");
        sbSQL.append("  left JOIN ").append(common.getEntryTable()).append(" e ON m.fid=e.fcheckageid and tmpe.fitemId = e.fitemId and tmpe.fdataelement=e.fdataelement");
        sbSQL.append(" and ((m.fisolddata=1 and e.fcompanyId<e.ftargetCompanyId) or (m.fisolddata=0 and e.fcredit<>0)) \n");
        sbSQL.append(" \twhere m.fid in(select fid from ").append(idsTmp).append(") \n");
        sbSQL.append(" and (m.fisolddata=1 or (m.fisolddata=0 and tmpe.fdc=0)) ");
        DbUtil.execute((Context)ctx, (String)sbSQL.getSQL(), (Object[])sbSQL.getParams());
        return checkagesTmp;
    }

    private List<String> getSQLBuilder(SQLBuilder sbSQL) throws Exception {
        ArrayList<String> tmpTbls = new ArrayList<String>();
        InterCheckControllerBean.CommonTable common = new InterCheckControllerBean.CommonTable((ElimTypeEnum)((Object)this._param.get("elimType")));
        String idsTmp = InterExchReportValChgChecker.getCheckageIds(this._ctx, common, tmpTbls, this._param, null);
        String checkagesTmp = InterExchReportValChgChecker.buildExistCheckagesByTemplate(this._ctx, idsTmp, common, tmpTbls);
        sbSQL.append(" select distinct currency.Fname_").append((Object)this._ctx.getLocale()).append(" currName,\n");
        sbSQL.append(" rptData.rptName rptName, mm.FNumber chkNumber ,\r\n");
        sbSQL.append(" item.Fnumber itemNum, \r\n");
        sbSQL.append(" dataElement.FName_").append((Object)this._ctx.getLocale()).append(" dataElementName,\n");
        sbSQL.append(" company.Fname_").append((Object)this._ctx.getLocale()).append(" companyName,m.fid \n");
        sbSQL.append(" From ").append(checkagesTmp).append(" m   \n");
        sbSQL.append(" inner join ").append(common.getMasterTable()).append(" mm on m.fid=mm.fid   \n");
        sbSQL.append(" JOIN T_CSL_RptItem item ON item.FID = m.FItemID \n");
        sbSQL.append(" JOIN T_CSL_DataElement dataElement ON dataElement.FInterSeq = m.FDataElement \n");
        sbSQL.append(" JOIN T_BD_Currency currency ON currency.FID = m.FCurrencyId \n");
        sbSQL.append(" JOIN T_ORG_BaseUnit company ON company.FID = m.FcompanyID \n");
        sbSQL.append(" left join (");
        sbSQL.append("   select idata.FItemNumber,idata.FtargetCompanyID,idata.FCompanyID,idata.FcurrencyID,idata.FYear,idata.FPeriod");
        sbSQL.append("   ,idata.FPeriodType,idata.FDataElement,idata.Fmoney,rpt.FName rptName ");
        sbSQL.append("   from ").append(common.getItemDataTable()).append(" idata  \n");
        sbSQL.append("   JOIN T_CSL_CslReport rpt ON rpt.FID = idata.FReport \n");
        sbSQL.append("   JOIN T_RPT_RptSheetPara sheetPara ON sheetPara.FReportID = rpt.FID \n");
        sbSQL.append("   where idata.FYear=? ", this._param.get("year"));
        sbSQL.append("    \tAND  idata.FPeriod = ? ", this._param.get("period"));
        sbSQL.append(" \t  \tAND idata.FPeriodType= ? ", this._param.get("periodType"));
        sbSQL.append(" \t\tAND ( idata.fimportedgroup is null and rpt.FAuditedStatus = 2 \n");
        sbSQL.append(" \t\tAND sheetPara.FReportClass = ?", (Object)(ElimTypeEnum.ComeAndGo.equals((Object)((ElimTypeEnum)((Object)this._param.get("elimType")))) ? 10 : 20));
        sbSQL.append(" \t\tor idata.fimportedgroup is not null)");
        sbSQL.append(" \t) rptData ON rptData.FItemNumber = item.FNumber ");
        sbSQL.append("  AND rptData.FtargetCompanyID = m.FtargetCompanyID \n");
        sbSQL.append("  AND rptData.FCompanyID = m.FCompanyID AND rptData.FcurrencyID = m.FcurrencyID \n");
        sbSQL.append("  AND rptData.FDataElement = m.FDataElement \n");
        sbSQL.append(" WHERE ");
        sbSQL.append(" (rptData.Fmoney <> m.fbeforeadjustdata or (m.fbeforeadjustdata<>0 and rptData.rptName is null)) \n");
        sbSQL.append(" order by mm.FNumber,item.Fnumber ");
        return tmpTbls;
    }
}

