/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslParamBox;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.ElimDataUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.dynarpt.DynaItemDataByCompany;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.dynarpt.DynaItemDataByName;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.dynarpt.DynaItemDataListAll;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaCslRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ReportCalcGroupKey;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.fast.FastMergeExecSelector;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DynaRptCalcServerHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaRptCalcServerHelper");

    public static Map _calculateDynaSumRpt(Context ctx, String reportID, List companys, Map positions, boolean doOffset, boolean includeDiffTable, boolean isSupportRpt) throws BOSException, EASBizException {
        if (reportID == null || companys == null || companys.size() == 0 || positions == null || positions.size() == 0) {
            return null;
        }
        CslReportInfo report = DynaRptCalcServerHelper.getCslReportInfo(ctx, reportID);
        if (report == null) {
            return null;
        }
        CslParamBox paramBox = DynaRptCalcServerHelper.getCslParamBox(ctx);
        PeriodCollection periods = null;
        if (paramBox.isMergeByFiscalPeriod()) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, report);
        }
        String orgTreeid = null;
        boolean keepItemFormula = false;
        boolean isForSave = true;
        Map result = DynaRptCalcServerHelper.performDynaRptSUM(ctx, report, null, companys, positions, doOffset, includeDiffTable, keepItemFormula, isForSave, paramBox, periods, orgTreeid, isSupportRpt);
        return result;
    }

    public static Map _calculateDynaSumRpt(Context ctx, String reportID, List companys, Map positions, boolean doOffset, boolean includeDiffTable) throws BOSException, EASBizException {
        boolean isSupportRpt = true;
        if (positions.get("isSupportRpt") != null && positions.get("isSupportRpt") instanceof Boolean) {
            isSupportRpt = (Boolean)positions.get("isSupportRpt");
            positions.remove("isSupportRpt");
        }
        return DynaRptCalcServerHelper._calculateDynaSumRpt(ctx, reportID, companys, positions, doOffset, includeDiffTable, isSupportRpt);
    }

    private static CslReportInfo getCslReportInfo(Context ctx, String reportID) throws BOSException {
        if (reportID == null) {
            return null;
        }
        String oql = new StringBuffer("select id, year, period, periodType, reportDate, SourceType, ").append("currency.id, currency.precision, OrgTree.id,orgTree.number, OrgUnit.id, ").append("orgUnit.number,orgUnit.name,template.id,template.isSupportInnerExch,").append("dataCollectNumber, company.id, fastmergesoluid where id = '").append(reportID).append("'").toString();
        CslReportCollection reportCol = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(oql);
        if (reportCol == null || reportCol.size() != 1) {
            return null;
        }
        return reportCol.get(0);
    }

    private static CslParamBox getCslParamBox(Context ctx) {
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        CslParamBox paramBox = new CslParamBox();
        paramBox.setMergeByFiscalPeriod(values[0]);
        paramBox.setSupport13Period(values[1]);
        return paramBox;
    }

    public static Map _calculateDynaCslRpt(Context ctx, DynaCslRptParamInfo dynaCslRptParamInfo, Map positions, boolean doOffset, boolean includeDiffTable) throws BOSException, EASBizException {
        if (dynaCslRptParamInfo.getReportID() == null || positions == null || positions.size() == 0 || dynaCslRptParamInfo.getCompanyMap() == null) {
            return null;
        }
        CslReportInfo report = DynaRptCalcServerHelper.getCslReportInfo(ctx, dynaCslRptParamInfo.getReportID());
        if (report == null) {
            return null;
        }
        CslParamBox paramBox = DynaRptCalcServerHelper.getCslParamBox(ctx);
        PeriodCollection periods = null;
        if (paramBox.isMergeByFiscalPeriod()) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, report);
        }
        String orgTreeid = null;
        boolean keepItemFormula = false;
        boolean isForSave = false;
        Map result = DynaRptCalcServerHelper.performDynaRptSUM(ctx, report, dynaCslRptParamInfo, null, positions, doOffset, includeDiffTable, keepItemFormula, isForSave, paramBox, periods, orgTreeid, true);
        return result;
    }

    public static void _calculateDynaSumRptAndSave(Context ctx, String reportID, Map companys, Map positions, boolean doOffset, boolean includeDiffTable) throws BOSException, EASBizException {
        CslReportInfo report;
        if (positions == null || positions.isEmpty()) {
            return;
        }
        boolean isSingeSheetCal = false;
        if (companys.containsKey("isSingeSheetCal")) {
            isSingeSheetCal = true;
            companys.remove("isSingeSheetCal");
        }
        String unitMap2SerialString = null;
        if (companys.containsKey("unitMap2SerialString")) {
            unitMap2SerialString = (String)companys.remove("unitMap2SerialString");
        }
        if ((report = DynaRptCalcServerHelper.getCslReportInfo(ctx, reportID)) == null) {
            return;
        }
        CslParamBox paramBox = DynaRptCalcServerHelper.getCslParamBox(ctx);
        PeriodCollection periods = null;
        if (paramBox.isMergeByFiscalPeriod()) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, report);
        }
        String orgTreeid = null;
        HashMap paramMap = new HashMap();
        HashMap mapH = new HashMap();
        ArrayList sheetIds = new ArrayList();
        Integer dynaType = Integer.valueOf("1");
        RptSheetParamCollection sheetparams = RptSheetParamFactory.getLocalInstance((Context)ctx).getRptSheetParamCollection("select id,sheetid,sheetname where report = '" + report.getId().toString() + "'");
        HashMap<String, String> sheets = new HashMap<String, String>();
        int size = sheetparams.size();
        for (int i = 0; i < size; ++i) {
            RptSheetParamInfo sheetparam = sheetparams.get(i);
            if (sheets.containsKey(sheetparam.getSheetName())) continue;
            sheets.put(sheetparam.getSheetName(), sheetparam.getSheetID());
        }
        boolean isDyRptSaveUpdateItem4CM = CSLParamUtil.isDyRptSaveUpdateItem4CM(ctx);
        boolean keepItemFormula = true;
        boolean isForSave = true;
        if (unitMap2SerialString == null) {
            boolean isHasData = false;
            for (Map.Entry ent : companys.entrySet()) {
                List cs = (List)ent.getValue();
                long time1 = System.currentTimeMillis();
                HashMap singleSheet = new HashMap(4);
                Map tmpMap = (Map)positions.get(ent.getKey());
                if (tmpMap == null || tmpMap.isEmpty()) continue;
                singleSheet.put(ent.getKey(), tmpMap);
                Map result = DynaRptCalcServerHelper.performDynaRptSUM(ctx, report, null, cs, singleSheet, doOffset, includeDiffTable, keepItemFormula, isForSave, paramBox, periods, orgTreeid, true);
                logger.info((Object)("performDynaRptSUM:" + (System.currentTimeMillis() - time1) + "ms"));
                DynaRptCalcServerHelper.loopResult4MapH(ctx, mapH, result, sheetIds, sheets, isDyRptSaveUpdateItem4CM, paramMap);
                isHasData = true;
            }
            if (!isHasData) {
                return;
            }
        } else {
            DynaCslRptParamInfo dynaCslRptParamInfo = new DynaCslRptParamInfo();
            dynaCslRptParamInfo.parseStr2UnitMap(unitMap2SerialString);
            dynaCslRptParamInfo.setReportID(reportID);
            Map result = DynaRptCalcServerHelper.performDynaRptSUM(ctx, report, dynaCslRptParamInfo, null, positions, doOffset, includeDiffTable, keepItemFormula, isForSave, paramBox, periods, orgTreeid, true);
            DynaRptCalcServerHelper.loopResult4MapH(ctx, mapH, result, sheetIds, sheets, isDyRptSaveUpdateItem4CM, paramMap);
        }
        try {
            boolean isEnd = false;
            Iterator iter = positions.keySet().iterator();
            while (iter.hasNext() && !isEnd) {
                Iterator iter2;
                String sheetID = (String)iter.next();
                Map sheetMap = (Map)positions.get(sheetID);
                if (sheetMap == null || sheetMap.isEmpty() || !(iter2 = sheetMap.keySet().iterator()).hasNext()) continue;
                Point basePoint = (Point)iter2.next();
                Map areaMap = (Map)sheetMap.get(basePoint);
                DynaParameters param = DynaParameters.getInstanceFromString((String)((String)areaMap.get("param")));
                dynaType = param.getSumMethod().getValue();
                isEnd = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"get dynaType error", (Throwable)ex);
            dynaType = 1;
        }
        IItemDataProvider iItemData = ItemDataProviderFactory.getLocalInstance(ctx);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(8);
        map.put("itemData", mapH);
        map.put("valueType", new Integer(includeDiffTable ? 2 : 0));
        map.put("dynaType", dynaType);
        if (isSingeSheetCal) {
            if (sheetIds.isEmpty()) {
                return;
            }
            map.put("sheetIds", sheetIds);
        }
        iItemData.saveDynaItemData(reportID, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map performDynaRptSUM(Context ctx, CslReportInfo report, DynaCslRptParamInfo dynaCslRptParamInfo, List companys, Map positions, boolean doOffset, boolean includeDiffTable, boolean keepItemFormula, boolean isForSave, CslParamBox paramBox, PeriodCollection periods, String orgTreeid, boolean isSupportRpt) throws EASBizException, BOSException {
        if (report == null || positions == null || positions.size() == 0) {
            return null;
        }
        DynaParamInfo paramInfo = new DynaParamInfo();
        if (dynaCslRptParamInfo == null) {
            paramInfo.dynaCslRptParamInfo = null;
            paramInfo.companyIDs = CslRptUtil.changeIdList2String(companys);
            paramInfo.isSupportCrossMerger = false;
        } else {
            paramInfo.dynaCslRptParamInfo = dynaCslRptParamInfo;
            paramInfo.companyIDs = null;
            paramInfo.isSupportCrossMerger = true;
        }
        paramInfo.report = report;
        paramInfo.doOffset = doOffset;
        paramInfo.includeDiffTable = includeDiffTable;
        paramInfo.isForSave = isForSave;
        paramInfo.keepItemFormula = keepItemFormula;
        paramInfo.orgTreeid = orgTreeid;
        paramInfo.paramBox = paramBox;
        paramInfo.periods = periods;
        paramInfo.positions = positions;
        List yearAndPeriod = DynaRptCalcServerHelper.offsetYearAndPeriod(paramInfo);
        Map result = null;
        try {
            if (paramInfo.doOffset && paramInfo.isSupportCrossMerger) {
                ItemDataCondition condition = new ItemDataCondition();
                condition.setValueType(-100);
                condition.setTargetCurrency(report.getCurrency().getId().toString());
                condition.setRptPeriodType(report.getPeriodType().getValue());
                condition.setDataCollectNumber(report.getDataCollectNumber());
                if (dynaCslRptParamInfo != null) {
                    String fastMergeSoluId = report.getFastMergeSoluId();
                    if (!StringUtils.isEmpty((String)fastMergeSoluId)) {
                        dynaCslRptParamInfo.setIncludeUnAuditElim(FastMergeUtil.getIsContainUnRecive(ctx, fastMergeSoluId));
                    }
                    condition.setIncludeUnAuditElim(dynaCslRptParamInfo.isIncludeUnAuditElim());
                }
                HashMap<String, List> m = new HashMap<String, List>(2);
                m.put("YearAndPeriod", yearAndPeriod);
                condition.setSystemVars(m);
                if (dynaCslRptParamInfo != null) {
                    dynaCslRptParamInfo.backCompanyMap();
                }
                paramInfo.tempElimIDTable = ElimDataUtil.getTempElimIDTable(ctx, condition, dynaCslRptParamInfo, report.getOrgTree().getId().toString(), report.getOrgUnit().getId().toString());
                if (dynaCslRptParamInfo != null) {
                    dynaCslRptParamInfo.reSetCompanyMap();
                }
            }
            result = DynaRptCalcServerHelper.performDynaRptSUM(ctx, paramInfo, isSupportRpt);
        }
        finally {
            if (!StringUtils.isEmpty((String)paramInfo.tempElimIDTable) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)ctx).releaseTable(paramInfo.tempElimIDTable);
            }
        }
        return result;
    }

    private static List offsetYearAndPeriod(DynaParamInfo paramInfo) throws EASBizException, BOSException {
        ArrayList<int[]> yearAndPeriod = null;
        if (paramInfo.doOffset && paramInfo.isSupportCrossMerger) {
            yearAndPeriod = new ArrayList<int[]>();
        }
        for (Map.Entry values22 : paramInfo.positions.entrySet()) {
            HashMap map = (HashMap)values22.getValue();
            if (map == null) continue;
            for (Map.Entry values22 : map.entrySet()) {
                Map formulasMap;
                HashMap map1 = (HashMap)values22.getValue();
                if (map1 == null || (formulasMap = (Map)map1.get("formulas")) == null) continue;
                for (Map.Entry values22 : formulasMap.entrySet()) {
                    ItemFormula formula = (ItemFormula)values22.getValue();
                    if (formula == null) continue;
                    DynaRptCalcServerHelper.offsetYearAndPeriod(paramInfo.paramBox.isMergeByFiscalPeriod(), paramInfo.paramBox.isSupport13Period(), paramInfo.report.getPeriodType(), paramInfo.report.getYear(), paramInfo.report.getPeriod(), formula, paramInfo.periods);
                    if (yearAndPeriod == null) continue;
                    yearAndPeriod.add(new int[]{formula.getYear(), formula.getPeriod()});
                }
            }
        }
        return yearAndPeriod;
    }

    private static Integer loopResult4MapH(Context ctx, Map mapH, Map result, ArrayList sheetIds, HashMap sheets, boolean isDyRptSaveUpdateItem4CM, Map paramMap) throws EASBizException, BOSException {
        Integer dynaType = Integer.valueOf("1");
        if (result == null) {
            return dynaType;
        }
        for (Map.Entry values : result.entrySet()) {
            Map sheet = (Map)values.getValue();
            for (Map.Entry points : sheet.entrySet()) {
                Map pointValue = (Map)points.getValue();
                for (Map.Entry row : pointValue.entrySet()) {
                    Map v = (Map)row.getValue();
                    String ditemNumber = (String)row.getKey();
                    String grade = (String)v.get("GRADE_NUMBER");
                    Map m = (Map)v.get("KEY_POINT_VALUE");
                    Iterator mit = m.entrySet().iterator();
                    Map notGradeLeaf = (Map)m.get("notGradeLeaf");
                    while (mit.hasNext()) {
                        DynaParameters params;
                        Map.Entry man = mit.next();
                        Object key = man.getKey();
                        if (!(key instanceof Point)) continue;
                        ItemFormula f = (ItemFormula)m.get("ItemFormula" + key.toString());
                        String param = (String)m.get("DynaParam" + key.toString());
                        StringBuffer fkey = new StringBuffer();
                        fkey.append(DataElementProvider.getDataElementInnerValue(ctx, f.getDataElementNumber()));
                        fkey.append(",");
                        fkey.append(f.getValueType());
                        fkey.append(",");
                        fkey.append(f.getYear());
                        fkey.append(",");
                        fkey.append(f.getPeriod());
                        fkey.append(",");
                        fkey.append(f.getDay().toString());
                        String ks = fkey.toString();
                        Object cellValue = man.getValue();
                        HashMap value = null;
                        if (!mapH.containsKey(ks)) {
                            value = new HashMap();
                            mapH.put(ks, value);
                        } else {
                            value = (HashMap)mapH.get(ks);
                        }
                        Object v_item = cellValue;
                        String itemNumber = f.getItemNumber();
                        Map mapD = null;
                        if (!value.containsKey(itemNumber)) {
                            mapD = new HashMap();
                            value.put(itemNumber, mapD);
                        } else {
                            mapD = (Map)value.get(itemNumber);
                        }
                        ArrayList<Object> valueList = new ArrayList<Object>();
                        valueList.add(0, v_item);
                        String keyName = (String)v.get("KEY_DITEM_NAME");
                        valueList.add(1, keyName);
                        valueList.add(2, new Integer(DynaRptCalcServerHelper.getDynaItemType(ctx, param, paramMap).getValue()));
                        valueList.add(3, new Integer(((Point)key).y));
                        valueList.add(4, new Integer(((Point)key).x));
                        valueList.add(5, sheets.get(values.getKey()));
                        if (!sheetIds.contains(sheets.get(values.getKey()))) {
                            sheetIds.add(sheets.get(values.getKey()));
                        }
                        if ((params = DynaParameters.getInstanceFromString((String)param)).getDynaItemSource() == 0 && params.isGrade()) {
                            valueList.add(6, grade);
                            if (grade != null && grade.indexOf(".D") < 0 && notGradeLeaf.containsKey(grade)) {
                                valueList.add(7, false);
                            } else {
                                valueList.add(7, true);
                            }
                        }
                        if (isDyRptSaveUpdateItem4CM) {
                            if (!StringUtils.isEmpty((String)grade)) {
                                mapD.put(grade + "@@" + keyName, valueList);
                            } else {
                                mapD.put(keyName, valueList);
                            }
                        } else {
                            mapD.put(ditemNumber, valueList);
                        }
                        dynaType = new Integer(params.getSumMethod().getValue());
                        HashMap value1 = (HashMap)mapH.get(ks);
                        if (value1 != null && value1.isEmpty()) {
                            mapH.remove(ks);
                        }
                        key = null;
                    }
                }
            }
        }
        return dynaType;
    }

    private static Map performDynaRptSUM(Context ctx, DynaParamInfo paramInfo, boolean isSupportRpt) throws BOSException, EASBizException {
        if (paramInfo.report == null || paramInfo.positions == null || paramInfo.positions.size() == 0) {
            return null;
        }
        paramInfo = DynaRptCalcServerHelper.initFastMegerDynaParamInfo(ctx, paramInfo);
        String gradeNumber = null;
        HashMap result = new HashMap();
        Iterator iter = paramInfo.positions.keySet().iterator();
        boolean isExpandCompanyIds = false;
        while (iter.hasNext()) {
            long time1 = System.currentTimeMillis();
            String sheetID = (String)iter.next();
            Map sheetMap = (Map)paramInfo.positions.get(sheetID);
            HashMap resultSheet = new HashMap();
            result.put(sheetID, resultSheet);
            if (sheetMap == null) continue;
            for (Point basePoint : sheetMap.keySet()) {
                Map areaMap = (Map)sheetMap.get(basePoint);
                DynaParameters param = DynaParameters.getInstanceFromString((String)((String)areaMap.get("param")));
                Map formulasMap = (Map)areaMap.get("formulas");
                HashMap<String, Object> notGradeLeaf = new HashMap<String, Object>();
                if (!resultSheet.containsKey(basePoint)) {
                    resultSheet.put(basePoint, new HashMap());
                }
                boolean isManualGrade = param.isGrade() && param.getDynaItemSource() == 0;
                Map resultBase = (Map)resultSheet.get(basePoint);
                Map gradeMapping = null;
                if (isManualGrade) {
                    DynaSumMethodEnum method = param.getSumMethod();
                    if (!paramInfo.isSupportCrossMerger && method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) && param.isOnlyListCompany() && !isExpandCompanyIds) {
                        paramInfo.companyIDs = CslRptUtil.expandCompanys(ctx, paramInfo.report.getOrgTree().getId().toString(), paramInfo.companyIDs, true);
                        isExpandCompanyIds = true;
                    }
                    gradeMapping = DynaRptCalcServerHelper.getTextGrade(ctx, formulasMap, method, paramInfo);
                } else {
                    gradeMapping = new HashMap();
                }
                Iterator iter3 = formulasMap.keySet().iterator();
                HashMap<String, String> sameName = new HashMap<String, String>();
                HashMap<String, String> keyNumberKeyName = new HashMap<String, String>();
                while (iter3.hasNext()) {
                    Point point = (Point)iter3.next();
                    ItemFormula formula = (ItemFormula)formulasMap.get(point);
                    List dataList = null;
                    dataList = DynaRptCalcServerHelper.getDynaItemData(ctx, formula, param, gradeMapping, paramInfo, isSupportRpt);
                    int n = dataList.size();
                    for (int i = 0; i < n; ++i) {
                        Map row = (Map)dataList.get(i);
                        String name = (String)row.get("KEY_DITEM_NAME");
                        String showName = (String)row.get("KEY_DITEM_SHOW_NUMBER");
                        String key = (String)row.get("KEY_DITEM_NUMBER");
                        String sortNumber = (String)row.get("KEY_DITEM_SORT_NUMBER");
                        Object value = row.get("KEY_DITEM_VALUE");
                        boolean isSameNameNubmer = false;
                        isSameNameNubmer = row.get("KEY_DITEM_NAMENUMBERISSAME") != null ? (Boolean)row.get("KEY_DITEM_NAMENUMBERISSAME") : key != null && key.equals(name);
                        gradeNumber = (String)row.get("GRADE_NUMBER");
                        if (isSameNameNubmer && keyNumberKeyName.get(name) != null) {
                            key = (String)keyNumberKeyName.get(name);
                        } else if (!isSameNameNubmer && sameName.containsKey(name)) {
                            Map curPointMap = (Map)resultBase.get(sameName.get(name));
                            resultBase.remove(sameName.get(name));
                            resultBase.put(key, curPointMap);
                            sameName.remove(name);
                        }
                        if (!resultBase.containsKey(key)) {
                            Object orgUnitNumber;
                            Object o;
                            HashMap<String, Object> pointMap = new HashMap<String, Object>();
                            pointMap.put("KEY_DITEM_SHOW_NUMBER", showName);
                            pointMap.put("KEY_DITEM_SORT_NUMBER", sortNumber);
                            pointMap.put("KEY_DITEM_NAME", name);
                            pointMap.put("KEY_POINT_VALUE", new HashMap());
                            pointMap.put("GRADE_NUMBER", gradeNumber);
                            if (gradeNumber != null && gradeNumber.indexOf(".D") > 0) {
                                notGradeLeaf.put(gradeNumber.replace(".D", ""), null);
                            }
                            if ((o = row.get("COMPANY_NAME")) != null) {
                                pointMap.put("COMPANY_NAME", o);
                            }
                            if ((orgUnitNumber = row.get("COMPANY_NUMBER")) != null) {
                                pointMap.put("COMPANY_NUMBER", orgUnitNumber);
                            }
                            if ((o = row.get("KEY_OWNER_COMPANY")) != null) {
                                pointMap.put("KEY_OWNER_COMPANY", o);
                            }
                            if ((o = row.get("KEY_BOUND_TYPE")) != null) {
                                pointMap.put("KEY_BOUND_TYPE", o);
                            }
                            if ((o = row.get("KEY_INNER_NUMBER")) != null) {
                                pointMap.put("KEY_INNER_NUMBER", o);
                            }
                            resultBase.put(key, pointMap);
                            if (isSameNameNubmer && !sameName.containsKey(name)) {
                                sameName.put(name, key);
                            } else if (!isSameNameNubmer && !keyNumberKeyName.containsKey(name)) {
                                keyNumberKeyName.put(name, key);
                            }
                        } else {
                            Map tmpResultName = (Map)((Map)resultBase.get(key)).get("KEY_POINT_VALUE");
                            Object tmpValue = tmpResultName.get(point);
                            if (tmpValue instanceof BigDecimal && value instanceof BigDecimal) {
                                value = ((BigDecimal)tmpValue).add((BigDecimal)value);
                            } else if (tmpValue instanceof String && value instanceof String) {
                                value = tmpValue == null ? value : tmpValue.toString() + ";" + value;
                            }
                        }
                        Map resultName = (Map)((Map)resultBase.get(key)).get("KEY_POINT_VALUE");
                        if (paramInfo.keepItemFormula) {
                            resultName.put("ItemFormula" + point.toString(), formula);
                            resultName.put("DynaParam" + point.toString(), (String)areaMap.get("param"));
                            if (isManualGrade) {
                                resultName.put("notGradeLeaf", notGradeLeaf);
                            }
                        }
                        resultName.put(point, value);
                    }
                }
            }
            logger.info((Object)("sheet" + sheetID + ":" + (System.currentTimeMillis() - time1) + "ms"));
        }
        return result;
    }

    private static List getDynaItemData(Context ctx, ItemFormula formula, DynaParameters param, Map gradeMapping, DynaParamInfo paramInfo, boolean isSupportRpt) throws BOSException, EASBizException {
        boolean isTextGrade = param.isGrade() && param.getDynaItemSource() == 0;
        DynaSumMethodEnum method = param.getSumMethod();
        boolean isSumByTextNotGrade = !isTextGrade && !paramInfo.isForSave && formula.getValueType() == 3;
        ArrayList dynaItemDataList = new ArrayList();
        if (paramInfo.dynaCslRptParamInfo == null) {
            DynaCslRptParamInfo curParamInfo = new DynaCslRptParamInfo();
            curParamInfo.setSumMethod(method);
            OrgTreeInfo orgTree = new OrgTreeInfo();
            String orgTreeId = paramInfo.orgTreeid;
            if (!StringUtils.isEmpty((String)orgTreeId)) {
                orgTree.setId(BOSUuid.read((String)orgTreeId));
            } else if (paramInfo.report != null && paramInfo.report.getOrgTree() != null) {
                orgTree = paramInfo.report.getOrgTree();
            } else {
                return dynaItemDataList;
            }
            if (!StringUtils.isEmpty((String)paramInfo.companyIDs)) {
                if (!paramInfo.isSupportGroupReport && !StringUtils.isEmpty((String)paramInfo.fastMergeSoluId)) {
                    FullOrgUnitCollection coll = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select id where id in(" + paramInfo.companyIDs + ") and isUnion=1 ");
                    Set<String> unionOrgSet = null;
                    ReportCalcGroupKey calcGroupKey = null;
                    if (coll != null && coll.size() > 0) {
                        String[] sourceSoluInfo = new FastMergeSoluInfo();
                        sourceSoluInfo.setId(BOSUuid.read((String)paramInfo.fastMergeSoluId));
                        calcGroupKey = new ReportCalcGroupKey();
                        calcGroupKey.setOrgTree(orgTree);
                        calcGroupKey.setFromStatutory(false);
                        calcGroupKey.setSourceSoluInfo((FastMergeSoluInfo)sourceSoluInfo);
                        for (int i = 0; i < coll.size(); ++i) {
                            curParamInfo.addCompanyGroupMap(calcGroupKey, coll.get(i).getId().toString());
                        }
                        unionOrgSet = curParamInfo.getCompanyGroupMap().get(calcGroupKey);
                    }
                    calcGroupKey = new ReportCalcGroupKey();
                    calcGroupKey.setOrgTree(orgTree);
                    calcGroupKey.setFromStatutory(true);
                    for (String companyId : paramInfo.companyIDs.split(",")) {
                        companyId = companyId.replaceAll("'", "");
                        if (unionOrgSet != null && unionOrgSet.contains(companyId)) continue;
                        curParamInfo.addCompanyGroupMap(calcGroupKey, companyId);
                    }
                    curParamInfo.setIncludeUnAuditElim(paramInfo.isContainUnRecive);
                } else {
                    for (String companyId : paramInfo.companyIDs.split(",")) {
                        curParamInfo.addCompany(orgTree, companyId.replaceAll("'", ""));
                    }
                }
            } else {
                return dynaItemDataList;
            }
            paramInfo.dynaCslRptParamInfo = curParamInfo;
        }
        Map<ReportCalcGroupKey, Set<String>> companyGroupMap = paramInfo.dynaCslRptParamInfo.getCompanyGroupMap();
        ItemFormula curFormula = null;
        if (companyGroupMap != null && !companyGroupMap.isEmpty()) {
            Set<String> companyIds = null;
            int groupIndex = 0;
            for (ReportCalcGroupKey calcGroupKey : companyGroupMap.keySet()) {
                paramInfo.isIgnoreCalcElimData = groupIndex != 0;
                if (calcGroupKey.getPeriodOffset() != 0) {
                    curFormula = (ItemFormula)formula.clone();
                    int[] offsetYearAndPeriod = RptCalcHelper.offsetYearAndPeriod(paramInfo.paramBox.isMergeByFiscalPeriod(), paramInfo.paramBox.isSupport13Period(), paramInfo.report.getPeriodType(), curFormula.getYear(), curFormula.getPeriod(), 0, calcGroupKey.getPeriodOffset(), paramInfo.periods);
                    curFormula.putExt("10", String.valueOf(offsetYearAndPeriod[0]));
                    curFormula.putExt("11", String.valueOf(offsetYearAndPeriod[1]));
                } else {
                    curFormula = formula;
                }
                companyIds = companyGroupMap.get(calcGroupKey);
                if (companyIds != null && !companyIds.isEmpty()) {
                    paramInfo.companyIDs = CslRptUtil.changeIdSet2String(companyIds);
                    paramInfo.calcGroupKey = calcGroupKey;
                    dynaItemDataList.addAll(DynaRptCalcServerHelper.calculate(ctx, curFormula, isTextGrade, isSumByTextNotGrade, param, method, gradeMapping, paramInfo, isSupportRpt));
                }
                ++groupIndex;
            }
        }
        DynaRptCalcServerHelper.cslByNameForElim(dynaItemDataList, method, formula);
        return dynaItemDataList;
    }

    private static void cslByNameForElim(List result, DynaSumMethodEnum method, ItemFormula formula) {
        BigDecimal curValue = null;
        if (method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) && formula.getValueType() != 3) {
            Map row = null;
            String name = null;
            HashMap<String, Integer> notElimDatas = new HashMap<String, Integer>();
            ArrayList<Integer> elimRows = new ArrayList<Integer>();
            ArrayList<Map> removeRows = new ArrayList<Map>();
            String tmpStr = null;
            int index = -1;
            for (int i = result.size() - 1; i >= 0; --i) {
                row = (Map)result.get(i);
                name = (String)row.get("KEY_DITEM_NAME");
                tmpStr = name.trim();
                index = tmpStr.lastIndexOf("[");
                if (index > 0) {
                    notElimDatas.put(tmpStr.substring(index), i);
                    continue;
                }
                if (index != 0) continue;
                elimRows.add(i);
            }
            Map row2 = null;
            for (Integer i : elimRows) {
                row = (Map)result.get(i);
                name = (String)row.get("KEY_DITEM_NAME");
                if (!notElimDatas.containsKey(name)) continue;
                row2 = (Map)result.get((Integer)notElimDatas.get(name));
                curValue = ((BigDecimal)row.get("KEY_DITEM_VALUE")).add((BigDecimal)row2.get("KEY_DITEM_VALUE"));
                row2.put("KEY_DITEM_VALUE", curValue);
                if (curValue.compareTo(BigDecimal.ZERO) == 0) {
                    removeRows.add(row2);
                }
                removeRows.add(row);
            }
            if (!removeRows.isEmpty()) {
                result.removeAll(removeRows);
            }
            notElimDatas.clear();
            elimRows.clear();
            removeRows.clear();
        }
    }

    private static List calculate(Context ctx, ItemFormula formula, boolean isTextGrade, boolean isSumByTextNotGrade, DynaParameters param, DynaSumMethodEnum method, Map gradeMapping, DynaParamInfo paramInfo, boolean isSupportRpt) throws BOSException, EASBizException {
        if (method.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE) || method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME) || isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY) || paramInfo.isForSave && formula.getValueType() == 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
            DynaItemDataByName dataByName = new DynaItemDataByName(ctx, formula, isTextGrade, isSumByTextNotGrade, method, gradeMapping, paramInfo);
            dataByName.setSupportRpt(isSupportRpt);
            return dataByName.calculate();
        }
        if (formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
            DynaItemDataByCompany dataByCompany = new DynaItemDataByCompany(ctx, formula, isTextGrade, isSumByTextNotGrade, method, gradeMapping, paramInfo, param.isGrade());
            dataByCompany.setSupportRpt(isSupportRpt);
            return dataByCompany.calculate();
        }
        if (method.equals((Object)DynaSumMethodEnum.LIST_NAME_COMPANY) || method.equals((Object)DynaSumMethodEnum.LIST_COMPANY_NAME) || method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME)) {
            DynaItemDataListAll itemDataListAll = new DynaItemDataListAll(ctx, formula, isTextGrade, isSumByTextNotGrade, method, gradeMapping, paramInfo, param);
            itemDataListAll.setSupportRpt(isSupportRpt);
            return itemDataListAll.calculate();
        }
        return new ArrayList();
    }

    private static DynaParamInfo initFastMegerDynaParamInfo(Context ctx, DynaParamInfo paramInfo) throws BOSException, EASBizException {
        DynaParamInfo curParamInfo = paramInfo;
        if (curParamInfo == null) {
            curParamInfo = new DynaParamInfo();
        } else {
            String fastMergeSoluId = curParamInfo.report.getFastMergeSoluId();
            if (!StringUtils.isEmpty((String)fastMergeSoluId)) {
                curParamInfo.fastMergeSoluId = fastMergeSoluId;
                SelectorItemCollection selector = new FastMergeExecSelector().getSelector();
                FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getLocalInstance(ctx).getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selector);
                if (soluInfo != null) {
                    FastMergeUtil.initSoluAdjustAndElimData(ctx, soluInfo);
                    curParamInfo.adjustTypeList = FastMergeUtil.getAdjustTypeList(soluInfo);
                    curParamInfo.elimTypeList = FastMergeUtil.getElimTypeList(soluInfo);
                    curParamInfo.isSupportGroupReport = soluInfo.isIsSupportGroupReport();
                    curParamInfo.isContainUnRecive = !soluInfo.isIsSupportGroupReport() && soluInfo.isIsContainUnRecive();
                }
            }
        }
        return curParamInfo;
    }

    private static List getDynaItemData(Context ctx, ItemFormula formula, DynaParameters param, Map gradeMapping, DynaParamInfo paramInfo) throws BOSException, EASBizException {
        return DynaRptCalcServerHelper.getDynaItemData(ctx, formula, param, gradeMapping, paramInfo, true);
    }

    public static String getOrgTreeCompanySql(String orgTreeColumn, String companyColumn, String soluIdColumn, Map<ReportCalcGroupKey, Set<String>> companyGroupMap) throws BOSException {
        StringBuffer whereSql = new StringBuffer();
        if (companyGroupMap != null && !companyGroupMap.isEmpty()) {
            int i = 0;
            for (ReportCalcGroupKey groupKey : companyGroupMap.keySet()) {
                if (i > 0) {
                    whereSql.append(" or ");
                }
                whereSql.append("(").append(DynaRptCalcServerHelper.getOrgTreeCompanySql(orgTreeColumn, companyColumn, soluIdColumn, groupKey, companyGroupMap.get(groupKey)));
                whereSql.append(")");
                ++i;
            }
        }
        return whereSql.toString();
    }

    public static String getOrgTreeCompanySql(String orgTreeColumn, String companyColumn, String soluIdColumn, ReportCalcGroupKey groupKey, Set<String> companyIds) throws BOSException {
        StringBuffer whereSql = new StringBuffer();
        whereSql.append(orgTreeColumn).append("='").append(groupKey.getOrgTree().getId().toString()).append("' and ");
        whereSql.append(companyColumn).append(" in (").append(CslRptUtil.changeIdSet2String(companyIds)).append(") ");
        if (!groupKey.isFromStatutory() && groupKey.getSourceSoluInfo() != null && groupKey.getSourceSoluInfo().getId() != null) {
            whereSql.append(" and ").append(soluIdColumn).append("='").append(groupKey.getSourceSoluInfo().getId().toString()).append("' ");
        }
        return whereSql.toString();
    }

    public static String getOrgTreeCompanySql(Context ctx, String orgTreeSql, String companySql, DynaParamInfo paramInfo, DynaParameters param) throws BOSException {
        if (!paramInfo.isSupportCrossMerger) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Map<OrgTreeInfo, Set<String>> companyMap = paramInfo.dynaCslRptParamInfo.getCompanyMap();
        if (companyMap == null || companyMap.isEmpty()) {
            throw new BOSException(" no company ");
        }
        Iterator<OrgTreeInfo> iter = companyMap.keySet().iterator();
        OrgTreeInfo orgTreeInfo = null;
        Set<String> companyIdSet = null;
        String orgTreeId = null;
        String companyIDs = null;
        boolean isfirst = true;
        str.append(" ( ");
        while (iter.hasNext()) {
            orgTreeInfo = iter.next();
            companyIdSet = companyMap.get(orgTreeInfo);
            companyIDs = CslRptUtil.changeIdSet2String(companyIdSet);
            orgTreeId = orgTreeInfo.getId().toString();
            if (param != null && param.isOnlyListCompany() && param.getSumMethod().equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME)) {
                companyIDs = CslRptUtil.expandCompanys(ctx, orgTreeId, companyIDs, true);
            }
            if (!isfirst) {
                str.append(" OR ");
            } else {
                isfirst = false;
            }
            str.append(" ( ");
            str.append(orgTreeSql).append("='").append(orgTreeId).append("' ");
            str.append(" AND ").append(companySql).append(" IN (").append(companyIDs).append(")");
            str.append(" ) ");
        }
        str.append(" ) ");
        return str.toString();
    }

    private static Map getTextGrade(Context ctx, Map formulas, DynaSumMethodEnum method, DynaParamInfo paramInfo) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer items = new StringBuffer();
        Iterator iter3 = formulas.keySet().iterator();
        if (formulas.size() < 1) {
            return result;
        }
        boolean bfirst = true;
        ItemFormula formula = null;
        while (iter3.hasNext()) {
            if (!bfirst) {
                items.append(',');
            }
            bfirst = false;
            Point point = (Point)iter3.next();
            formula = (ItemFormula)formulas.get(point);
            items.append('\'').append(formula.getItemNumber()).append('\'');
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(DynaRptCalcServerHelper.getTextGradeSelectSql(method)).append(DynaRptCalcServerHelper.getTextGradeFromSql()).append(" inner join t_csl_rptreceived r on d.FReportId = r.FReportId \n");
        if (paramInfo.isSupportCrossMerger) {
            sql.append(" WHERE ");
            sql.append(DynaRptCalcServerHelper.getOrgTreeCompanySql(ctx, "r.FOrgTreeID", "d.FOrgUnitID", paramInfo, null));
        } else {
            sql.append(" WHERE d.FOrgUnitID IN (" + paramInfo.companyIDs + ")  \n");
            sql.append(" AND r.FOrgTreeID = ? ");
            params.add(paramInfo.report.getOrgTree().getId().toString());
        }
        sql.append(DynaRptCalcServerHelper.getTextGradeWherSql(params, paramInfo, items));
        if (!paramInfo.isSupportGroupReport) {
            StringBuffer inStr = new StringBuffer();
            if (paramInfo.report.getSourceType().getValue() == 35) {
                Map<OrgTreeInfo, Set<String>> companyMap = paramInfo.dynaCslRptParamInfo.getCompanyMap();
                String rptOrgTreeId = String.valueOf(paramInfo.report.getOrgTree().getId());
                if (companyMap != null) {
                    Iterator<OrgTreeInfo> iter = companyMap.keySet().iterator();
                    String orgTreeId = null;
                    OrgTreeInfo orgTreeInfo = null;
                    HashSet companySet = null;
                    String CompanyId = null;
                    Iterator companyItr = null;
                    while (iter.hasNext()) {
                        orgTreeInfo = iter.next();
                        orgTreeId = String.valueOf(orgTreeInfo.getId());
                        if (!rptOrgTreeId.equals(orgTreeId)) continue;
                        companySet = (HashSet)companyMap.get(orgTreeInfo);
                        companyItr = companySet.iterator();
                        while (companyItr.hasNext()) {
                            CompanyId = String.valueOf(companyItr.next());
                            inStr.append("'").append(CompanyId).append("',");
                        }
                    }
                    if (inStr.length() > 0) {
                        inStr.deleteCharAt(inStr.lastIndexOf(","));
                    }
                }
            } else if (paramInfo.report.getSourceType().getValue() == 32) {
                inStr.append(paramInfo.companyIDs);
            }
            if (inStr.length() > 0) {
                sql.append(" union all ");
                sql.append(DynaRptCalcServerHelper.getTextGradeSelectSql(method)).append(DynaRptCalcServerHelper.getTextGradeFromSql());
                sql.append(" WHERE ");
                sql.append("  d.FOrgUnitID IN (").append(inStr.toString()).append(") \n");
                sql.append(DynaRptCalcServerHelper.getTextGradeWherSql(params, paramInfo, items));
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            String number = null;
            while (rs.next()) {
                number = rs.getString(1);
                if (!StringUtils.isEmpty((String)number)) {
                    number = number.trim();
                }
                result.put(number, rs.getString(2));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static String getTextGradeSelectSql(DynaSumMethodEnum method) {
        return " SELECT DISTINCT de.FGradeNumber || '**' || de.FKeyNumber , de.FGradeNumber \n";
    }

    private static String getTextGradeFromSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" FROM T_CSL_DynaItemDataEntry de                        \n");
        sql.append(" INNER JOIN T_CSL_DynaItemData d                        \n");
        sql.append("    ON de.FItemDataID = d.FID                           \n");
        return sql.toString();
    }

    private static String getTextGradeWherSql(List params, DynaParamInfo paramInfo, StringBuffer items) {
        StringBuffer sql = new StringBuffer();
        sql.append("    AND d.FCurrencyID = ?                               \n");
        sql.append(" \tAnd d.FPeriodType = ? \t\t\t\t\t\t\t\t\n");
        sql.append(" \tAnd de.FYear = ? \t\t\t\t\t\t\t\t\t\n");
        sql.append(" \tAnd de.FPeriod = ? \t\t\t\t\t\t\t\t\t\n");
        sql.append("    AND de.FItemID in (" + items.toString() + ")            \n");
        sql.append("    AND de.FGradeNumber IS NOT NULL                    \n");
        params.add(paramInfo.report.getCurrency().getId().toString());
        params.add(new Integer(paramInfo.report.getPeriodType().getValue()));
        params.add(new Integer(paramInfo.report.getYear()));
        params.add(new Integer(paramInfo.report.getPeriod()));
        return sql.toString();
    }

    private static void offsetYearAndPeriod(boolean isMergeByFiscalPeriod, boolean isSupport13Period, RptPeriodTypeEnum rptPeriodType, int reportYear, int reportPeriod, ItemFormula itemFormula, PeriodCollection periods) throws EASBizException, BOSException {
        RptCalcHelper.offsetYearAndPeriod(isMergeByFiscalPeriod, isSupport13Period, rptPeriodType, reportYear, reportPeriod, itemFormula, periods);
    }

    private static DynaItemTypeEnum getDynaItemType(Context ctx, String param, Map dynaItemTypes) throws BOSException, EASBizException {
        if (param == null) {
            return DynaItemTypeEnum.Other;
        }
        DynaItemTypeEnum type = null;
        if (dynaItemTypes.containsKey(param)) {
            type = (DynaItemTypeEnum)dynaItemTypes.get(param);
        } else {
            block8: {
                DynaParameters params = DynaParameters.getInstanceFromString((String)param);
                if (params.getDynaItemSource() == 0) {
                    type = DynaItemTypeEnum.ManualImport;
                } else {
                    String itemname = params.getAssistantType().properityName;
                    String sql = "select FAsstHGAttribute from t_bd_asstActType where FNumber = ?";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{itemname});
                    try {
                        if (rowSet.next()) {
                            String asstType = rowSet.getString("FAsstHGAttribute");
                            type = asstType.equals("companyOrg") ? DynaItemTypeEnum.Company : (asstType.equals("customer") ? DynaItemTypeEnum.Custom : (asstType.equals("provider") ? DynaItemTypeEnum.Provider : DynaItemTypeEnum.Other));
                            break block8;
                        }
                        throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"136_CSLReportCalculatorControllerBean", (Locale)ctx.getOriginLocale()) + "\r\n" + params.getAssistantType().properityAlias + "    " + itemname));
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                }
            }
            dynaItemTypes.put(param, type);
        }
        return type;
    }
}

