/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataYearInit;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.AbstractMnsRptCalcColumn;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcElimData;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcParam;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsCalcKey;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.samecontrol.CslOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.newrpt.samecontrol.mnsCalc.MnsDisposalColumnCollection;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MnsRptCalcCombineData
extends AbstractMnsRptCalcColumn {
    private MnsColumnCollection comColColl;
    private MnsColumnCollection elimColColl;
    private MnsColumnCollection sumColColl;
    private MnsColumnCollection clearColColl;
    private Map<String, MnsDisposalColumnCollection> disposalMnsColumnCollMap = null;
    private boolean isFeignCalc = false;
    private String parentCompanyID = null;
    private String sheetID = null;

    public MnsRptCalcCombineData(MnsRptCalcParam mnsRptCalcParam) {
        super(mnsRptCalcParam);
    }

    @Override
    protected void calcData() throws BOSException, EASBizException, CloneNotSupportedException {
        Map columnValue = null;
        MnsColumnInfo columnInfo = null;
        String itemNumber2 = null;
        HashSet fdc0Set = null;
        fdc0Set = this.mnsRptCalcParam.isSupportCrossMerger || this.mnsRptCalcParam.mnsRptParamInfo.isSupportHandElim() ? this.getFdc0Set(this.ctx, this.itemNumbers) : new HashSet(2);
        if (!StringUtils.isEmpty((String)this.mnsRptCalcParam.mnsRptParamInfo.getFastMergeSoluId()) && !this.mnsRptCalcParam.mnsRptParamInfo.isSupportGroupReport()) {
            if (this.elimColColl.size() == 0) {
                this.elimColColl.clear();
                for (int i = 0; i < this.comColColl.size(); ++i) {
                    columnInfo = this.comColColl.get(i);
                    if (columnInfo.calcKey.dataElementNumber.equals("YTBEGIN")) continue;
                    this.elimColColl.add(-1, 6, columnInfo.calcKey.dataElementNumber, columnInfo.calcKey.valueType);
                }
                MnsRptCalcElimData calcElimData = new MnsRptCalcElimData(this.mnsRptCalcParam);
                calcElimData.setMnsColumnCollection(this.elimColColl);
                calcElimData.initParams(this.itemNumbers, this.itemRows, this.sheetData, this.items);
                calcElimData.setFeignCalc(true);
                calcElimData.setSheetID(this.sheetID);
                calcElimData.calcData();
            }
            this.calcMnsColumnCombieByDataElementMapping(columnInfo, fdc0Set);
        } else if (this.mnsRptCalcParam.isSupportCrossMerger) {
            if (this.elimColColl.size() == 0) {
                this.elimColColl.clear();
                for (int i = 0; i < this.comColColl.size(); ++i) {
                    columnInfo = this.comColColl.get(i);
                    if (columnInfo.calcKey.dataElementNumber.equals("YTBEGIN")) continue;
                    this.elimColColl.add(-1, 6, columnInfo.calcKey.dataElementNumber, columnInfo.calcKey.valueType);
                }
                MnsRptCalcElimData calcElimData = new MnsRptCalcElimData(this.mnsRptCalcParam);
                calcElimData.setMnsColumnCollection(this.elimColColl);
                calcElimData.initParams(this.itemNumbers, this.itemRows, this.sheetData, this.items);
                calcElimData.setFeignCalc(true);
                calcElimData.setSheetID(this.sheetID);
                calcElimData.calcData();
            }
            boolean isElimCombine = false;
            if (this.elimColColl.size() > 0 && this.elimColColl.get((int)0).columnDataType == 6) {
                isElimCombine = true;
            }
            int precision = this.mnsRptCalcParam.report.getCurrency().getPrecision();
            for (String itemNumber2 : this.itemNumbers.keySet()) {
                this.calcMnsCombineItemData(itemNumber2, isElimCombine, fdc0Set, precision);
            }
            for (int i = 0; i < this.comColColl.size(); ++i) {
                columnInfo = this.comColColl.get(i);
                if (!columnInfo.calcKey.dataElementNumber.equals("YTBEGIN")) continue;
                columnValue = this.calcMnsCombineYtBegin(columnInfo.calcKey);
                this.putMnsCombineData(columnInfo, columnValue);
            }
        } else {
            this.calcMnsColumnCombieByDataElementMapping(columnInfo, fdc0Set);
        }
    }

    private void calcMnsColumnCombieByDataElementMapping(MnsColumnInfo columnInfo, Set fdc0Set) throws EASBizException, BOSException, CloneNotSupportedException {
        Map columnValue = null;
        ItemDataCondition condition = this.mnsRptCalcParam.condition;
        ItemDataCondition tmpcondition = null;
        Map elimValueMap = this.mnsRptCalcParam.mnsRptParamInfo.getElimValueMap();
        int dataElementRelating = this.mnsRptCalcParam.mnsRptParamInfo.getDataElementRelating();
        for (int i = 0; i < this.comColColl.size(); ++i) {
            columnInfo = this.comColColl.get(i);
            tmpcondition = (ItemDataCondition)condition.clone();
            tmpcondition.setValueType(columnInfo.calcKey.valueType);
            columnValue = this.calcMnsColumnCombine(this.ctx, tmpcondition, elimValueMap, dataElementRelating, columnInfo, fdc0Set);
            if (!this.mnsRptCalcParam.isAutoCalcSubCombineData && (columnValue == null || columnValue.isEmpty())) continue;
            if (this.isFeignCalc) {
                columnInfo.setValueMap(columnValue);
                continue;
            }
            this.putMnsCombineData(columnInfo, columnValue);
        }
    }

    private Map calcMnsColumnCombine(Context ctx, ItemDataCondition condition, Map elimValueMap, int dataElementRelating, MnsColumnInfo columnInfo, Set fdc0Set) throws EASBizException, BOSException {
        String dataElementNumber = columnInfo.calcKey.dataElementNumber;
        Map columnValue = null;
        columnValue = dataElementNumber.equals("AMOUNT") && dataElementRelating == 1 ? this.calcMnsCombineAmount(ctx, condition, elimValueMap, columnInfo) : (dataElementNumber.equals("YTDAMOUNT") && dataElementRelating == 2 ? this.calcMnsCombineYtdAmount(ctx, condition, elimValueMap, columnInfo) : (dataElementNumber.equals("YTBEGIN") ? this.calcMnsCombineYtBegin(columnInfo.calcKey) : this.calcMnsCombineCommon(ctx, condition, dataElementNumber, columnInfo, fdc0Set)));
        return columnValue;
    }

    private Map calcMnsCombineAmount(Context ctx, ItemDataCondition condition, Map elimValueMap, MnsColumnInfo columnInfo) throws EASBizException, BOSException {
        boolean isFromFastMerge = !StringUtils.isEmpty((String)this.mnsRptCalcParam.mnsRptParamInfo.getFastMergeSoluId());
        boolean isContainUnRecive = FastMergeUtil.getIsContainUnRecive(ctx, condition.getFastMergeSoluId());
        CslReportInfo report = this.mnsRptCalcParam.report;
        int precision = report.getCurrency().getPrecision();
        condition.setItemList(this.items);
        condition.setDataElement(this.getDataElementInnerValue("YTDAMOUNT"));
        condition.setOrgUnit(this.mnsRptCalcParam.companys);
        Map sumValues = new HashMap();
        if (isFromFastMerge && !condition.isSupportGroupReport()) {
            int sumColCollSize = this.sumColColl.size();
            for (int i = 0; i < sumColCollSize; ++i) {
                MnsColumnInfo info = this.sumColColl.get(i);
                if (!info.calcKey.dataElementNumber.equals("YTDAMOUNT")) continue;
                sumValues = info.valueMap;
                break;
            }
        } else {
            ArrayList orgUnitIds = new ArrayList(condition.getOrgUnit());
            orgUnitIds.removeAll(this.mnsRptCalcParam.disposalCompnays.keySet());
            condition.setOrgUnit(orgUnitIds);
            sumValues = this.getItemDataProvider().getAcctItems(condition);
            if (this.disposalMnsColumnCollMap != null) {
                SameControlUtil.getDisposalColumnCollection(this.disposalMnsColumnCollMap, (int)report.getYear(), (int)report.getPeriod()).addrelaColumns(this.mnsRptCalcParam.disposalCompnays, "YTDAMOUNT", columnInfo.calcKey.dataElementNumber, columnInfo.calcKey.valueType);
            }
        }
        condition.setDebitOrCredit(2);
        condition.setOrgUnit(CslRptUtil.arrOrgUnit(this.parentCompanyID));
        condition.setItemList(this.itemNumbers);
        Map elimValues = null;
        if (isFromFastMerge && !condition.isSupportGroupReport()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("isSupportCrossMerger", this.mnsRptCalcParam.isSupportCrossMerger);
            paramMap.put("isQueryBudget", Boolean.FALSE);
            paramMap.put("isSupportHandElim", Boolean.FALSE);
            paramMap.put("tempElimIDTable", this.mnsRptCalcParam.getElimIDTable());
            paramMap.put("relateValueMap", columnInfo.valueMap);
            paramMap.put("condition", condition);
            elimValues = MnsRptCalcHelper._getElimDataByItems(ctx, paramMap);
        } else {
            elimValues = MnsRptCalcHelper._getElimByItems(ctx, condition, false);
        }
        String itemNumber2 = null;
        if (elimValueMap != null && this.sheetID != null) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            HashMap customElimValueMap = new HashMap();
            paramMap.put("isQueryBudget", Boolean.FALSE);
            paramMap.put("condition", condition);
            Set colSet = (Set)elimValueMap.get(this.sheetID + "-colSet");
            Map elimValueM = (Map)elimValueMap.get(this.sheetID + "-elimValueMap");
            for (String itemNumber2 : this.itemNumbers.keySet()) {
                Iterator col = colSet.iterator();
                while (col.hasNext()) {
                    Object debit;
                    Integer row = (Integer)this.itemRows.get(itemNumber2);
                    if (row == null) continue;
                    int coll = (Integer)col.next();
                    Object crebit = elimValueM.get(row + "-" + coll + "-" + 5 + "-" + "YTDAMOUNT");
                    if (crebit != null) {
                        customElimValueMap.put(itemNumber2 + "-" + 5, crebit);
                    }
                    if ((debit = elimValueM.get(row + "-" + coll + "-" + 4 + "-" + "YTDAMOUNT")) == null) continue;
                    customElimValueMap.put(itemNumber2 + "-" + 4, debit);
                }
            }
            paramMap.put("customElimValueMap", customElimValueMap);
            paramMap.put("oldelimValues", elimValues);
            paramMap.put("isSupportHandElim", Boolean.TRUE);
            elimValues = MnsRptCalcHelper._getElimDataByItems(ctx, paramMap);
        }
        Map lastCombinValues = new HashMap();
        HashMap<String, BigDecimal> columnValue = new HashMap<String, BigDecimal>();
        if (this.curFormula.getPeriod() > 1) {
            String lastPeriodTreeId = null;
            String lastPeriodUnitId = null;
            Map treeMap = FiscalPeriodHelper.getOrgTreeByPeriods(ctx, this.mnsRptCalcParam.periods, report.getOrgTree().getNumber(), this.curFormula.getYear(), this.curFormula.getYear(), this.curFormula.getPeriod() - 1, this.curFormula.getPeriod() - 1, condition.getRptPeriodType(), this.mnsRptCalcParam.isMergeByFiscalPeriod, this.mnsRptCalcParam.isSupport13Period);
            if (treeMap != null && treeMap.keySet() != null) {
                RptPeriodTypeEnum curPeriodType = RptPeriodTypeEnum.getEnum((int)condition.getRptPeriodType());
                lastPeriodTreeId = this.getOrgTreeIdForQuarterly(treeMap, curPeriodType);
                if (lastPeriodTreeId == null) {
                    Iterator ite = treeMap.keySet().iterator();
                    while (ite.hasNext()) {
                        lastPeriodTreeId = ite.next().toString();
                    }
                }
                if (lastPeriodTreeId != null) {
                    lastPeriodUnitId = this.getUnitIdByTreeIdAndUnitNumber(ctx, lastPeriodTreeId, report.getOrgUnit().getNumber());
                }
                if (lastPeriodUnitId != null) {
                    condition.setItemList(this.items);
                    condition.setDataElement(this.getDataElementInnerValue("YTDAMOUNT"));
                    condition.setRptYearStart(this.curFormula.getYear());
                    condition.setRptPeriodStart(this.curFormula.getPeriod() - 1);
                    condition.setRptYearEnd(this.curFormula.getYear());
                    condition.setRptPeriodEnd(this.curFormula.getPeriod() - 1);
                    condition.setOrgTreeId(lastPeriodTreeId);
                    condition.setOrgUnit(CslRptUtil.arrOrgUnit(lastPeriodUnitId));
                    if (isFromFastMerge && !condition.isSupportGroupReport()) {
                        if (isContainUnRecive) {
                            condition.setCommitStatus(-1);
                            condition.setDataSource(34);
                            condition.setDataSourceString(new int[]{34});
                        } else {
                            condition.setCommitStatus(3);
                            condition.setDataSource(34);
                            condition.setDataSourceString(new int[]{34});
                        }
                    }
                    lastCombinValues = this.getItemDataProvider().getAcctItems(condition);
                }
            }
        }
        BigDecimal sumValue = null;
        BigDecimal elimValue = null;
        BigDecimal lastCombinValue = null;
        BigDecimal result1 = CslConstant.BGZERO;
        BigDecimal result2 = CslConstant.BGZERO;
        boolean isFound = false;
        ArrayList<MnsColumnInfo> mnsColumnInfos = new ArrayList<MnsColumnInfo>();
        int size = this.clearColColl.size();
        for (int i = 0; i < size; ++i) {
            MnsColumnInfo mnsColumnInfo = this.clearColColl.get(i);
            if (!mnsColumnInfo.calcKey.dataElementNumber.equals("YTDAMOUNT")) continue;
            mnsColumnInfos.add(mnsColumnInfo);
            isFound = true;
        }
        for (String itemNumber2 : this.itemNumbers.keySet()) {
            sumValue = (BigDecimal)sumValues.get(itemNumber2);
            elimValue = (BigDecimal)elimValues.get(itemNumber2);
            result1 = this.getCombineValue(sumValue, elimValue, precision);
            BigDecimal clearSingleVal = new BigDecimal("0.0");
            if (isFound) {
                int size2 = mnsColumnInfos.size();
                for (int i = 0; i < size2; ++i) {
                    MnsColumnInfo mnsColumnInfo = (MnsColumnInfo)mnsColumnInfos.get(i);
                    if (mnsColumnInfo.valueMap == null || !mnsColumnInfo.valueMap.containsKey(itemNumber2)) continue;
                    BigDecimal single = mnsColumnInfo.valueMap.get(itemNumber2) == null ? new BigDecimal("0.0") : (BigDecimal)mnsColumnInfo.valueMap.get(itemNumber2);
                    clearSingleVal = clearSingleVal.add(single);
                }
            }
            result1 = result1.add(clearSingleVal);
            if (this.curFormula.getPeriod() > 1) {
                lastCombinValue = (BigDecimal)lastCombinValues.get(itemNumber2);
                if (lastCombinValue != null) {
                    lastCombinValue = this.mnsRptCalcParam.mnsRptParamInfo.isRoundingByPrecision() ? lastCombinValue.setScale(precision, 4) : lastCombinValue;
                }
                result2 = lastCombinValue != null ? lastCombinValue : CslConstant.BGZERO;
            }
            columnValue.put(itemNumber2, result1.subtract(result2));
        }
        return columnValue;
    }

    private String getOrgTreeIdForQuarterly(Map treeMap, RptPeriodTypeEnum curPeriodType) {
        String treeId = null;
        if (curPeriodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
            int tempPeriod = -1;
            Iterator ite = treeMap.keySet().iterator();
            while (ite.hasNext()) {
                String orgTreeId = String.valueOf(ite.next());
                Map values = (Map)treeMap.get(orgTreeId);
                int period = Integer.valueOf(String.valueOf(values.get("KEY_ENDPERIOD")));
                if (tempPeriod >= period) continue;
                treeId = orgTreeId;
                tempPeriod = period;
            }
        }
        return treeId;
    }

    private Map calcMnsCombineYtdAmount(Context ctx, ItemDataCondition condition, Map elimValueMap, MnsColumnInfo columnInfo) throws EASBizException, BOSException {
        boolean isFromFastMerge = !StringUtils.isEmpty((String)this.mnsRptCalcParam.mnsRptParamInfo.getFastMergeSoluId());
        boolean isContainUnRecive = FastMergeUtil.getIsContainUnRecive(ctx, condition.getFastMergeSoluId());
        CslReportInfo report = this.mnsRptCalcParam.report;
        int precision = report.getCurrency().getPrecision();
        ArrayList arrParentCompanyID = CslRptUtil.arrOrgUnit(this.parentCompanyID);
        condition.setItemList(this.items);
        condition.setDataElement(DataElementProvider.getDataElementInnerValue(ctx, "AMOUNT"));
        condition.setOrgUnit(this.mnsRptCalcParam.companys);
        Map sumValues = new HashMap();
        if (isFromFastMerge && !condition.isSupportGroupReport()) {
            int sumColCollSize = this.sumColColl.size();
            for (int i = 0; i < sumColCollSize; ++i) {
                MnsColumnInfo info = this.sumColColl.get(i);
                if (!info.calcKey.dataElementNumber.equals("AMOUNT")) continue;
                sumValues = info.valueMap;
                break;
            }
        } else {
            ArrayList orgUnitIds = new ArrayList(condition.getOrgUnit());
            orgUnitIds.removeAll(this.mnsRptCalcParam.disposalCompnays.keySet());
            condition.setOrgUnit(orgUnitIds);
            sumValues = this.getItemDataProvider().getAcctItems(condition);
            if (this.disposalMnsColumnCollMap != null) {
                SameControlUtil.getDisposalColumnCollection(this.disposalMnsColumnCollMap, (int)report.getYear(), (int)report.getPeriod()).addrelaColumns(this.mnsRptCalcParam.disposalCompnays, "AMOUNT", columnInfo.calcKey.dataElementNumber, columnInfo.calcKey.valueType);
            }
        }
        condition.setDebitOrCredit(2);
        condition.setOrgUnit(arrParentCompanyID);
        condition.setItemList(this.itemNumbers);
        Map elimValues = null;
        if (isFromFastMerge && !condition.isSupportGroupReport()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("isSupportCrossMerger", this.mnsRptCalcParam.isSupportCrossMerger);
            paramMap.put("isQueryBudget", Boolean.FALSE);
            paramMap.put("isSupportHandElim", Boolean.FALSE);
            paramMap.put("tempElimIDTable", this.mnsRptCalcParam.getElimIDTable());
            paramMap.put("relateValueMap", columnInfo.valueMap);
            paramMap.put("condition", condition);
            elimValues = MnsRptCalcHelper._getElimDataByItems(ctx, paramMap);
        } else {
            elimValues = MnsRptCalcHelper._getElimByItems(ctx, condition, false);
        }
        String itemNumber2 = null;
        if (elimValueMap != null && this.sheetID != null) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            HashMap customElimValueMap = new HashMap();
            paramMap.put("isQueryBudget", Boolean.FALSE);
            paramMap.put("condition", condition);
            Set colSet = (Set)elimValueMap.get(this.sheetID + "-colSet");
            Map elimValueM = (Map)elimValueMap.get(this.sheetID + "-elimValueMap");
            for (String itemNumber2 : this.itemNumbers.keySet()) {
                Iterator col = colSet.iterator();
                while (col.hasNext()) {
                    Object debit;
                    Integer row = (Integer)this.itemRows.get(itemNumber2);
                    if (row == null) continue;
                    int coll = (Integer)col.next();
                    Object crebit = elimValueM.get(row + "-" + coll + "-" + 5 + "-" + "AMOUNT");
                    if (crebit != null) {
                        customElimValueMap.put(itemNumber2 + "-" + 5, crebit);
                    }
                    if ((debit = elimValueM.get(row + "-" + coll + "-" + 4 + "-" + "AMOUNT")) == null) continue;
                    customElimValueMap.put(itemNumber2 + "-" + 4, debit);
                }
            }
            paramMap.put("customElimValueMap", customElimValueMap);
            paramMap.put("oldelimValues", elimValues);
            paramMap.put("isSupportHandElim", Boolean.TRUE);
            elimValues = MnsRptCalcHelper._getElimDataByItems(ctx, paramMap);
        }
        HashMap<String, BigDecimal> combineValues = new HashMap<String, BigDecimal>();
        if (this.curFormula.getPeriod() > 1) {
            String lastPeriodTreeId = null;
            String lastPeriodUnitId = null;
            Map oneValue = null;
            for (int i = 1; i < this.curFormula.getPeriod(); ++i) {
                Map treeMap = FiscalPeriodHelper.getOrgTreeByPeriods(ctx, this.mnsRptCalcParam.periods, report.getOrgTree().getNumber(), this.curFormula.getYear(), this.curFormula.getYear(), i, i, condition.getRptPeriodType(), this.mnsRptCalcParam.isMergeByFiscalPeriod, this.mnsRptCalcParam.isSupport13Period);
                if (treeMap == null || treeMap.keySet() == null) continue;
                RptPeriodTypeEnum curPeriodType = RptPeriodTypeEnum.getEnum((int)condition.getRptPeriodType());
                lastPeriodTreeId = this.getOrgTreeIdForQuarterly(treeMap, curPeriodType);
                if (lastPeriodTreeId == null) {
                    Iterator ite = treeMap.keySet().iterator();
                    while (ite.hasNext()) {
                        lastPeriodTreeId = ite.next().toString();
                    }
                }
                if (lastPeriodTreeId == null || (lastPeriodUnitId = this.getUnitIdByTreeIdAndUnitNumber(ctx, lastPeriodTreeId, report.getOrgUnit().getNumber())) == null) continue;
                ArrayList lastPeriodUnit = CslRptUtil.arrOrgUnit(lastPeriodUnitId);
                condition.setItemList(this.items);
                condition.setDataElement(DataElementProvider.getDataElementInnerValue(ctx, "AMOUNT"));
                condition.setRptYearStart(this.curFormula.getYear());
                condition.setRptPeriodStart(i);
                condition.setRptYearEnd(this.curFormula.getYear());
                condition.setRptPeriodEnd(i);
                condition.setOrgTreeId(lastPeriodTreeId);
                condition.setOrgUnit(lastPeriodUnit);
                if (isFromFastMerge && !condition.isSupportGroupReport()) {
                    if (isContainUnRecive) {
                        condition.setCommitStatus(-1);
                        condition.setDataSource(-1);
                        condition.setDataSourceString(new int[]{34});
                    } else {
                        condition.setCommitStatus(3);
                        condition.setDataSource(-1);
                        condition.setDataSourceString(new int[]{34});
                    }
                }
                oneValue = this.getItemDataProvider().getAcctItems(condition);
                for (String itemNumber2 : this.itemNumbers.keySet()) {
                    BigDecimal bigTemp;
                    BigDecimal bigDecimal = bigTemp = oneValue.get(itemNumber2) == null ? CslConstant.BGZERO : (BigDecimal)oneValue.get(itemNumber2);
                    if (combineValues.containsKey(itemNumber2)) {
                        BigDecimal b = combineValues.get(itemNumber2) == null ? CslConstant.BGZERO : (BigDecimal)combineValues.get(itemNumber2);
                        combineValues.put(itemNumber2, b.add(bigTemp));
                        continue;
                    }
                    combineValues.put(itemNumber2, bigTemp);
                }
            }
        }
        BigDecimal sumValue = null;
        BigDecimal elimValue = null;
        BigDecimal result1 = null;
        BigDecimal result2 = null;
        HashMap<String, BigDecimal> columnValue = new HashMap<String, BigDecimal>();
        boolean isFound = false;
        ArrayList<MnsColumnInfo> mnsColumnInfos = new ArrayList<MnsColumnInfo>();
        int size = this.clearColColl.size();
        for (int i = 0; i < size; ++i) {
            MnsColumnInfo mnsColumnInfo = this.clearColColl.get(i);
            if (!mnsColumnInfo.calcKey.dataElementNumber.equals("AMOUNT")) continue;
            mnsColumnInfos.add(mnsColumnInfo);
            isFound = true;
        }
        for (String itemNumber2 : this.itemNumbers.keySet()) {
            BigDecimal clearSingleVal = new BigDecimal("0.0");
            if (isFound) {
                int size2 = mnsColumnInfos.size();
                for (int i = 0; i < size2; ++i) {
                    MnsColumnInfo mnsColumnInfo = (MnsColumnInfo)mnsColumnInfos.get(i);
                    if (mnsColumnInfo.valueMap == null || !mnsColumnInfo.valueMap.containsKey(itemNumber2)) continue;
                    BigDecimal single = mnsColumnInfo.valueMap.get(itemNumber2) == null ? new BigDecimal("0.0") : (BigDecimal)mnsColumnInfo.valueMap.get(itemNumber2);
                    clearSingleVal = clearSingleVal.add(single);
                }
            }
            sumValue = (BigDecimal)sumValues.get(itemNumber2);
            elimValue = (BigDecimal)elimValues.get(itemNumber2);
            result1 = this.getCombineValue(sumValue, elimValue, precision);
            result2 = (BigDecimal)combineValues.get(itemNumber2);
            if (result2 == null) {
                result2 = CslConstant.BGZERO;
            }
            result2 = result2.add(clearSingleVal);
            columnValue.put(itemNumber2, result1.add(result2));
        }
        combineValues.clear();
        return columnValue;
    }

    private Map calcMnsCombineYtBegin(MnsCalcKey calcKey) throws EASBizException, BOSException {
        CslReportInfo report = this.mnsRptCalcParam.report;
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("OrgTreeID", report.getOrgTree().getId().toString());
        mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
        mapParams.put("KEY_CURRENCY_ID", report.getCurrency().getId().toString());
        mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
        mapParams.put("Year", new Integer(this.curFormula.getYear()));
        mapParams.put("DataElement", new Integer(5));
        mapParams.put("KEY_CONVERTSTATUS", new Integer(0));
        mapParams.put("MERGETYPE", this.mnsRptCalcParam.isSupportGroupReport() ? 0 : 1);
        String dataCollectNumber = report.getDataCollectNumber();
        if (null != dataCollectNumber) {
            mapParams.put("KEY_DATACOLLECT_NUMBER", dataCollectNumber);
        }
        HashMap<String, BigDecimal> columnValue = new HashMap<String, BigDecimal>();
        int v = calcKey.valueType;
        Integer valueType = v == 0 ? new Integer(1) : new Integer(v);
        String curNumber2 = null;
        IItemDataYearInit itemDataYearInit = ItemDataYearInitFactory.getLocalInstance(this.ctx);
        for (String curNumber2 : this.itemNumbers.keySet()) {
            mapParams.put("ValueType", valueType);
            mapParams.put("KEY_ITEM_NUMBER", curNumber2);
            BigDecimal result = itemDataYearInit.getYearInitValue(mapParams);
            if (result == null) {
                result = CslConstant.BGZERO;
            }
            columnValue.put(curNumber2, result);
        }
        return columnValue;
    }

    private Map calcMnsCombineCommon(Context ctx, ItemDataCondition condition, String dataElementNumber, MnsColumnInfo columnInfo, Set fdc0Set) throws EASBizException, BOSException {
        MnsColumnInfo info;
        condition.setItemList(this.items);
        condition.setDataElement(this.getDataElementInnerValue(dataElementNumber));
        CslReportInfo report = this.mnsRptCalcParam.report;
        int reportYear = report.getYear();
        short reportPeriod = report.getPeriod();
        RptPeriodTypeEnum rptPeriodType = report.getPeriodType();
        int periodType = rptPeriodType.getValue();
        boolean isBeginbalance = dataElementNumber.equals("BEGINBALANCE");
        if (isBeginbalance) {
            int offsetYear = this.curFormula.getYearOffSet();
            int offsetPeriod = this.curFormula.getPeriodOffSet();
            boolean iscalcByCurPeriodBegin = this.mnsRptCalcParam.isSupportCrossMerger || this.mnsRptCalcParam.getMnsRptCalcParam().isCalcCslBeginByCurPeriodBegin();
            int[] yearAndPeriod = null;
            if (this.mnsRptCalcParam.isSupport13Period) {
                if (iscalcByCurPeriodBegin) {
                    yearAndPeriod = RPTDate13Util.getRptYearAndPeriod(reportYear, (int)reportPeriod, periodType, offsetYear, offsetPeriod, this.mnsRptCalcParam.isSupport13Period);
                } else {
                    if (periodType == 6) {
                        --offsetYear;
                    } else {
                        --offsetPeriod;
                    }
                    yearAndPeriod = RPTDate13Util.getRptYearAndPeriod(reportYear, (int)reportPeriod, periodType, offsetYear, offsetPeriod, this.mnsRptCalcParam.isSupport13Period);
                }
            } else if (iscalcByCurPeriodBegin) {
                yearAndPeriod = FiscalPeriodHelper.getRptYearAndPeriod(this.mnsRptCalcParam.periods, reportYear, reportPeriod, periodType, offsetYear, offsetPeriod, this.mnsRptCalcParam.isMergeByFiscalPeriod);
            } else {
                if (periodType == 6) {
                    --offsetYear;
                } else {
                    --offsetPeriod;
                }
                yearAndPeriod = FiscalPeriodHelper.getRptYearAndPeriod(this.mnsRptCalcParam.periods, reportYear, reportPeriod, periodType, offsetYear, offsetPeriod, this.mnsRptCalcParam.isMergeByFiscalPeriod);
            }
            condition.setRptYearStart(yearAndPeriod[0]);
            condition.setRptPeriodStart(yearAndPeriod[1]);
            condition.setRptYearEnd(yearAndPeriod[0]);
            condition.setRptPeriodEnd(yearAndPeriod[1]);
            if (iscalcByCurPeriodBegin) {
                condition.setDataElement(1);
            } else {
                condition.setDataElement(4);
            }
            condition.setOrgTreeId2(null);
            if (iscalcByCurPeriodBegin) {
                HashMap orgUnitMap = this.mnsRptCalcParam.orgUnits_IdNumber;
                if (orgUnitMap != null && orgUnitMap.size() > 0) {
                    ArrayList<Object> orgUnitNumber = new ArrayList<Object>(Arrays.asList(orgUnitMap.keySet().toArray()));
                    Iterator<Object> iter = this.mnsRptCalcParam.disposalCompnays.values().iterator();
                    while (iter.hasNext()) {
                        orgUnitNumber.remove(iter.next().getNumber());
                    }
                    condition.setOrgUnitNumber(orgUnitNumber);
                }
            } else {
                List disposalCompanys;
                condition.setOrgUnitNumber(this.mnsRptCalcParam.getPrePeriodCompanyNumbers(condition.getRptYearEnd(), condition.getRptPeriodEnd(), RptPeriodTypeEnum.getEnum((int)periodType)));
                if (this.mnsRptCalcParam.mnsRptParamInfo.isSupportGroupReport() && !this.mnsRptCalcParam.isSupportCrossMerger() && (disposalCompanys = SameControlUtil.getPreDisposalCompanys((Context)ctx, (List)condition.getOrgUnitNumber(), (MnsRptCalcParam)this.mnsRptCalcParam, (int)condition.getRptYearEnd(), (int)condition.getRptPeriodEnd())) != null && !disposalCompanys.isEmpty()) {
                    HashMap<String, FullOrgUnitInfo> disposalCompnayMap = new HashMap<String, FullOrgUnitInfo>();
                    for (CslOrgUnitInfo info2 : disposalCompanys) {
                        disposalCompnayMap.put(info2.getCompany().getId().toString(), info2.getCompany());
                    }
                    SameControlUtil.getDisposalColumnCollection(this.disposalMnsColumnCollMap, (int)condition.getRptYearEnd(), (int)condition.getRptPeriodEnd()).addrelaColumns(disposalCompnayMap, "ENDBALANCE", columnInfo.calcKey.dataElementNumber, columnInfo.calcKey.valueType);
                }
            }
            if (!StringUtils.isEmpty((String)this.parentCompanyID)) {
                info = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.parentCompanyID));
                String number = info.getNumber();
                condition.setParentOrgNumber(number);
            }
        }
        if (!this.mnsRptCalcParam.disposalCompnays.isEmpty() && this.mnsRptCalcParam.companys != null) {
            ArrayList calCompanys = (ArrayList)this.mnsRptCalcParam.companys.clone();
            calCompanys.removeAll(this.mnsRptCalcParam.disposalCompnays.keySet());
            condition.setOrgUnit(calCompanys);
        } else {
            condition.setOrgUnit(this.mnsRptCalcParam.companys);
        }
        boolean isFromFastMerge = !StringUtils.isEmpty((String)this.mnsRptCalcParam.mnsRptParamInfo.getFastMergeSoluId());
        boolean isContainUnRecive = FastMergeUtil.getIsContainUnRecive(ctx, condition.getFastMergeSoluId());
        Map sumValues = new HashMap();
        if (isFromFastMerge && !condition.isSupportGroupReport()) {
            for (int i = 0; i < this.sumColColl.size(); ++i) {
                info = this.sumColColl.get(i);
                if (!info.calcKey.dataElementNumber.equals(columnInfo.calcKey.dataElementNumber)) continue;
                sumValues = info.valueMap;
                break;
            }
        } else if (condition.getOrgUnit() != null && !condition.getOrgUnit().isEmpty() || condition.getOrgUnitNumber() != null && !condition.getOrgUnitNumber().isEmpty()) {
            sumValues = this.getItemDataProvider().getAcctItems(condition);
        }
        int precision = report.getCurrency().getPrecision();
        String itemNumber2 = null;
        BigDecimal sumValue = null;
        BigDecimal result = null;
        HashMap<String, BigDecimal> columnValue = new HashMap<String, BigDecimal>();
        dataElementNumber.equals("BEGINBALANCE");
        if (this.mnsRptCalcParam.mnsRptParamInfo.isSupportHandElim() && (!isBeginbalance || isBeginbalance && this.mnsRptCalcParam.getMnsRptCalcParam().isCalcCslBeginByCurPeriodBegin()) && this.elimColColl != null && this.elimColColl.size() > 0) {
            boolean isElimCombine = false;
            if (this.elimColColl.get((int)0).columnDataType == 6) {
                isElimCombine = true;
            }
            boolean isFound = false;
            ArrayList<MnsColumnInfo> mnsColumnInfos = new ArrayList<MnsColumnInfo>();
            int size = this.clearColColl.size();
            for (int i = 0; i < size; ++i) {
                MnsColumnInfo mnsColumnInfo = this.clearColColl.get(i);
                if (!mnsColumnInfo.calcKey.equals(columnInfo.calcKey)) continue;
                mnsColumnInfos.add(mnsColumnInfo);
                isFound = true;
            }
            BigDecimal sumElim = null;
            for (String itemNumber2 : this.itemNumbers.keySet()) {
                sumValue = (BigDecimal)sumValues.get(itemNumber2);
                sumElim = this.getSumElim(itemNumber2, isElimCombine, columnInfo, fdc0Set);
                BigDecimal combData = this.getCombineData(itemNumber2, fdc0Set, sumValue, sumElim, precision);
                BigDecimal clearSingleVal = new BigDecimal("0.0");
                if (isFound) {
                    int size2 = mnsColumnInfos.size();
                    for (int i = 0; i < size2; ++i) {
                        MnsColumnInfo mnsColumnInfo = (MnsColumnInfo)mnsColumnInfos.get(i);
                        if (mnsColumnInfo.valueMap == null || !mnsColumnInfo.valueMap.containsKey(itemNumber2)) continue;
                        BigDecimal single = mnsColumnInfo.valueMap.get(itemNumber2) == null ? new BigDecimal("0.0") : (BigDecimal)mnsColumnInfo.valueMap.get(itemNumber2);
                        clearSingleVal = clearSingleVal.add(single);
                    }
                }
                result = combData.add(clearSingleVal);
                columnValue.put(itemNumber2, result);
            }
            return columnValue;
        }
        BigDecimal elimValue = null;
        condition.setDebitOrCredit(2);
        ArrayList arrParentCompanyID = CslRptUtil.arrOrgUnit(this.parentCompanyID);
        condition.setOrgUnit(arrParentCompanyID);
        condition.setItemList(this.itemNumbers);
        Map elimValues = null;
        if (!StringUtils.isEmpty((String)this.mnsRptCalcParam.mnsRptParamInfo.getFastMergeSoluId()) && !this.mnsRptCalcParam.mnsRptParamInfo.isSupportGroupReport() && this.elimColColl != null && this.elimColColl.size() > 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("isSupportCrossMerger", this.mnsRptCalcParam.isSupportCrossMerger);
            paramMap.put("isQueryBudget", Boolean.FALSE);
            paramMap.put("isSupportHandElim", Boolean.FALSE);
            paramMap.put("tempElimIDTable", this.mnsRptCalcParam.getElimIDTable());
            paramMap.put("relateValueMap", columnInfo.valueMap);
            paramMap.put("condition", condition);
            elimValues = MnsRptCalcHelper._getElimDataByItems(ctx, paramMap);
        } else if (this.elimColColl != null && this.elimColColl.size() > 0) {
            elimValues = MnsRptCalcHelper._getElimByItems(ctx, condition, false);
        }
        boolean isFound = false;
        ArrayList<MnsColumnInfo> mnsColumnInfos = new ArrayList<MnsColumnInfo>();
        int size = this.clearColColl.size();
        for (int i = 0; i < size; ++i) {
            MnsColumnInfo mnsColumnInfo = this.clearColColl.get(i);
            if (!mnsColumnInfo.calcKey.equals(columnInfo.calcKey)) continue;
            mnsColumnInfos.add(mnsColumnInfo);
            isFound = true;
        }
        for (String itemNumber2 : this.itemNumbers.keySet()) {
            BigDecimal clearSingleVal = new BigDecimal("0.0");
            if (isFound) {
                int size3 = mnsColumnInfos.size();
                for (int i = 0; i < size3; ++i) {
                    MnsColumnInfo mnsColumnInfo = (MnsColumnInfo)mnsColumnInfos.get(i);
                    if (mnsColumnInfo.valueMap == null || !mnsColumnInfo.valueMap.containsKey(itemNumber2)) continue;
                    BigDecimal single = mnsColumnInfo.valueMap.get(itemNumber2) == null ? new BigDecimal("0.0") : (BigDecimal)mnsColumnInfo.valueMap.get(itemNumber2);
                    clearSingleVal = clearSingleVal.add(single);
                }
            }
            sumValue = (BigDecimal)sumValues.get(itemNumber2);
            if (elimValues != null) {
                elimValue = (BigDecimal)elimValues.get(itemNumber2);
            }
            result = this.getCombineValue(sumValue, elimValue, precision);
            result = result.add(clearSingleVal);
            columnValue.put(itemNumber2, result);
        }
        return columnValue;
    }

    private void calcMnsCombineItemData(String itemNumber, boolean isElimCombine, Set fdc0Set, int precision) {
        MnsColumnInfo columnInfo = null;
        BigDecimal sumValue = null;
        BigDecimal sumElim = null;
        BigDecimal result = null;
        Integer rowIndex = null;
        for (int i = 0; i < this.comColColl.size(); ++i) {
            columnInfo = this.comColColl.get(i);
            if (columnInfo == null || columnInfo.calcKey.dataElementNumber.equals("YTBEGIN")) continue;
            sumValue = this.getValue(this.sumColColl, columnInfo.calcKey, itemNumber, 0);
            sumElim = this.getSumElim(itemNumber, isElimCombine, columnInfo, fdc0Set);
            result = this.getCombineData(itemNumber, fdc0Set, sumValue, sumElim, precision);
            rowIndex = (Integer)this.itemRows.get(itemNumber);
            this.putMnsData(result, columnInfo.col, rowIndex);
        }
    }

    private BigDecimal getSumElim(String itemNumber, boolean isElimCombine, MnsColumnInfo columnInfo, Set fdc0Set) {
        BigDecimal sumElim = null;
        if (isElimCombine) {
            sumElim = this.getValue(this.elimColColl, columnInfo.calcKey, itemNumber, 3);
        } else {
            BigDecimal elimDebit = this.getValue(this.elimColColl, columnInfo.calcKey, itemNumber, 1);
            BigDecimal elimCredit = this.getValue(this.elimColColl, columnInfo.calcKey, itemNumber, 2);
            sumElim = fdc0Set.contains(itemNumber) ? elimDebit.subtract(elimCredit) : elimCredit.subtract(elimDebit);
        }
        return sumElim;
    }

    private BigDecimal getCombineData(String itemNumber, Set fdc0Set, BigDecimal sumValue, BigDecimal sumElim, int precision) {
        BigDecimal result = (sumValue = sumValue == null ? CslConstant.BGZERO : sumValue).subtract(sumElim = sumElim == null ? CslConstant.BGZERO : sumElim);
        return result == null ? null : (this.mnsRptCalcParam.mnsRptParamInfo.isRoundingByPrecision() ? result.setScale(precision, 4) : result);
    }

    private BigDecimal getValue(MnsColumnCollection sumColColl, MnsCalcKey calcKey, String itemNumber, int type) {
        MnsColumnInfo columnInfo = this.getMnsColumnInfo(sumColColl, calcKey, type);
        if (columnInfo == null || columnInfo.valueMap == null) {
            return CslConstant.BGZERO;
        }
        Object v = columnInfo.valueMap.get(itemNumber);
        return v == null ? CslConstant.BGZERO : (BigDecimal)v;
    }

    private BigDecimal getCombineValue(BigDecimal sumValue, BigDecimal elimValue, int precision) {
        if (elimValue != null) {
            BigDecimal bigDecimal = elimValue = this.mnsRptCalcParam.mnsRptParamInfo.isRoundingByPrecision() ? elimValue.setScale(precision, 4) : elimValue;
        }
        if (sumValue != null) {
            sumValue = this.mnsRptCalcParam.mnsRptParamInfo.isRoundingByPrecision() ? sumValue.setScale(precision, 4) : sumValue;
            return sumValue.subtract(elimValue == null ? CslConstant.BGZERO : elimValue);
        }
        if (elimValue != null) {
            return CslConstant.BGZERO.subtract(elimValue);
        }
        return CslConstant.BGZERO;
    }

    private MnsColumnInfo getMnsColumnInfo(MnsColumnCollection coll, MnsCalcKey calcKey, int type) {
        MnsColumnInfo columnInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            columnInfo = coll.get(i);
            if (!columnInfo.calcKey.equals(calcKey)) continue;
            if (type == 0) {
                return columnInfo;
            }
            if (type == 1 && columnInfo.columnDataType == 4) {
                return columnInfo;
            }
            if (type == 2 && columnInfo.columnDataType == 5) {
                return columnInfo;
            }
            if (type != 3 || columnInfo.columnDataType != 6) continue;
            return columnInfo;
        }
        return null;
    }

    private String getUnitIdByTreeIdAndUnitNumber(Context ctx, String treeid, String unitNumber) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" select structure.funitid from t_org_structure structure \n");
        sbSql.append(" join t_org_tree tree on structure.ftreeid=tree.fid \n");
        sbSql.append(" join t_org_baseunit unit on structure.funitid=unit.fid \n");
        sbSql.append(" where tree.fid=? \n");
        sbSql.append(" and unit.fnumber=? \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{treeid, unitNumber});
        String ret = null;
        try {
            while (rs.next()) {
                ret = rs.getString("funitid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    private Set getFdc0Set(Context ctx, Map itemNumbers) throws BOSException {
        HashSet<String> fdc0Set = new HashSet<String>();
        try {
            if (itemNumbers.isEmpty()) {
                return fdc0Set;
            }
            String sql = new StringBuffer("SELECT FNUMBER FROM T_CSL_RPTITEM WHERE FDC = 0").append(" AND FNUMBER IN (").append(CslRptUtil.changeIdIter2String(itemNumbers.keySet().iterator())).append(")").toString();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                fdc0Set.add(rs.getString("fnumber").trim());
            }
            return fdc0Set;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw e;
        }
    }

    private void putMnsCombineData(MnsColumnInfo columnInfo, Map columnValue) {
        if (columnInfo.col == -1 || this.sheetData == null) {
            return;
        }
        if (!this.mnsRptCalcParam.isAutoCalcSubCombineData && columnValue == null || columnValue.isEmpty()) {
            return;
        }
        BigDecimal sumValue = null;
        Iterator iter = columnValue.keySet().iterator();
        Object itemNumber = null;
        BigDecimal result = null;
        Integer rowIndex = null;
        while (iter.hasNext()) {
            itemNumber = iter.next();
            if (this.mnsRptCalcParam.isAutoCalcSubCombineData && !this.mnsRptCalcParam.isSupportCrossMerger) {
                sumValue = this.getValue(this.sumColColl, columnInfo.calcKey, itemNumber + "#isFeignCalc", 0);
            }
            BigDecimal bigDecimal = result = columnValue == null ? null : (BigDecimal)columnValue.get(itemNumber);
            if (result == null && sumValue == null) continue;
            if (result == null && sumValue != null) {
                result = sumValue;
            } else if (result != null && sumValue != null) {
                result = result.add(sumValue);
            }
            rowIndex = (Integer)this.itemRows.get(itemNumber);
            this.putMnsData(result, columnInfo.col, rowIndex);
        }
    }

    public void setElimColColl(MnsColumnCollection elimColColl) {
        this.elimColColl = elimColColl;
    }

    public void setSumColColl(MnsColumnCollection sumColColl) {
        this.sumColColl = sumColColl;
    }

    @Override
    protected void setMnsColumnCollection(MnsColumnCollection collection) {
        this.comColColl = collection;
    }

    public void setDisposalMnsColumnCollMap(Map<String, MnsDisposalColumnCollection> disposalMnsColumnCollMap) {
        this.disposalMnsColumnCollMap = disposalMnsColumnCollMap;
    }

    public void setFeignCalc(boolean isFeignCalc) {
        this.isFeignCalc = isFeignCalc;
    }

    public void setParentCompanyID(String parentCompanyID) {
        this.parentCompanyID = parentCompanyID;
    }

    public void setSheetID(String sheetID) {
        this.sheetID = sheetID;
    }

    public MnsColumnCollection getClearColColl() {
        return this.clearColColl;
    }

    public void setClearColColl(MnsColumnCollection clearColColl) {
        this.clearColColl = clearColColl;
    }
}

