/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.AbstractMnsRptCalcColumn;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcParam;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MnsRptCalcElimData
extends AbstractMnsRptCalcColumn {
    private MnsColumnCollection elimColColl;
    private boolean isFeignCalc = false;
    private String sheetID = null;

    public MnsRptCalcElimData(MnsRptCalcParam mnsRptCalcParam) {
        super(mnsRptCalcParam);
    }

    @Override
    protected void calcData() throws BOSException, EASBizException, CloneNotSupportedException {
        if (this.elimColColl == null || this.elimColColl.isEmpty()) {
            return;
        }
        boolean isSupportCrossMerger = this.mnsRptCalcParam.isSupportCrossMerger;
        CslReportInfo report = this.mnsRptCalcParam.report;
        ItemDataCondition condition = this.mnsRptCalcParam.condition;
        String tempElimIDTable = null;
        boolean hasElim = false;
        try {
            if (isSupportCrossMerger) {
                IRowSet rowSet;
                condition.setValueType(-100);
                tempElimIDTable = this.mnsRptCalcParam.getElimIDTable();
                if (tempElimIDTable == null) {
                    tempElimIDTable = this.getTempElimIDTable(report.getOrgTree().getId().toString(), report.getOrgUnit().getId().toString());
                    this.mnsRptCalcParam.setElimIDTable(tempElimIDTable);
                }
                if ((rowSet = DbUtil.executeQuery((Context)this.ctx, (String)("SELECT TOP 1 FID FROM " + tempElimIDTable))).next()) {
                    hasElim = true;
                }
            }
            if (isSupportCrossMerger && !hasElim && this.elimColColl.size() < 1 && !this.mnsRptCalcParam.mnsRptParamInfo.isSupportHandElim()) {
                return;
            }
            ItemDataCondition tmpcondition = (ItemDataCondition)condition.clone();
            if (!isSupportCrossMerger) {
                String parentCompanyID = report.getOrgUnit().getId().toString();
                ArrayList arrParentCompanyID = CslRptUtil.arrOrgUnit(parentCompanyID);
                tmpcondition.setOrgUnit(arrParentCompanyID);
            }
            tmpcondition.setItemList(this.itemNumbers);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("isSupportCrossMerger", new Boolean(isSupportCrossMerger));
            paramMap.put("isQueryBudget", Boolean.FALSE);
            paramMap.put("isSupportHandElim", Boolean.FALSE);
            paramMap.put("tempElimIDTable", tempElimIDTable);
            MnsColumnInfo columnInfo = null;
            HashMap<String, BigDecimal> columnValue = null;
            for (int i = 0; i < this.elimColColl.size(); ++i) {
                columnInfo = this.elimColColl.get(i);
                paramMap.put("relateValueMap", columnInfo.valueMap);
                if (columnInfo.columnDataType == 4) {
                    tmpcondition.setDebitOrCredit(1);
                } else if (columnInfo.columnDataType == 5) {
                    tmpcondition.setDebitOrCredit(0);
                } else {
                    if (columnInfo.columnDataType != 6) continue;
                    tmpcondition.setDebitOrCredit(3);
                }
                tmpcondition.setDataElement(this.getDataElementInnerValue(columnInfo.calcKey.dataElementNumber));
                tmpcondition.setValueType(columnInfo.calcKey.valueType);
                paramMap.put("condition", tmpcondition);
                columnValue = !isSupportCrossMerger || hasElim ? this._getElimDataByItems(this.ctx, paramMap) : new HashMap<String, BigDecimal>(2);
                if (this.mnsRptCalcParam.mnsRptParamInfo.isSupportHandElim()) {
                    Map elimValueMap;
                    Map elimValueM = null;
                    String itemNumber2 = null;
                    Integer rowIndex = null;
                    if ((columnInfo.columnDataType == 5 || columnInfo.columnDataType == 4 || columnInfo.columnDataType == 6) && (elimValueMap = this.mnsRptCalcParam.mnsRptParamInfo.getElimValueMap()) != null) {
                        elimValueM = (Map)elimValueMap.get(this.sheetID + "-elimValueMap");
                    }
                    BigDecimal result = null;
                    for (String itemNumber2 : this.itemNumbers.keySet()) {
                        result = (BigDecimal)columnValue.get(itemNumber2);
                        rowIndex = (Integer)this.itemRows.get(itemNumber2);
                        if (result != null || elimValueM == null) continue;
                        result = (BigDecimal)elimValueM.get(rowIndex + "-" + columnInfo.col + "-" + columnInfo.columnDataType + "-" + columnInfo.calcKey.dataElementNumber);
                        columnValue.put(itemNumber2, result);
                    }
                    columnInfo.putAllValueMap(columnValue);
                } else if (!isSupportCrossMerger || hasElim) {
                    columnInfo.setValueMap(columnValue);
                }
                if (this.isFeignCalc) continue;
                this.putMnsElimData(columnInfo.valueMap, columnInfo.columnDataType, columnInfo.col, this.sheetID);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void putMnsElimData(Map columnValue, int columnDataType, int columnIndex, String sheetID) {
        if (columnValue == null || columnValue.isEmpty()) {
            return;
        }
        String itemNumber2 = null;
        Integer rowIndex = null;
        BigDecimal result = null;
        for (String itemNumber2 : this.itemNumbers.keySet()) {
            result = (BigDecimal)columnValue.get(itemNumber2);
            rowIndex = (Integer)this.itemRows.get(itemNumber2);
            this.putMnsData(result, columnIndex, rowIndex);
        }
    }

    private String getTempElimIDTable(String currOrgTreeId, String currOrgUnitId) throws EASBizException, BOSException {
        return MnsRptCalcHelper.getTempElimIDTable(this.ctx, this.mnsRptCalcParam.condition, this.elimColColl, this.mnsRptCalcParam.mnsRptParamInfo, this.itemNumbers, currOrgTreeId, currOrgUnitId);
    }

    private Map _getElimDataByItems(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return MnsRptCalcHelper._getElimDataByItems(ctx, paramMap);
    }

    @Override
    protected void setMnsColumnCollection(MnsColumnCollection collection) {
        this.elimColColl = collection;
    }

    public void setFeignCalc(boolean isFeignCalc) {
        this.isFeignCalc = isFeignCalc;
    }

    public void setSheetID(String sheetID) {
        this.sheetID = sheetID;
    }
}

