/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.rpt.batch.AbstractSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.AbstractSortState;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.ICombineHandler;
import com.kingdee.eas.fi.rpt.batch.ICombineRowSetHandler;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.RowSetCombineHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DItemLocationBatchQuery {
    private BatchHelper batchHelper;
    private BatchSQLSorterRegister sortRegister;
    private ParameterContext parameterContext;

    private void initSortRegister() {
        this.sortRegister = new BatchSQLSorterRegister(new HashMap());
        this.sortRegister.setSortState((IBatchSQLSortState)new DItemLocationSortState());
    }

    public DItemLocationBatchQuery(Context ctx, BatchHelper batchHelper, ParameterContext parameterContext) {
        this.batchHelper = new BatchHelper(ctx);
        this.parameterContext = parameterContext;
        this.initSortRegister();
    }

    public void registerFormula(ItemFormula itemFormula) {
        Formula formula1 = itemFormula.formula;
        Map extendedProperty = formula1.getExtendedProperty();
        FunctionExpr functionExpr = (FunctionExpr)formula1.getFunctionExpr();
        String formulaName = functionExpr.funcionName;
        if (formulaName.equalsIgnoreCase("DITEM") && !StringUtils.isEmpty((String)itemFormula.keyNumber) && extendedProperty.get("itemFormulaInfo") != null) {
            this.sortRegister.register((IFormulaCalculator)itemFormula);
        }
    }

    public void executeDItemLocationBatchQuery() throws BOSException {
        RowSetCombineHandler combineHandler = new RowSetCombineHandler(new ICombineRowSetHandler(){

            public void processRowSet(IRowSet rs, IFormulaCalculator formula, IBatchSQLProcessor sqlBuilder) throws SQLException {
                ItemFormula itemFormula = (ItemFormula)formula;
                Formula formula1 = itemFormula.formula;
                Map extendedProperty = formula1.getExtendedProperty();
                ItemFormulaInfo itemFormulaInfo = (ItemFormulaInfo)extendedProperty.get("itemFormulaInfo");
                itemFormulaInfo.setRow(rs.getInt("cellRow"));
                itemFormulaInfo.setCol(rs.getInt("cellCol"));
            }
        });
        this.batchHelper.batchCalculateBigDecimalBySorter((IBatchSQLSorterProcessor)new DItemLocationSQLProcessor(), (IBatchSQLSorterRegister)this.sortRegister, (ICombineHandler)combineHandler);
    }

    class DItemLocationSQLProcessor
    extends AbstractSQLProcessor {
        private int maxsqlvar = 300;

        public DItemLocationSQLProcessor() {
            this.initMaxSQLVaribleSize();
        }

        public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
            ItemFormula itemFormula = (ItemFormula)formula;
            ArrayList<Object> fields = new ArrayList<Object>();
            fields.add(itemFormula.itemNumber);
            fields.add(itemFormula.keyNumber);
            fields.add(new Integer(itemFormula.dataElement));
            Object[][] result = new Object[1][fields.size()];
            result[0] = fields.toArray();
            return result;
        }

        public String[] getIndexResultSetFields() {
            ArrayList<String> indexedFields = new ArrayList<String>();
            indexedFields.add("itemNumber");
            indexedFields.add("keyNumber");
            indexedFields.add("dataElement");
            String[] result = new String[indexedFields.size()];
            indexedFields.toArray(result);
            return result;
        }

        public int getMaxSQLVaribleSize() {
            return this.maxsqlvar;
        }

        private void initMaxSQLVaribleSize() {
            Object batchSize = DItemLocationBatchQuery.this.parameterContext.getAttribute("KEY_CSLPARAM_CHECKFORMULA_DITEMBATCH_SIZE");
            if (batchSize != null) {
                try {
                    this.maxsqlvar = (Integer)batchSize;
                }
                catch (Exception e) {
                    this.maxsqlvar = 300;
                }
            }
        }

        public void buildSelectPart(Set nullSet, StringBuffer sql) {
            sql.append(" select entry.FRow cellRow, entry.FCol cellCol, entry.FSheetId sheetId,");
            sql.append(" entry.FItemId itemNumber, entry.FKeyNumber keyNumber, entry.FDataelement dataElement");
        }

        public void buildFromPart(Set nullSet, StringBuffer sql) {
            sql.append(" from T_CSL_DynaitemDataEntry entry join T_CSL_DynaitemData dyItemData on entry.FItemDataID = dyItemData.FID");
        }

        public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
            DItemLocationSortState ditemLocationSortState = (DItemLocationSortState)this.sortState;
            sql.append(" where entry.FYear= ? and entry.FPeriod= ? and entry.FValueType=? ");
            sql.append(" and dyItemData.FReportID= ? and dyItemData.FPeriodType= ? ");
            sql.append(" and (");
            params.add(new Integer(ditemLocationSortState.year));
            params.add(new Integer(ditemLocationSortState.period));
            params.add(new Integer(ditemLocationSortState.valueType));
            params.add(ditemLocationSortState.reportId);
            CslReportInfo reportInfo = (CslReportInfo)DItemLocationBatchQuery.this.parameterContext.getAttribute("cslReportInfo");
            int periodType = reportInfo.getPeriodType().getValue();
            params.add(new Integer(periodType));
        }

        public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
            sql.append("(entry.FItemID = ? and entry.FkeyNumber = ? and entry.FDataElement = ?)");
            ItemFormula itemFormula = (ItemFormula)formula;
            params.add(itemFormula.itemNumber);
            params.add(itemFormula.keyNumber);
            params.add(new Integer(itemFormula.dataElement));
        }

        public void buildGroupByPart(Set nullSet, StringBuffer sql) {
            sql.append(")");
        }
    }

    class DItemLocationSortState
    extends AbstractSortState {
        String reportId;
        int year;
        int period;
        int valueType;

        DItemLocationSortState() {
        }

        public void setState(IFormulaCalculator formula) {
            ItemFormula itemFormula = (ItemFormula)formula;
            this.year = itemFormula.year;
            this.period = itemFormula.period;
            this.valueType = itemFormula.valueType;
            Formula formula1 = itemFormula.formula;
            Map extendedProperty = formula1.getExtendedProperty();
            ItemFormulaInfo itemFormulaInfo = (ItemFormulaInfo)extendedProperty.get("itemFormulaInfo");
            this.reportId = itemFormulaInfo.getReportId();
        }

        public String generateKey() {
            StringBuffer sortKey = new StringBuffer();
            sortKey.append("[").append(this.year).append("]");
            sortKey.append("[").append(this.period).append("]");
            sortKey.append("[").append(this.valueType).append("]");
            sortKey.append("[").append(this.reportId).append("]");
            return sortKey.toString();
        }

        public Object clone() {
            DItemLocationSortState sortState = new DItemLocationSortState();
            sortState.year = this.year;
            sortState.period = this.period;
            sortState.valueType = this.valueType;
            sortState.reportId = this.reportId;
            return sortState;
        }

        public void reset() {
            this.year = 0;
            this.period = 0;
            this.valueType = 0;
            this.reportId = null;
        }
    }
}

