/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula.FillFormulaUtil;
import com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula.IFillFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import java.math.BigDecimal;
import java.util.List;
import org.apache.log4j.Logger;

public class FillDItemFormula
implements IFillFormula {
    private static Logger logger = Logger.getLogger(FillDItemFormula.class);

    @Override
    public FunctionExpr fillFormulaParameter(Context ctx, FunctionExpr expr, ParameterContext parameterContext) {
        CslReportInfo reportInfo = (CslReportInfo)parameterContext.getAttribute("cslReportInfo");
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)parameterContext.getAttribute("orgTreeInfo");
        Boolean isMergeByFiscalPeriod = (Boolean)parameterContext.getAttribute("isMergeByFiscalPeriod");
        Boolean isSupport13Period = (Boolean)parameterContext.getAttribute("isSupport13Period");
        PeriodCollection periodCollection = (PeriodCollection)parameterContext.getAttribute("periodCollection");
        RptSrcTypeEnum sourceType = reportInfo.getSourceType();
        FunctionExpr functionExpr = new FunctionExpr("DITEM");
        List paramList = functionExpr.parameters;
        paramList.add(0, new StringExpr(orgTreeInfo.getNumber()));
        paramList.add(1, new StringExpr(reportInfo.getOrgUnit().getNumber()));
        paramList.add(2, new StringExpr(reportInfo.getSourceCurrency().getNumber()));
        paramList.add(3, new StringExpr(reportInfo.getCurrency().getNumber()));
        paramList.add(4, expr.parameters.get(0));
        paramList.add(5, expr.parameters.get(1));
        paramList.add(6, new StringExpr(reportInfo.getPeriodType().getName()));
        int yearOffset = 0;
        int periodOffset = 0;
        if (expr.parameters.get(2) instanceof IntExpr) {
            yearOffset = ((IntExpr)expr.parameters.get((int)2)).value.intValue();
        } else if (expr.parameters.get(2) instanceof UnaryOperationExpr) {
            yearOffset = new Integer(((UnaryOperationExpr)expr.parameters.get(2)).toString());
        }
        if (expr.parameters.get(3) instanceof IntExpr) {
            periodOffset = ((IntExpr)expr.parameters.get((int)3)).value.intValue();
        } else if (expr.parameters.get(3) instanceof UnaryOperationExpr) {
            periodOffset = new Integer(((UnaryOperationExpr)expr.parameters.get(3)).toString());
        }
        int[] yearAndPeriod = FillFormulaUtil.getRptYearAndPeriod(ctx, reportInfo, periodCollection, yearOffset, periodOffset, isSupport13Period, isMergeByFiscalPeriod);
        paramList.add(7, new IntExpr(new BigDecimal("" + yearAndPeriod[0]).toBigInteger()));
        paramList.add(8, new IntExpr(new BigDecimal("" + yearAndPeriod[1]).toBigInteger()));
        paramList.add(9, new IntExpr(new BigDecimal("" + yearAndPeriod[1]).toBigInteger()));
        String sourceTypeName = sourceType.equals((Object)RptSrcTypeEnum.NORMAL) ? RptSrcTypeEnum.DYNAMICNORMALREPORT.getName() : (sourceType.equals((Object)RptSrcTypeEnum.SUM) ? RptSrcTypeEnum.DYNAMICSUMREPORT.getName() : (sourceType.equals((Object)RptSrcTypeEnum.CONSOLIDATION) ? RptSrcTypeEnum.DYNAMICCSLREPORT.getName() : sourceType.getName()));
        paramList.add(10, new StringExpr(sourceTypeName));
        paramList.add(11, expr.parameters.get(4));
        paramList.add(12, expr.parameters.get(5));
        paramList.add(13, new BoolExpr(false));
        paramList.add(14, new BoolExpr(false));
        String dataCollectNumber = null;
        if (expr.parameters.size() == 7) {
            dataCollectNumber = ((StringExpr)expr.parameters.get((int)7)).value;
        }
        dataCollectNumber = FillFormulaUtil.getDataCollectNumber(reportInfo, dataCollectNumber);
        paramList.add(15, new StringExpr(dataCollectNumber));
        DebugLogger.info((Logger)logger, (String)"transDItemFormula", (Object)expr.toString());
        return functionExpr;
    }
}

