/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.report;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResult;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.BtwTableArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.report.IMessageDisplay;
import com.kingdee.eas.fi.gr.cslrpt.articulation.report.MessageDisplayUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BtwRelationReportMsg
implements IMessageDisplay {
    private Map itemFormulaPointMap = new HashMap(8);
    CslReportInfo report;
    Book book = null;

    @Override
    public String getReportMessage(ParameterContext parameterContext) {
        Boolean isSupportOtherDS = (Boolean)parameterContext.getAttribute("isSupportOtherDS");
        ArticulationCheckResult articulationCheckResult = (ArticulationCheckResult)parameterContext.getAttribute("reportCheckFormulaResult");
        Locale locale = parameterContext.getLocale();
        return this.getReportMessage(isSupportOtherDS, articulationCheckResult, locale);
    }

    public String getReportMessage(Boolean isSupportOtherDS, ArticulationCheckResult articulationCheckResult, Locale locale) {
        this.report = articulationCheckResult.getReportInfo();
        this.book = null;
        StringBuffer resultRpt = new StringBuffer();
        Map orgTreeArticulationMap = articulationCheckResult.getOrgTreeArticulationMap();
        StringBuffer articulationMessage = new StringBuffer();
        for (Map.Entry entry : orgTreeArticulationMap.entrySet()) {
            BtwTableArticulationInfo articulationInfo;
            OrgTreeInfo orgTreeInfo;
            String orgTreeArticulationMessage;
            List checkFormulaList = (List)entry.getValue();
            if (checkFormulaList.isEmpty() || StringUtils.isEmpty((String)(orgTreeArticulationMessage = this.getArticulationMessage(checkFormulaList, orgTreeInfo = (articulationInfo = (BtwTableArticulationInfo)checkFormulaList.iterator().next()).getOrgTreeInfo(), locale)))) continue;
            String temp = this.getString("CHECK_MESSAGE_13", locale);
            articulationMessage.append(temp).append(orgTreeInfo.getName()).append("<br>");
            articulationMessage.append(orgTreeArticulationMessage);
        }
        if (!StringUtils.isEmpty((String)articulationMessage.toString())) {
            String headMessage = this.getReportHeadMessage(this.report, isSupportOtherDS, locale);
            resultRpt.append(headMessage).append(articulationMessage);
        }
        this.itemFormulaPointMap.clear();
        return resultRpt.toString();
    }

    private String getReportHeadMessage(CslReportInfo report, Boolean isSupportOtherDS, Locale locale) {
        StringBuffer resultRpt = new StringBuffer();
        String tempStr = null;
        this.joinCheckTypeAndDate(report, isSupportOtherDS, locale, resultRpt);
        resultRpt.append("====================================================================<br>");
        this.joinReportType(report, locale, resultRpt);
        this.joinReportName(report, locale, resultRpt);
        tempStr = this.getString("CHECK_MESSAGE_46", locale);
        if (report.getCompany() != null && report.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICSUMREPORT && RptSrcTypeEnum.CONSOLIDATION != report.getSourceType() && RptSrcTypeEnum.SUM != report.getSourceType() && RptSrcTypeEnum.DYNAMICCSLREPORT != report.getSourceType()) {
            resultRpt.append(tempStr).append(report.getCompany().getName()).append("<br>");
        } else {
            resultRpt.append(tempStr).append(report.getOrgUnit().getName()).append("<br>");
        }
        return resultRpt.toString();
    }

    protected void joinCheckTypeAndDate(CslReportInfo report, Boolean isSupportOtherDS, Locale locale, StringBuffer resultRpt) {
        String actual = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"currentActualData", (Locale)locale);
        String budget = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"currentBudgetData", (Locale)locale);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String tempStr = this.getString("CHECK_MESSAGE_1", locale);
        resultRpt.append(tempStr).append("<br>");
        tempStr = this.getString("CHECK_MESSAGE_41", locale);
        resultRpt.append(tempStr);
        resultRpt.append(format.format(new Date()).toString()).append("<br>");
        if (isSupportOtherDS.booleanValue()) {
            resultRpt.append(report.getDataCollectNumber().equalsIgnoreCase("ACTUALDATA") ? actual : budget).append("<br>");
        }
    }

    protected void joinReportName(CslReportInfo report, Locale locale, StringBuffer resultRpt) {
        String tempStr = this.getString("CHECK_MESSAGE_5", locale);
        resultRpt.append(tempStr).append(report.getName()).append("<br>");
    }

    protected void joinReportType(CslReportInfo report, Locale locale, StringBuffer resultRpt) {
        String tempStr = report.getSourceType().getValue() == 3 ? this.getString("CHECK_MESSAGE_2", locale) : (report.getSourceType().getValue() == 2 ? this.getString("CHECK_MESSAGE_3", locale) : (report.getSourceType().getValue() == 12 || report.getSourceType().getValue() == 35 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SourceType", (Locale)locale) + "\uff1a" + report.getSourceType().getAlias() : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SourceType", (Locale)locale) + "\uff1a" + RptSrcTypeEnum.getEnum((int)report.getSourceType().getValue()).getAlias()));
        resultRpt.append(tempStr).append("<br>");
    }

    private String getArticulationMessage(List<BtwTableArticulationInfo> checkFormulaList, OrgTreeInfo orgTreeInfo, Locale locale) {
        StringBuffer resultRpt = new StringBuffer();
        String tempStr = null;
        for (int i = 0; i < checkFormulaList.size(); ++i) {
            BtwTableArticulationInfo articulationInfo1 = checkFormulaList.get(i);
            if (!articulationInfo1.isAvailable() || articulationInfo1.isPassArticulation()) continue;
            BigDecimal range = articulationInfo1.getRange();
            DecimalFormat f = new DecimalFormat("#,##0.0000");
            String rangeStr = "0.00";
            if (range != null) {
                rangeStr = f.format(range);
            }
            tempStr = this.getString("CHECK_MESSAGE_15", locale);
            resultRpt.append("<br>").append(tempStr).append(articulationInfo1.getName());
            tempStr = this.getString("CHECK_MESSAGE_16", locale);
            resultRpt.append("<br>").append(tempStr).append(articulationInfo1.getNumber());
            tempStr = this.getString("CHECK_MESSAGE_17", locale);
            if (!articulationInfo1.getDetailFormulaMap().isEmpty() && this.book == null) {
                this.book = MessageDisplayUtil.getBook(this.report);
            }
            String srcLFormula = articulationInfo1.getCheckFormulaInfo().getLFormula().toUpperCase();
            String linkInfoL = MessageDisplayUtil.setItemFormulaInformation(srcLFormula, articulationInfo1.getDetailFormulaMap(), this.report, this.book, this.itemFormulaPointMap);
            resultRpt.append("<br>").append(tempStr).append(linkInfoL);
            tempStr = this.getString("CHECK_MESSAGE_18", locale);
            Object lValue = articulationInfo1.getlValue();
            if (lValue instanceof Throwable) {
                resultRpt.append("=").append(((Throwable)lValue).getMessage()).append("<br>").append(tempStr);
            } else {
                resultRpt.append("=").append(lValue).append("<br>").append(tempStr);
            }
            String srcRFormula = articulationInfo1.getCheckFormulaInfo().getRFormula().toUpperCase();
            String linkInfoR = MessageDisplayUtil.setItemFormulaInformation(srcRFormula, articulationInfo1.getDetailFormulaMap(), this.report, this.book, this.itemFormulaPointMap);
            resultRpt.append(linkInfoR);
            Object rValue = articulationInfo1.getrValue();
            if (rValue instanceof Throwable) {
                resultRpt.append("=").append(((Throwable)rValue).getMessage()).append("<br>").append(tempStr);
            } else {
                resultRpt.append("=").append(rValue).append("<br>");
            }
            tempStr = this.getString("CHECK_MESSAGE_19", locale);
            resultRpt.append(tempStr);
            OperateSymbolEnum operateSymbol = articulationInfo1.getCheckFormulaInfo().getOperateSymbol();
            resultRpt.append(MessageDisplayUtil.getOperateSymbolStr(operateSymbol, locale));
            tempStr = this.getString("CHECK_MESSAGE_20", locale);
            resultRpt.append(tempStr + "<br>");
            tempStr = this.getString("CHECK_MESSAGE_43", locale);
            resultRpt.append(tempStr).append(rangeStr);
            if (!StringUtils.isEmpty((String)articulationInfo1.getCheckFormulaInfo().getPrompt())) {
                tempStr = this.getString("CHECK_MESSAGE_21", locale);
                resultRpt.append("<br>" + tempStr).append(articulationInfo1.getCheckFormulaInfo().getPrompt().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            }
            tempStr = this.getString("CHECK_MESSAGE_22", locale);
            resultRpt.append("<br>" + tempStr + orgTreeInfo.getName());
            int checkResultType = articulationInfo1.getCheckFormulaInfo().getCheckResult().getValue();
            if (checkResultType == 1) {
                tempStr = this.getString("CHECK_MESSAGE_23", locale);
                resultRpt.append(tempStr + "(***)\n\n").append("<br><br>");
                continue;
            }
            if (checkResultType == 2) {
                tempStr = this.getString("CHECK_MESSAGE_49", locale);
                resultRpt.append(tempStr + "(***)\n\n").append("<br><br>");
                continue;
            }
            String postil = MessageDisplayUtil.getItemFormulaCellPostil(articulationInfo1.getDetailFormulaMap(), locale);
            if (!StringUtils.isEmpty((String)postil)) {
                tempStr = this.getString("CHECK_MESSAGE_35", locale);
                resultRpt.append(tempStr).append("\n");
                resultRpt.append(postil).append("(***)\n\n").append("<br><br>");
                continue;
            }
            tempStr = this.getString("CHECK_MESSAGE_51", locale);
            resultRpt.append(tempStr + "(***)\n\n").append("<br><br>");
        }
        return resultRpt.toString();
    }

    protected String getString(String resName, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CheckFormula", (String)resName, (Locale)locale);
    }
}

