/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckCalcResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.FindItemFormulaSaveUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.BatchCalculator;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.BatchCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FindParameterType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaCalcUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaParameter;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ItemFormulaSaveUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterResults;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterTypeOrderComparator;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SheetParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.AutoItemLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.SaveItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.util.Uuid;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class CalculateFormulaCalcUnit {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CalculateFormulaCalcUnit.class);
    protected DBHandler dao;

    public CalculateFormulaCalcUnit(DBHandler dao) {
        this.dao = dao;
    }

    public Set<ItemFormulaSaveUnit> exec(FormulaCalcContextInfo formulaContextDefine, Set<FormulaCalcUnit> calcUnits, Uuid currentCalcFlag, String executeTaskId, int calcLevelInOneProcess, AutoItemLog reportLog) throws BOSException, EASBizException {
        HashSet<FormulaParameter> allParams = new HashSet<FormulaParameter>();
        Collection<FormulaParameter> params = null;
        CheckCalcResult checkCalcResult = new CheckCalcResult(reportLog);
        TreeSet<ParameterType> allTypes = new TreeSet<ParameterType>(new ParameterTypeOrderComparator());
        Set<ParameterType> types = null;
        HashMap<String, HashSet<FormulaCalcUnit>> param2CalcUnit = new HashMap<String, HashSet<FormulaCalcUnit>>();
        HashSet<TemplateInfo> templates = new HashSet<TemplateInfo>(formulaContextDefine.getTemplates().size());
        int maxCalcLevel = 0;
        FormulaParameter maxCalcLevelParam = null;
        HashSet<String> paramKeys = new HashSet<String>(calcUnits.size());
        for (FormulaCalcUnit calcUnit : calcUnits) {
            params = calcUnit.initValueFormula();
            maxCalcLevel = -1;
            maxCalcLevelParam = null;
            for (FormulaParameter param : params) {
                paramKeys.add(param.getParamKey());
                if (param.getType().getCalcLevel() <= maxCalcLevel) continue;
                maxCalcLevel = param.getType().getCalcLevel();
                maxCalcLevelParam = param;
            }
            if (maxCalcLevelParam != null) {
                HashSet<FormulaCalcUnit> units = (HashSet<FormulaCalcUnit>)param2CalcUnit.get(maxCalcLevelParam.getParamKey());
                if (units == null) {
                    units = new HashSet<FormulaCalcUnit>(1);
                    param2CalcUnit.put(maxCalcLevelParam.getParamKey(), units);
                }
                units.add(calcUnit);
            }
            allParams.addAll(params);
            types = new FindParameterType().exec(this.dao, params);
            allTypes.addAll(types);
            templates.add(calcUnit.getTemplate());
        }
        LOG.debug("get parameter types:{0}", new Object[]{allTypes});
        if (currentCalcFlag == null) {
            currentCalcFlag = Uuid.randomUUID();
        }
        ParameterDao paramDao = new ParameterDao(this.dao, currentCalcFlag);
        try {
            FormulaParameter param;
            paramDao.save(allParams);
            BatchCalculator batchCalculator = null;
            HashSet<SheetParam> sheetParams = null;
            param = null;
            ParameterResults paramsResults = new ParameterResults(allParams.size() * 2);
            allParams.clear();
            System.gc();
            for (ParameterType type : allTypes) {
                sheetParams = new HashSet<SheetParam>();
                params = paramDao.getParam(type, sheetParams);
                HashMap dupParams = new HashMap();
                HashMap<String, FormulaParameter> dupParamKeys = new HashMap<String, FormulaParameter>();
                HashSet<FormulaParameter> removes = new HashSet<FormulaParameter>(5);
                Iterator<FormulaParameter> it = params.iterator();
                while (it.hasNext()) {
                    param = it.next();
                    if (!paramKeys.contains(param.getParamKey())) {
                        it.remove();
                        continue;
                    }
                    if (param2CalcUnit.containsKey(param.getParamKey())) {
                        param.setFormulaCalcUnits((Collection)param2CalcUnit.get(param.getParamKey()));
                        param.setCheckCalcResult(checkCalcResult);
                    }
                    if (dupParamKeys.containsKey(param.getFormula())) {
                        if (param.getType().getCalcLevel() > ((FormulaParameter)((Object)dupParamKeys.get(param.getFormula()))).getType().getCalcLevel()) {
                            dupParams.put(param, dupParamKeys.get(param.getFormula()));
                            it.remove();
                            continue;
                        }
                        dupParams.put(dupParamKeys.get(param.getFormula()), param);
                        removes.add((FormulaParameter)((Object)dupParamKeys.get(param.getFormula())));
                        continue;
                    }
                    dupParamKeys.put(param.getFormula(), param);
                }
                params.removeAll(removes);
                batchCalculator = BatchCalculatorFactory.create(type, sheetParams, formulaContextDefine.getOrgType());
                batchCalculator.exec(this.dao.getContext(), params);
                for (FormulaParameter dupParam : dupParams.keySet()) {
                    dupParam.setValue(((FormulaParameter)((Object)dupParams.get((Object)dupParam))).getValue());
                }
                paramDao.saveValue(params);
                paramDao.saveValue(removes);
                paramsResults.putResults(params);
                paramsResults.putResults(removes);
                params.clear();
                removes.clear();
                sheetParams.clear();
            }
            Set<ItemFormulaSaveUnit> itemUnits = new FindItemFormulaSaveUnit(this.dao).exec(formulaContextDefine, currentCalcFlag, calcUnits, executeTaskId, reportLog, paramsResults);
            new SaveItem(this.dao).exec(itemUnits, calcLevelInOneProcess, formulaContextDefine.getOrgType());
            Set<ItemFormulaSaveUnit> set = itemUnits;
            return set;
        }
        catch (EASBizException e) {
            for (TemplateInfo template : templates) {
                this.recordErrorForAllCompanys(calcUnits, reportLog, template, (Exception)((Object)e));
            }
            throw e;
        }
        catch (BOSException e) {
            for (TemplateInfo template : templates) {
                this.recordErrorForAllCompanys(calcUnits, reportLog, template, (Exception)((Object)e));
            }
            throw e;
        }
        finally {
            paramDao.deleteTaskParam();
            allParams = null;
        }
    }

    protected void recordErrorForAllCompanys(Set<FormulaCalcUnit> calcUnits, AutoItemLog reportLog, TemplateInfo template, Exception e) throws EASBizException, BOSException {
        if (template != null) {
            HashSet<String> recordedCompanys = new HashSet<String>();
            String company = null;
            String errorDetail = ResourceDebugUtil.res("unknown.exception") + ":" + e.getClass().getSimpleName();
            for (FormulaCalcUnit calcUnit : calcUnits) {
                company = calcUnit.getCalcContext().getCompany().getId().toString();
                if (!recordedCompanys.contains(company)) {
                    reportLog.fail(template, calcUnit.getCalcContext().getCompany(), errorDetail, "");
                } else {
                    recordedCompanys.add(company);
                }
                calcUnit.setExceptionResult(true);
            }
            recordedCompanys = null;
        }
    }

    private RptWeaveParams buildRptWeaveParams(FormulaCalcContextInfo formulaCalcContext, TemplateInfo template, FormulaCalcContextCompanyInfo companyEntity) {
        RptWeaveParams schmParam = new RptWeaveParams();
        schmParam.setObject("KEY_TEMPLATE", template);
        schmParam.setObject("KEY_COMPANY", companyEntity.getCompany());
        schmParam.setInt("Period", formulaCalcContext.getPeriod());
        schmParam.setInt("Year", formulaCalcContext.getYear());
        RptAutoWeaveSchmRptInfo schmRptInfo = new RptAutoWeaveSchmRptInfo();
        schmRptInfo.setCurrency(formulaCalcContext.getCurrentCurrency());
        schmParam.setObject("rpt_weave_rptSchmObj", schmRptInfo);
        RptWeaveExecParams execParam = new RptWeaveExecParams();
        execParam.setUserId(formulaCalcContext.getLastUpdateUser().getId().toString());
        schmParam.setObject("rpt_weave_execparams", execParam);
        schmParam.setBoolean("rptautoweave_isfromgeextractdataf", true);
        return schmParam;
    }
}

