/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.PutReportSheetParam2Sheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IReportEntity;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QuerySheetParams;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import java.io.IOException;

public class ReportEntityForTemplate
implements IReportEntity {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ReportEntityForTemplate.class);
    private TemplateInfo template;
    private QuerySheetParams querySheetParams;

    public ReportEntityForTemplate(TemplateInfo template, QuerySheetParams querySheetParams) {
        this.template = template;
        this.querySheetParams = querySheetParams;
    }

    @Override
    public Book getBook() throws BOSException {
        try {
            return this.template.getBook();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void setBook(Book book) throws BOSException {
        try {
            this.template.setBook(book);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public RptTmpTypeEnum getType() {
        return this.template.getTemplateType();
    }

    @Override
    public RptSheetParamInfo getSheetParam(String sheetId) {
        Object sheetParam = this.template.get("sheet" + sheetId);
        if (!(sheetParam instanceof RptSheetParamInfo)) {
            this.reQuerySheetParams();
            sheetParam = this.template.get("sheet" + sheetId);
            if (!(sheetParam instanceof RptSheetParamInfo)) {
                sheetParam = null;
            }
        }
        if (sheetParam == null && this.querySheetParams != null) {
            try {
                Book book = this.getBook();
                sheetParam = this.querySheetParams.exec(book, book.getSheetByID(sheetId), (VirtualSheetParamInfo)this.template);
            }
            catch (Exception e) {
                LOG.warn("", e);
            }
        }
        return (RptSheetParamInfo)sheetParam;
    }

    @Override
    public RptSheetParamCollection getSheetParams() {
        RptSheetParamCollection sheetParams = this.template.getSheetParam();
        if (sheetParams.isEmpty()) {
            this.reQuerySheetParams();
            return this.template.getSheetParam();
        }
        return sheetParams;
    }

    @Override
    public void put(String sheetId, RptSheetParamInfo sheetParam) {
        this.template.put("sheet" + sheetId, (Object)sheetParam);
    }

    public void reQuerySheetParams() {
        try {
            if (this.template.getSheetParam().isEmpty()) {
                if (this.querySheetParams == null) {
                    LOG.error("need report QuerySheetParam for IReportEntity");
                    return;
                }
                this.querySheetParams.exec((VirtualSheetParamInfo)this.template);
            }
            ActionFactory.get(PutReportSheetParam2Sheet.class).put(this, this.template.getSheetParam());
        }
        catch (BOSException e) {
            LOG.error("", e);
        }
    }
}

