/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.text.MessageFormat;
import java.text.ParseException;

public class ContextKey {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ContextKey.class);
    private static final String STYLE = "{0},,,{1},,,{2},,,{3},,,{4}";
    private OrgUnitInfo company;
    private CurrencyInfo currency;
    private int year;
    private int period;
    private RptPeriodTypeEnum periodType;

    public ContextKey(OrgUnitInfo company, CurrencyInfo currency, int year, int period, RptPeriodTypeEnum periodType) {
        this.company = company;
        this.currency = currency;
        this.year = year;
        this.period = period;
        this.periodType = periodType;
    }

    public OrgUnitInfo getCompany() {
        return this.company;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public int getYear() {
        return this.year;
    }

    public int getPeriod() {
        return this.period;
    }

    public RptPeriodTypeEnum getPeriodType() {
        return this.periodType;
    }

    public static ContextKey unserialString(String contextKey) {
        if (contextKey == null) {
            return null;
        }
        Object[] keys = null;
        try {
            keys = new MessageFormat(STYLE).parse(contextKey);
        }
        catch (ParseException e) {
            LOG.error("", e);
            return null;
        }
        if (keys == null || keys.length != 5) {
            return null;
        }
        try {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setNumber((String)keys[0]);
            int year = Integer.parseInt((String)keys[1]);
            int period = Integer.parseInt((String)keys[2]);
            CurrencyInfo currency = new CurrencyInfo();
            currency.setNumber((String)keys[3]);
            RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)Integer.parseInt((String)keys[4]));
            return new ContextKey((OrgUnitInfo)company, currency, year, period, periodType);
        }
        catch (NumberFormatException e) {
            LOG.error("", e);
            return null;
        }
    }

    public String serialString() {
        Object[] arguments = new Object[]{this.company.getNumber(), this.year + "", this.period + "", this.currency.getNumber(), this.periodType.getValue() + ""};
        return MessageFormat.format(STYLE, arguments);
    }

    public int compareTo(ContextKey other) {
        if (other == null) {
            return 1;
        }
        if (this.serialString() != null) {
            return this.serialString().compareTo(other.serialString());
        }
        return -1;
    }

    public boolean isValid() {
        return this.company != null && this.currency != null && this.company.getNumber() != null && this.currency.getNumber() != null && this.periodType != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.company == null || this.company.getNumber() == null ? 0 : this.company.getNumber().hashCode());
        result = 31 * result + (this.currency == null || this.currency.getNumber() == null ? 0 : this.currency.getNumber().hashCode());
        result = 31 * result + this.period;
        result = 31 * result + (this.periodType == null ? 0 : this.periodType.hashCode());
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextKey other = (ContextKey)obj;
        if (this.company == null ? other.company != null : (this.company.getNumber() == null ? other.company.getNumber() != null : !this.company.getNumber().equals(other.company.getNumber()))) {
            return false;
        }
        if (this.currency == null ? other.currency != null : (this.currency.getNumber() == null ? other.currency.getNumber() != null : !this.currency.getNumber().equals(other.currency.getNumber()))) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        if (this.periodType == null ? other.periodType != null : !this.periodType.equals((Object)other.periodType)) {
            return false;
        }
        return this.year == other.year;
    }

    public String toString() {
        return StringUtil.toStringByReflect(this);
    }
}

