/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FindFormulaCalcMethod;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaExecutor;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaForDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.trigger.FormulaForQueryItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class InvokeFormulaExecutor {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", InvokeFormulaExecutor.class);
    private Collection<FormulaExecutor> formulaExecutors = new HashSet<FormulaExecutor>(1);

    public InvokeFormulaExecutor() throws EASBizException, BOSException {
        this.init();
    }

    protected void init() throws EASBizException, BOSException {
        this.formulaExecutors.clear();
        HashSet bizFormulaCalcTypes = new HashSet(1);
        try {
            bizFormulaCalcTypes.addAll(FormulaDefinition.getInstance().getBatchImplClass());
            bizFormulaCalcTypes.addAll(FormulaDefinition.getInstance().getImplClass());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (String type : bizFormulaCalcTypes) {
            this.addFormulaExecutor(type, 0);
        }
        this.addFormulaExecutor(FormulaForDefine.class.getName(), 1);
        this.addFormulaExecutor(FormulaForQueryItemResult.class.getName(), 1);
    }

    public boolean addFormulaExecutor(String type, int grade) throws EASBizException, BOSException {
        Collection<Method> methods = null;
        FindFormulaCalcMethod findFormulaMethod = ActionFactory.get(FindFormulaCalcMethod.class);
        FormulaExecutor formulaExecutor = new FormulaExecutor(type, grade);
        try {
            methods = findFormulaMethod.exec(Class.forName(type));
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        for (Method method : methods) {
            LOG.debug("find one batch method:{0}", new Object[]{method});
            formulaExecutor.addMethod(method);
        }
        this.formulaExecutors.add(formulaExecutor);
        return true;
    }

    public void exec(Map<String, SortedParameterArray> methods, ICalculateContextProvider calContext) throws BOSException {
        methods = new HashMap<String, SortedParameterArray>(methods);
        SortedParameterArray params = null;
        String paramSheetName = null;
        String methodName = null;
        HashMap sameMethodNameParams = null;
        HashMap executorCache = new HashMap(1);
        TreeSet<FormulaExecutor> orderedFormulaExecutors = new TreeSet<FormulaExecutor>(new Comparator<FormulaExecutor>(){

            @Override
            public int compare(FormulaExecutor o1, FormulaExecutor o2) {
                return o1.compareTo(o2);
            }
        });
        orderedFormulaExecutors.addAll(this.formulaExecutors);
        for (FormulaExecutor executor : orderedFormulaExecutors) {
            executorCache.clear();
            Iterator<String> methodNameInterator = methods.keySet().iterator();
            while (methodNameInterator.hasNext()) {
                methodName = methodNameInterator.next();
                if (!executor.meet(methodName)) continue;
                params = methods.get(methodName);
                methodNameInterator.remove();
                for (int i = 0; i < params.size(); ++i) {
                    paramSheetName = params.getParameter(i).getSheetName();
                    if (!executorCache.containsKey(paramSheetName)) {
                        sameMethodNameParams = new HashMap();
                        executorCache.put(paramSheetName, sameMethodNameParams);
                    }
                    if (!((Map)executorCache.get(paramSheetName)).containsKey(methodName)) {
                        ((Map)executorCache.get(paramSheetName)).put(methodName, new SortedParameterArray());
                    }
                    ((SortedParameterArray)((Map)executorCache.get(paramSheetName)).get(methodName)).append((Object)params.getParameter(i));
                }
            }
            for (String sheetName : executorCache.keySet()) {
                this.exec((Map)executorCache.get(sheetName), (FormulaExecutor)executor.clone(), calContext, sheetName);
            }
        }
    }

    protected Thread exec(Map<String, SortedParameterArray> params, FormulaExecutor executor, ICalculateContextProvider calContext, String sheetName) throws BOSException {
        try {
            executor.exec(params, sheetName, calContext);
        }
        catch (EASBizException e) {
            for (SortedParameterArray paramArray : params.values()) {
                for (int i = 0; i < paramArray.size(); ++i) {
                    paramArray.getParameter(i).setValue((Object)("#BAD FUNCTION!:" + e.getMessage()));
                }
            }
        }
        return null;
    }
}

