/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.BuildFormulaCalcUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaCalcUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.OneLevels;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx.QueryFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class QueryFormulaUnit {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QueryFormulaUnit.class);
    private DBHandler dao;

    public QueryFormulaUnit(DBHandler dao) {
        this.dao = dao;
    }

    public Collection<FormulaCalcUnit> exec(FormulaCalcContextInfo formulaCalcContext, OrgUnitInfo company) throws EASBizException, BOSException {
        HashSet<FormulaCalcUnit> allCalcUnits = new HashSet<FormulaCalcUnit>();
        FormulaSchemeCollection formulaSchemes = null;
        QueryFormulaScheme queryFormulaScheme = new QueryFormulaScheme(this.dao);
        FormulaCalcContextTemplateCollection templates = formulaCalcContext.getTemplates();
        TemplateInfo template = null;
        HashSet<IFormula> duplicItemFormula = new HashSet<IFormula>(5);
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            template = ((FormulaCalcContextTemplateInfo)iterator.next()).getTemplate();
            formulaSchemes = queryFormulaScheme.exec(template, company);
            if (formulaSchemes.isEmpty()) {
                LOG.error("FormulaScheme not be found from {0}({1})", new Object[]{template.getName(), template.getNumber()});
                continue;
            }
            LOG.debug("find {0} formula schemes from template {1}({2}) ", new Object[]{formulaSchemes.size(), template.getName(), template.getNumber()});
            List<Set<FormulaCalcUnit>> levelCalcUnits = new BuildFormulaCalcUnit(this.dao).scan(formulaCalcContext, formulaSchemes, company, new OneLevels(0));
            for (Set<FormulaCalcUnit> calcUnits : levelCalcUnits) {
                if (calcUnits.isEmpty()) {
                    LOG.error("FormulaCalcUnit not be found from {0}({1}),formulaScheme is {2}", new Object[]{template.getName(), template.getNumber(), formulaSchemes});
                    continue;
                }
                Iterator<FormulaCalcUnit> it = calcUnits.iterator();
                while (it.hasNext()) {
                    FormulaCalcUnit formulaCalcUnit = it.next();
                    if (duplicItemFormula.contains(formulaCalcUnit.getItemFormula())) {
                        it.remove();
                        continue;
                    }
                    duplicItemFormula.add(formulaCalcUnit.getItemFormula());
                }
                allCalcUnits.addAll(calcUnits);
                calcUnits.clear();
            }
        }
        duplicItemFormula.clear();
        duplicItemFormula = null;
        return allCalcUnits;
    }
}

