/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx.IHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx.ITailHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ArrayListExt;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CheckValidException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CombineCheckValidException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryPermissionCompany {
    public static final ITailHandler<List<CompanyOrgUnitInfo>> DEFAULT_HANDLER = new ITailHandler<List<CompanyOrgUnitInfo>>(){

        @Override
        public List<CompanyOrgUnitInfo> exec(List<CompanyOrgUnitInfo> beforeObject) {
            return beforeObject;
        }
    };
    protected DBHandler dao;

    public QueryPermissionCompany(DBHandler dao) {
        this.dao = dao;
    }

    public List<OrgUnitInfo> exec(String userId, OrgType orgType, IHandler<List<OrgUnitInfo>, List<OrgUnitInfo>> handler) throws BOSException {
        return this.exec(userId, orgType, new HashSet<String>(0), handler);
    }

    protected List<OrgUnitInfo> exec(String userId, OrgType orgType, Set<String> companyIds, IHandler<List<OrgUnitInfo>, List<OrgUnitInfo>> handler) throws BOSException {
        ArrayListExt<FullOrgUnitInfo, String> companys = new ArrayListExt<FullOrgUnitInfo, String>();
        FullOrgUnitCollection fullOrgs = new FullOrgUnitCollection();
        try {
            EntityViewInfo orgStructureView = new EntityViewInfo();
            orgStructureView.getSelector().add("id");
            orgStructureView.getSelector().add("number");
            orgStructureView.getSelector().add("name");
            orgStructureView.getSelector().add("isLeaf");
            orgStructureView.setFilter(new FilterInfo());
            if (!companyIds.isEmpty()) {
                orgStructureView.getFilter().getFilterItems().add(new FilterItemInfo("unit.id", companyIds, CompareType.INCLUDE));
            }
            if (orgType == null || OrgType.Company.equals((Object)orgType)) {
                orgStructureView.getFilter().appendFilterItem("unit.partFI.isBizUnit", (Object)1);
                fullOrgs = this.getCompanyInPermssion(userId, orgStructureView);
            } else if (OrgType.ProfitCenter.equals((Object)orgType)) {
                orgStructureView.getFilter().appendFilterItem("unit.partProfitCenter.isBizUnit", (Object)1);
                fullOrgs = this.getProfitCenterInPermission(userId, orgStructureView);
            } else if (OrgType.NONE.equals((Object)orgType)) {
                fullOrgs.addCollection(this.getCompanyInPermssion(userId, orgStructureView));
                fullOrgs.addCollection(this.getProfitCenterInPermission(userId, orgStructureView));
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (fullOrgs == null || fullOrgs.size() == 0) {
            return companys;
        }
        int size = fullOrgs.size();
        for (int i = 0; i < size; ++i) {
            companys.add(fullOrgs.get(i));
            if (!(companys instanceof ArrayListExt)) continue;
            companys.addCellInfo(fullOrgs.get(i).getId().toString());
        }
        return handler.exec(companys);
    }

    protected FullOrgUnitCollection getCompanyInPermssion(String userId, EntityViewInfo orgStructureView) throws BOSException, EASBizException {
        return this.dao.get(IPermission.class).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.Company, null, "rpt_report_calculate", orgStructureView);
    }

    protected FullOrgUnitCollection getProfitCenterInPermission(String userId, EntityViewInfo orgStructureView) throws BOSException, EASBizException {
        return this.dao.get(IPermission.class).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.ProfitCenter, null, "prof_rpt_update", orgStructureView);
    }

    public void check(String userId, OrgType orgType, List<OrgUnitInfo> companys) throws BOSException, CheckValidException {
        HashSet<String> companyIds = new HashSet<String>(companys.size());
        for (OrgUnitInfo company : companys) {
            companyIds.add(company.getId().toString());
        }
        if (companyIds.isEmpty()) {
            return;
        }
        List<OrgUnitInfo> permissionCompanys = this.exec(userId, orgType, companyIds, new RetainBusinessCompany(this.dao));
        HashSet<String> permissionCompanyIds = new HashSet<String>(permissionCompanys.size());
        for (OrgUnitInfo checkedCompany : permissionCompanys) {
            permissionCompanyIds.add(checkedCompany.getId().toString());
        }
        ArrayList<CheckValidException> exceptions = new ArrayList<CheckValidException>();
        for (OrgUnitInfo checkedCompany : companys) {
            if (permissionCompanyIds.contains(checkedCompany.getId().toString())) continue;
            exceptions.add(new CheckValidException("company.permission.calculateReport.false", checkedCompany));
        }
        if (!exceptions.isEmpty()) {
            throw new CombineCheckValidException(exceptions);
        }
    }

    public static class RetainBusinessCompany
    implements ITailHandler<List<OrgUnitInfo>> {
        protected DBHandler dao;

        public RetainBusinessCompany(DBHandler dao) {
            this.dao = dao;
        }

        @Override
        public List<OrgUnitInfo> exec(List<OrgUnitInfo> beforeCompanys) throws BOSException {
            ArrayList<OrgUnitInfo> afterCompanys = new ArrayList<OrgUnitInfo>(beforeCompanys.size());
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add("id");
            view.getSelector().add("number");
            view.getSelector().add("name");
            view.getSelector().add("isCompanyOrgUnit");
            view.getSelector().add("isProfitOrgUnit");
            view.getSelector().add("orgTypeStr");
            HashSet<Object> idSet = new HashSet<Object>();
            if (beforeCompanys instanceof ArrayListExt) {
                idSet.addAll(((ArrayListExt)beforeCompanys).getCellInfos());
            } else {
                for (OrgUnitInfo company : beforeCompanys) {
                    idSet.add(company.getId().toString());
                }
            }
            view.setFilter(new FilterInfo());
            view.getFilter().appendFilterItem("partFI.isBizUnit", (Object)1);
            view.getFilter().appendFilterItem("partProfitCenter.isBizUnit", (Object)1);
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.getFilter().setMaskString(" ( #0 or #1 ) and #2 ");
            FullOrgUnitCollection companys = this.dao.get(IFullOrgUnit.class).getFullOrgUnitCollection(view);
            Integer isBizUnit = new Integer(1);
            int size = companys.size();
            for (int i = 0; i < size; ++i) {
                companys.get(i).put("isBizUnit", (Object)isBizUnit);
                afterCompanys.add((OrgUnitInfo)companys.get(i));
            }
            return afterCompanys;
        }
    }

    public static class SortCompanyByNumber
    implements ITailHandler<List<OrgUnitInfo>> {
        @Override
        public List<OrgUnitInfo> exec(List<OrgUnitInfo> beforeCompanys) {
            Comparator<OrgUnitInfo> comparator = new Comparator<OrgUnitInfo>(){

                @Override
                public int compare(OrgUnitInfo o1, OrgUnitInfo o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            };
            Collections.sort(beforeCompanys, (Comparator)comparator);
            return beforeCompanys;
        }
    }
}

