/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.ILogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.DateUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.sql.Timestamp;

public class ReadyLogTask
implements ILogTask {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ReadyLogTask.class);
    private String executeTaskId;
    private FormulaCalcContextInfo calcContext;
    private IFormulaCalcLog formulaCalcLogDao;
    private DBHandler dao;

    @Override
    public void run() {
        LOG.debug("ready...");
        try {
            this.deleteAllLog();
            FormulaCalcLogInfo readyLog = new FormulaCalcLogInfo();
            readyLog.setExecuteTaskId(this.executeTaskId);
            readyLog.setContext(this.calcContext);
            readyLog.setStatus(FormulaCalcLogStatus.READY);
            Timestamp readyTime = new Timestamp(System.currentTimeMillis());
            readyLog.setCreateTime(readyTime);
            readyLog.setLastUpdateTime(readyTime);
            int[] yearPeriod = DateUtil.getCurrentYearPeriod(this.calcContext.getPeriodType(), null, this.calcContext.getOffYear(), this.calcContext.getOffPeriod());
            readyLog.setYear(yearPeriod[0]);
            readyLog.setPeriod(yearPeriod[1]);
            this.formulaCalcLogDao.addnew(readyLog);
        }
        catch (EASBizException e) {
            LOG.error("", e);
            return;
        }
        catch (BOSException e) {
            LOG.error("", e);
            return;
        }
    }

    public IObjectPK[] deleteAllLog() throws EASBizException, BOSException {
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append(" delete from t_csl_formulaCalcLog where fContextId = ? ");
        this.dao.getExecuteSQL().execute(deleteSql.toString(), new Object[]{this.calcContext.getId().toString()});
        return null;
    }

    public void setParams(String executeTaskId, FormulaCalcContextInfo calcContext, IFormulaCalcLog formulaCalcLogDao, DBHandler dao) {
        this.executeTaskId = executeTaskId;
        this.calcContext = calcContext;
        this.formulaCalcLogDao = formulaCalcLogDao;
        this.dao = dao;
    }
}

