/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.NeedSelectorForFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.TemplateAndCompany;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.ReportEntityForReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcuateAndFillCellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FindValueFormulaWithoutItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.GetCalcContextFromReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.CreateEmptyReportByTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.FillElimSheetAndValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.FillNormalSheetAndValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.FillSheetAndValueFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.IFillSheetAndValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.NewReportParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.GetNewVersionTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QuerySheetParams;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.dynamic.fill.ClearUpBook;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;

public class CreateReportByFormulaCalcContext {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CreateReportByFormulaCalcContext.class);
    private DBHandler dao;

    public CreateReportByFormulaCalcContext(DBHandler dao) {
        this.dao = dao;
    }

    @Deprecated
    public ReportCollection exec(FormulaCalcContextInfo calcContext) throws EASBizException, BOSException {
        LOG.debug("Start Create Report");
        ReportCollection reports = new ReportCollection();
        TemplateInfo template = null;
        ReportInfo report = null;
        TemplateInfo newVersionTemplate = null;
        GetNewVersionTemplate getNewVersionTemplate = new GetNewVersionTemplate(this.dao);
        TemplateAndCompany templateAndCompany2 = null;
        StringBuffer error = new StringBuffer();
        for (TemplateAndCompany templateAndCompany2 : calcContext) {
            template = templateAndCompany2.getTemplate();
            LOG.info("The Template is Ready:{0}({1})", new Object[]{template.getName(), template.getId().toString()});
            FullOrgUnitInfo company = templateAndCompany2.getCompany();
            newVersionTemplate = getNewVersionTemplate.exec(template, (OrgUnitInfo)company, new NeedSelectorForFormulaCalcContext().template());
            if (newVersionTemplate == null) {
                LOG.error("query non for the lastest version template :{0}({1})", new Object[]{template.getName(), template.getId()});
                newVersionTemplate = template;
            }
            if (newVersionTemplate.isIsFreezed()) {
                error.append(MessageFormat.format(ResourceDebugUtil.res("template.have.been.freezed.with.format"), newVersionTemplate.getName(), newVersionTemplate.getNumber()));
                error.append(';');
                continue;
            }
            report = this.exec(calcContext, newVersionTemplate, (OrgUnitInfo)company);
            reports.add(report);
        }
        if (error.length() > 0) {
            throw new BOSException(error.toString());
        }
        LOG.info("The Report Number Which is Ready{0}", new Object[]{reports.size()});
        return reports;
    }

    public ReportInfo exec(FormulaCalcContextInfo calcContext, TemplateInfo template, OrgUnitInfo company) throws EASBizException, BOSException {
        Book book;
        int year = calcContext.getYear();
        int period = calcContext.getPeriod();
        NewReportParam reportParam = new NewReportParam(template, year, period, calcContext.getCurrentCurrency(), company, calcContext.getLastUpdateUser(), calcContext.getOrgType());
        CreateEmptyReportByTemplate createEmptyReportByTemplate = new CreateEmptyReportByTemplate(this.dao);
        QuerySheetParams querySheetParams = new QuerySheetParams(this.dao);
        HashMap<AutoItemItemFormula, Cell> itemFormulas = new HashMap(0);
        ReportInfo report = createEmptyReportByTemplate.exec(reportParam);
        if (report == null) {
            LOG.info("Company{0}'sReport(Template:{1})AddFailed", new Object[]{company, template});
            throw new AutoItemException(AutoItemException.FAIL_TO_CREATE_REPORT, new Object[]{MessageFormat.format(ResourceDebugUtil.res("unknown.error.with.format"), company, template)});
        }
        if (report.containsKey("existedReport") && AuditedStatusEnum.AUDITED.equals((Object)report.getAuditedStatus())) {
            LOG.info("The report is audited!Please use the original one");
            return report;
        }
        LOG.info("CreatedReport:{0}({1})", new Object[]{report.getName(), report.getId().toString()});
        ReportEntityForReport reportEntity = new ReportEntityForReport(report, querySheetParams);
        try {
            book = report.getBook();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        book.getUndoManager().enable(false);
        book.setAutoCalculate(false);
        ClearUpBook clearUpBook = new ClearUpBook(book, false);
        CompanyOrgUnitInfo delegateCompany = MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(company, this.dao.getContext());
        CalcContext newCalcContext = ActionFactory.get(GetCalcContextFromReport.class).exec(report);
        FindValueFormulaWithoutItemFormula find = ActionFactory.get(FindValueFormulaWithoutItemFormula.class);
        CalcuateAndFillCellFormula calculateAndFill = new CalcuateAndFillCellFormula(this.dao);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            IFillSheetAndValue fillSheetAndValue = FillSheetAndValueFactory.get(reportEntity, sheet, this.dao);
            itemFormulas.clear();
            if (!(report.containsKey("existedReport") && fillSheetAndValue instanceof FillNormalSheetAndValue || !(fillSheetAndValue instanceof FillElimSheetAndValue) && DynaEnumRptTypeEnum.FIXED.equals((Object)template.getDynaRptType()))) {
                itemFormulas = fillSheetAndValue.buildFillSheetHandler().exec(calcContext, (OrgUnitInfo)delegateCompany, reportEntity, sheet);
            }
            if (itemFormulas.isEmpty()) {
                itemFormulas = fillSheetAndValue.buildFindItemFormula().exec(sheet, this.dao);
            }
            fillSheetAndValue.buildFillValueHandler().exec(new ItemContext(company, calcContext.getCurrentCurrency(), calcContext.getPeriodType(), calcContext.getYear(), calcContext.getPeriod()), itemFormulas, false, calcContext.getOrgType());
            if (fillSheetAndValue instanceof FillElimSheetAndValue) {
                try {
                    clearUpBook.removeZeroRowAndFillDigit(sheet);
                }
                catch (Exception e) {
                    LOG.error("", e);
                }
            } else if (template.getDynaRptType() != null) {
                sheet.setUserObject("calculateed", (Object)"Y");
                clearUpBook.removeZeroDynamicRow(sheet, report.getReportSourceType(), true);
            }
            if (fillSheetAndValue instanceof FillElimSheetAndValue) continue;
            Collection<CellFormula> valueFormulas = find.exec(sheet);
            calculateAndFill.exec(valueFormulas, newCalcContext);
        }
        try {
            report.setBook(book);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return report;
    }
}

