/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AssistGetFormulaResult;
import com.kingdee.eas.fi.gr.cslrpt.IAutoItemBusinessFacade;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcContextHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.InvokeFormulaExecutor;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.CalculateExcelFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public class CalculateFormula {
    private static final ILog LOG = LogFactory.getLog("AUTO_ITEM", CalculateFormula.class);
    protected CalcContext calcContext;
    protected InvokeFormulaExecutor executor;

    public CalculateFormula(CalcContext calcContext) throws EASBizException, BOSException {
        this.calcContext = calcContext;
        this.setExecutor(new InvokeFormulaExecutor());
    }

    public CalculateFormula(CalcContext calcContext, InvokeFormulaExecutor executor) throws EASBizException, BOSException {
        this.calcContext = calcContext;
        this.setExecutor(executor);
    }

    public void calc(Context serverContext, Map<String, SortedParameterArray> methods) {
        Map<String, SortedParameterArray> excelMethods = this.removeExcelFormulaFrom(methods);
        if (serverContext != null) {
            CalcContextHandler calContext = new CalcContextHandler(serverContext, this.calcContext);
            try {
                this.executor.exec(methods, calContext);
            }
            catch (BOSException e) {
                LOG.error("", e);
            }
        } else {
            try {
                byte[] methodData = new DBHandler(null).get(IAutoItemBusinessFacade.class).executeFormula(methods, this.calcContext);
                AssistGetFormulaResult get = new AssistGetFormulaResult();
                get.unserial(methodData, methods);
            }
            catch (EASBizException e) {
                LOG.error("", e);
            }
            catch (BOSException e) {
                LOG.error("", e);
            }
        }
        this.calculateExcelFormula(excelMethods);
    }

    public void setExecutor(InvokeFormulaExecutor executor) {
        this.executor = executor;
    }

    public Map<String, SortedParameterArray> removeExcelFormulaFrom(Map<String, SortedParameterArray> methods) {
        HashMap<String, SortedParameterArray> excelMethods = new HashMap<String, SortedParameterArray>();
        for (String name : methods.keySet()) {
            if (!CalculateExcelFormula.isExcelFormula(name)) continue;
            excelMethods.put(name, methods.get(name));
        }
        return excelMethods;
    }

    public void calculateExcelFormula(Map<String, SortedParameterArray> excelMethods) {
        CalculateExcelFormula excelAction = ActionFactory.get(CalculateExcelFormula.class);
        excelAction.exec(excelMethods);
    }
}

