/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.DItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemKeyTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryDItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemSource;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValueSet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.ExecuteSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DItemDao
implements IItemDao {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", DItemDao.class);
    protected DBHandler dao;

    public DItemDao(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public void saveItemData(ItemSource itemSource, int calcLevelInOneProcess, OrgType orgType) throws BOSException {
        LOG.info("start save ditem's data:{0}", new Object[]{itemSource});
        DItemQueryUnit rptQueryInfo = new DItemQueryUnit(itemSource.getCompany(), null, null, itemSource.getYear(), itemSource.getPeriod(), itemSource.getPeriodType(), itemSource.getDataElement(), itemSource.getValueType(), itemSource.getCurrency(), null);
        Collection<ItemSource> existedItemSources = new QueryDItem(this.dao).queryItemSource(rptQueryInfo);
        ExecuteSQL executeSQL = this.dao.getExecuteSQL();
        boolean needNewItemData = true;
        if (existedItemSources.isEmpty()) {
            this.newItemData(itemSource, executeSQL, orgType);
        } else {
            boolean mustReturn = false;
            for (ItemSource existedItemSource : existedItemSources) {
                BOSUuid oldCtxId;
                if (existedItemSource.getSourceType() instanceof ReportBaseInfo) {
                    LOG.info("repeat item context(type:{2},id:{0},entryid:{1}) be found!it will be deleted", new Object[]{existedItemSource.getId(), existedItemSource.getEntrys(), IItemSourceType.SOURCE_TYPE_REPORT});
                    this.excludeItemValues(existedItemSource, itemSource);
                    if (!itemSource.getItemValues().isEmpty()) continue;
                    mustReturn = true;
                    continue;
                }
                if (existedItemSource == null || !(existedItemSource.getSourceType() instanceof FormulaCalcContextInfo) || (oldCtxId = ((FormulaCalcContextInfo)existedItemSource.getSourceType()).getItemSourceId()) == null) continue;
                if (itemSource.getSourceType().getItemSourceType() == 100 && oldCtxId.equals((Object)itemSource.getSourceType().getItemSourceId())) {
                    LOG.info("repeat ditem context(type:{2},id:{0},entryid:{1}) be found!it will be deleted", new Object[]{existedItemSource.getId(), existedItemSource.getEntrys(), 100});
                    itemSource.setId(existedItemSource.getId());
                    needNewItemData = false;
                    if (calcLevelInOneProcess > 1) continue;
                    this.deleteItemValues(existedItemSource, itemSource, true);
                    continue;
                }
                this.deleteItemValues(existedItemSource, itemSource, false);
            }
            if (mustReturn) {
                return;
            }
            if (needNewItemData) {
                this.newItemData(itemSource, executeSQL, orgType);
            }
        }
        String insertItemDataEntry = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/insertDItemDataEntry.sql");
        String entryId = null;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(itemSource.getItemValues().size());
        for (ItemValue itemValue : itemSource.getItemValues()) {
            BigDecimal result = itemValue.getResult() instanceof BigDecimal ? (BigDecimal)itemValue.getResult() : (itemValue.getResult() instanceof Number ? new BigDecimal(((Number)itemValue.getResult()).doubleValue()) : new BigDecimal("0"));
            entryId = Uuid.create().toString();
            Object[] params = new Object[]{entryId, itemSource.getId(), itemValue.getNumber(), itemValue.getDynaItem(), itemValue.getDynaItemName() == null ? itemValue.getDynaItem() : itemValue.getDynaItemName(), itemSource.getDataElement(), itemSource.getValueType().getValue(), itemSource.getYear(), itemSource.getPeriod(), result, itemValue.getDynaGradeInfo() != null ? itemValue.getDynaGradeInfo().getGradeNumber() : null, itemValue.getDynaGradeInfo() != null ? itemValue.getDynaGradeInfo().isGradeLeaf() : false};
            paramsList.add(params);
        }
        executeSQL.executeBatchAndReturn(insertItemDataEntry.toString(), paramsList);
    }

    protected void newItemData(ItemSource itemSource, ExecuteSQL executeSQL, OrgType orgType) throws BOSException {
        String insertItemData = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/insertDItemData.sql");
        itemSource.setId(Uuid.create().toString());
        executeSQL.execute(insertItemData, new Object[]{itemSource.getId(), itemSource.getCompany().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getPeriodType().getValue(), orgType.getValue(), 100, itemSource.getSourceType().getItemSourceId().toString(), new Integer(1), itemSource.getCompany().getId().toString(), 0, "ACTUALDATA", 1});
    }

    @Override
    public void saveItemValue(ItemSource itemSource, Map<String, ItemKeyTable> itemKeyTable, int calcLevelInOneProcess) throws BOSException {
        LOG.info("start save ditem's value:{0}", new Object[]{itemSource});
    }

    @Override
    public void deleteItemSource(ItemSource itemSource, int calcLevelInOneProcess) throws BOSException {
        String deleteItemValueFormatSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/deleteDItemValueWithFormat.sql");
        String deleteItemValueSql = null;
        HashSet<String> deleteIds = new HashSet<String>(1);
        deleteIds.addAll(itemSource.getEntrys().keySet());
        LOG.info("delete item context.ids:{0}", new Object[]{deleteIds});
        deleteItemValueSql = new MessageFormat(deleteItemValueFormatSql).format(new Object[]{StringUtil.toSql(deleteIds, true)});
        LOG.debug("delete item value sql is {0}", new Object[]{deleteItemValueSql});
        ExecuteSQL executeSQL = this.dao.getExecuteSQL();
        executeSQL.execute(deleteItemValueSql);
        String deleteItemData = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/deleteDItemData.sql");
        LOG.debug("delete item context sql is {0}", new Object[]{deleteItemData});
        executeSQL.execute(deleteItemData, new Object[]{itemSource.getId()});
    }

    protected void deleteItemValues(ItemSource itemSourceForDuplicItemValue, ItemSource currentItemSource, boolean deleteAllItemData) throws BOSException {
        ItemValueSet currentItemValues = currentItemSource.getItemValues();
        HashSet<String> itemValueEntrysForWantToRemove = new HashSet<String>(currentItemValues.size());
        for (ItemValue existedItemValue : itemSourceForDuplicItemValue.getItemValues()) {
            if (deleteAllItemData) {
                itemValueEntrysForWantToRemove.add(existedItemValue.getItemDataEntryId());
                continue;
            }
            for (ItemValue currentItemValue : currentItemValues) {
                if (!currentItemValue.getNumber().equals(existedItemValue.getNumber()) || !currentItemValue.getDynaItem().equals(existedItemValue.getDynaItem())) continue;
                itemValueEntrysForWantToRemove.add(existedItemValue.getItemDataEntryId());
            }
        }
        if (itemValueEntrysForWantToRemove.isEmpty()) {
            return;
        }
        ExecuteSQL executeSql = this.dao.getExecuteSQL();
        executeSql.execute(" delete from t_CSL_DynaItemDataEntry where Fid in(" + StringUtil.toSql(itemValueEntrysForWantToRemove, true, ",", null) + ")");
    }

    private void excludeItemValues(ItemSource itemSourceForDuplicItemValue, ItemSource currentItemSource) {
        ItemValueSet currentItemValues = currentItemSource.getItemValues();
        for (ItemValue existedItemValue : itemSourceForDuplicItemValue.getItemValues()) {
            Iterator it = currentItemValues.iterator();
            while (it.hasNext()) {
                ItemValue currentItemValue = (ItemValue)it.next();
                if (!currentItemValue.getNumber().equals(existedItemValue.getNumber()) || !currentItemValue.getDynaItem().equals(existedItemValue.getDynaItem())) continue;
                it.remove();
            }
        }
    }
}

