/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgTypeForEntityEnum;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ConvertAsstActObjects;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.GetInnerCompany;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.GetInvestCompany;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryAsstType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class QueryAsstData {
    private static final ILog LOG = LogFactory.getLog("AUTO_ITEM", QueryAsstData.class);
    protected DBHandler dao;
    protected OrgUnitInfo company;
    protected boolean paramIsTrue;
    protected DynaParameters param;

    public QueryAsstData(DBHandler dao, OrgUnitInfo company, DynaParameters param) throws EASBizException, BOSException {
        this.dao = dao;
        this.company = company;
        this.param = param;
        if (company.getExtendedProperty("fi_rp_004") != null) {
            this.paramIsTrue = Boolean.valueOf(company.getExtendedProperty("fi_rp_004"));
        } else {
            CtrlUnitInfo cu = company.getCU();
            if (cu != null) {
                this.paramIsTrue = RptUtil.isTrue((Object)dao.get(IParamControl.class).getParamValue((IObjectPK)new ObjectUuidPK(cu.getId()), "fi_rp_004"));
            }
        }
    }

    public List<AsstActObject> exec(String assistNum) throws EASBizException, BOSException {
        return this.exec(assistNum, new HashSet<String>(0));
    }

    public List<AsstActObject> exec(String assistNum, Collection<String> asstObjNumbers) throws EASBizException, BOSException {
        if ("INNER_COMPANY".equals(assistNum)) {
            List<CompanyOrgUnitInfo> companys = new GetInnerCompany(this.dao).exec(this.company.getId().toString(), false, asstObjNumbers);
            return ActionFactory.get(ConvertAsstActObjects.class).exec(companys);
        }
        if ("R_COMPANY".equals(assistNum)) {
            List<CompanyOrgUnitInfo> companys = new GetInvestCompany(this.dao).exec(this.company.getId().toString(), asstObjNumbers);
            return ActionFactory.get(ConvertAsstActObjects.class).exec(companys);
        }
        AsstActTypeInfo asstType = new QueryAsstType(this.dao).query(this.company, assistNum);
        if (asstType == null) {
            LOG.error("assist type number {0} is not be defined!return empty assist objects.", new Object[]{assistNum});
            return new ArrayList<AsstActObject>(0);
        }
        IMetaDataPK queryPK = this.getQueryPK(false, asstType);
        IQueryExecutor exec = this.getQueryExecutor(queryPK, OrgTypeForEntityEnum.NULL, asstType);
        FilterInfo otherFilter = new FilterInfo();
        if (!asstObjNumbers.isEmpty()) {
            String numberFieldName = this.getAsstObjFieldNameForDItem(asstType);
            String mappingFieldName = asstType.getAsstHGAttribute();
            if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider") || mappingFieldName.equals("material")) {
                HashSet<String> newNumbers = new HashSet<String>(asstObjNumbers.size());
                Iterator<String> it = asstObjNumbers.iterator();
                while (it.hasNext()) {
                    String longNumber = it.next();
                    longNumber = longNumber.replaceAll("(.*\\!)([^!]+)", "$2");
                    it.remove();
                    newNumbers.add(longNumber);
                }
                asstObjNumbers = newNumbers;
            }
            otherFilter.getFilterItems().add(new FilterItemInfo(numberFieldName, new HashSet<String>(asstObjNumbers), CompareType.INCLUDE));
        }
        return this.getFillData(exec, queryPK, asstType, otherFilter);
    }

    private String getAsstObjFieldNameForDItem(AsstActTypeInfo asstType) {
        String mappingFieldName = asstType.getAsstHGAttribute();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider") || mappingFieldName.equals("material")) {
            return "number";
        }
        boolean isMulti = this.isMultiLevel(asstType);
        if ("INNER_COMPANY".equals(asstType.getNumber()) || "R_COMPANY".equals(asstType.getNumber())) {
            return "id";
        }
        return isMulti ? "longNumber" : "number";
    }

    public IMetaDataPK getQueryPK(boolean isShowAssistant, AsstActTypeInfo asstActTypeInfo) throws EASBizException, BOSException {
        String mappingFieldName = asstActTypeInfo.getAsstHGAttribute();
        String defaultQueryName = asstActTypeInfo.getDefaultQueryName();
        if ("companyOrg".equals(mappingFieldName) && isShowAssistant) {
            defaultQueryName = "com.kingdee.eas.fi.gr.dynamic.app.CompanyOrgUnit4AsstAcctQuery";
        }
        if (!this.paramIsTrue) {
            if (mappingFieldName.equals("customer")) {
                defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7CustomerQuery";
            } else if (mappingFieldName.equals("provider")) {
                defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7SupplierQuery";
            } else if (mappingFieldName.equals("material")) {
                defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7MaterialQuery";
            }
        }
        if (mappingFieldName.equals("person")) {
            defaultQueryName = "com.kingdee.eas.fi.gr.dynamic.app.AllPositionPersonQuery";
        }
        MetaDataPK queryPK = MetaDataPK.create((String)defaultQueryName);
        return queryPK;
    }

    public IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, OrgTypeForEntityEnum currentOrgType, AsstActTypeInfo asstActTypeInfo) throws EASBizException, BOSException {
        String mappingFieldName = asstActTypeInfo.getAsstHGAttribute();
        boolean isSelfAsstActaiatem = asstActTypeInfo.isIsSelfAsstActaiatem();
        EntityViewInfo view = this.buildSearchView(asstActTypeInfo, this.paramIsTrue);
        if ("companyOrg".equals(mappingFieldName)) {
            if (null == view.getFilter()) {
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
            }
            this.addOrgFilter(view, currentOrgType);
        }
        IQueryExecutor exec = null;
        exec = this.dao.getContext() == null || this.dao.getContext().get((Object)"isBVTTestCase") != null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK) : QueryExecutorFactory.getLocalInstance((Context)this.dao.getContext(), (IMetaDataPK)queryPK);
        SelectorItemCollection scoll = new SelectorItemCollection();
        scoll.add(new SelectorItemInfo("id"));
        view.setSelector(scoll);
        exec.setObjectView(view);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        if (mappingFieldName.equals("adminOrg") || mappingFieldName.equals("companyOrg") || mappingFieldName.equals("costOrg") || mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg") || isSelfAsstActaiatem) {
            exec.option().isIgnorePermissionCheck = true;
        }
        return exec;
    }

    public EntityViewInfo buildSearchView(AsstActTypeInfo info, boolean paramIsTrue) throws EASBizException, BOSException {
        String mappingFieldName = info.getAsstHGAttribute();
        boolean isSelfAsstActaiatem = info.isIsSelfAsstActaiatem();
        if (mappingFieldName.equals("customer")) {
            return this.buildCustomerView(info);
        }
        if (mappingFieldName.equals("provider")) {
            return this.buildProviderView();
        }
        if (mappingFieldName.equals("bankAccount")) {
            return this.buildAccountBankView();
        }
        if (mappingFieldName.equals("companyOrg") || mappingFieldName.equals("costOrg") || mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg")) {
            EntityViewInfo view = new EntityViewInfo();
            if (mappingFieldName.equalsIgnoreCase("costOrg")) {
                this.buildCostOrgView(view);
            }
            return view;
        }
        if (mappingFieldName.equals("adminOrg")) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
            return view;
        }
        if (mappingFieldName.equals("person")) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            if (paramIsTrue) {
                filter.getFilterItems().add(new FilterItemInfo("cu2.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
            }
            return view;
        }
        if (isSelfAsstActaiatem) {
            EntityViewInfo view = new EntityViewInfo();
            if (paramIsTrue && !"00000000-0000-0000-0000-000000000000CCE7AED4".equals(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString())) {
                this.addCUConditions(mappingFieldName, view, "CurProject");
            }
            return view;
        }
        if (mappingFieldName.equalsIgnoreCase("costObject")) {
            EntityViewInfo view = new EntityViewInfo();
            if (paramIsTrue) {
                this.addCUConditions(mappingFieldName, view, "costObject");
            }
            return view;
        }
        if (mappingFieldName.equals("material")) {
            return this.buildMateralView();
        }
        if (mappingFieldName.equals("project")) {
            EntityViewInfo view = new EntityViewInfo();
            OrgUnitInfo currentBizOrg = this.company;
            CtrlUnitInfo cu = this.company.getCU();
            if (currentBizOrg != null && cu != null && paramIsTrue) {
                String longNumber = this.dao.get(ICtrlUnit.class).getOrgUnitInfo("select longNumber where id = '" + cu.getId().toString() + "'").getLongNumber();
                String[] numbers = longNumber.split("!");
                HashSet<String> lnUps = new HashSet<String>();
                for (int i = 0; i < numbers.length; ++i) {
                    lnUps.add(numbers[i]);
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("cu.number", lnUps, CompareType.INCLUDE));
                filter.setMaskString("#0");
                view.setFilter(filter);
            }
            return view;
        }
        String groupId = info.getGlAsstActTypeGrp() != null ? info.getGlAsstActTypeGrp().getId().toString() : null;
        EntityViewInfo view = new EntityViewInfo();
        String maskString = "";
        FilterInfo filter = new FilterInfo();
        if (info.isIsSelfAsstActaiatem() || !StringUtils.isEmpty((String)groupId)) {
            CompanyOrgUnitInfo orgUnitInfo = (CompanyOrgUnitInfo)this.company;
            filter = DynamicTemplateUtility.getFilterForGeneral((Context)this.dao.getContext(), (String)groupId, (CompanyOrgUnitInfo)orgUnitInfo);
        } else {
            CtrlUnitInfo curCU = SysContext.getSysContext().getCurrentCtrlUnit();
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)curCU.getId().toString(), CompareType.EQUALS));
            filter.setMaskString(" #0 or #1 or #2 ");
        }
        if ("T_BD_GeneralAsstActType".equalsIgnoreCase(info.getRealtionDataObject()) && (this.param.getDynaItemSource() == 0 && this.param.isGrade() || this.param.getDynaItemSource() == 1 && !this.param.isGrade())) {
            maskString = filter.getMaskString();
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1), CompareType.EQUALS));
            maskString = "(" + maskString + ") and #" + (filter.getFilterItems().size() - 1);
            filter.setMaskString(maskString);
        }
        view.setFilter(filter);
        return view;
    }

    private EntityViewInfo buildProviderView() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        if (!this.paramIsTrue) {
            return view;
        }
        ObjectUuidPK cuPK = new ObjectUuidPK(this.company.getCU().getId());
        FilterInfo filter = ((IDataBaseD)this.dao.get(ISupplier.class)).getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        String maskString = filter.getMaskString();
        if (StringUtils.isEmpty((String)maskString)) {
            maskString = "";
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                if (i != 0) {
                    maskString = maskString + " and ";
                }
                maskString = maskString + "#" + i;
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        maskString = "(" + maskString + ") and #" + (filter.getFilterItems().size() - 1);
        filter.getFilterItems().add(new FilterItemInfo("supplierGroupDetails.supplierGroupStandard.type", (Object)0));
        maskString = "(" + maskString + ") and (#" + (filter.getFilterItems().size() - 1);
        filter.getFilterItems().add(new FilterItemInfo("supplierGroupDetails.supplierGroupStandard.type", (Object)2));
        maskString = maskString + " or #" + (filter.getFilterItems().size() - 1) + ")";
        filter.getFilterItems().add(new FilterItemInfo("supplierGroupDetails.supplierGroupStandard.isBasic", (Object)1));
        maskString = "(" + maskString + ") and #" + (filter.getFilterItems().size() - 1);
        filter.setMaskString(maskString);
        if (filter != null && filter.getFilterItems().size() > 0) {
            view.setFilter(filter);
        }
        return view;
    }

    private EntityViewInfo buildCustomerView(AsstActTypeInfo info) throws EASBizException, BOSException {
        FilterInfo orgFilter;
        EntityViewInfo view = new EntityViewInfo();
        if (!this.paramIsTrue) {
            return view;
        }
        OrgUnitInfo currentBizOrg = this.company;
        CtrlUnitInfo cu = this.company.getCU();
        if (currentBizOrg != null && cu != null && (orgFilter = RptUtil.buildCustomerFilter((Context)this.dao.getContext(), (OrgUnitInfo)currentBizOrg, (boolean)false)) != null && orgFilter.getFilterItems().size() > 0) {
            view.setFilter(orgFilter);
        }
        return view;
    }

    private EntityViewInfo buildAccountBankView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String companyid = this.company.getId().toString();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)companyid));
        fic.add(new FilterItemInfo("company.id", null));
        filter.setMaskString("#0 OR #1  ");
        return view;
    }

    private void buildCostOrgView(EntityViewInfo view) throws EASBizException, BOSException {
        if (this.paramIsTrue) {
            CompanyOrgUnitInfo orgUnitInfo = (CompanyOrgUnitInfo)this.company;
            String curOrgCU = null;
            String longNumber = null;
            if (orgUnitInfo == null || orgUnitInfo.getCU() == null) {
                orgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
                curOrgCU = this.getCurOrgCU(orgUnitInfo);
            } else {
                curOrgCU = this.getCurOrgCU(orgUnitInfo);
            }
            boolean isBizUnit = orgUnitInfo.isIsBizUnit();
            longNumber = isBizUnit ? orgUnitInfo.getLongNumber() : orgUnitInfo.getCU().getLongNumber();
            HashSet<String> CostOrgIds = new HashSet<String>();
            if (orgUnitInfo.isIsBizUnit()) {
                CostOrgIds.add(curOrgCU);
            } else {
                this.getCurCUCostOrgs(curOrgCU, CostOrgIds);
            }
            this.getFromCostOrgs(curOrgCU, CostOrgIds);
            if (CostOrgIds.size() <= 0) {
                CostOrgIds.add(orgUnitInfo.getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", CostOrgIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filter.setMaskString("( #0 OR #1 )");
            view.setFilter(filter);
        }
    }

    private void addCUConditions(String mappingFieldName, EntityViewInfo view, String specialItem) {
        if (specialItem.equalsIgnoreCase(mappingFieldName)) {
            FilterInfo filter = view.getFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            view.setFilter(filter);
            String currentBizOrgID = this.company.getId().toString();
            if (!specialItem.equalsIgnoreCase("costObject")) {
                filter.getFilterItems().add(new FilterItemInfo("Fullorgunit.id", (Object)currentBizOrgID));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentBizOrgID));
            }
        }
    }

    private EntityViewInfo buildMateralView() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        if (!this.paramIsTrue) {
            return view;
        }
        CtrlUnitInfo currentBizOrg = this.company.getCU();
        ObjectUuidPK cuPK = new ObjectUuidPK(currentBizOrg.getId());
        FilterInfo filter = ((IDataBaseD)this.dao.get(IMaterial.class)).getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        if (filter != null && filter.getFilterItems().size() > 0) {
            view.setFilter(filter);
        }
        return view;
    }

    private String getCurOrgCU(CompanyOrgUnitInfo orgUnitInfo) {
        String curOrgCU = null;
        boolean isBizUnit = orgUnitInfo.isIsBizUnit();
        curOrgCU = isBizUnit ? orgUnitInfo.getId().toString() : orgUnitInfo.getCU().getId().toString();
        return curOrgCU;
    }

    private void getCurCUCostOrgs(String curOrgCU, Set<String> CostOrgIds) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer("#0");
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)curOrgCU));
        filter.getFilterItems().add(new FilterItemInfo("iscostOrgUnit", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isAssistantOrg", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("partCostCenter.isSealUp", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("partAdmin.isVirtual", (Object)0));
        maskString.append(" and #1 and #2 and #3 and #4 and (#5 or #6)");
        filter.setMaskString(maskString.toString());
        ev.setSelector(sic);
        ev.setFilter(filter);
        FullOrgUnitCollection fullOrgUnitIds = this.dao.get(IFullOrgUnit.class).getFullOrgUnitCollection(ev);
        String orgUnitId = null;
        for (int i = 0; i < fullOrgUnitIds.size(); ++i) {
            orgUnitId = fullOrgUnitIds.get(i).getId().toString();
            if (CostOrgIds.contains(orgUnitId)) continue;
            CostOrgIds.add(orgUnitId);
        }
    }

    private void getFromCostOrgs(String curOrgCU, Set<String> CostOrgIds) throws EASBizException, BOSException {
        OrgUnitCollection orgUnitRelationCollection = this.dao.get(IOrgUnitRelation.class).getFromUnit(curOrgCU, 1, 5);
        if (orgUnitRelationCollection != null && orgUnitRelationCollection.size() > 0) {
            String orgUnitId = null;
            for (int i = 0; i < orgUnitRelationCollection.size(); ++i) {
                orgUnitId = orgUnitRelationCollection.get(i).getId().toString();
                if (CostOrgIds.contains(orgUnitId)) continue;
                CostOrgIds.add(orgUnitId);
            }
        }
    }

    private void addOrgFilter(EntityViewInfo view, OrgTypeForEntityEnum currentOrgType) {
        Integer isTrue = new Integer(1);
        if (currentOrgType.getValue() == 1) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isCompanyOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 5) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isCostOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 7) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isHROrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 6) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isProfitOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 3) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isPurchaseOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 2) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isSaleOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 4) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isStorageOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 8) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isTransportOrgUnit", (Object)isTrue));
        }
    }

    public List getFillData(IQueryExecutor exec, IMetaDataPK queryPK, AsstActTypeInfo asstActTypeInfo, FilterInfo otherFilter) throws BOSException, EASBizException {
        ArrayList list = null;
        HashSet<AsstActObject> asstActSet = null;
        QueryInfo queryInfo = this.dao.get(IMetaDataLoader.class).getQuery(queryPK);
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = null;
        if (mainObjectInfo instanceof SubEntityInfo) {
            mainEntityInfo = (SubEntityInfo)mainObjectInfo;
        }
        if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
            IDynamicObject idynaObj = this.dao.get(IDynamicObject.class);
            BOSObjectType type = mainEntityInfo.getEntityRef().getType();
            String mappingFieldName = asstActTypeInfo.getAsstHGAttribute();
            SelectorItemCollection sic = this.getSelectorItemCollection(mappingFieldName);
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().addObjectCollection((IObjectCollection)sic);
            try {
                HashSet<String> idSet = new HashSet<String>();
                IRowSet rowSet = null;
                rowSet = exec.executeQuery();
                while (rowSet.next()) {
                    idSet.add(rowSet.getString("id"));
                }
                if (!idSet.isEmpty()) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    filter.mergeFilter(otherFilter, "and");
                    ev.setFilter(filter);
                    IObjectCollection cl = idynaObj.getCollection(type, ev);
                    if (asstActSet == null) {
                        asstActSet = new HashSet<AsstActObject>();
                    }
                    this.addArrayToList(asstActSet, cl.toArray(), asstActTypeInfo);
                }
                idSet.clear();
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (asstActSet != null && !asstActSet.isEmpty()) {
            list = new ArrayList(asstActSet);
            this.sortList(list, asstActTypeInfo);
        } else {
            list = new ArrayList(0);
        }
        return list;
    }

    public SelectorItemCollection getSelectorItemCollection(String mappingFieldName) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider")) {
            sic.add(new SelectorItemInfo("browseGroup"));
        } else if (mappingFieldName.equals("material")) {
            sic.add(new SelectorItemInfo("materialGroup"));
        } else {
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("isLeaf"));
        }
        if (mappingFieldName.equals("costOrg")) {
            sic.add(new SelectorItemInfo("isBizUnit"));
        }
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    private void addArrayToList(Set<AsstActObject> asstActSet, Object[] objects, AsstActTypeInfo info) throws EASBizException, BOSException {
        boolean isSelfAsstActaiatem;
        String mappingFieldName = info.getAsstHGAttribute();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider") || mappingFieldName.equals("material")) {
            this.addArrayToList2(asstActSet, objects, info);
            return;
        }
        boolean isMulti = info.isIsMultilevel();
        String realType = info.getRealtionDataObject();
        boolean bl = isSelfAsstActaiatem = realType != null && (realType.equalsIgnoreCase("T_BD_GeneralAsstActType") || realType.equalsIgnoreCase("T_FDC_CurProject"));
        if (!StringUtils.isEmpty((String)info.getGroupTableName())) {
            isMulti = false;
        }
        boolean isLeaf = true;
        for (int i = 0; i < objects.length; ++i) {
            DataBaseInfo obj = (DataBaseInfo)objects[i];
            String id = obj.getId().toString();
            String number = obj.getNumber();
            String longNumber = null;
            isLeaf = true;
            if (isMulti) {
                longNumber = ((TreeBaseInfo)obj).getLongNumber();
                isLeaf = ((TreeBaseInfo)obj).isIsLeaf();
            }
            if (isMulti && isSelfAsstActaiatem) {
                number = number == null || number.trim().equals("") ? number : (longNumber != null ? longNumber.replaceAll("!", ".") : "");
            }
            String name = obj.getName();
            AsstActObject asstActObj = new AsstActObject(id, number, longNumber, name, isMulti, isLeaf);
            if (mappingFieldName.equals("costOrg")) {
                asstActObj.setBizUnit(obj.getBoolean("isBizUnit"));
            }
            if (!this.canAdd(asstActObj)) continue;
            asstActSet.add(asstActObj);
        }
    }

    private void addArrayToList2(Set asstActSet, Object[] objects, AsstActTypeInfo info) throws EASBizException, BOSException {
        String oql;
        String mappingFieldName = info.getAsstHGAttribute();
        DataBaseCollection col = null;
        boolean isMulti = false;
        ICSSPGroup csspGroupDao = this.dao.get(ICSSPGroup.class);
        if (mappingFieldName.equals("customer")) {
            isMulti = true;
            oql = "select id, number, name, longNumber, parent where deletedStatus = 1 and groupStandard.type in (0, 1)";
            col = csspGroupDao.getDataBaseCollection(oql);
        } else if (mappingFieldName.equals("provider")) {
            isMulti = true;
            oql = "select id, number, name, longNumber, parent where deletedStatus = 1 and groupStandard.type in (0, 2)";
            col = csspGroupDao.getDataBaseCollection(oql);
        } else if (mappingFieldName.equals("material")) {
            isMulti = true;
            oql = "select id, number, name, longNumber, parent where deletedStatus = 1";
            col = csspGroupDao.getDataBaseCollection(oql);
        }
        if (col == null) {
            return;
        }
        HashMap<String, DataBaseInfo> csspCache = new HashMap<String, DataBaseInfo>(col.size());
        DataBaseInfo group = null;
        for (int i = 0; i < col.size(); ++i) {
            group = col.get(i);
            csspCache.put(group.getId().toString(), group);
        }
        HashSet<BOSUuid> csspGroup = new HashSet<BOSUuid>(objects.length);
        DataBaseInfo obj = null;
        String id = null;
        String number = null;
        String longNumber = null;
        String name = null;
        AsstActObject asstActObj = null;
        for (int i = 0; i < objects.length; ++i) {
            obj = (DataBaseInfo)objects[i];
            group = (DataBaseInfo)obj.get("browseGroup");
            if (group != null && !csspCache.containsKey(group.getId().toString())) continue;
            while (group != null && !csspGroup.contains(group.getId())) {
                id = (group = (DataBaseInfo)csspCache.get(group.getId().toString())).getId().toString();
                asstActObj = new AsstActObject(id, number = group.getNumber(), longNumber = (String)group.get("longNumber"), name = group.getName(), isMulti, false);
                if (this.canAdd(asstActObj)) {
                    asstActSet.add(asstActObj);
                    csspGroup.add(group.getId());
                }
                group = (DataBaseInfo)group.get("parent");
            }
            id = obj.getId().toString();
            number = obj.getNumber();
            longNumber = null;
            if (obj.get("browseGroup") != null) {
                group = (DataBaseInfo)csspCache.get(((DataBaseInfo)obj.get("browseGroup")).getId().toString());
                longNumber = (String)group.get("longNumber") + "!" + number;
            } else {
                longNumber = number;
            }
            name = obj.getName();
            asstActObj = new AsstActObject(id, number, longNumber, name, isMulti, true);
            if (!this.canAdd(asstActObj)) continue;
            asstActSet.add(asstActObj);
        }
    }

    private boolean canAdd(AsstActObject asstActObj) {
        return true;
    }

    private void sortList(List list, AsstActTypeInfo asstActTypeInfo) {
        if (asstActTypeInfo.getAsstHGAttribute().equalsIgnoreCase("project")) {
            Collections.sort(list, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    AsstActObject actObject1 = (AsstActObject)arg0;
                    AsstActObject actObject2 = (AsstActObject)arg1;
                    String number1 = actObject1.getNumber();
                    String number2 = actObject2.getNumber();
                    if (number1 == null || number2 == null) {
                        return 0;
                    }
                    return number1.toLowerCase(Locale.ENGLISH).compareTo(number2.toLowerCase(Locale.ENGLISH));
                }
            });
        } else {
            Collections.sort(list);
        }
    }

    private boolean isMultiLevel(AsstActTypeInfo asstType) {
        String mappingFieldName = asstType.getAsstHGAttribute();
        boolean isMulti = false;
        if (mappingFieldName.equals("customer")) {
            isMulti = true;
        } else if (mappingFieldName.equals("provider")) {
            isMulti = true;
        } else if (mappingFieldName.equals("material")) {
            isMulti = true;
        } else {
            isMulti = asstType.isIsMultilevel();
            if (!StringUtils.isEmpty((String)asstType.getGroupTableName())) {
                isMulti = false;
            }
        }
        return isMulti;
    }
}

