/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.DItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.HandleMultiItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IQueryItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemSource;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ObjectMatcher;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.CircleSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.SuperSQL;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryDItem
implements IQueryItem<DItemQueryUnit> {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QueryDItem.class);
    protected DBHandler dao;

    public QueryDItem(DBHandler dao) {
        this.dao = dao;
    }

    public Collection<ItemSource> queryItemSource(DItemQueryUnit rptQueryInfo) throws BOSException {
        String queryItemValueSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryDItemData.sql");
        IRowSet entryRs = this.dao.getExecuteSQL().executeQuery(queryItemValueSql, new Object[]{rptQueryInfo.getCompany().getId().toString(), rptQueryInfo.getCurrency().getId().toString(), rptQueryInfo.getPeriodType().getValue(), rptQueryInfo.getYear(), rptQueryInfo.getPeriod(), rptQueryInfo.getDataElement(), rptQueryInfo.getValueType().getValue()});
        try {
            HashMap<String, ItemSource> itemSources = new HashMap<String, ItemSource>();
            ItemSource itemSource = null;
            while (entryRs.next()) {
                String entryId = entryRs.getString("EntryId");
                String sourceId = entryRs.getString("SourceId");
                String sourceTypeId = entryRs.getString("SourceTypeId");
                int sourceType = entryRs.getInt("SourceType");
                String itemNumber = entryRs.getString("ItemId");
                String dynaItem = entryRs.getString("DynaItem");
                String dynaName = entryRs.getString("DynaName");
                BigDecimal result = entryRs.getBigDecimal("Result");
                ItemValue entryData = new ItemValue("DITEM", itemNumber, dynaItem, result);
                entryData.setDynaItemName(dynaName);
                entryData.setTableName(entryId);
                entryData.setItemDataEntryId(entryId);
                itemSource = (ItemSource)itemSources.get(sourceId);
                if (itemSource != null) {
                    itemSource.addEntry(entryId, null);
                    itemSource.addItemValue(entryData);
                    continue;
                }
                FormulaCalcContextInfo sourceTypeInfo = null;
                if (sourceType == 100) {
                    FormulaCalcContextInfo autoItemType = new FormulaCalcContextInfo();
                    autoItemType.setId(BOSUuid.read((String)sourceTypeId));
                    sourceTypeInfo = autoItemType;
                } else {
                    if (!IItemSourceType.SOURCE_TYPE_REPORT.contains(sourceType)) continue;
                    ReportBaseInfo reportType = new ReportBaseInfo();
                    reportType.setId(BOSUuid.read((String)sourceTypeId));
                    sourceTypeInfo = reportType;
                }
                itemSource = new ItemSource(rptQueryInfo.getType(), sourceTypeInfo, rptQueryInfo.getCompany(), rptQueryInfo.getCurrency(), rptQueryInfo.getPeriodType(), rptQueryInfo.getYear(), rptQueryInfo.getPeriod(), rptQueryInfo.getDataElement(), rptQueryInfo.getValueType());
                itemSource.setId(sourceId);
                itemSource.addEntry(entryId, null);
                itemSource.addItemValue(entryData);
                itemSources.put(sourceId, itemSource);
            }
            LOG.info("item context {0} found!entry is {1}", new Object[]{itemSource == null ? "be not" : "be", itemSource != null ? itemSource.getEntrys() : " blank "});
            return itemSources.values();
        }
        catch (SQLException e) {
            LOG.error("", e);
            throw new SQLDataException(e);
        }
    }

    @Override
    public ItemResult queryValue(DItemQueryUnit rptQueryInfo, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashSet<DItemQueryUnit> rptQueryInfos = new HashSet<DItemQueryUnit>(1);
        rptQueryInfos.add(rptQueryInfo);
        Map<DItemQueryUnit, ItemResult> values = this.queryValues((Set<DItemQueryUnit>)rptQueryInfos, fixedSourceTypes, orgType);
        return values.get(rptQueryInfo);
    }

    @Override
    public Map<DItemQueryUnit, ItemResult> queryValues(Set<DItemQueryUnit> queryUnits, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashMap<DItemQueryUnit, ItemResult> itemValues = new HashMap<DItemQueryUnit, ItemResult>();
        if (queryUnits.isEmpty()) {
            return itemValues;
        }
        HashSet<String> rptItemNums = new HashSet<String>();
        HashMap<String, Collection<DItemQueryUnit>> itemNum2QueryUnit = new HashMap<String, Collection<DItemQueryUnit>>();
        ObjectMatcher<DItemQueryUnit> itemMatcher = new ObjectMatcher<DItemQueryUnit>();
        for (DItemQueryUnit queryUnit : queryUnits) {
            rptItemNums.add(queryUnit.getNumber());
            if (!itemNum2QueryUnit.containsKey(queryUnit.getNumber() + "|" + queryUnit.getDItemNumber())) {
                itemNum2QueryUnit.put(queryUnit.getNumber() + "|" + queryUnit.getDItemNumber(), new HashSet(5));
            }
            ((Collection)itemNum2QueryUnit.get(queryUnit.getNumber() + "|" + queryUnit.getDItemNumber())).add(queryUnit);
            itemMatcher.add(queryUnit, new Object[]{queryUnit.getCompany().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getValueType().getValue(), queryUnit.getNumber(), queryUnit.getDItemNumber()});
        }
        Collection<SuperSQL> executeSqls = this.buildSqls(itemNum2QueryUnit, fixedSourceTypes, orgType);
        String sql = null;
        for (SuperSQL executeSql : executeSqls) {
            try {
                sql = executeSql.sql();
                LOG.debug("query ditem's sql:\n{0}", new Object[]{sql});
                IRowSet dataRs = this.dao.getExecuteSQL().executeQuery(sql, executeSql.params());
                if (dataRs.size() == 0) {
                    LOG.debug("no ditem value be queryed with sql:{0}/*param:{1}*/", new Object[]{sql, executeSql.params()});
                    continue;
                }
                while (dataRs.next()) {
                    this.matchData(itemValues, itemMatcher, dataRs);
                }
            }
            catch (SQLException e) {
                LOG.error("", e);
                throw new SQLDataException(e);
            }
            finally {
                executeSql.clear();
            }
        }
        return itemValues;
    }

    protected void matchData(Map<DItemQueryUnit, ItemResult> itemValues, ObjectMatcher<DItemQueryUnit> itemMatcher, IRowSet dataRs) throws SQLException {
        Set<DItemQueryUnit> finds = null;
        BigDecimal newValue = null;
        String sourceId = null;
        int sourceType = -1;
        ItemResult preResult = null;
        String dynaName = null;
        String entryId = null;
        finds = itemMatcher.get(new Object[]{dataRs.getString("FOrgUnitId"), dataRs.getInt("fperiodType"), dataRs.getString("fCurrencyId"), dataRs.getInt("fyear"), dataRs.getInt("fperiod"), dataRs.getInt("fdataElement"), dataRs.getInt("fValueType"), dataRs.getString("FItemID"), dataRs.getString("FKeyNumber")});
        if (finds != null) {
            if (finds.size() > 1) {
                LOG.debug("too many matcher exception.", new Object[0]);
            }
            newValue = dataRs.getBigDecimal("result");
            sourceId = dataRs.getString("sourceId");
            sourceType = dataRs.getInt("sourceType");
            dynaName = dataRs.getString("DynaName");
            entryId = dataRs.getString("entryId");
            for (DItemQueryUnit find : finds) {
                preResult = itemValues.get(find);
                preResult = new HandleMultiItemValue().exec(preResult, newValue, sourceId, sourceType, find.getType());
                preResult.setDynaName(dynaName);
                preResult.setEntryId(entryId);
                itemValues.put(find, preResult);
            }
        }
    }

    public Collection<SuperSQL> buildSqls(Map<String, Collection<DItemQueryUnit>> itemNum2QueryUnit, Collection<Integer> fixedSourceTypes, OrgType orgType) {
        Collection<DItemQueryUnit> queryUnits = null;
        HashSet<SuperSQL> executeSqls = new HashSet<SuperSQL>();
        SuperSQL sql = this.createNewSuperSQL(fixedSourceTypes, orgType);
        int limitNum = 0;
        for (String itemKey : itemNum2QueryUnit.keySet()) {
            queryUnits = itemNum2QueryUnit.get(itemKey);
            for (DItemQueryUnit queryUnit : queryUnits) {
                ((CircleSQL)sql.getFormats().get(0)).add(new Object[0], new Object[]{queryUnit.getCompany().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getValueType().getValue(), queryUnit.getNumber(), queryUnit.getDItemNumber()});
                ++limitNum;
            }
            if (limitNum <= 100) continue;
            executeSqls.add(sql);
            sql = this.createNewSuperSQL(fixedSourceTypes, orgType);
            limitNum = 0;
        }
        if (limitNum != 0) {
            executeSqls.add(sql);
        }
        return executeSqls;
    }

    protected SuperSQL createNewSuperSQL(Collection<Integer> fixedSourceTypes, OrgType orgType) {
        String sourceTypeCondition = "";
        if (!fixedSourceTypes.isEmpty()) {
            sourceTypeCondition = " and define.FDataSource in ( " + StringUtil.toSql(fixedSourceTypes, false) + " ) ";
        }
        if (orgType != null) {
            sourceTypeCondition = sourceTypeCondition + " and define.FOrgType = " + orgType.getValue() + " ";
        }
        SuperSQL sql = new SuperSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryDItem.sql").sql());
        CircleSQL where = new CircleSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryDItem_ItemCondition_CircleEntry.sql").sql());
        where.setJoinChar("or");
        where.setWithBlockChar(true);
        sql.set(new Object[]{where, sourceTypeCondition}, new Object[0]);
        return sql;
    }
}

