/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.EItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.HandleMultiItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IQueryItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEItemTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemSource;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ObjectMatcher;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.CircleSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.SuperSQL;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryEItem
implements IQueryItem<EItemQueryUnit> {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QueryEItem.class);
    protected DBHandler dao;

    public QueryEItem(DBHandler dao) {
        this.dao = dao;
    }

    public Collection<ItemSource> queryItemSource(EItemQueryUnit rptQueryInfo) throws BOSException {
        String itemKey = rptQueryInfo.getType();
        GetEItemTable GET_TABLE = ActionFactory.get(GetEItemTable.class);
        String itemTable = GET_TABLE.getTable(itemKey);
        String queryItemValueSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryEItemData.sql");
        queryItemValueSql = new MessageFormat(queryItemValueSql).format(new Object[]{itemTable, "REITEM".equalsIgnoreCase(itemKey) ? "FReportID" : "FReport", this.dao.getContext() == null ? "l2" : this.dao.getContext().getLocale().getLanguage()});
        IRowSet entryRs = this.dao.getExecuteSQL().executeQuery(queryItemValueSql, new Object[]{rptQueryInfo.getCompany().getId().toString(), rptQueryInfo.getCurrency().getId().toString(), rptQueryInfo.getPeriodType().getValue(), rptQueryInfo.getYear(), rptQueryInfo.getPeriod(), rptQueryInfo.getDataElement()});
        try {
            HashMap<String, ItemSource> itemSources = new HashMap<String, ItemSource>();
            ItemSource itemSource = null;
            while (entryRs.next()) {
                String entryId = entryRs.getString("EntryId");
                String sourceTypeId = entryRs.getString("SourceTypeId");
                int sourceType = entryRs.getInt("SourceType");
                BigDecimal result = entryRs.getBigDecimal("Result");
                String itemNumber = entryRs.getString("ItemNumber");
                String targetCompany = entryRs.getString("TargetCompany");
                String targetCompanyName = entryRs.getString("TargetCompanyName");
                ItemValue entryData = new ItemValue("DITEM", itemNumber, targetCompany, result);
                entryData.setDynaItemName(targetCompanyName);
                entryData.setTableName(entryId);
                entryData.setItemDataEntryId(entryId);
                itemSource = (ItemSource)itemSources.get(sourceTypeId);
                if (itemSource != null) {
                    itemSource.addEntry(entryId, null);
                    itemSource.addItemValue(entryData);
                    continue;
                }
                FormulaCalcContextInfo sourceTypeInfo = null;
                if (sourceType == 100) {
                    FormulaCalcContextInfo autoItemType = new FormulaCalcContextInfo();
                    autoItemType.setId(BOSUuid.read((String)sourceTypeId));
                    sourceTypeInfo = autoItemType;
                } else {
                    if (!IItemSourceType.SOURCE_TYPE_REPORT.contains(sourceType)) continue;
                    ReportBaseInfo reportType = new ReportBaseInfo();
                    reportType.setId(BOSUuid.read((String)sourceTypeId));
                    sourceTypeInfo = reportType;
                }
                itemSource = new ItemSource(rptQueryInfo.getType(), sourceTypeInfo, rptQueryInfo.getCompany(), rptQueryInfo.getCurrency(), rptQueryInfo.getPeriodType(), rptQueryInfo.getYear(), rptQueryInfo.getPeriod(), rptQueryInfo.getDataElement(), rptQueryInfo.getValueType());
                itemSource.addEntry(entryId, null);
                itemSource.addItemValue(entryData);
                itemSources.put(sourceTypeId, itemSource);
            }
            LOG.info("item context {0} found!entry is {1}", new Object[]{itemSource == null ? "be not" : "be", itemSource != null ? itemSource.getEntrys() : " blank "});
            return itemSources.values();
        }
        catch (SQLException e) {
            LOG.error("", e);
            throw new SQLDataException(e);
        }
    }

    @Override
    public ItemResult queryValue(EItemQueryUnit rptQueryInfo, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashSet<EItemQueryUnit> rptQueryInfos = new HashSet<EItemQueryUnit>(1);
        rptQueryInfos.add(rptQueryInfo);
        Map<EItemQueryUnit, ItemResult> values = this.queryValues((Set<EItemQueryUnit>)rptQueryInfos, fixedSourceTypes, orgType);
        return values.get(rptQueryInfo);
    }

    @Override
    public Map<EItemQueryUnit, ItemResult> queryValues(Set<EItemQueryUnit> rptQueryInfos, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashMap<EItemQueryUnit, ItemResult> itemValues = new HashMap<EItemQueryUnit, ItemResult>();
        if (rptQueryInfos.isEmpty()) {
            return itemValues;
        }
        HashSet<String> rptItemNums = new HashSet<String>();
        HashMap<String, Collection<EItemQueryUnit>> itemNum2QueryUnit = new HashMap<String, Collection<EItemQueryUnit>>();
        ObjectMatcher<EItemQueryUnit> itemMatcher = new ObjectMatcher<EItemQueryUnit>();
        for (EItemQueryUnit queryUnit : rptQueryInfos) {
            rptItemNums.add(queryUnit.getNumber());
            if (!itemNum2QueryUnit.containsKey(queryUnit.getType() + "|" + queryUnit.getNumber() + "|" + queryUnit.getDItemNumber())) {
                itemNum2QueryUnit.put(queryUnit.getType() + "|" + queryUnit.getNumber() + "|" + queryUnit.getDItemNumber(), new HashSet(5));
            }
            ((Collection)itemNum2QueryUnit.get(queryUnit.getType() + "|" + queryUnit.getNumber() + "|" + queryUnit.getDItemNumber())).add(queryUnit);
            itemMatcher.add(queryUnit, new Object[]{queryUnit.getCompany().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getNumber(), queryUnit.getTargetCompanyId()});
        }
        Collection<SuperSQL> executeSqls = this.buildSqls(itemNum2QueryUnit, fixedSourceTypes);
        Set finds = null;
        String sql = null;
        BigDecimal newValue = null;
        String sourceId = null;
        int sourceType = -1;
        String entryId = null;
        ItemResult preResult = null;
        String targetCompanyName = null;
        for (SuperSQL executeSql : executeSqls) {
            try {
                sql = executeSql.sql();
                LOG.debug("query item's sql:\n{0}", new Object[]{sql});
                IRowSet dataRs = this.dao.getExecuteSQL().executeQuery(sql, executeSql.params());
                if (dataRs.size() == 0) {
                    LOG.debug("no item value be queryed with sql:{0}/*param:{1}*/", new Object[]{sql, executeSql.params()});
                    continue;
                }
                while (dataRs.next()) {
                    finds = itemMatcher.get(new Object[]{dataRs.getString("fcompanyid"), dataRs.getInt("fperiodType"), dataRs.getString("fCurrencyId"), dataRs.getInt("fyear"), dataRs.getInt("fperiod"), dataRs.getInt("fdataElement"), dataRs.getString("FItemNumber"), dataRs.getString("FTargetCompanyID")});
                    if (finds == null) continue;
                    if (finds.size() > 1) {
                        LOG.debug("too many matcher exception.", new Object[0]);
                    }
                    newValue = dataRs.getBigDecimal("result");
                    sourceId = dataRs.getString("SourceTypeId");
                    sourceType = dataRs.getInt("sourceType");
                    entryId = dataRs.getString("entryId");
                    targetCompanyName = dataRs.getString("FTargetCompanyName");
                    for (EItemQueryUnit find : finds) {
                        preResult = (ItemResult)itemValues.get(find);
                        preResult = new HandleMultiItemValue().exec(preResult, newValue, sourceId, sourceType, find.getType());
                        preResult.setDynaName(targetCompanyName);
                        preResult.setEntryId(entryId);
                        itemValues.put(find, preResult);
                    }
                }
            }
            catch (SQLException e) {
                LOG.error("", e);
                throw new SQLDataException(e);
            }
            finally {
                executeSql.clear();
            }
        }
        return itemValues;
    }

    public Collection<SuperSQL> buildSqls(Map<String, Collection<EItemQueryUnit>> itemNum2QueryUnit, Collection<Integer> fixedSourceTypes) {
        Collection<EItemQueryUnit> queryUnits = null;
        HashSet<SuperSQL> sqls = new HashSet<SuperSQL>();
        HashMap<String, SuperSQL> executeSqls = new HashMap<String, SuperSQL>();
        SuperSQL sql = null;
        GetEItemTable GET_TABLE = ActionFactory.get(GetEItemTable.class);
        String itemTable = null;
        String reportFieldName = null;
        String sourceTypeCondition = "";
        if (!fixedSourceTypes.isEmpty()) {
            sourceTypeCondition = " and entry.FSourceType in ( " + StringUtil.toSql(fixedSourceTypes, false) + " ) ";
        }
        for (String itemKey : itemNum2QueryUnit.keySet()) {
            queryUnits = itemNum2QueryUnit.get(itemKey);
            for (EItemQueryUnit queryUnit : queryUnits) {
                itemTable = GET_TABLE.getTable(queryUnit.getType());
                reportFieldName = GET_TABLE.getReportFieldName(queryUnit.getType());
                sql = (SuperSQL)executeSqls.get(itemTable);
                if (sql != null && ((CircleSQL)sql.getFormats().get(1)).params().length > 1000) {
                    sqls.add(sql);
                    executeSqls.remove(itemTable);
                    sql = null;
                }
                if (sql == null) {
                    sql = new SuperSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryEItemValue.sql").sql());
                    CircleSQL subSql2 = new CircleSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryEItemValue_ItemCondition_CircleEntry.sql").sql());
                    subSql2.setJoinChar("or");
                    subSql2.setWithBlockChar(true);
                    sql.set(new Object[]{itemTable, subSql2, reportFieldName, sourceTypeCondition, this.dao.getContext() == null ? "l2" : this.dao.getContext().getLocale().getLanguage()}, new Object[0]);
                    executeSqls.put(itemTable, sql);
                }
                ((CircleSQL)sql.getFormats().get(1)).add(new Object[0], new Object[]{queryUnit.getCompany().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getNumber(), queryUnit.getDItemNumber()});
            }
        }
        sqls.addAll(executeSqls.values());
        return sqls;
    }
}

