/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.HandleMultiItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IQueryItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.NItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemSource;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.QueryItemValueTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ObjectMatcher;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.CircleSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.SuperSQL;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryNItem
implements IQueryItem<NItemQueryUnit> {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QueryNItem.class);
    protected DBHandler dao;

    public QueryNItem(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public ItemResult queryValue(NItemQueryUnit rptQueryInfo, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashSet<NItemQueryUnit> rptQueryInfos = new HashSet<NItemQueryUnit>(1);
        rptQueryInfos.add(rptQueryInfo);
        Map<NItemQueryUnit, ItemResult> values = this.queryValues((Set<NItemQueryUnit>)rptQueryInfos, fixedSourceTypes, orgType);
        return values.get(rptQueryInfo);
    }

    public Set<ItemValue> queryItemValue(NItemQueryUnit rptQueryInfo) throws BOSException {
        String queryItemValueSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItemData.sql");
        IRowSet entryRs = this.dao.getExecuteSQL().executeQuery(queryItemValueSql, new Object[]{rptQueryInfo.getCompany().getId().toString(), rptQueryInfo.getCurrency().getId().toString(), rptQueryInfo.getPeriodType().getValue(), rptQueryInfo.getYear(), rptQueryInfo.getPeriod(), rptQueryInfo.getDataElement(), rptQueryInfo.getValueType().getValue()});
        try {
            ItemDao itemDao = new ItemDao(this.dao);
            HashSet<String> entryIds = new HashSet<String>();
            while (entryRs.next()) {
                entryIds.add(entryRs.getString("EntryId"));
            }
            if (entryIds.isEmpty()) {
                return new HashSet<ItemValue>(0);
            }
            return itemDao.queryItem(entryIds);
        }
        catch (SQLException e) {
            LOG.error("", e);
            throw new SQLDataException(e);
        }
    }

    public Collection<ItemSource> queryItemSource(NItemQueryUnit rptQueryInfo, OrgType orgType) throws BOSException {
        String queryItemValueSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItemData.sql");
        IRowSet entryRs = this.dao.getExecuteSQL().executeQuery(queryItemValueSql, new Object[]{rptQueryInfo.getCompany().getId().toString(), rptQueryInfo.getCurrency().getId().toString(), rptQueryInfo.getPeriodType().getValue(), orgType.getValue(), rptQueryInfo.getYear(), rptQueryInfo.getPeriod(), rptQueryInfo.getDataElement(), rptQueryInfo.getValueType().getValue()});
        try {
            HashMap<String, ItemSource> itemSources = new HashMap<String, ItemSource>();
            ItemSource itemSource = null;
            while (entryRs.next()) {
                String entryId = entryRs.getString("EntryId");
                String sourceId = entryRs.getString("SourceId");
                String sourceTypeId = entryRs.getString("SourceTypeId");
                int sourceType = entryRs.getInt("SourceType");
                itemSource = (ItemSource)itemSources.get(sourceId);
                if (itemSource != null) {
                    itemSource.addEntry(entryId, null);
                    continue;
                }
                FormulaCalcContextInfo sourceTypeInfo = null;
                if (sourceType == 100) {
                    FormulaCalcContextInfo autoItemType = new FormulaCalcContextInfo();
                    autoItemType.setId(BOSUuid.read((String)sourceTypeId));
                    sourceTypeInfo = autoItemType;
                } else {
                    if (!IItemSourceType.SOURCE_TYPE_REPORT.contains(sourceType)) continue;
                    ReportBaseInfo reportType = new ReportBaseInfo();
                    if (new AdjustInfo().getBOSType().equals((Object)BOSUuid.getBOSObjectType((String)sourceTypeId, (boolean)true)) || !new CslReportInfo().getBOSType().equals((Object)BOSUuid.getBOSObjectType((String)sourceTypeId, (boolean)true))) continue;
                    reportType.setId(BOSUuid.read((String)sourceTypeId));
                    reportType.setSourceType(RptSrcTypeEnum.getEnum((int)sourceType));
                    sourceTypeInfo = reportType;
                }
                itemSource = new ItemSource(rptQueryInfo.getType(), sourceTypeInfo, rptQueryInfo.getCompany(), rptQueryInfo.getCurrency(), rptQueryInfo.getPeriodType(), rptQueryInfo.getYear(), rptQueryInfo.getPeriod(), rptQueryInfo.getDataElement(), rptQueryInfo.getValueType());
                itemSource.setId(sourceId);
                itemSource.addEntry(entryId, null);
                itemSources.put(sourceId, itemSource);
            }
            LOG.info("item context {0} found!entry is {1}", new Object[]{itemSource == null ? "be not" : "be", itemSource != null ? itemSource.getEntrys() : " blank "});
            return itemSources.values();
        }
        catch (SQLException e) {
            LOG.error("", e);
            throw new SQLDataException(e);
        }
    }

    @Override
    public Map<NItemQueryUnit, ItemResult> queryValues(Set<NItemQueryUnit> queryUnits, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashMap<NItemQueryUnit, ItemResult> itemValues = new HashMap<NItemQueryUnit, ItemResult>(1);
        if (queryUnits.isEmpty()) {
            return itemValues;
        }
        HashSet<String> rptItemNums = new HashSet<String>();
        HashMap<String, Collection<NItemQueryUnit>> itemNum2QueryUnit = new HashMap<String, Collection<NItemQueryUnit>>();
        ObjectMatcher<NItemQueryUnit> itemMatcher = new ObjectMatcher<NItemQueryUnit>();
        for (NItemQueryUnit queryUnit : queryUnits) {
            rptItemNums.add(queryUnit.getNumber());
            if (!itemNum2QueryUnit.containsKey(queryUnit.getNumber())) {
                itemNum2QueryUnit.put(queryUnit.getNumber(), new HashSet(5));
            }
            ((Collection)itemNum2QueryUnit.get(queryUnit.getNumber())).add(queryUnit);
            itemMatcher.add(queryUnit, new Object[]{queryUnit.getCompany().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getValueType().getValue()});
        }
        Map<String, String> itemTableInfos = new QueryItemValueTable(this.dao).exec(rptItemNums);
        Collection<SuperSQL> executeSqls = this.buildSqls(itemNum2QueryUnit, itemTableInfos, fixedSourceTypes, orgType);
        Set finds = null;
        String sql = null;
        BigDecimal newValue = null;
        String sourceId = null;
        int sourceType = -1;
        String entryid = null;
        for (SuperSQL executeSql : executeSqls) {
            try {
                sql = executeSql.sql();
                LOG.debug("query item's sql:\n{0}", new Object[]{sql});
                IRowSet dataRs = this.dao.getExecuteSQL().executeQuery(sql, executeSql.params());
                if (dataRs.size() == 0) {
                    LOG.debug("no item value be queryed with sql:{0}/*param:{1}*/", new Object[]{sql, executeSql.params()});
                    HashMap<NItemQueryUnit, ItemResult> hashMap = itemValues;
                    return hashMap;
                }
                while (dataRs.next()) {
                    finds = itemMatcher.get(new Object[]{dataRs.getString("fcompanyid"), dataRs.getInt("fperiodType"), dataRs.getString("fTargetCurrencyId"), dataRs.getInt("fyear"), dataRs.getInt("fperiod"), dataRs.getInt("fdataElement"), dataRs.getInt("fValueType")});
                    sourceId = dataRs.getString("sourceId");
                    sourceType = dataRs.getInt("sourceType");
                    entryid = dataRs.getString("entryid");
                    if (finds == null) continue;
                    for (NItemQueryUnit find : finds) {
                        try {
                            newValue = dataRs.getBigDecimal(itemTableInfos.get(find.getNumber()).split("\\.")[1]);
                        }
                        catch (SQLException e) {
                            continue;
                        }
                        if (newValue == null) continue;
                        ItemResult oldResult = (ItemResult)itemValues.get(find);
                        oldResult = new HandleMultiItemValue().exec(oldResult, newValue, sourceId, sourceType, find.getType());
                        oldResult.setEntryId(entryid);
                        itemValues.put(find, oldResult);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("", e);
                throw new BOSException((Throwable)e);
            }
            finally {
                executeSql.clear();
            }
        }
        return itemValues;
    }

    public Collection<SuperSQL> buildSqls(Map<String, Collection<NItemQueryUnit>> itemNum2QueryUnit, Map<String, String> itemTableInfos, Collection<Integer> fixedSourceTypes, OrgType orgType) {
        String[] tableField = null;
        Collection<NItemQueryUnit> queryUnits = null;
        HashMap<String, SuperSQL> executeSqls = new HashMap<String, SuperSQL>();
        HashSet<SuperSQL> sqls = new HashSet<SuperSQL>();
        SuperSQL sql = null;
        String topWhereCondition = "";
        if (!fixedSourceTypes.isEmpty()) {
            topWhereCondition = " and define.FDataSource in ( " + StringUtil.toSql(fixedSourceTypes, false) + " ) ";
        }
        if (orgType != null) {
            topWhereCondition = topWhereCondition + " and define.FOrgType = " + orgType.getValue() + " ";
        }
        for (String itemNum : itemTableInfos.keySet()) {
            String tableInfo = itemTableInfos.get(itemNum);
            tableField = tableInfo.split("\\.");
            queryUnits = itemNum2QueryUnit.get(itemNum);
            sql = (SuperSQL)executeSqls.get(tableField[0]);
            if (sql != null && ((CircleSQL)sql.getFormats().get(2)).params().length > 1000) {
                sqls.add(sql);
                executeSqls.remove(tableField[0]);
                sql = null;
            }
            if (sql == null) {
                sql = new SuperSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItem.sql").sql());
                CircleSQL subSql1 = new CircleSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItem_FieldName_CircleEntry.sql").sql());
                subSql1.setJoinChar(",");
                CircleSQL subSql2 = new CircleSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItem_ItemCondition_CircleEntry.sql").sql());
                subSql2.setJoinChar("or");
                subSql2.setWithBlockChar(true);
                sql.set(new Object[]{subSql1, tableField[0], subSql2, topWhereCondition}, new Object[0]);
                executeSqls.put(tableField[0], sql);
            }
            ((CircleSQL)sql.getFormats().get(0)).add(new Object[]{tableField[1]}, new Object[0]);
            for (NItemQueryUnit queryUnit : queryUnits) {
                if (queryUnit.getExtraSQL() != null) {
                    ((CircleSQL)sql.getFormats().get(2)).add(new Object[]{tableField[1], queryUnit.getExtraSQL()}, new Object[]{queryUnit.getCompany().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getValueType().getValue()});
                    continue;
                }
                ((CircleSQL)sql.getFormats().get(2)).add(new Object[]{tableField[1], ""}, new Object[]{queryUnit.getCompany().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getValueType().getValue()});
            }
        }
        sqls.addAll(executeSqls.values());
        return sqls;
    }
}

