/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.TemplateAndCompany;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResult;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.articulation.IArticulationService;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.ReportEntityForTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.AutoFillDynaSheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.CreateEmptyReportByTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.check.BtwRelationReportMsgForAutoitem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.check.ItemDiffCheckReportMsgForAutoitem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ParamCache;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CheckItemValue {
    private DBHandler dao;

    public CheckItemValue(DBHandler dao) {
        this.dao = dao;
    }

    public String exec(FormulaCalcContextInfo calcContext) throws BOSException, EASBizException {
        ArrayList<CslReportInfo> reportList = new ArrayList<CslReportInfo>(1);
        TemplateAndCompany templateAndCompany2 = null;
        ParamCache paramCache = new ParamCache();
        for (TemplateAndCompany templateAndCompany2 : calcContext) {
            CslReportInfo reportInfo = this.createFakeReport(templateAndCompany2.getTemplate(), (OrgUnitInfo)templateAndCompany2.getCompany(), calcContext, paramCache);
            reportList.add(reportInfo);
        }
        IArticulationService articulationService = ArticulationServiceFactory.getArticulationService();
        Map checkFormulaResult = articulationService.checkArticulation(this.dao.getContext(), reportList, 2);
        Map differItemResult = articulationService.checkArticulation(this.dao.getContext(), reportList, 3);
        Boolean isSupportOtherDS = Boolean.FALSE;
        StringBuffer report = new StringBuffer();
        String checkFormulaErrorMsg = this.buildCheckResult(checkFormulaResult, this.dao.getContext(), isSupportOtherDS, 2);
        report.append(checkFormulaErrorMsg);
        String diffItemErrorMsg = this.buildCheckResult(differItemResult, this.dao.getContext(), isSupportOtherDS, 3);
        if (checkFormulaErrorMsg.length() > 0 && diffItemErrorMsg.length() > 0) {
            report.append("<br><br><br>");
        }
        report.append(diffItemErrorMsg);
        return report.toString();
    }

    protected CslReportInfo createFakeReport(TemplateInfo template, OrgUnitInfo company, FormulaCalcContextInfo context, ParamCache cache) throws BOSException {
        Book book;
        CslReportInfo reportInfo = new CslReportInfo();
        reportInfo.setExtendedProperty("FROM_AUTOITEM", Boolean.TRUE.toString());
        reportInfo.setId(BOSUuid.create((BOSObjectType)reportInfo.getBOSType()));
        reportInfo.setTemplate(template);
        reportInfo.setPeriodType(context.getPeriodType());
        reportInfo.setAdjustStatus(AdjustStatusEnum.BEFOREADJUST);
        reportInfo.setCurrency(context.getCurrentCurrency());
        reportInfo.setDataCollectNumber("ACTUALDATA");
        reportInfo.setOrgUnit(company);
        reportInfo.setCompany(company);
        reportInfo.setOrgTree(null);
        reportInfo.setSourceCurrency(context.getCurrentCurrency());
        reportInfo.setSourceType(RptSrcTypeEnum.COMMITREPORT);
        reportInfo.setYear(context.getYear());
        reportInfo.setPeriod((short)context.getPeriod());
        reportInfo.setReportDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod(), reportInfo.getPeriodType()));
        try {
            book = template.getBook();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)template.getTemplateType())) {
            AutoFillDynaSheet autoFillDynaSheet = new AutoFillDynaSheet(this.dao);
            HashMap<AutoItemItemFormula, Cell> itemFormulaAfterFill = new HashMap<AutoItemItemFormula, Cell>();
            for (int i = 0; i < book.getSheetCount(); ++i) {
                itemFormulaAfterFill.putAll(autoFillDynaSheet.exec(context, company, new ReportEntityForTemplate(template, null), book.getSheet(i)));
            }
        }
        try {
            reportInfo.setBook(book);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        RptSheetParamCollection templateSheetParams = null;
        if (!cache.contain(CheckItemValue.class, template.getId().toString())) {
            templateSheetParams = new CreateEmptyReportByTemplate(this.dao).queryTemplateParams((VirtualSheetParamInfo)reportInfo, reportInfo.getTemplate());
            cache.put(CheckItemValue.class, template.getId().toString(), templateSheetParams);
        } else {
            templateSheetParams = (RptSheetParamCollection)cache.getClone(CheckItemValue.class, template.getId().toString());
        }
        reportInfo.getSheetParam().addCollection(templateSheetParams);
        return reportInfo;
    }

    protected String buildCheckResult(Map<String, ArticulationCheckResult> result, Context serverContext, Boolean isSupportOtherDS, int checkType) {
        StringBuffer report;
        block5: {
            block4: {
                report = new StringBuffer();
                if (checkType != 2) break block4;
                BtwRelationReportMsgForAutoitem createMsg = new BtwRelationReportMsgForAutoitem();
                createMsg.setOmitCheckTypeAndDate(false);
                boolean first = true;
                for (Map.Entry<String, ArticulationCheckResult> entry : result.entrySet()) {
                    if (!first) {
                        createMsg.setOmitCheckTypeAndDate(true);
                    }
                    report.append(createMsg.getReportMessage(isSupportOtherDS, entry.getValue(), serverContext.getLocale()));
                    if (report.length() <= 0) continue;
                    first = false;
                }
                break block5;
            }
            if (checkType != 3) break block5;
            ItemDiffCheckReportMsgForAutoitem createMsg = new ItemDiffCheckReportMsgForAutoitem();
            createMsg.setOmitCheckTypeAndDate(false);
            boolean first = true;
            for (Map.Entry<String, ArticulationCheckResult> entry : result.entrySet()) {
                if (!first) {
                    createMsg.setOmitCheckTypeAndDate(true);
                }
                report.append(createMsg.getReportMessage(entry.getValue(), serverContext.getLocale(), serverContext));
                if (report.length() <= 0) continue;
                first = false;
            }
        }
        return report.toString();
    }
}

