/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEItemTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IClearItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.QueryItemValueTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.db.DeleteTableRow;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.db.UpdateTableField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClearItemValue
implements IClearItemValue {
    private DBHandler dao;
    private UpdateTableField update;
    private DeleteTableRow delete;
    private List<String> rptItemNums = new LinkedList<String>();
    private List<Integer> dataElements = new ArrayList<Integer>();
    private Map<String, String> entryIds = new HashMap<String, String>();

    public ClearItemValue(DBHandler dao) {
        this.dao = dao;
        this.update = new UpdateTableField(dao);
        this.delete = new DeleteTableRow(dao);
    }

    @Override
    public void add(String itemType, String itemNumber, int dataElement, String entryId) {
        if (BizFormulaDefine.belongType(itemType, new String[]{"ITEM"})) {
            this.rptItemNums.add(itemNumber);
            if (!this.dataElements.contains(dataElement)) {
                this.dataElements.add(dataElement);
            }
            this.entryIds.put(itemNumber + "-" + dataElement, entryId);
        } else if (BizFormulaDefine.belongType(itemType, new String[]{"DITEM"})) {
            this.delete.add("T_CSL_DynaItemDataEntry", new Object[]{"fid", entryId});
        } else if (BizFormulaDefine.belongType(itemType, new String[]{"CEITEM", "LEITEM", "REITEM"})) {
            this.delete.add(new GetEItemTable().getTable(itemType), new Object[]{"fid", entryId});
        }
    }

    @Override
    public void exec() throws BOSException {
        Map<String, String> itemTableInfos = new QueryItemValueTable(this.dao).exec(this.rptItemNums);
        for (int i = 0; i < this.dataElements.size(); ++i) {
            for (Map.Entry<String, String> entry : itemTableInfos.entrySet()) {
                entry.getKey();
                entry.getValue();
                this.update.add(entry.getValue().split("\\.")[0], new Object[]{"fid", this.entryIds.get(entry.getKey() + "-" + this.dataElements.get(i))}, new Object[]{entry.getValue().split("\\.")[1], null});
            }
        }
        this.update.exec();
        this.delete.exec();
    }
}

