/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValueSet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.UnknownItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.SetExt;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ItemSource
implements Serializable {
    private static final long serialVersionUID = 2777069170481288494L;
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ItemSource.class);
    protected String id;
    protected String itemType;
    protected IItemSourceType sourceType;
    protected ItemContext itemContext;
    protected ItemValueSet itemValues = new ItemValueSet(0);
    protected Map<String, Collection<String>> entryId2Table = new HashMap<String, Collection<String>>(0);

    public ItemSource(String itemType, IItemSourceType sourceType, OrgUnitInfo company, CurrencyInfo currency, RptPeriodTypeEnum periodType, int year, int period, int dataElement, ValueTypeEnum valueType) {
        this.itemType = itemType;
        this.sourceType = sourceType;
        this.itemContext = new ItemContext(company, currency, periodType, year, period, dataElement, valueType);
    }

    public ItemSource(String itemType, String sourceId, int sourceType, OrgUnitInfo company, CurrencyInfo currency, RptPeriodTypeEnum periodType, int year, int period, int dataElement, ValueTypeEnum valueType) {
        this(itemType, new UnknownItemSourceType(sourceId, sourceType), company, currency, periodType, year, period, dataElement, valueType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.itemContext == null ? 0 : this.itemContext.hashCode());
        result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
        result = 31 * result + (this.sourceType == null ? 0 : (this.sourceType.getItemSourceId() == null ? this.sourceType.hashCode() : this.sourceType.getItemSourceId().toString().hashCode()));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemSource other = (ItemSource)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.itemContext == null ? other.itemContext != null : !this.itemContext.equals(other.itemContext)) {
            return false;
        }
        if (this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType)) {
            return false;
        }
        return !(this.sourceType == null ? other.sourceType != null : !this.sourceType.equals(other.sourceType));
    }

    public IItemSourceType getSourceType() {
        return this.sourceType;
    }

    public OrgUnitInfo getCompany() {
        return this.itemContext.getCompany();
    }

    public CurrencyInfo getCurrency() {
        return this.itemContext.getCurrency();
    }

    public RptPeriodTypeEnum getPeriodType() {
        return this.itemContext.getPeriodType();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void addItemValue(ItemValue itemValue) {
        this.itemValues.add(itemValue);
        if (itemValue.getTableName() != null) {
            this.itemValues.addTableName(itemValue.getTableName());
        }
    }

    public ItemValueSet getItemValues() {
        return this.itemValues;
    }

    public int getYear() {
        return this.itemContext.getYear();
    }

    public int getPeriod() {
        return this.itemContext.getPeriod();
    }

    public int getDataElement() {
        return this.itemContext.getDataElement();
    }

    public ValueTypeEnum getValueType() {
        return this.itemContext.getValueType();
    }

    public void addEntry(String entryId, String entryTableName) {
        if (!this.entryId2Table.containsKey(entryId)) {
            this.entryId2Table.put(entryId, new SetExt(true));
        }
        if (entryTableName == null) {
            return;
        }
        this.entryId2Table.get(entryId).add(entryTableName.toUpperCase());
    }

    public Map<String, Collection<String>> getEntrys() {
        return this.entryId2Table;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String toString() {
        return StringUtil.toStringByReflect(this);
    }
}

