/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.HandleMultiItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IQueryItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.CSLItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.SplitedCSLItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.UpdateItemDC;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ObjectMatcher;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.CircleSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.SuperSQL;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryDCSLItemData
implements IQueryItem<CSLItemQueryUnit> {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QueryDCSLItemData.class);
    protected DBHandler dao;
    private UpdateItemDC updateItemDC;

    public QueryDCSLItemData(DBHandler dao) {
        this.dao = dao;
    }

    public QueryDCSLItemData(DBHandler dao, UpdateItemDC updateItemDC) {
        this(dao);
        this.updateItemDC = updateItemDC;
    }

    @Override
    public ItemResult queryValue(CSLItemQueryUnit rptQueryInfo, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashSet<CSLItemQueryUnit> rptQueryInfos = new HashSet<CSLItemQueryUnit>(1);
        rptQueryInfos.add(rptQueryInfo);
        Map<CSLItemQueryUnit, ItemResult> values = this.queryValues((Set<CSLItemQueryUnit>)rptQueryInfos, fixedSourceTypes, orgType);
        return values.get(rptQueryInfo);
    }

    @Override
    public Map<CSLItemQueryUnit, ItemResult> queryValues(Set<CSLItemQueryUnit> queryUnits, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashMap<CSLItemQueryUnit, ItemResult> itemValues = new HashMap<CSLItemQueryUnit, ItemResult>();
        if (queryUnits.isEmpty()) {
            return itemValues;
        }
        HashSet<String> rptItemNums = new HashSet<String>();
        HashMap<String, Collection<CSLItemQueryUnit>> itemNum2QueryUnit = new HashMap<String, Collection<CSLItemQueryUnit>>();
        ObjectMatcher<CSLItemQueryUnit> itemMatcher = new ObjectMatcher<CSLItemQueryUnit>();
        for (CSLItemQueryUnit queryUnit : queryUnits) {
            rptItemNums.add(queryUnit.getNumber());
            if (!itemNum2QueryUnit.containsKey(queryUnit.getNumber())) {
                itemNum2QueryUnit.put(queryUnit.getNumber(), new HashSet(5));
            }
            ((Collection)itemNum2QueryUnit.get(queryUnit.getNumber())).add(queryUnit);
            itemMatcher.add(queryUnit, new Object[]{queryUnit.getOrgUnit().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getValueType().getValue(), queryUnit.getNumber()});
        }
        Collection<SuperSQL> executeSqls = this.buildSqls(itemNum2QueryUnit, fixedSourceTypes);
        String sql = null;
        for (SuperSQL executeSql : executeSqls) {
            try {
                sql = executeSql.sql();
                LOG.debug("query dcslitem's sql:\n{0}", new Object[]{sql});
                IRowSet dataRs = this.dao.getExecuteSQL().executeQuery(sql, executeSql.params());
                if (dataRs.size() == 0) {
                    LOG.debug("no dcslitem value be queryed with sql:{0}/*param:{1}*/", new Object[]{sql, executeSql.params()});
                    HashMap<CSLItemQueryUnit, ItemResult> hashMap = itemValues;
                    return hashMap;
                }
                while (dataRs.next()) {
                    this.matchData(itemValues, itemMatcher, dataRs);
                }
            }
            catch (SQLException e) {
                LOG.error("", e);
                throw new SQLDataException(e);
            }
            finally {
                executeSql.clear();
            }
        }
        return itemValues;
    }

    protected void matchData(Map<CSLItemQueryUnit, ItemResult> itemValues, ObjectMatcher<CSLItemQueryUnit> itemMatcher, IRowSet dataRs) throws SQLException {
        Set<CSLItemQueryUnit> finds = null;
        BigDecimal newValue = null;
        String sourceId = null;
        int sourceType = -1;
        ItemResult preResult = null;
        String dynaName = null;
        String dynaNumber = null;
        finds = itemMatcher.get(new Object[]{dataRs.getString("FOrgUnitId"), dataRs.getInt("fperiodType"), dataRs.getString("fCurrencyId"), dataRs.getInt("fyear"), dataRs.getInt("fperiod"), dataRs.getInt("fdataElement"), dataRs.getInt("fValueType"), dataRs.getString("FItemID")});
        if (finds != null) {
            if (finds.size() > 1) {
                LOG.debug("too many matcher exception.", new Object[0]);
            }
            newValue = dataRs.getBigDecimal("result");
            sourceId = dataRs.getString("sourceId");
            sourceType = dataRs.getInt("sourceType");
            dynaName = dataRs.getString("DynaName");
            dynaNumber = dataRs.getString("FKeyNumber");
            for (CSLItemQueryUnit find : finds) {
                preResult = itemValues.get(find);
                preResult = new HandleMultiItemValue().exec(preResult, newValue, sourceId, sourceType, find.getType());
                preResult.setDynaName(dynaName);
                SplitedCSLItemQueryUnit splitedQueryUnit = new SplitedCSLItemQueryUnit(find);
                splitedQueryUnit.updateDynaInfo(dynaNumber, dynaName, "");
                itemValues.put(splitedQueryUnit, preResult);
                if (this.updateItemDC == null) continue;
                this.updateItemDC.add(splitedQueryUnit, preResult);
            }
        }
    }

    public Collection<SuperSQL> buildSqls(Map<String, Collection<CSLItemQueryUnit>> itemNum2QueryUnit, Collection<Integer> fixedSourceTypes) {
        Collection<CSLItemQueryUnit> queryUnits = null;
        HashSet<SuperSQL> executeSqls = new HashSet<SuperSQL>();
        SuperSQL sql = this.createNewSuperSQL(fixedSourceTypes);
        int limitNum = 0;
        for (String itemKey : itemNum2QueryUnit.keySet()) {
            queryUnits = itemNum2QueryUnit.get(itemKey);
            for (CSLItemQueryUnit queryUnit : queryUnits) {
                if (queryUnit.getExtraSQL() != null) {
                    ((CircleSQL)sql.getFormats().get(0)).add(new Object[]{queryUnit.getExtraSQL()}, new Object[]{queryUnit.getOrgUnit().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getValueType().getValue(), queryUnit.getNumber()});
                } else {
                    ((CircleSQL)sql.getFormats().get(0)).add(new Object[]{""}, new Object[]{queryUnit.getOrgUnit().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getValueType().getValue(), queryUnit.getNumber()});
                }
                ++limitNum;
            }
            if (limitNum <= 100) continue;
            executeSqls.add(sql);
            sql = this.createNewSuperSQL(fixedSourceTypes);
            limitNum = 0;
        }
        if (limitNum != 0) {
            executeSqls.add(sql);
        }
        return executeSqls;
    }

    protected SuperSQL createNewSuperSQL(Collection<Integer> fixedSourceTypes) {
        String sourceTypeCondition = "";
        if (!fixedSourceTypes.isEmpty()) {
            sourceTypeCondition = " and define.FDataSource in ( " + StringUtil.toSql(fixedSourceTypes, false) + " ) ";
        }
        SuperSQL sql = new SuperSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/item/csl/queryDCSLItem.sql").sql());
        CircleSQL where = new CircleSQL(new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/item/csl/queryDCSLItem_ItemCondition_CircleEntry.sql").sql());
        where.setJoinChar("or");
        where.setWithBlockChar(true);
        sql.set(new Object[]{where, sourceTypeCondition}, new Object[0]);
        return sql;
    }
}

