/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.StringSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class UpdateItemDC {
    private DBHandler dao;
    private Map<String, Collection<ItemResult>> itemCache = new HashMap<String, Collection<ItemResult>>(10);

    public UpdateItemDC(DBHandler dao) {
        this.dao = dao;
    }

    public void add(IItemQueryUnit itemQueryUnit, ItemResult itemResult) {
        if (itemQueryUnit == null || StringUtils.isEmpty((String)itemQueryUnit.getNumber()) || itemResult == null) {
            return;
        }
        Collection<Object> results = null;
        if (!this.itemCache.containsKey(itemQueryUnit.getNumber())) {
            results = new HashSet(5);
            this.itemCache.put(itemQueryUnit.getNumber(), results);
        } else {
            results = this.itemCache.get(itemQueryUnit.getNumber());
        }
        results.add(itemResult);
    }

    public void exec() throws BOSException {
        if (this.itemCache.isEmpty()) {
            return;
        }
        this.execByItemDefine();
    }

    public void execByItemDefine() throws BOSException {
        StringSQL sql = new StringSQL();
        sql.append(" select fnumber,fdc from t_csl_rptitem ");
        sql.append(" where fnumber in (");
        sql.append(StringUtil.toSql(this.itemCache.keySet(), true, ",", null));
        sql.append(" )");
        IRowSet data = this.dao.getExecuteSQL().executeQuery(sql.sql(), new Object[0]);
        if (data.size() == 0) {
            return;
        }
        try {
            String number = null;
            boolean dc = true;
            while (data.next()) {
                number = data.getString("fnumber");
                dc = data.getBoolean("fdc");
                if (!this.itemCache.containsKey(number)) continue;
                for (ItemResult result : this.itemCache.get(number)) {
                    result.setDebitOrCredit(dc);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

