/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;

public class CellUtil {
    public static ItemFormula getItemFormula(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object itemFormula = cell.getUserObjectValue("ITEM");
        if (!(itemFormula instanceof ItemFormula)) {
            return null;
        }
        return (ItemFormula)itemFormula;
    }

    public static String getValueFormula(Cell cell) {
        if (cell == null || cell.getFormula() == null || "".equals(cell.getFormula())) {
            return "";
        }
        return cell.getFormula();
    }

    public static boolean isEmptyValueFormula(Cell cell) {
        return "".equals(CellUtil.getValueFormula(cell));
    }

    public static boolean isValidValueFormula(Cell cell) {
        return CellUtil.getValueFormula(cell) != null && CellUtil.getValueFormula(cell).startsWith("=");
    }

    public static void insertRowRange(int site, int range, Sheet curSheet) {
        for (int i = 0; i <= range; ++i) {
            CellUtil.insertRow(site + i, curSheet);
        }
    }

    public static void insertRow(int site, Sheet curSheet) {
        ValidationList upRowPartValidationList = curSheet.getValidations().getClippedCopy(0, 0, curSheet.getMaxColIndex(), site - 1);
        UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(site, site)).insert(true, InsertType.NOSTYLE);
        curSheet.getValidations().merge(upRowPartValidationList, 0, 0);
    }

    public static void insertCol(int site, Sheet curSheet) {
        ValidationList upRowPartValidationList = curSheet.getValidations().getClippedCopy(0, 0, site - 1, curSheet.getMaxRowIndex());
        UserObjectHelper.getUnprotectedRange((Range)curSheet.getColRange(site, site)).insert(false, InsertType.NOSTYLE);
        curSheet.getValidations().merge(upRowPartValidationList, 0, 0);
    }

    public static void insertColRange(int site, int range, Sheet curSheet) {
        for (int i = 0; i <= range; ++i) {
            CellUtil.insertCol(site + i, curSheet);
        }
    }

    public static int getRow(String cellName) {
        String rowStr = cellName.replaceAll("[a-zA-Z]+", "");
        return Integer.parseInt(rowStr) - 1;
    }

    public static int getCol(String cellName) {
        String rowStr = cellName.replaceAll("[0-9]+", "");
        char c = '\u0000';
        int num = 0;
        for (int i = 0; i < rowStr.length(); ++i) {
            c = rowStr.charAt(i);
            if (c < 'A' || c > 'Z' && (c < 'a' || c > 'z')) {
                throw new RuntimeException(cellName + " is not valid cell name");
            }
            if (c >= 'A' && c <= 'Z') {
                num = num * 26 + (c - 65 + 1);
                continue;
            }
            if (c < 'a' || c > 'z') continue;
            num = num * 26 + (c - 97 + 1);
        }
        return num - 1;
    }

    public static String name(int row, int col) {
        StringBuffer name = new StringBuffer();
        int diff = 25;
        int small = col % diff;
        name.append(new String(new char[]{(char)(small + 65)}));
        for (int pos = col / diff; pos > 0; pos /= diff) {
            name.insert(0, new String(new char[]{(char)(pos - 1 + 65)}));
        }
        return name.toString() + (row + 1);
    }
}

