/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.BuildExprForDefault;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.IBuildExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.BlockExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.ErrorExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.FormulaExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.IExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.IHasSubExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.JoinExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.LogicExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.MultiExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.NumberExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.StringExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.UnKnownExpr;
import java.util.Stack;

public class ParseExpression {
    private IBuildExpr builder;

    public ParseExpression() {
        this.builder = new BuildExprForDefault();
    }

    public ParseExpression(IBuildExpr builder) {
        this.builder = builder;
    }

    public IExpr exec(String str) {
        int charIndex = 0;
        StringBuffer expr = new StringBuffer();
        Stack<Character> matchChar = new Stack<Character>();
        Stack<IExpr> exprObj = new Stack<IExpr>();
        IExpr preObj = null;
        String join = null;
        MultiExpr root = new MultiExpr();
        exprObj.push(root);
        int currLevel = 1;
        IHasSubExpr parent = null;
        Stack<Integer> blockLevels = new Stack<Integer>();
        while (charIndex < str.length()) {
            IExpr preExpr;
            char strChar = str.charAt(charIndex);
            preObj = this.getPreObj(exprObj);
            Character preChar = null;
            preChar = matchChar.isEmpty() ? Character.valueOf('~') : (Character)matchChar.peek();
            switch (strChar) {
                case '\"': {
                    if (preChar.charValue() == '\"' && str.charAt(charIndex - 1) == '\\') {
                        expr.append(strChar);
                        break;
                    }
                    if (preChar.charValue() != '\"' && expr.toString().trim().length() != 0) {
                        return new ErrorExpr("error:" + str.substring(0, charIndex + 1) + "|expr:" + expr.toString().trim());
                    }
                    if (preChar.charValue() == '\"') {
                        StringExpr currExpr = new StringExpr(expr.toString());
                        matchChar.pop();
                        parent = this.getParent(preObj, currLevel);
                        if (parent != null) {
                            parent.append(currExpr);
                            exprObj.push(currExpr);
                            expr.setLength(0);
                            break;
                        }
                    } else if (preChar.charValue() != '\"' && expr.toString().trim().length() == 0) {
                        expr.setLength(0);
                        matchChar.push(Character.valueOf('\"'));
                        break;
                    }
                    expr.append(strChar);
                    break;
                }
                case '(': {
                    if (preChar.charValue() == '\"' || charIndex - 1 >= 0 && str.charAt(charIndex - 1) == '\\') {
                        expr.append(strChar);
                        break;
                    }
                    if (this.isString(expr.toString().trim())) {
                        parent = this.getParent(preObj, currLevel);
                        FormulaExpr formula = new FormulaExpr(expr.toString().trim());
                        ParseExpression.push(exprObj, formula);
                        if (parent != null) {
                            parent.append(formula);
                            expr.setLength(0);
                            ++currLevel;
                        }
                        blockLevels.push(formula.level());
                        break;
                    }
                    if (this.isEmpty(expr)) {
                        parent = this.getParent(preObj, currLevel);
                        BlockExpr block = new BlockExpr();
                        block.append(new MultiExpr());
                        ++currLevel;
                        ParseExpression.push(exprObj, block);
                        if (parent != null) {
                            parent.append(block);
                            expr.setLength(0);
                            ++currLevel;
                        }
                        blockLevels.push(block.level());
                        break;
                    }
                    if (expr.length() > 1 && expr.toString().startsWith("-") && this.isString(expr.toString().substring(1))) {
                        parent = this.getParent(preObj, currLevel);
                        MultiExpr multi = new MultiExpr();
                        multi.append(new NumberExpr(0));
                        multi.append(new JoinExpr("-"));
                        FormulaExpr formula = new FormulaExpr(expr.toString().trim().substring(1));
                        multi.append(formula);
                        ParseExpression.push(exprObj, multi);
                        if (parent != null) {
                            parent.append(multi);
                            expr.setLength(0);
                            ++currLevel;
                            ++currLevel;
                        }
                        blockLevels.push(formula.level());
                        break;
                    }
                    expr.append(strChar);
                    break;
                }
                case ')': {
                    if (preChar.charValue() == '\"' || charIndex - 1 >= 0 && str.charAt(charIndex - 1) == '\\') {
                        expr.append(strChar);
                        break;
                    }
                    if (expr.toString().trim().length() != 0 && preChar.charValue() != '\"') {
                        IExpr preExpr2 = this.getExpr(expr.toString());
                        if (preExpr2 != null) {
                            expr.setLength(0);
                        }
                        if (preExpr2 != null) {
                            parent = this.getParent(preObj, currLevel);
                            if (parent != null) {
                                parent.append(preExpr2);
                                exprObj.push(preExpr2);
                            }
                            preObj = preExpr2;
                        }
                    }
                    int blockLevel = -1;
                    if (!blockLevels.isEmpty()) {
                        blockLevel = (Integer)blockLevels.pop();
                        ParseExpression.pop(exprObj, blockLevel);
                        currLevel = blockLevel;
                        break;
                    }
                    expr.append(strChar);
                    break;
                }
                case '&': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case '<': 
                case '>': {
                    IExpr upExpr;
                    if (preChar.charValue() == '\"' || charIndex - 1 >= 0 && str.charAt(charIndex - 1) == '\\') {
                        expr.append(strChar);
                        break;
                    }
                    if ((strChar == '>' || strChar == '<') && charIndex + 1 < str.length() && str.charAt(charIndex + 1) == '=') {
                        join = strChar + "" + str.charAt(charIndex + 1);
                        ++charIndex;
                    } else {
                        join = strChar + "";
                    }
                    IExpr preExpr3 = null;
                    parent = this.getParent(preObj, currLevel);
                    if (parent instanceof LogicExpr && ((LogicExpr)parent).sub().size() == 2) {
                        upExpr = ParseExpression.pop(exprObj, ((LogicExpr)parent).level());
                        parent = upExpr.getParent();
                        currLevel = upExpr.level();
                    }
                    if (strChar == '-' && preObj != null && (preObj.level() == currLevel - 1 || preObj.level() == currLevel && (parent instanceof FormulaExpr || parent instanceof MultiExpr && parent.sub().size() == parent.joins().size())) && expr.length() == 0) {
                        expr.append(strChar);
                        break;
                    }
                    if (expr.toString().trim().length() != 0 && (preExpr3 = this.getExpr(expr.toString())) != null) {
                        expr.setLength(0);
                    }
                    if (strChar == '>' || strChar == '<') {
                        LogicExpr logic = new LogicExpr();
                        if (preExpr3 == null) {
                            logic.append(preObj);
                            parent.update(preObj, logic);
                            if (!exprObj.isEmpty() && exprObj.peek() == preObj) {
                                exprObj.pop();
                            }
                        } else {
                            logic.append(preExpr3);
                            parent.append(logic);
                            preObj = preExpr3;
                        }
                        exprObj.push(logic);
                        ++currLevel;
                    } else if (preExpr3 != null) {
                        if (parent instanceof FormulaExpr && strChar == ',' || parent instanceof MultiExpr && strChar != ',' || parent instanceof LogicExpr && ((LogicExpr)parent).sub().size() == 1 || parent instanceof BlockExpr) {
                            parent.append(preExpr3);
                            preObj = ParseExpression.push(exprObj, preExpr3);
                            currLevel = preObj.level();
                        } else if (parent instanceof FormulaExpr && strChar != ',') {
                            MultiExpr multi = new MultiExpr();
                            multi.append(preExpr3);
                            parent.append(multi);
                            preObj = ParseExpression.push(exprObj, multi);
                            currLevel = preObj.level();
                        } else if (parent instanceof MultiExpr && strChar == ',') {
                            parent.append(preExpr3);
                            ParseExpression.push(exprObj, preExpr3);
                            preObj = parent;
                            currLevel = preObj.level();
                            ParseExpression.pop(exprObj, currLevel);
                        }
                    }
                    parent = this.getParent(preObj, currLevel);
                    if (parent instanceof LogicExpr && ((LogicExpr)parent).sub().size() == 2) {
                        upExpr = ParseExpression.pop(exprObj, ((LogicExpr)parent).level());
                        parent = upExpr.getParent();
                        currLevel = upExpr.level();
                    }
                    if (parent != null) {
                        parent.append(new JoinExpr(join));
                        break;
                    }
                    expr.append(join);
                    break;
                }
                case ' ': {
                    if (preChar.charValue() != '\"') break;
                }
                default: {
                    expr.append(strChar);
                }
            }
            if (++charIndex < str.length() || expr.toString().trim().length() == 0 || preChar.charValue() == '\"' || (preExpr = this.getExpr(expr.toString())) == null) continue;
            expr.setLength(0);
            parent = this.getParent(preObj, currLevel);
            if (parent == null) continue;
            parent.append(preExpr);
            exprObj.push(preExpr);
        }
        if (root.sub().size() == 1) {
            root.sub().get(0).setParent(null);
            return root.sub().get(0);
        }
        return root;
    }

    private IExpr getExpr(String expr) {
        if (this.builder != null) {
            return this.builder.exec(expr);
        }
        return new UnKnownExpr(expr);
    }

    public static IExpr pop(Stack<IExpr> exprObj, int blockLevel) {
        if (exprObj.isEmpty()) {
            return null;
        }
        while (exprObj.peek().level() > blockLevel) {
            exprObj.pop();
        }
        return exprObj.peek();
    }

    protected IHasSubExpr getParent(IExpr preObj, int currLevel) {
        IHasSubExpr parent = null;
        int level = preObj.level();
        IHasSubExpr preSParent = preObj.getParent();
        if (level == currLevel && preSParent instanceof IHasSubExpr) {
            parent = preSParent;
        } else if (level == currLevel - 1 && preObj instanceof IHasSubExpr) {
            parent = (IHasSubExpr)preObj;
        }
        if (parent != null) {
            // empty if block
        }
        return parent;
    }

    public static IExpr push(Stack<IExpr> exprObj, IExpr preExpr) {
        exprObj.push(preExpr);
        while (preExpr instanceof IHasSubExpr && !((IHasSubExpr)preExpr).sub().isEmpty()) {
            for (IExpr expr : ((IHasSubExpr)preExpr).sub()) {
                exprObj.push(expr);
            }
            preExpr = exprObj.peek();
        }
        return preExpr;
    }

    private boolean isEmpty(StringBuffer expr) {
        return expr.toString().trim().length() == 0;
    }

    private boolean isString(Object obj) {
        if (obj instanceof StringExpr) {
            return ((StringExpr)obj).getContent().matches("[a-zA-Z0-9_]+");
        }
        if (obj instanceof UnKnownExpr) {
            return ((UnKnownExpr)obj).getContent().matches("[a-zA-Z0-9_]+");
        }
        if (obj instanceof String) {
            return ((String)obj).matches("[a-zA-Z0-9_]+");
        }
        return false;
    }

    private IExpr getPreObj(Stack<IExpr> exprObj) {
        if (exprObj.isEmpty()) {
            return null;
        }
        return (IExpr)exprObj.get(exprObj.size() - 1);
    }
}

