/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

public class DebugLogger
extends Logger {
    protected Map<Integer, OutputStream> prints;

    protected DebugLogger(String name, Map<Integer, OutputStream> prints) {
        super(name);
        this.prints = prints;
    }

    protected void print(Integer printType, Object message, Throwable t) {
        OutputStream print = null;
        print = !this.prints.containsKey(printType) ? this.prints.get(LogFactory.DEBUG) : this.prints.get(printType);
        this.write(print, message == null ? null : message.toString());
        this.write(print, "\n");
    }

    protected void write(OutputStream print, String content) {
        if (content == null || "".equals(content)) {
            return;
        }
        try {
            print.write(content.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void debug(Object message) {
        this.print(LogFactory.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.print(LogFactory.DEBUG, message, t);
    }

    public void error(Object message, Throwable t) {
        this.print(LogFactory.ERROR, message, t);
    }

    public void error(Object message) {
        this.print(LogFactory.ERROR, message, null);
    }

    public void info(Object message, Throwable t) {
        this.print(LogFactory.INFO, message, t);
    }

    public void info(Object message) {
        this.print(LogFactory.INFO, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.print(LogFactory.WARN, message, t);
    }

    public void warn(Object message) {
        this.print(LogFactory.WARN, message, null);
    }
}

