/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.BuildElimRptBookInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.FormulaItemData;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IDataSourceHandle;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IItemData;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DataSourceHandle
implements IDataSourceHandle {
    protected int _precision;
    protected BuildElimRptBookInfo _buildInfo;
    protected int _notMatchValHandleType;
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.elimreport.DataSourceHandle");

    public DataSourceHandle(int precision, BuildElimRptBookInfo buildInfo, int notMatchType) {
        this._precision = precision;
        this._buildInfo = buildInfo;
        this._notMatchValHandleType = notMatchType;
    }

    @Override
    public void handle() {
        Map<String, List<IItemData>> originalData = this._buildInfo.getOriginalData();
        Map<String, List<IItemData>> modifiedData = this._buildInfo.getModifiedData();
        if (modifiedData == null || modifiedData.size() == 0) {
            return;
        }
        if (DebugLogger.isDebug || logger.isDebugEnabled()) {
            logger.info((Object)("DataSourceHandle-Before_Compare_OriginalData:" + originalData));
            logger.info((Object)("DataSourceHandle-Before_Compare_ModifiedData:" + originalData));
        }
        HashMap foundItems = new HashMap();
        for (Map.Entry<String, List<IItemData>> entry : modifiedData.entrySet()) {
            if (!originalData.containsKey(entry.getKey())) {
                this.handleOrginalDataIsNull(entry.getValue());
                continue;
            }
            if (originalData.get(entry.getKey()) != null && originalData.get(entry.getKey()).size() > 0) {
                List<IItemData> itemDataList = originalData.get(entry.getKey());
                HashMap<IItemData, Integer> itemDataMap = new HashMap<IItemData, Integer>();
                for (int i = 0; i < itemDataList.size(); ++i) {
                    itemDataMap.put(itemDataList.get(i), i);
                }
                for (IItemData modifiedItemData : entry.getValue()) {
                    Integer i = (Integer)itemDataMap.get(modifiedItemData);
                    if (i != null) {
                        this.handleVal(modifiedItemData, itemDataList.get(i));
                        if (!foundItems.containsKey(entry.getKey())) {
                            foundItems.put(entry.getKey(), new ArrayList());
                        }
                        ((List)foundItems.get(entry.getKey())).add(i);
                        continue;
                    }
                    this.handleOrginalDataNotMatchItem(modifiedItemData);
                }
                itemDataMap.clear();
                continue;
            }
            this.handleOrginalDataIsNull(entry.getValue());
        }
        if (DebugLogger.isDebug || logger.isDebugEnabled()) {
            logger.info((Object)("DataSourceHandle-After_Compare_ModifiedData:" + originalData));
        }
        for (Map.Entry<String, List<IItemData>> entry : originalData.entrySet()) {
            List indexs = (List)foundItems.get(entry.getKey());
            if (indexs == null) continue;
            Collections.sort(indexs);
            for (int i = indexs.size() - 1; i >= 0; --i) {
                entry.getValue().remove(i);
            }
        }
        this.fillBack2Book();
    }

    private void fillMoreOriginalMoreItemDatas2Book() throws Exception {
        RowAndCellRela rowCellRela;
        PointAndRowsDataRela pointRowRela;
        SheetAndBasePointRela sheetPntRela;
        Map<String, List<IItemData>> map = this._buildInfo.getOriginalData();
        if (map.size() == 0) {
            return;
        }
        Map<Object, Object> tableValues = this._buildInfo.getTableScanValues();
        BookAndSheetRela bookStRela = new BookAndSheetRela();
        for (Map.Entry<String, List<IItemData>> entry : map.entrySet()) {
            Map sheetMap = (Map)tableValues.get(entry.getKey());
            block1: for (IItemData itemData : entry.getValue()) {
                for (Map.Entry entry3 : sheetMap.entrySet()) {
                    Map pointMap = (Map)entry3.getValue();
                    Map formulaMap = (Map)pointMap.get("formulas");
                    for (Map.Entry entry4 : formulaMap.entrySet()) {
                        ItemFormula formula = (ItemFormula)entry4.getValue();
                        if (!this.isEqualsFormula(formula, ((FormulaItemData)itemData).getFormula())) continue;
                        itemData.getPosition().x = ((Point)entry4.getKey()).x;
                        itemData.getPosition().y = ((Point)entry4.getKey()).y;
                        if (!bookStRela.containsSheet(entry.getKey())) {
                            sheetPntRela = new SheetAndBasePointRela(entry.getKey());
                            bookStRela.addSheet(sheetPntRela);
                        }
                        if (!(sheetPntRela = bookStRela.getSheet(entry.getKey())).containsPoint((Point)entry3.getKey())) {
                            pointRowRela = new PointAndRowsDataRela((Point)entry3.getKey());
                            sheetPntRela.addPoint(pointRowRela);
                        }
                        if (!(pointRowRela = sheetPntRela.getPoint((Point)entry3.getKey())).isSameRow(((FormulaItemData)itemData).getKeyNumber())) {
                            rowCellRela = new RowAndCellRela(((FormulaItemData)itemData).getKeyNumber());
                            rowCellRela.setKeyDisplay(((FormulaItemData)itemData).getKeyName());
                            pointRowRela.addRow(rowCellRela);
                        }
                        rowCellRela = pointRowRela.getRow(((FormulaItemData)itemData).getKeyNumber());
                        rowCellRela.add(itemData);
                        continue block1;
                    }
                }
            }
        }
        String keyDisplay = null;
        boolean isSumByName = false;
        Book book = this._buildInfo.getElimRptInfo().getBook();
        int size = bookStRela.getSheets().size();
        for (int i = 0; i < size; ++i) {
            sheetPntRela = bookStRela.getSheets().get(i);
            Sheet sheet = book.getSheetByID(sheetPntRela.getSheetId());
            sheetPntRela.pointsSort();
            for (int k = sheetPntRela.getPoints().size() - 1; k >= 0; --k) {
                StyleAttributes sa2;
                pointRowRela = sheetPntRela.getPoints().get(k);
                Point basePoint = pointRowRela.getPoint();
                DynaParameters params = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)pointRowRela.getPoint());
                if (params == null || params.getSpreadStyle() == 1) continue;
                isSumByName = ElimReportUtils.isSumByName(params.getSumMethod());
                int beginRowIndex = -1;
                int insertCount = pointRowRela.getRows().size();
                beginRowIndex = ElimReportUtils.insertRows(book, basePoint, pointRowRela.getRows().size());
                int defaultCounter = params.getDefaultCounter() + insertCount;
                params.setDefaultCounter(defaultCounter);
                DynamicTemplateUtility.saveParametersToCell((Cell)sheet.getCell(basePoint.y, basePoint.x, true), (DynaParameters)params);
                int size3 = pointRowRela.getRows().size();
                for (int j = 0; j < size3; ++j) {
                    rowCellRela = pointRowRela.getRows().get(j);
                    keyDisplay = StringUtils.isEmpty((String)rowCellRela.getKeyDisplay()) ? rowCellRela.getKeyName() : rowCellRela.getKeyDisplay();
                    sheet.getRow(beginRowIndex, true).getCell(basePoint.x, true).setValue(new Variant((Object)keyDisplay));
                    if (isSumByName) {
                        DynaItemListener.autoFillFormula((Sheet)sheet, (int)beginRowIndex, (int)basePoint.x, (String)rowCellRela.getKeyName(), null, (int)0, null, (boolean)false);
                    }
                    int size4 = rowCellRela.getCells().size();
                    for (int y = 0; y < size4; ++y) {
                        IItemData itemData;
                        itemData = rowCellRela.getCells().get(y);
                        Object value = itemData.getValue();
                        if (value instanceof BigDecimal) {
                            value = ((BigDecimal)value).negate();
                        }
                        sheet.getRow(beginRowIndex, true).getCell(itemData.getPosition().x, true).setValue(new Variant(value));
                    }
                    ++beginRowIndex;
                }
                StyleAttributes sa = sa2 = Styles.getEmptySA();
                sa.setBackground(Color.YELLOW);
                sheet.getRange(beginRowIndex - insertCount, basePoint.x, beginRowIndex - 1, basePoint.x + DynamicTemplateUtility.getDynaHeadItemCount((Sheet)sheet, (Point)basePoint)).setStyle(sa, sa2);
                DynamicTemplateUtility.autoAdjustSum((Sheet)sheet, (Point)basePoint, (int)defaultCounter, (boolean)true);
            }
        }
        this._buildInfo.getElimRptInfo().setBook(book);
    }

    private boolean isEqualsFormula(ItemFormula left, ItemFormula right) {
        return this.getFormulaKey(left).equals(this.getFormulaKey(right));
    }

    private String getFormulaKey(ItemFormula formula) {
        StringBuffer key = new StringBuffer();
        ElimReportUtils.combineKey(key, formula.getItemNumber());
        ElimReportUtils.combineKey(key, "" + formula.getYear());
        ElimReportUtils.combineKey(key, "" + formula.getPeriod());
        ElimReportUtils.combineKey(key, formula.getDataElementNumber());
        ElimReportUtils.combineKey(key, "" + formula.getValueType());
        return key.toString();
    }

    private void fillBack2Book() {
        CslReportInfo elimRptInfo = this._buildInfo.getElimRptInfo();
        try {
            Book book = elimRptInfo.getBook();
            book.getUndoManager().enable(false);
            boolean isAutoCalculate = book.isAutoCalculate();
            book.setCalculate(false);
            for (Map.Entry<String, List<IItemData>> entry : this._buildInfo.getModifiedData().entrySet()) {
                Sheet sheet = book.getSheetByID(entry.getKey());
                for (IItemData item : entry.getValue()) {
                    Cell cell = sheet.getCell(item.getPosition().x, item.getPosition().y, true);
                    if (cell == null) continue;
                    if (item.getValue() instanceof Variant) {
                        cell.setValue((Variant)item.getValue());
                        continue;
                    }
                    System.out.println(item.getValue());
                }
            }
            elimRptInfo.setBook(book);
            this.fillMoreOriginalMoreItemDatas2Book();
            book = this._buildInfo.getElimRptInfo().getBook();
            book.setCalculate(true);
            book.calc();
            book.setCalculate(isAutoCalculate);
            book.getUndoManager().enable(true);
            this._buildInfo.getElimRptInfo().setBook(book);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleOrginalDataIsNull(List<IItemData> lst) {
        if (lst != null && lst.size() > 0) {
            Iterator<IItemData> it = lst.iterator();
            while (it.hasNext()) {
                this.handleOrginalDataNotMatchItem(it.next());
            }
        }
    }

    private void handleOrginalDataNotMatchItem(IItemData item) {
        if (3 == item.getValueType()) {
            return;
        }
        if (3 == this._notMatchValHandleType) {
            item.setValue(Variant.nullVariant);
        } else if (2 == this._notMatchValHandleType) {
            BigDecimal bg = this.getBigDecimalVal(item);
            bg.setScale(this._precision, 4);
            if (bg.compareTo(new BigDecimal("0.0")) == 0) {
                item.setValue(Variant.nullVariant);
            } else {
                item.setValue(new Variant((Object)bg));
            }
        }
    }

    protected BigDecimal getBigDecimalVal(IItemData item) {
        try {
            return new BigDecimal(item.getValue().toString());
        }
        catch (Exception e) {
            return new BigDecimal("0");
        }
    }

    public abstract void handleVal(IItemData var1, IItemData var2);

    class RowAndCellRela {
        private String keyName;
        private String keyDisplay;
        private List<IItemData> items;

        public RowAndCellRela(String keyName) {
            this.keyName = keyName;
            this.items = new ArrayList<IItemData>();
        }

        public void add(IItemData itemData) {
            this.items.add(itemData);
        }

        public String getKeyDisplay() {
            return this.keyDisplay;
        }

        public void setKeyDisplay(String keyDisplay) {
            this.keyDisplay = keyDisplay;
        }

        public List<IItemData> getCells() {
            return this.items;
        }

        public String getKeyName() {
            return this.keyName;
        }
    }

    class PointAndRowsDataRela {
        private Point point;
        private List<RowAndCellRela> rows;

        public PointAndRowsDataRela(Point point) {
            this.point = point;
            this.rows = new ArrayList<RowAndCellRela>();
        }

        public void addRow(RowAndCellRela row) {
            this.rows.add(row);
        }

        public List<RowAndCellRela> getRows() {
            return this.rows;
        }

        public Point getPoint() {
            return this.point;
        }

        public boolean isSameRow(String keyName) {
            return this.getRowIndex(keyName) != -1;
        }

        public RowAndCellRela getRow(String keyName) {
            return this.rows.get(this.getRowIndex(keyName));
        }

        private int getRowIndex(String keyName) {
            int size = this.rows.size();
            for (int i = 0; i < size; ++i) {
                if (!this.rows.get(i).getKeyName().equals(keyName)) continue;
                return i;
            }
            return -1;
        }
    }

    class SheetAndBasePointRela {
        private String sheetId;
        private List<PointAndRowsDataRela> points;

        protected SheetAndBasePointRela(String sheetId) {
            this.sheetId = sheetId;
            this.points = new ArrayList<PointAndRowsDataRela>();
        }

        public void addPoint(PointAndRowsDataRela point) {
            this.points.add(point);
        }

        public List<PointAndRowsDataRela> getPoints() {
            return this.points;
        }

        public String getSheetId() {
            return this.sheetId;
        }

        public void pointsSort() {
            Collections.sort(this.points, new Comparator<PointAndRowsDataRela>(){

                @Override
                public int compare(PointAndRowsDataRela o1, PointAndRowsDataRela o2) {
                    return ((PointAndRowsDataRela)o1).point.y > ((PointAndRowsDataRela)o2).point.y ? 1 : 0;
                }
            });
        }

        public boolean containsPoint(Point point) {
            return this.getPointIndex(point) != -1;
        }

        public PointAndRowsDataRela getPoint(Point point) {
            return this.points.get(this.getPointIndex(point));
        }

        private int getPointIndex(Point point) {
            int size = this.points.size();
            for (int i = 0; i < size; ++i) {
                if (!this.points.get(i).getPoint().equals(point)) continue;
                return i;
            }
            return -1;
        }
    }

    class BookAndSheetRela {
        private List<SheetAndBasePointRela> sheets = new ArrayList<SheetAndBasePointRela>();

        public void addSheet(SheetAndBasePointRela sheet) {
            this.sheets.add(sheet);
        }

        public List<SheetAndBasePointRela> getSheets() {
            return this.sheets;
        }

        public boolean containsSheet(String sheetId) {
            return this.getSheetIndex(sheetId) != -1;
        }

        public SheetAndBasePointRela getSheet(String sheetId) {
            return this.sheets.get(this.getSheetIndex(sheetId));
        }

        private int getSheetIndex(String sheetId) {
            int size = this.sheets.size();
            for (int i = 0; i < size; ++i) {
                if (!this.sheets.get(i).getSheetId().equals(sheetId)) continue;
                return i;
            }
            return -1;
        }
    }
}

