/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataFactory;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import java.awt.Point;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class DynaRangeProvider {
    private HashMap getDynaRange(Sheet sheet, Cell cell) throws BOSException, SQLException, EASBizException {
        ArrayList pointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isNotBasePoint = true;
        DynaRptBasePointIndexHandle indexHandle = null;
        int sumFormulaCount = 0;
        for (int i = 0; i < pointList.size(); ++i) {
            Point point;
            Point basePoint = (Point)pointList.get(i);
            int x = basePoint.y;
            int y = basePoint.x;
            if (cell == null || x != cell.getRow() || y != cell.getCol()) continue;
            isNotBasePoint = false;
            DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
            int colSize = param.getDefaultCounter();
            map.put("basePoint", basePoint);
            if (param.getDynaItemSource() == 0) {
                map.put("dynaSource", DynaItemTypeEnum.ManualImport);
            } else {
                DynaItemTypeEnum dynaSource = null;
                String itemName = param.getAssistantType().properityName;
                String asstType = (String)DynaItemDataFactory.getRemoteInstance().getDynaItemType(itemName);
                if (asstType.equals("companyOrg")) {
                    dynaSource = DynaItemTypeEnum.Company;
                } else if (asstType.equals("customer")) {
                    dynaSource = DynaItemTypeEnum.Custom;
                } else if (asstType.equals("provider")) {
                    dynaSource = DynaItemTypeEnum.Provider;
                } else {
                    dynaSource = DynaItemTypeEnum.Other;
                    map.put("dynaSource_Alias", param.getAssistantType().properityAlias);
                }
                map.put("dynaSource", dynaSource);
            }
            indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
            sumFormulaCount = indexHandle.getSumRangeCount();
            if (param.getSpreadStyle() == 0) {
                int x1 = x + colSize + sumFormulaCount;
                int y1 = this.getColCount(sheet, x, y);
                point = new Point(x1, y1);
                map.put("dynaRangeRow", point);
            } else if (param.getSpreadStyle() == 1) {
                int y1 = y + colSize + sumFormulaCount;
                int x1 = this.getRowCount(sheet, x, y);
                point = new Point(x1, y1);
                map.put("dynaRangeCol", point);
            }
            boolean isGrade = param.isGrade();
            map.put("isGrade", new Boolean(isGrade));
            if (param.isIncludeSum()) {
                map.put("isHaveSumItem", new Boolean(true));
                if (param.getPosition() == 1) {
                    if (param.getSpreadStyle() == 0) {
                        map.put("sumItemRow", new Point(x + 1, 0));
                    }
                    if (param.getSpreadStyle() == 1) {
                        map.put("sumItemCol", new Point(0, y + 1));
                    }
                } else if (param.getPosition() == 2) {
                    if (param.getSpreadStyle() == 0) {
                        map.put("sumItemRow", new Point(x + colSize + sumFormulaCount, 0));
                    }
                    if (param.getSpreadStyle() == 1) {
                        map.put("sumItemCol", new Point(0, y + colSize + sumFormulaCount));
                    }
                }
            } else {
                map.put("isHaveSumItem", null);
            }
            if (param.getOrderBy().getValue() == 1) {
                map.put("orderBy", (Object)OrderByEnum.NONE);
                continue;
            }
            map.put("orderBy", (Object)param.getOrderBy());
            if (param.getSpreadStyle() == 0) {
                String row = Location.getCellName(0, y + param.getOrderRow());
                map.put("orderRow", row);
                continue;
            }
            if (param.getSpreadStyle() != 1) continue;
            map.put("orderCol", new Integer(x + param.getOrderRow()));
        }
        if (isNotBasePoint) {
            return null;
        }
        return map;
    }

    public Point getDynaRange(Sheet sheet, Point basePoint) {
        Point point = null;
        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
        int colSize = param.getDefaultCounter();
        int x = basePoint.y;
        int y = basePoint.x;
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int sumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        if (param.getSpreadStyle() == 0) {
            int x1 = x + colSize + sumFormulaCount;
            point = new Point(this.getColCount(sheet, x, y), x1);
        } else if (param.getSpreadStyle() == 1) {
            int y1 = y + colSize + sumFormulaCount;
            point = new Point(y1, this.getRowCount(sheet, x, y));
        }
        return point;
    }

    public int getColCount(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    public int getRowCount(Sheet curSheet, int top, int left) {
        int height;
        for (int i = height = curSheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = curSheet.getCell(i, left, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }
}

