/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel.utils;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostMan;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostManManager;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.ExcelConstants;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.BookInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.CellInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.SheetInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.SheetOptionInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.ValidationInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.JSONUtils;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.CalculatorUtils;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.StyleUtils;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExcelUtil {
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";

    private static boolean isDynaCslRpt(CslReportInfo cslRptInfo) {
        RptSrcTypeEnum sourceType = cslRptInfo.getSourceType();
        return cslRptInfo != null && (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)sourceType) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)sourceType) || RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)sourceType)) && DynaEnumRptTypeEnum.DYNAMIC.equals((Object)cslRptInfo.getTemplate().getDynaRptType());
    }

    private boolean isDynaTemplate(RptTmpTypeEnum templateType) {
        return templateType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICSUMREPORT) || templateType.equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT);
    }

    public static String formatString(String str) {
        return str.replace("&34&", "\"").replace("&92&", "\\");
    }

    public static String getExportFile(ReportBaseInfo info, boolean isFromMergeReportCenter) {
        String fileName = info.getName();
        if (isFromMergeReportCenter) {
            fileName = info.getName() + "-" + info.getCompany().getName() + "-" + info.getSourceType().getAlias() + "-" + info.getYear() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"80_ExcelUtil") + info.getPeriod() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"81_ExcelUtil") + "-" + info.getCurrency().getName();
        } else {
            fileName = info.getName() + "-" + info.getSourceType().getAlias() + "-" + info.getYear() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"80_ExcelUtil") + info.getPeriod() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"81_ExcelUtil") + "-" + info.getCurrency().getName();
            int version = ExcelUtil.getReportVersion(info);
            if (version != 0) {
                fileName = fileName + "-" + version;
            }
        }
        return ExcelConstants.EXCEL_EXPORT_PATH + fileName + ".xlsx";
    }

    private static int getReportVersion(ReportBaseInfo info) {
        RptSrcTypeEnum type;
        int version = 0;
        if (info instanceof CslReportInfo && ((type = ((CslReportInfo)info).getSourceType()).equals((Object)RptSrcTypeEnum.MANUSCRIPT) || type.equals((Object)RptSrcTypeEnum.MULTIDYNAMICMNSREPORT) || type.equals((Object)RptSrcTypeEnum.MANUSCRIPT_FASTMERGE))) {
            try {
                String osql = "select version where report='" + info.getId().toString() + "'";
                SumRptAddedPerportyInfo propInfo = SumRptAddedPerportyFactory.getRemoteInstance().getSumRptAddedPerportyInfo(osql);
                if (propInfo != null) {
                    version = propInfo.getVersion();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("os.name"));
    }

    public Object initSheet(String json) throws Exception {
        Map paramMap = JSONUtils.convertJsonToObject(json, Map.class);
        String reportId = (String)paramMap.get("reportId");
        String templateId = (String)paramMap.get("templateId");
        String sheetName = (String)paramMap.get("sheetName");
        String reportType = (String)paramMap.get("reportType");
        boolean isRpt = "1".equals(paramMap.get("isRpt"));
        String id = "";
        id = isRpt ? reportId : templateId;
        Map<String, Object> reportMap = this.getRptInfo(id, reportType, isRpt);
        boolean isDynaRpt = (Boolean)reportMap.get("isDynaRpt");
        Book book = (Book)reportMap.get("book");
        book.setAutoCalculate(false);
        Sheet sheet = book.getSheetByName(sheetName);
        if (sheet != null) {
            CellInfo[] cells = StyleUtils.getCellContent(sheet, true);
            SheetOptionInfo sheetOption = StyleUtils.buildSheetOption(sheet);
            SheetInfo sheetInfo = new SheetInfo();
            sheetInfo.setId(sheet.getID());
            if (cells != null) {
                sheetInfo.setCells(cells);
            }
            if (sheetOption != null) {
                sheetInfo.setSheetOption(sheetOption);
            }
            if (book.getActiveSheetIndex() == sheet.getIndex()) {
                sheetInfo.setIsActive(0);
            } else {
                sheetInfo.setIsActive(1);
            }
            if (isDynaRpt) {
                sheetInfo.setDynaInfo(StyleUtils.buildDynaInfo(sheet));
            }
            return sheetInfo;
        }
        return null;
    }

    public SaveRptResult saveRpt(String json) throws Exception {
        SaveRptResult resultInfo = new SaveRptResult();
        BookInfo clientBook = JSONUtils.convertJsonToObject(json, BookInfo.class);
        Book book = null;
        Object rptInfo = null;
        String reportId = clientBook.getReportId();
        if (!StringUtils.isEmpty((String)reportId)) {
            rptInfo = "groupRpt".equals(clientBook.getReportType()) ? CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectStringPK(reportId), this.getCslReportSelectors()) : ReportFactory.getRemoteInstance().getReportInfo((IObjectPK)new ObjectStringPK(reportId), this.getReportSelectors());
            String errMsg = "";
            if (AuditedStatusEnum.AUDITED.equals((Object)rptInfo.getAuditedStatus())) {
                resultInfo.setResult("FAIL");
                resultInfo.setMsg(RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"216_RptReportProcessUI"));
                return resultInfo;
            }
            book = rptInfo.getBook();
            boolean isAutoCalcBook = book.isAutoCalculate();
            book.setAutoCalculate(false);
            this.excelToBook(clientBook, book);
            rptInfo.setBook(book);
            book.setAutoCalculate(isAutoCalcBook);
            if (clientBook.getReportType().equals("groupRpt")) {
                CslReportFactory.getRemoteInstance().update((IObjectPK)new ObjectStringPK(rptInfo.getId().toString()), (CoreBaseInfo)rptInfo);
            } else {
                ReportFactory.getRemoteInstance().update((IObjectPK)new ObjectStringPK(rptInfo.getId().toString()), (CoreBaseInfo)rptInfo);
            }
            reportId = rptInfo.getId().toString();
        } else {
            rptInfo = this.addnew(clientBook, book);
            reportId = rptInfo.getId().toString();
            book = rptInfo.getBook();
        }
        SheetInfo[] sheetInfo = new SheetInfo[book.getSheetCount()];
        for (int i = 0; i < book.getSheetCount(); ++i) {
            SheetInfo tmpSI = new SheetInfo();
            tmpSI.setId(book.getSheet(i).getID());
            tmpSI.setSheetName(book.getSheet(i).getSheetName());
            sheetInfo[i] = tmpSI;
        }
        resultInfo.setReportId(reportId);
        resultInfo.setResult("SUCCESS");
        resultInfo.setMsg(ExcelConstants.MSG_SAVE_SUCCESS);
        if (sheetInfo != null) {
            resultInfo.setSheetInfo(sheetInfo);
        }
        return resultInfo;
    }

    private void excelToBook(BookInfo clientBook, Book book) throws Exception {
        this.refreshSheet(book, clientBook);
        Sheet curRptSheet = null;
        Cell curRptCell = null;
        boolean isEnableCalculation = false;
        for (SheetInfo curSheet : clientBook.getSheets()) {
            curRptSheet = StringUtils.isEmpty((String)curSheet.getId()) ? book.getSheetByName(curSheet.getSheetName()) : book.getSheetByID(curSheet.getId());
            isEnableCalculation = curRptSheet.isEnableCalculation();
            curRptSheet.setEnableCalculation(false);
            if (curSheet.getIsActive() == 0) {
                book.setActiveSheet(curRptSheet.getIndex());
            }
            CalculatorUtils.clearSheetOldData(curRptSheet);
            for (CellInfo cell : curSheet.getCells()) {
                String text;
                if (!(StringUtils.isEmpty((String)cell.getFormula()) && StringUtils.isEmpty((String)cell.getCellValue()) && StringUtils.isEmpty((String)cell.getItemformula()) && StringUtils.isEmpty((String)cell.getExt()) && cell.getComment() == null && cell.getHyperLink() == null)) {
                    curRptCell = curRptSheet.getCell(cell.getRow() - 1, cell.getCol() - 1, true);
                }
                if (curRptCell != null && !StringUtils.isEmpty((String)cell.getFormula()) && !cell.getFormula().toUpperCase(Locale.ENGLISH).equals("NULL")) {
                    curRptCell.setFormula(ExcelUtil.formatString(cell.getFormula()));
                }
                if (curRptCell != null && !StringUtils.isEmpty((String)cell.getItemformula()) && !cell.getItemformula().toUpperCase(Locale.ENGLISH).equals("NULL")) {
                    UserObjectHelper.setItemFormula((Cell)curRptCell, (ItemFormula)new ItemFormula(ExcelUtil.formatString(cell.getItemformula())));
                }
                if (curRptCell != null && !StringUtils.isEmpty((String)cell.getCellValue()) && !cell.getCellValue().toUpperCase(Locale.ENGLISH).equals("NULL")) {
                    String cv = cell.getCellValue();
                    if (!StringUtils.isEmpty((String)cv) && cv.matches("^-?([1-9]\\d*|0)(\\.\\d+)?$") && !"-0".equals(cv)) {
                        curRptCell.setValue(new Variant((Object)new BigDecimal(cv), 10));
                    } else {
                        curRptCell.setValue(new Variant((Object)ExcelUtil.formatString(cv)));
                    }
                }
                if (curRptCell != null && !StringUtils.isEmpty((String)cell.getExt()) && !cell.getExt().toUpperCase(Locale.ENGLISH).equals("NULL")) {
                    ItemFormula vif = new ItemFormula();
                    String[] exts = ExcelUtil.formatString(cell.getExt()).split("#:#");
                    for (int e = 0; e < exts.length; ++e) {
                        String[] es = exts[e].split("#_#");
                        if (es.length == 2) {
                            vif.putExt(es[0], es[1]);
                            continue;
                        }
                        if (es.length != 1) continue;
                        vif.putExt(es[0], "");
                    }
                    UserObjectHelper.setItemFormula((Cell)curRptCell, (ItemFormula)vif);
                }
                if (curRptCell != null && !StringUtils.isEmpty((String)cell.getGradeInfo())) {
                    DItemGradeInfo digi = new DItemGradeInfo();
                    digi.fromSerialString(ExcelUtil.formatString(cell.getGradeInfo()));
                    curRptCell.setUserObject("DItemGradeInfo", (Object)digi);
                }
                if (curRptCell != null && cell.getComment() != null) {
                    text = cell.getComment().getText();
                    curRptCell.setComment(new Comment("", text));
                }
                if (curRptCell != null && cell.getHyperLink() != null) {
                    text = cell.getHyperLink().getText();
                    String linkTo = cell.getHyperLink().getLinkTo();
                    curRptCell.setHyperLink(new HyperLink(text, "#" + linkTo));
                }
                if (curRptCell == null || StringUtils.isEmpty((String)cell.getFormulaExp())) continue;
                String formulaExp = cell.getFormulaExp();
                curRptCell.setUserObject("FormulaExp", (Object)formulaExp);
            }
            if (curSheet.getValidationList() != null && curSheet.getValidationList().size() > 0) {
                this.buildValidation(curRptSheet, curSheet);
            }
            curRptSheet.setEnableCalculation(isEnableCalculation);
        }
    }

    public SheetInfo calcSheet(String json, boolean isFill) throws Exception {
        SheetInfo resultSheet = null;
        BookInfo clientBook = JSONUtils.convertJsonToObject(json, BookInfo.class);
        String reportId = clientBook.getReportId();
        if (!StringUtils.isEmpty((String)reportId) && clientBook.getSheets().length > 0) {
            CslReportInfo reportInfo = null;
            Book book = null;
            if ("groupRpt".equals(clientBook.getReportType())) {
                reportInfo = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectStringPK(reportId), this.getCslReportSelectors());
                book = reportInfo.getBook();
            } else {
                reportInfo = ReportFactory.getRemoteInstance().getReportInfo((IObjectPK)new ObjectStringPK(reportId), this.getReportSelectors());
                book = reportInfo.getBook();
            }
            SheetInfo clientSheet = clientBook.getSheets()[0];
            resultSheet = CalculatorUtils.calcClientSheet(book, clientSheet.getId(), clientSheet, reportInfo, isFill);
        } else {
            TemplateInfo template = null;
            template = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectStringPK(clientBook.getTemplateId()), this.getTemplateSelectors());
            ReportInfo reportInfo = this.constructReportInfoByTmp(template, clientBook);
            Book book = reportInfo.getBook();
            SheetInfo clientSheet = clientBook.getSheets()[0];
            resultSheet = CalculatorUtils.calcClientSheet(book, clientSheet.getId(), clientSheet, (ReportBaseInfo)reportInfo, isFill);
        }
        return resultSheet;
    }

    public String checkAll(String json) throws Exception {
        String result = null;
        BookInfo clientBook = JSONUtils.convertJsonToObject(json, BookInfo.class);
        String reportId = clientBook.getReportId();
        if (!StringUtils.isEmpty((String)reportId)) {
            CslReportInfo rptInfo = null;
            if (clientBook.getReportType().equals("groupRpt")) {
                ICslReport icr = CslReportFactory.getRemoteInstance();
                if (icr.exists((IObjectPK)new ObjectStringPK(reportId))) {
                    rptInfo = icr.getCslReportInfo((IObjectPK)new ObjectStringPK(reportId));
                }
            } else {
                IReport ir = ReportFactory.getRemoteInstance();
                if (ir.exists((IObjectPK)new ObjectStringPK(reportId))) {
                    rptInfo = ir.getReportInfo((IObjectPK)new ObjectStringPK(reportId));
                }
            }
            if (rptInfo != null) {
                Book book = rptInfo.getBook();
                boolean isAutoCalcBook = book.isAutoCalculate();
                book.setAutoCalculate(false);
                this.excelToBook(clientBook, book);
                rptInfo.setBook(book);
                book.setAutoCalculate(isAutoCalcBook);
                result = new CslRptUtil().dataCheckAll(rptInfo);
            }
        } else {
            return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Please_Save_First");
        }
        if (!StringUtils.isEmpty(result)) {
            result = this.formatCheckResult(result);
        }
        return result;
    }

    public String commitRpt(String json, boolean isCommit) throws Exception {
        String result = "";
        BookInfo clientBook = JSONUtils.convertJsonToObject(json, BookInfo.class);
        String reportId = clientBook.getReportId();
        if (!StringUtils.isEmpty((String)reportId)) {
            ReportInfo reportInfo = ReportFactory.getRemoteInstance().getReportInfo((IObjectPK)new ObjectUuidPK(reportId), this.getReportSelectors());
            if (reportInfo != null) {
                Map resultMap;
                List checkedMap;
                if (isCommit && reportInfo.getIsSupportGroup() != IsSupportGroupReportEnum.SUPPORT || CslRptUtil.is13AdjustPeriod(null, reportInfo) || reportInfo.getCslReport() == null) {
                    return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"221_RptReportProcessUI");
                }
                CommittedStatusEnum committedStatus = reportInfo.getCommittedStatus();
                if (isCommit) {
                    if (CommittedStatusEnum.COMMITTED.equals((Object)committedStatus)) {
                        return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"223_RptReportProcessUI");
                    }
                    if (CommittedStatusEnum.GROUPCOMMITTED.equals((Object)committedStatus)) {
                        return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"224_RptReportProcessUI");
                    }
                } else {
                    if (committedStatus.getValue() == 3) {
                        return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"225_RptReportProcessUI");
                    }
                    if (committedStatus.getValue() != 2) {
                        return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"noSubmittedRpt");
                    }
                    if (reportInfo.getAuditedStatus().getValue() == 1) {
                        return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoauditedCannotUnCommit");
                    }
                }
                if (!isCommit && PublishedStatusEnum.PUBLISHED.equals((Object)reportInfo.getPublishedStatus())) {
                    return RptUtil.getReportResource((String)"PublishedCannotUnAudit");
                }
                if (isCommit && reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT)) {
                    StringBuffer result1 = new StringBuffer();
                    result1.append(reportInfo.getName()).append(" :").append("\n");
                    boolean isPassed = CslRptUtil.checkTemplateForItem(reportInfo.getBook(), true, result1);
                    if (!isPassed) {
                        return CslRptUtil.getString("CslRptUCheckFail");
                    }
                }
                RptSrcTypeEnum rptSrcType = reportInfo.getReportSourceType();
                if (isCommit && RptUtil.isTrue((Object)ParamManager.getParamValue(null, null, (String)"GR_CSL_CheckNumber")) && (RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)rptSrcType) || RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)rptSrcType) || RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT.equals((Object)rptSrcType))) {
                    Book book = reportInfo.getBook();
                    FullOrgUnitInfo object = reportInfo.getCompany();
                    ArrayList result1 = new ArrayList();
                    for (int i = 0; i < book.getSheetCount(); ++i) {
                        DynamicTemplateUtility.checkDynaAccountItem((Sheet)book.getSheet(i), (int)reportInfo.getSourceType().getValue(), (boolean)true, (Object)object, result1);
                    }
                    if (result1 != null && result1.size() > 0) {
                        if (result1.size() > 50) {
                            return DynamicTemplateUtility.formatMessageWithNewLine(result1.subList(0, 50), (String)"\n");
                        }
                        return DynamicTemplateUtility.formatMessageWithNewLine(result1, (String)"\n");
                    }
                }
                if (isCommit && !CslRptUtil.isNewVersionStatus(null, (ReportBaseInfo)reportInfo, null)) {
                    return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"8_BaseReportDesignerUI");
                }
                ArrayList<String> reportIdList = new ArrayList<String>();
                ArrayList<String> cslReportIdList = new ArrayList<String>();
                reportIdList.add(reportInfo.getId().toString());
                cslReportIdList.add(reportInfo.getCslReport().getId().toString());
                if (isCommit && (checkedMap = ReportFactory.getRemoteInstance().reportBatchCheck(reportIdList)).get(0) instanceof Map && (resultMap = (Map)checkedMap.get(0)) != null && resultMap.get("REPORTID") != null) {
                    String id = resultMap.get("REPORTID").toString();
                    if (!((Boolean)resultMap.get("CHECKPASSED")).booleanValue()) {
                        result = RptUtil.getReportResource((String)"report") + " \"" + reportInfo.getNumber() + "\" " + RptUtil.getReportResource((String)"AUDIT_FAIL_CHECK_NO_PASS") + " :\n\t" + resultMap.get("CHECKMSG");
                        result = this.formatCheckResult(result);
                        return result;
                    }
                }
                ICslReport icr = CslReportFactory.getRemoteInstance();
                if (isCommit) {
                    icr.auditAndCommit(reportIdList, cslReportIdList);
                } else {
                    icr.unAuditAndUnCommit(reportIdList, cslReportIdList);
                }
            } else {
                result = RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Please_Save_First");
            }
        } else {
            result = RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Please_Save_First");
        }
        return result;
    }

    public SaveRptResult unAuditRpt(String json) throws Exception {
        SaveRptResult resultInfo = new SaveRptResult();
        String result = null;
        BookInfo clientBook = JSONUtils.convertJsonToObject(json, BookInfo.class);
        String reportId = clientBook.getReportId();
        if (!StringUtils.isEmpty((String)reportId)) {
            CslReportInfo rptInfo = null;
            rptInfo = clientBook.getReportType().equals("groupRpt") ? CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectStringPK(reportId), this.getCslReportSelectors()) : ReportFactory.getRemoteInstance().getReportInfo((IObjectPK)new ObjectStringPK(reportId), this.getReportSelectors());
            Book book = rptInfo.getBook();
            boolean isAutoCalcBook = book.isAutoCalculate();
            book.setAutoCalculate(false);
            this.excelToBook(clientBook, book);
            rptInfo.setBook(book);
            book.setAutoCalculate(isAutoCalcBook);
            result = new CslRptUtil().dataCheckAll(rptInfo);
        }
        resultInfo.setResult("SUCCESS");
        result = StringUtils.isEmpty(result) ? EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CheckFormula", (String)"CHECK_MESSAGE_50") : this.formatCheckResult(result);
        resultInfo.setMsg(result);
        return resultInfo;
    }

    private void refreshSheet(Book rptBook, BookInfo clientBook) {
        int i;
        ArrayList<String> idList = new ArrayList<String>();
        for (int i2 = 0; i2 < clientBook.getSheets().length; ++i2) {
            String sheetId = clientBook.getSheets()[i2].getId();
            String sheetName = clientBook.getSheets()[i2].getSheetName();
            if (StringUtils.isEmpty((String)sheetId)) {
                rptBook.insertSheet(i2, new Sheet(rptBook, sheetName));
                sheetId = sheetName;
            } else {
                Sheet sheet = rptBook.getSheetByID(sheetId);
                sheet.setName(sheetName);
            }
            idList.add(sheetId);
        }
        ArrayList<String> removeList = new ArrayList<String>();
        String tempId = "";
        int j = rptBook.getSheetCount();
        for (i = 0; i < j; ++i) {
            tempId = rptBook.getSheet(i).getID();
            if (idList.contains(tempId)) continue;
            removeList.add(tempId);
        }
        for (i = 0; i < removeList.size(); ++i) {
            rptBook.removeSheet(rptBook.getSheetByID((String)removeList.get(i)));
        }
    }

    private Map<String, Object> getRptInfo(String id, String reportType, boolean isRpt) throws Exception {
        Object reportInfo;
        Book book = null;
        String name = null;
        RptTmpTypeEnum templateType = null;
        DynaEnumRptTypeEnum dynaType = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("data");
        if (isRpt) {
            selector.add("template.templateType");
            selector.add("template.dynaRptType");
            reportInfo = !reportType.equals("groupRpt") ? ReportFactory.getRemoteInstance().getReportInfo((IObjectPK)new ObjectStringPK(id), selector) : CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectStringPK(id), selector);
            book = reportInfo.getBook();
            name = reportInfo.getName();
            templateType = reportInfo.getTemplate().getTemplateType();
            dynaType = reportInfo.getTemplate().getDynaRptType();
        } else {
            selector.add("templateType");
            selector.add("dynaRptType");
            reportInfo = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectStringPK(id), selector);
            book = reportInfo.getBook();
            name = reportInfo.getName();
            templateType = reportInfo.getTemplateType();
            dynaType = reportInfo.getDynaRptType();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("book", book);
        map.put("isDynaRpt", DynaEnumRptTypeEnum.DYNAMIC.equals((Object)dynaType));
        return map;
    }

    public SelectorItemCollection getCslReportSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longnumber"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.sheet.sheetid"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.sumType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("reportDate"));
        sic.add(new SelectorItemInfo("template.includeOtherDC"));
        sic.add(new SelectorItemInfo("template.checkOpenPeriod"));
        sic.add(new SelectorItemInfo("template.isSupportInnerExch"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        return sic;
    }

    public SelectorItemCollection getReportSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longnumber"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("company.baseCurrency"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.sheet.sheetid"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.company.id"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.DynaRpttype"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("k3Template.group"));
        sic.add(new SelectorItemInfo("template.checkOpenPeriod"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("cslReport.id"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.company.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Number"));
        sic.add(new SelectorItemInfo("datacollect.id"));
        sic.add(new SelectorItemInfo("datacollect.number"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("template.includeOtherDC"));
        sic.add(new SelectorItemInfo("cslReport.commitor.id"));
        return sic;
    }

    private SelectorItemCollection getTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longnumber"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("company.baseCurrency"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.sheet.sheetid"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.company.id"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        return sic;
    }

    private String formatCheckResult(String result) {
        result = result.replaceAll("<br>", "\n");
        result = result.replaceAll("<[a|A]([^>]*)>", "");
        result = result.replaceAll("</a>", "");
        result = result.replaceAll("&lt;", "<");
        result = result.replaceAll("&gt;", ">");
        result = result.replaceAll("&quot;", "\"");
        result = result.replaceAll("====================================================================", "==========================================");
        return result;
    }

    private ReportInfo addnew(BookInfo clientBook, Book book) throws Exception {
        TemplateInfo template = null;
        template = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectStringPK(clientBook.getTemplateId()), this.getTemplateSelectors());
        ReportInfo reportInfo = this.constructReportInfoByTmp(template, clientBook);
        book = reportInfo.getBook();
        boolean isAutoCalcBook = book.isAutoCalculate();
        book.setAutoCalculate(false);
        this.excelToBook(clientBook, book);
        reportInfo.setBook(book);
        book.setAutoCalculate(isAutoCalcBook);
        IObjectPK pk = ReportFactory.getRemoteInstance().submit((CoreBaseInfo)reportInfo);
        return reportInfo;
    }

    private ReportInfo constructReportInfoByTmp(TemplateInfo tmpl, BookInfo clientBook) throws Exception {
        ReportInfo report = RptNewUIUtil.constructReportInfoByTemplateInfo((TemplateInfo)tmpl);
        report.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        FullOrgUnitInfo company = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(clientBook.getCompanyId()));
        report.setCompany(company);
        report.setYear(clientBook.getYear());
        report.setPeriod((short)clientBook.getPeriod());
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectStringPK(clientBook.getCurrencyId()));
        report.setCurrency(currency);
        report.setSourceCurrency(currency);
        MessagePostManManager msgMng = new MessagePostManManager("RptReportProcessNewUI");
        msgMng.addMessage(new MessagePostMan("fi_rp_005", "fi_rp_005"));
        msgMng = RpcHandleFacadeFactory.getRemoteInstance().getRpcZipData(msgMng);
        boolean ispublic = "true".equalsIgnoreCase(msgMng.getItemStringValue("fi_rp_005"));
        report.setPublicStatus(ispublic ? PublicStatusEnum.PUBLIC : PublicStatusEnum.UNPUBLIC);
        int year = clientBook.getYear();
        int period = clientBook.getPeriod();
        int periodType = clientBook.getPeriodType();
        report.setStartDate(RPTDateUtil.getPeriodFirstDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
        report.setEndDate(RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
        report.setOrgType(OrgType.Company);
        report.put("sheetParam", (Object)tmpl.getSheetParam());
        this.createNewNumber(report);
        return report;
    }

    private String createNewNumber(ReportInfo baseInfo) throws Exception {
        String number = null;
        ICodingRuleManager iCodingRuleManager = null;
        CodingRuleInfo codingRule = null;
        String companyId = baseInfo.getCompany().getId().toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(companyId));
        String companyID = company.getId().toString();
        iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, companyID, "sourceType");
        if (isCodingRule) {
            codingRule = iCodingRuleManager.getCodingRule((IObjectValue)baseInfo, companyID, "sourceType");
        } else {
            isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, companyID);
            if (isCodingRule) {
                codingRule = iCodingRuleManager.getCodingRule((IObjectValue)baseInfo, companyID);
            }
        }
        if (isCodingRule && codingRule != null) {
            number = iCodingRuleManager.getNumber((IObjectValue)baseInfo, codingRule);
        } else if (StringUtils.isEmpty(number)) {
            FilterInfo filterInfo;
            boolean isExists;
            String templateNumber = null;
            templateNumber = baseInfo.getTemplate() == null ? "NOTPL" : baseInfo.getTemplate().getNumber();
            String str = templateNumber + "_" + baseInfo.getYear() + "_" + baseInfo.getPeriod() + "_" + baseInfo.getCurrency().getNumber() + "_";
            int index = 0;
            do {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)(str + ++index)));
            } while (isExists = ReportFactory.getRemoteInstance().exists(filterInfo));
            number = str + index;
        }
        baseInfo.setNumber(number);
        return number;
    }

    public static String getExcelDir() {
        return ExcelConstants.EXCEL_EXPORT_PATH;
    }

    private void buildValidation(Sheet sheet, SheetInfo curSheet) {
        List<ValidationInfo> viList = curSheet.getValidationList();
        for (int i = 0; i < viList.size(); ++i) {
            ValidationInfo vi = viList.get(i);
            Validation val = new Validation(new MessagedValidate(), null);
            MessagedValidate mv = val.getMessagedValidate();
            mv.setType(vi.getTypeString());
            mv.setQualifier(vi.getOperatorString());
            val.setBlocks(SheetBaseMath.getSortedBlocks((Sheet)sheet, (String)vi.getAddress(), (boolean)false));
            mv.setImeMode((int)vi.getiMEMode());
            mv.setCellRangeList(vi.isInCellDropdown());
            mv.setUseBlank(!vi.isIgnoreBlank());
            mv.setInputHide(!vi.isShowInput());
            mv.setErrorHide(!vi.isShowError());
            mv.setMin(vi.getFormula1());
            mv.setMax(vi.getFormula2());
            mv.setInputTitle(vi.getInputTitle());
            mv.setInputMessage(vi.getInputMessage());
            mv.setErrorStyle(vi.getAlertStyleString());
            mv.setErrorTitle(vi.getErrorTitle());
            mv.setErrorMessage(vi.getErrorMessage());
            sheet.getValidations().addValidation(val);
        }
    }

    public class SaveRptResult {
        private String reportId;
        private String result;
        private String msg;
        private SheetInfo[] sheetInfo;

        public String getReportId() {
            return this.reportId;
        }

        public void setReportId(String reportId) {
            this.reportId = reportId;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public SheetInfo[] getSheetInfo() {
            return this.sheetInfo;
        }

        public void setSheetInfo(SheetInfo[] sheetInfo) {
            this.sheetInfo = sheetInfo;
        }
    }
}

