/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.inspect.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataCollection;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectResult;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectResultInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractInspectExe {
    private static final Logger logger = Logger.getLogger(AbstractInspectExe.class);
    public String RES_PATH = "com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectToolResource";

    public abstract Map<String, Object> executeFix(Map<String, Object> var1, Context var2) throws BOSException, EASBizException;

    public String executeFixAndUpdateData(Map<String, Object> filters, Context ctx) throws BOSException, EASBizException {
        Map<String, Object> result = this.executeFix(filters, ctx);
        CslInspectResultInfo cslInspectResultInfo = new CslInspectResultInfo();
        String key = this.getKey(filters);
        cslInspectResultInfo.setNumber(key);
        String inspectId = this.getInspectId(key);
        if (inspectId != null) {
            cslInspectResultInfo.setId(BOSUuid.read((String)inspectId));
        }
        CslInspectInfo inspectInfo = new CslInspectInfo();
        inspectInfo.setId(BOSUuid.read((String)((String)filters.get("inspectId"))));
        cslInspectResultInfo.setInspect(inspectInfo);
        String UIResult = null;
        if (result.get("UIResult") != null && (UIResult = (String)result.get("UIResult")).length() > 2000) {
            UIResult = UIResult.substring(0, 2000);
        }
        cslInspectResultInfo.setExeResult(UIResult);
        CslInspectFixDataCollection fixDatas = cslInspectResultInfo.getFixData();
        if (result.get("resultEntry") != null) {
            fixDatas.addCollection((CslInspectFixDataCollection)((Object)result.get("resultEntry")));
        }
        cslInspectResultInfo.setExeStatus(CslInspectStatusEnum.executed);
        CslInspectResultFactory.getLocalInstance(ctx).submit((CoreBaseInfo)cslInspectResultInfo);
        return (String)result.get("UIResult");
    }

    protected String getKey(Map<String, Object> filters) {
        return ((OrgTreeInfo)filters.get("orgBound")).getId().toString() + filters.get("year") + filters.get("month") + filters.get("periodType") + filters.get("inspectId");
    }

    protected void addResult(String uiResult, CslInspectFixDataCollection resultEntry, Map<String, Object> result) {
        result.put("UIResult", uiResult);
        result.put("resultEntry", (Object)resultEntry);
    }

    protected CslReportCollection getRpts(Map<String, Object> filters, String returnVal, Context ctx) throws BOSException {
        StringBuffer oqlBuffer = new StringBuffer("select ");
        oqlBuffer.append(returnVal);
        oqlBuffer.append(" where ");
        oqlBuffer.append("year =");
        oqlBuffer.append((Integer)filters.get("year"));
        oqlBuffer.append(" and period=");
        oqlBuffer.append((Integer)filters.get("month"));
        oqlBuffer.append(" and periodType=");
        oqlBuffer.append((Integer)filters.get("periodType"));
        oqlBuffer.append(" and orgTree='");
        oqlBuffer.append(((OrgTreeInfo)filters.get("orgBound")).getId());
        oqlBuffer.append("'");
        CslReportCollection collection = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(oqlBuffer.toString());
        return collection;
    }

    private String getInspectId(String key) {
        String oql = "select id where number = '" + key + "'";
        try {
            CslInspectResultInfo info = (CslInspectResultInfo)new CslInspectResult().getValue(oql);
            if (info != null) {
                return info.getId().toString();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("getInspectId error\uff1a" + (Object)((Object)e)));
        }
        catch (BOSException e) {
            logger.error((Object)("getInspectId error\uff1a" + (Object)((Object)e)));
        }
        return null;
    }

    public static String getExpMessage(Exception e) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        e.printStackTrace(new PrintWriter(buf, true));
        String expMessage = buf.toString();
        try {
            buf.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return expMessage;
    }
}

