/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.inspect.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataCollection;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.app.AbstractInspectExe;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RepairRptReceiveStatus
extends AbstractInspectExe {
    @Override
    public Map<String, Object> executeFix(Map<String, Object> filters, Context ctx) {
        HashMap<String, Object> result = new HashMap<String, String>();
        try {
            result = this.fixRptStatus(filters, ctx);
        }
        catch (Exception e) {
            result.put("UIResult", ResourceBase.getString((String)this.RES_PATH, (String)"reStatusDataDiffExRpt", (Locale)ctx.getOriginLocale()) + RepairRptReceiveStatus.getExpMessage(e));
        }
        return result;
    }

    private Map<String, Object> fixRptStatus(Map<String, Object> filters, Context ctx) throws BOSException, Exception {
        CslReportCollection collection = this.getRpts(filters, "id", ctx);
        ArrayList<BOSUuid> reportIdList = new ArrayList<BOSUuid>();
        for (int i = 0; i < collection.size(); ++i) {
            reportIdList.add(collection.get(i).getId());
        }
        Map<String, Object> result = this.repairReport(reportIdList, ctx);
        return result;
    }

    public Map<String, Object> repairReport(List<BOSUuid> cslRptIds, Context ctx) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String UIResult = "";
        if (cslRptIds == null || cslRptIds.isEmpty()) {
            UIResult = MessageFormat.format(ResourceBase.getString((String)this.RES_PATH, (String)"reStatusDataDiffRpt", (Locale)ctx.getOriginLocale()), 0) + UIResult;
            result.put("UIResult", UIResult);
            return result;
        }
        CslInspectFixDataCollection fixDatas = new CslInspectFixDataCollection();
        IReport ireport = ReportFactory.getLocalInstance((Context)ctx);
        EntityViewInfo rptView = new EntityViewInfo();
        rptView.getSelector().add(new SelectorItemInfo("*"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.AuditedStatus"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.Auditor"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.AuditTime"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.CommittedStatus"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.CommitTime"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.data"));
        rptView.setFilter(new FilterInfo());
        rptView.getFilter().getFilterItems().add(new FilterItemInfo("CslReport.id", new HashSet<BOSUuid>(cslRptIds), CompareType.INCLUDE));
        ReportCollection rpts = ireport.getReportCollection(rptView);
        CoreBaseCollection resultRpts = new CoreBaseCollection();
        for (int i = 0; i < rpts.size(); ++i) {
            ReportInfo rptInfo = rpts.get(i);
            CslReportInfo cslRptInfo = rptInfo.getCslReport();
            if (rptInfo.getAuditedStatus().equals((Object)cslRptInfo.getAuditedStatus()) && rptInfo.getData().equals(cslRptInfo.getData())) continue;
            if (!rptInfo.getAuditedStatus().equals((Object)cslRptInfo.getAuditedStatus())) {
                rptInfo.setAuditedStatus(cslRptInfo.getAuditedStatus());
                rptInfo.setAuditor(cslRptInfo.getAuditor());
                rptInfo.setAuditTime(cslRptInfo.getAuditTime());
                rptInfo.setCommittedStatus(cslRptInfo.getCommittedStatus());
                rptInfo.setCommitTime(cslRptInfo.getCommitTime());
            }
            if (!rptInfo.getData().equals(cslRptInfo.getData())) {
                rptInfo.setData(cslRptInfo.getData());
            }
            resultRpts.add((CoreBaseInfo)rptInfo);
            UIResult = UIResult + rptInfo.getName() + ";";
            CslInspectFixDataInfo fixData = new CslInspectFixDataInfo();
            fixData.setFixDataId(rptInfo.getId());
            fixDatas.add(fixData);
        }
        ireport.updateBatchData(resultRpts);
        if (UIResult.length() > 0) {
            UIResult = UIResult.substring(UIResult.length() - 1);
        }
        if (resultRpts.size() > 0) {
            UIResult = UIResult + ResourceBase.getString((String)this.RES_PATH, (String)"dataEntryTip", (Locale)ctx.getOriginLocale());
        }
        UIResult = MessageFormat.format(ResourceBase.getString((String)this.RES_PATH, (String)"reStatusDataDiffRpt", (Locale)ctx.getOriginLocale()), resultRpts.size()) + UIResult;
        result.put("UIResult", UIResult);
        result.put("resultEntry", (Object)fixDatas);
        return result;
    }
}

