/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataRepairUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.AbstractRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaCslRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaRptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaRptStyle;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.dynainnerexch.SheetStyleFiller;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.SysUtil;
import java.util.HashMap;
import java.util.Map;

public class CslRptCalculate
extends AbstractRptCalculate {
    private boolean isSupportCrossMerger = false;
    private Map uiContext = null;
    private DynaCslRptParamInfo dynaCslRptParamInfo = null;

    public CslRptCalculate(Context ctx) {
        super(ctx);
    }

    @Override
    public void prepareCalculate() throws EASBizException, BOSException {
        super.prepareCalculate();
        Map map = this.uiContext = this.reportProcessUI != null ? this.reportProcessUI.getUIContext() : new HashMap();
        if (this.isDynaCslRpt() && this.isSupportCrossMerger) {
            this.dynaCslRptParamInfo.setReportID(this.cslRptInfo.getId().toString());
        }
        if (this.calcType == 1) {
            this.uiContext.put("KEY_CALCULATESINGLEPAGE", Boolean.TRUE);
        } else if (this.calcType == 0) {
            this.uiContext.put("KEY_CALCULATESINGLEPAGE", Boolean.FALSE);
        }
    }

    @Override
    public void calculate() throws EASBizException, BOSException {
        if (this.isDynaCslRpt() && this.isSupportCrossMerger) {
            boolean isCalcSingle = Boolean.TRUE.equals(this.uiContext.get("KEY_CALCULATESINGLEPAGE"));
            boolean isAutoCalc = true;
            try {
                DynaRptStyle dynaRptStyle = new DynaRptStyle(this._ctx, this.cslRptInfo, this.book, this.dynaCslRptParamInfo.getSumMethod(), isCalcSingle);
                dynaRptStyle.getDynaRptStyle();
                HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
                HashMap<String, Map> tableValues = new HashMap<String, Map>();
                isAutoCalc = this.book.isAutoCalculate();
                this.book.setAutoCalculate(false);
                for (int i = 0; i < this.book.getSheetCount(); ++i) {
                    Sheet table = this.book.getSheet(i);
                    if (!table.isEnableCalculation()) continue;
                    Map tableMap = this.getTableMap(table);
                    DynamicTemplateUtility.setSheetSumMethod((Sheet)table, (DynaSumMethodEnum)this.dynaCslRptParamInfo.getSumMethod());
                    if (table == null) continue;
                    tables.put(table.getID(), table);
                    tableValues.put(table.getID(), tableMap);
                }
                ICSLReportCalculator calculator = null;
                calculator = this._ctx == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance(this._ctx);
                boolean doOffset = true;
                boolean includeDiffTable = false;
                Map sumResult = calculator.calculateDynaCslRpt(this.dynaCslRptParamInfo, tableValues, doOffset, includeDiffTable);
                DynaItemListener.setExeFlag((boolean)false);
                boolean isSupportInnerExch = false;
                if (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)this.cslRptInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)this.cslRptInfo.getSourceType())) {
                    ITemplate iTemplate = this._ctx == null ? TemplateFactory.getRemoteInstance() : TemplateFactory.getLocalInstance((Context)this._ctx);
                    TemplateInfo templateInfo = iTemplate.getTemplateInfo("select isSupportInnerExch where id='" + this.cslRptInfo.getTemplate().getId() + "'");
                    isSupportInnerExch = templateInfo.isIsSupportInnerExch();
                }
                this.book.setUserObject("isSupportInnerExch", (Object)isSupportInnerExch);
                DynamicTemplateUtility.clearDynaTableFirst((Book)this.book);
                this.book.removeUserObject("isSupportInnerExch");
                this.book.getUndoManager().startGroup();
                int precision = RptCalcHelper.getPrecisionByCry(this._ctx, this.cslRptInfo.getCurrency());
                DynaRptCalcHelper.fillDynaData(this._ctx, this.cslRptInfo, this.book, tables, tableValues, sumResult, precision, this.dynaCslRptParamInfo.getDisplayNumber(), this.dynaCslRptParamInfo.getSumMethod(), this.dynaCslRptParamInfo.isShowTotal(), this.dynaCslRptParamInfo.isOnlyList());
                this.uiContext.put("DynaSumMethod", this.dynaCslRptParamInfo.getSumMethod());
                this.uiContext.put("onlyList", this.dynaCslRptParamInfo.isOnlyList());
                if (this.dynaCslRptParamInfo.getSumMethod().equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
                    Sheet sheet = null;
                    for (int i = 0; i < this.book.getSheetCount(); ++i) {
                        sheet = this.book.getSheet(i);
                        DataRepairUtil.repairDynGradeParamByActualTableData(sheet);
                    }
                }
                dynaRptStyle.resetDynaRptStyle();
                if (isSupportInnerExch) {
                    SheetStyleFiller.me().fillColorOnRow(this.cslRptInfo.getId().toString(), this.book);
                }
                if (isCalcSingle) {
                    this.uiContext.put("singlePageCompanyIds", this.book.getActiveSheet().getSheetName());
                } else {
                    this.uiContext.remove("singlePageCompanyIds");
                }
                this.book.setUserObject("unitMap2SerialString", (Object)this.dynaCslRptParamInfo.unitMap2SerialString());
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            finally {
                this.book.getUndoManager().endGroup();
                DynaItemListener.setExeFlag((boolean)true);
                if (isAutoCalc) {
                    this.book.calc();
                }
                this.book.setAutoCalculate(isAutoCalc);
            }
        }
        if (this._ctx != null) {
            SysUtil.abort();
            return;
        }
        try {
            this.uiContext.remove("isCancelCalculateGuideUI");
            this.book.removeUserObject("unitMap2SerialString");
            new CslRptUIUtil().calculateReport(this.reportProcessUI, this.book, this.cslRptInfo, (Object)this.uiContext);
        }
        catch (Exception e) {
            this.reportProcessUI.handUIException((Throwable)e);
            SysUtil.abort();
        }
        Boolean isCanceled = (Boolean)this.uiContext.get("isCancelCalculateGuideUI");
        if (isCanceled != null && isCanceled.booleanValue()) {
            SysUtil.abort();
        }
    }

    @Override
    public void afterCalculate() {
        super.afterCalculate();
        if (this.uiContext != null) {
            this.uiContext.remove("KEY_CALCULATESINGLEPAGE");
            this.uiContext.remove("isCancelCalculateGuideUI");
        }
    }

    public void setSupportCrossMerger(boolean isSupportCrossMerger) {
        this.isSupportCrossMerger = isSupportCrossMerger;
    }

    private boolean isDynaCslRpt() {
        return this.cslRptInfo != null && (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)this.cslRptInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)this.cslRptInfo.getSourceType()) || RptSrcTypeEnum.DYNACSLELIMREPORT.equals((Object)this.cslRptInfo.getSourceType()));
    }

    private Map getTableMap(Sheet table) {
        Map tableMap = SumHelper.scanDynaTable(table, this.dynaCslRptParamInfo.getSumMethod(), this.dynaCslRptParamInfo.isOnlyList(), this.dynaCslRptParamInfo.isShowTotal(), this.dynaCslRptParamInfo.isOnlyListCompany());
        return tableMap;
    }

    public void setDynaCslRptParamInfo(DynaCslRptParamInfo dynaCslRptParamInfo) {
        this.dynaCslRptParamInfo = dynaCslRptParamInfo;
    }
}

