/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RelatedPartyRelationshipsFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLSysParamanager;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class RptCalcHelper {
    public static void checkRptRule(Map context, CslReportInfo cslRptInfo) throws EASBizException {
        OrgTreeInfo orgTree = null;
        FullOrgUnitInfo parentCompany = null;
        OrgUnitCollection units = null;
        Vector<OrgUnitInfo> companys = new Vector<OrgUnitInfo>(0);
        Vector<String> companyIDs = new Vector<String>(0);
        if (cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT)) {
            orgTree = cslRptInfo.getOrgTree();
            parentCompany = cslRptInfo.getOrgUnit();
            try {
                units = RptCalcHelper.getOrgUnits(orgTree, (OrgUnitInfo)parentCompany);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (units != null && units.size() > 0) {
                for (OrgUnitInfo info : units) {
                    if (info == null) continue;
                    companyIDs.add(info.getNumber());
                    companys.add(info);
                }
            }
        }
        RptCalcHelper.checkRptRule(context, cslRptInfo, companys, companyIDs);
    }

    public static void checkRptRule(Map uiContext, CslReportInfo cslRptInfo, Vector companys, Vector companyIDs) throws EASBizException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        HashMap ret = new HashMap(4);
        CslReportInfo curCslRptInfo = (CslReportInfo)cslRptInfo.clone();
        curCslRptInfo.setData(null);
        map.put("report", curCslRptInfo);
        map.put("companys", companys);
        map.put("bySumReport", Boolean.FALSE);
        Component comp = null;
        if (uiContext != null) {
            comp = (Component)uiContext.get("Owner");
            if (uiContext.containsKey("parentOwner")) {
                comp = (Component)uiContext.get("parentOwner");
            }
        }
        try {
            ret = CslRptCalculatorFactory.getRemoteInstance().checkSumRptRule(map);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        if (ret != null && ret.get("noConfirmCount") != null && (Integer)ret.get("noConfirmCount") > 0 && MsgBox.showConfirm3a((Component)comp, (String)CslRptUtil.getStringWithFormatCR("CslRpt_calculateHint", new Object[]{new Integer(companyIDs.size()), ret.get("noConfirmCount")}), (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SumRpt_NoConfirmCompany") + (String)ret.get("detail"))) == 2) {
            SysUtil.abort();
        }
    }

    public static OrgUnitCollection getOrgUnits(OrgTreeInfo orgTreeInfo, OrgUnitInfo parentCompanyInfo) throws EASBizException, BOSException {
        IOrgUnitCommon orgUtil = null;
        try {
            orgUtil = OrgUnitCommonFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        OrgUnitCollection units = null;
        boolean isByLevel = true;
        int i = Integer.parseInt(CSLSysParamanager.getSysParamValue((OrgTreeInfo)orgTreeInfo, (String)"GR_CSL_MERGETYPE_004"));
        if (i == -1) {
            throw new SumRptException(SumRptException.PLEASE_SET_SYSPARAMS);
        }
        isByLevel = i != 0;
        try {
            units = isByLevel ? orgUtil.getUnionDebtChildren(parentCompanyInfo, orgTreeInfo) : orgUtil.getUnionDebtAllOrgUnit(parentCompanyInfo, orgTreeInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"labGetLowLevelCom"), (Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"labGetLowLevelCom"), (Throwable)e);
        }
        int elimMethod = Integer.parseInt(CSLSysParamanager.getSysParamValue((OrgTreeInfo)orgTreeInfo, (String)"GR_CSL_ELIMMETHOD_001"));
        if (elimMethod == 2) {
            units = RelatedPartyRelationshipsFactory.getRemoteInstance().getHKRelationOrgUnits(units);
        }
        return units;
    }

    public static int getPrecisionByCry(Context ctx, CurrencyInfo ci) {
        int precision = 2;
        if (ci != null) {
            int i;
            CurrencyInfo info;
            block5: {
                info = ci;
                if (info.getPrecision() <= 0) {
                    try {
                        info = ctx == null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ci.getId())) : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(ci.getId()));
                    }
                    catch (Exception e) {
                        if (ctx != null) break block5;
                        MsgBox.showError((String)CslRptUtil.getString("CslRptUIUtilFailToGetCurrency"));
                        SysUtil.abort();
                    }
                }
            }
            if (info != null && (i = info.getPrecision()) > 0) {
                precision = i;
            }
        }
        return precision;
    }

    public static void refreshTableData(Map sheets, Map sheetData, int precision) {
        RptCalcHelper.refreshTableData(sheets, sheetData, precision, true);
    }

    public static void refreshTableData(Map sheets, Map sheetData, int precision, boolean isUseScalePrecision) {
        if (sheets == null || sheets.size() == 0 || sheetData == null || sheetData.size() == 0) {
            return;
        }
        for (String tableID : sheetData.keySet()) {
            if (tableID == null || tableID.trim().length() == 0) continue;
            Sheet curSheet = (Sheet)sheets.get(tableID);
            HashMap curSheetData = (HashMap)sheetData.get(tableID);
            Iterator iterCell = curSheetData.keySet().iterator();
            Object o = null;
            HashMap v = null;
            while (iterCell.hasNext()) {
                Cell cell;
                Object obj = iterCell.next();
                Point position = (Point)obj;
                BigDecimal newValue = null;
                o = curSheetData.get(position);
                if (o != null && o instanceof HashMap) {
                    v = (HashMap)curSheetData.get(position);
                    if (v != null && v.get("value") != null) {
                        newValue = isUseScalePrecision ? ((BigDecimal)v.get("value")).setScale(precision, 4) : (BigDecimal)v.get("value");
                    }
                } else if (o != null && o instanceof BigDecimal) {
                    newValue = isUseScalePrecision ? ((BigDecimal)o).setScale(precision, 4) : (BigDecimal)o;
                } else if (o != null) {
                    cell = curSheet.getCell(position.y, position.x, true);
                    cell.setValue(new Variant(o));
                    continue;
                }
                cell = curSheet.getCell(position.y, position.x, true);
                if (newValue == null) {
                    cell.setValue(Variant.nullVariant);
                    continue;
                }
                cell.setValue(new Variant((Object)newValue));
            }
        }
    }

    public static void setDataElementRelatingColor(int flag, Book book, boolean isFromTmp) {
        if (isFromTmp) {
            RptCalcHelper.setDataElementRelatingColor(flag, book);
        }
    }

    public static void setDataElementRelatingColor(int flag, Book book) {
        boolean isAmount = false;
        boolean isYTDAmount = false;
        if (flag == -1) {
            isAmount = false;
            isYTDAmount = false;
        } else if (flag == 1) {
            isAmount = true;
            isYTDAmount = false;
        } else if (flag == 2) {
            isAmount = false;
            isYTDAmount = true;
        }
        Color color = new Color(255, 255, 204);
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = book.getSheet(i);
            int rowCount = sheet.getMaxRowIndex();
            for (int y = 0; y <= rowCount; ++y) {
                int colCount = sheet.getMaxColIndex();
                for (int x = 0; x <= colCount; ++x) {
                    StyleAttributes ss;
                    ItemFormula f;
                    Range range = sheet.getRange(y, x);
                    if (range == null) continue;
                    StyleAttributes sa = Styles.getEmptySA();
                    sa.setBackground(color);
                    StyleAttributes sa1 = Styles.getEmptySA();
                    sa1.setBackground(Color.WHITE);
                    if (range == null || (f = (ItemFormula)range.getUserObject("ITEM")) == null) continue;
                    if (!StringUtils.isEmpty((String)f.getItemNumber()) && f.getDataElementNumber() != null && f.getDataElementNumber().equals("AMOUNT")) {
                        ss = isAmount ? sa : sa1;
                        range.setStyle(ss, ss);
                        continue;
                    }
                    if (StringUtils.isEmpty((String)f.getItemNumber()) || f.getDataElementNumber() == null || !f.getDataElementNumber().equals("YTDAMOUNT")) continue;
                    ss = isYTDAmount ? sa : sa1;
                    range.setStyle(ss, ss);
                }
            }
        }
    }

    public static void offsetYearAndPeriod(boolean isMergeByFiscalPeriod, boolean isSupport13Period, RptPeriodTypeEnum rptPeriodType, int reportYear, int reportPeriod, ItemFormula itemFormula, PeriodCollection periods) throws EASBizException, BOSException {
        if (isSupport13Period) {
            RPTDate13Util.getRptYearAndPeriod(itemFormula, reportYear, reportPeriod, rptPeriodType, isSupport13Period);
        } else {
            FiscalPeriodHelper.getRptYearAndPeriod(periods, itemFormula, reportYear, reportPeriod, rptPeriodType, isMergeByFiscalPeriod);
        }
    }

    public static int[] offsetYearAndPeriod(boolean isMergeByFiscalPeriod, boolean isSupport13Period, RptPeriodTypeEnum rptPeriodType, int reportYear, int reportPeriod, int offsetYear, int offsetPeriod, PeriodCollection periods) throws EASBizException, BOSException {
        if (isSupport13Period) {
            return RPTDate13Util.getRptYearAndPeriod(reportYear, reportPeriod, rptPeriodType.getValue(), offsetYear, offsetPeriod, isSupport13Period);
        }
        return FiscalPeriodHelper.getRptYearAndPeriod(periods, reportYear, reportPeriod, rptPeriodType.getValue(), offsetYear, offsetPeriod, isMergeByFiscalPeriod);
    }
}

