/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.upload;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.eas.base.permission.BasePMException;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.fi.gr.cslrpt.IRPTDataService;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.upload.ExcelReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.upload.InvokeException;
import com.kingdee.eas.fi.gr.cslrpt.upload.LogConfig;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadReportListener;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadResultInfo;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadResultInfoImpl;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadResultItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadResultItemInfoImpl;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoader;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class UpLoaderImpl
extends UpLoader {
    public static final int ALL_IN_ONE = 1;
    public static final int ONE_BY_ONE = 2;
    private int DataMODE = 2;
    private ILoginModule loginModule = null;
    String sessionId = null;
    Context ctx = null;
    private ArrayList listeners = new ArrayList();

    public UpLoaderImpl(Context _ctx) {
        this.ctx = _ctx;
    }

    public UpLoaderImpl() {
        this.ctx = null;
    }

    @Override
    public void login(LogConfig cfg) throws Exception {
    }

    public static Context innerFullLogin(ILoginModule loginModule, LoginContext ctx) throws BasePMException, EASLoginException {
        Context userCtx = null;
        try {
            userCtx = loginModule.fullLogin(ctx);
        }
        catch (BOSLoginException ble) {
            BasePMException cause = UpLoaderImpl.getBasePMException(ble);
            if (cause != null) {
                throw cause;
            }
            throw new EASLoginException(EASLoginException.EAS_LOGIN_FAIL, (Throwable)ble);
        }
        return userCtx;
    }

    private static String getDbType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2 UDB";
            }
            case 2: {
                return "Oracle";
            }
        }
        return "MS SQL Server";
    }

    public static String innerLogin(ILoginModule loginModule, LoginContext ctx) throws BasePMException, EASLoginException {
        String sessionId = null;
        try {
            sessionId = loginModule.login(ctx);
        }
        catch (BOSLoginException ble) {
            BasePMException cause = UpLoaderImpl.getBasePMException(ble);
            if (cause != null) {
                throw cause;
            }
            throw new EASLoginException(EASLoginException.EAS_LOGIN_FAIL, (Throwable)ble);
        }
        return sessionId;
    }

    private static BasePMException getBasePMException(BOSLoginException be) {
        Throwable ex = null;
        for (ex = be; ex != null && ex.getCause() != ex; ex = ex.getCause()) {
            if (!(ex instanceof BasePMException)) continue;
            return (BasePMException)ex;
        }
        return null;
    }

    @Override
    public void logout() throws Exception {
        if (this.loginModule != null) {
            this.loginModule.logout(this.sessionId);
        }
        this.loginModule = null;
        this.sessionId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOneByOneDataMode() {
        UpLoaderImpl upLoaderImpl = this;
        synchronized (upLoaderImpl) {
            this.DataMODE = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllInOneDataMode() {
        UpLoaderImpl upLoaderImpl = this;
        synchronized (upLoaderImpl) {
            this.DataMODE = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDataMode() {
        UpLoaderImpl upLoaderImpl = this;
        synchronized (upLoaderImpl) {
            return this.DataMODE;
        }
    }

    public UpLoadResultInfo upload(ExcelReportInfo info) {
        UpLoadResultInfo into = this.uploadAsy(info);
        into.waitForCompleted();
        return into;
    }

    public UpLoadResultInfo upload(ExcelReportInfo[] info) {
        UpLoadResultInfo into = this.uploadAsy(info);
        into.waitForCompleted();
        return into;
    }

    public UpLoadResultInfo uploadAsy(ExcelReportInfo info) {
        return this.uploadAsy(new ExcelReportInfo[]{info});
    }

    public UpLoadResultInfo uploadAsy(ExcelReportInfo[] info) {
        UpLoadResultInfoImpl rtInfo = new UpLoadResultInfoImpl();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            rtInfo.addUpLoadReportListener((UpLoadReportListener)it.next());
        }
        Worker t = new Worker(info, rtInfo, this.getDataMode());
        t.start();
        return rtInfo;
    }

    @Override
    public void addUpLoadReportListener(UpLoadReportListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public UpLoadResultInfo upload(String path) throws Exception {
        return this._upload(path, false);
    }

    @Override
    public UpLoadResultInfo upload(byte[] data, String excelname) throws Exception {
        return this._upload(data, excelname, false);
    }

    @Override
    public UpLoadResultInfo uploadAsy(String path) throws Exception {
        return this._upload(path, true);
    }

    @Override
    public UpLoadResultInfo uploadAsy(byte[] data, String excelname) throws Exception {
        return this._upload(data, excelname, true);
    }

    private UpLoadResultInfo _upload(byte[] data, String excelname, boolean isAsyMode) throws Exception {
        if (isAsyMode) {
            return this.uploadAsy(new ExcelReportInfo(data, excelname));
        }
        return this.upload(new ExcelReportInfo(data, excelname));
    }

    private UpLoadResultInfo _upload(String path, boolean isAsyMode) throws Exception {
        File file = new File(path);
        if (file.isDirectory()) {
            ArrayList<ExcelReportInfo> excelfiles = new ArrayList<ExcelReportInfo>();
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isFile() || !files[i].getName().toUpperCase(Locale.getDefault()).endsWith(".XLS")) continue;
                    excelfiles.add(new ExcelReportInfo(files[i].getAbsolutePath()));
                }
            }
            if (excelfiles.size() == 0) {
                throw new Exception(path + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"741_UpLoaderImpl"));
            }
            ExcelReportInfo[] excelInfo = excelfiles.toArray(new ExcelReportInfo[excelfiles.size()]);
            if (isAsyMode) {
                return this.uploadAsy(excelInfo);
            }
            return this.upload(excelInfo);
        }
        if (file.getName().toUpperCase(Locale.ENGLISH).endsWith(".XLS")) {
            if (isAsyMode) {
                return this.uploadAsy(new ExcelReportInfo(file));
            }
            return this.upload(new ExcelReportInfo(file));
        }
        throw new Exception(path + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"742_UpLoaderImpl"));
    }

    @Override
    public UpLoadResultInfo upload(InputStream in, String excelname) throws Exception {
        return this._upload(in, excelname, false);
    }

    @Override
    public UpLoadResultInfo uploadAsy(InputStream in, String excelname) throws Exception {
        return this._upload(in, excelname, true);
    }

    UpLoadResultInfo _upload(InputStream in, String excelname, boolean isAsyMode) throws Exception {
        if (isAsyMode) {
            return this.uploadAsy(new ExcelReportInfo(in, excelname));
        }
        return this.upload(new ExcelReportInfo(in, excelname));
    }

    private class Worker
    extends Thread {
        ExcelReportInfo[] info = null;
        UpLoadResultInfoImpl rtInfo = null;
        int Mode = 2;

        public Worker(ExcelReportInfo[] info, UpLoadResultInfoImpl rtInfo, int mode) {
            this.info = info;
            this.rtInfo = rtInfo;
            this.Mode = mode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.rtInfo.asyUping();
            IRPTDataService ds = null;
            try {
                ds = UpLoaderImpl.this.ctx == null ? RPTDataServiceFactory.getRemoteInstance() : RPTDataServiceFactory.getLocalInstance(UpLoaderImpl.this.ctx);
            }
            catch (Throwable a) {
                UpLoadResultItemInfo[] items = new UpLoadResultItemInfo[this.info.length];
                for (int i = 0; i < items.length; ++i) {
                    items[i] = new UpLoadResultItemInfoImpl();
                    ((UpLoadResultItemInfoImpl)items[i]).setState(3);
                    ((UpLoadResultItemInfoImpl)items[i]).setExceptionMsg(a.getMessage());
                    ((UpLoadResultItemInfoImpl)items[i]).setExcelName(this.info[i].getExcelName());
                    this.rtInfo.insertItem(items[i]);
                    InvokeException e = new InvokeException();
                    e.setResultItemInfo(items[i]);
                    e.setThrowable(a);
                    this.rtInfo.addException(e);
                    this.info[i].deleteData();
                }
                this.rtInfo.asyException();
                this.rtInfo.fireAllReportsCompletedEvent();
                return;
            }
            if (this.Mode == 2) {
                for (int i = 0; i < this.info.length; ++i) {
                    UpLoadResultItemInfo[] items = null;
                    try {
                        items = ds.uploadExcelReport(new ExcelReportInfo[]{this.info[i]});
                        continue;
                    }
                    catch (Throwable a) {
                        if (items == null) {
                            items = new UpLoadResultItemInfo[]{new UpLoadResultItemInfoImpl()};
                        }
                        ((UpLoadResultItemInfoImpl)items[0]).setState(3);
                        ((UpLoadResultItemInfoImpl)items[0]).setExceptionMsg(a.getMessage());
                        InvokeException e = new InvokeException();
                        e.setThrowable(a);
                        e.setResultItemInfo(items[0]);
                        this.rtInfo.addException(e);
                        continue;
                    }
                    finally {
                        if (items != null) {
                            ((UpLoadResultItemInfoImpl)items[0]).setExcelName(this.info[i].getExcelName());
                            this.rtInfo.insertItem(items[0]);
                            this.info[i].deleteData();
                        }
                    }
                }
            } else {
                UpLoadResultItemInfo[] items = null;
                try {
                    items = ds.uploadExcelReport(this.info);
                }
                catch (Throwable a) {
                    int i;
                    if (items == null) {
                        items = new UpLoadResultItemInfo[this.info.length];
                        for (i = 0; i < items.length; ++i) {
                            items[i] = new UpLoadResultItemInfoImpl();
                        }
                    }
                    for (i = 0; i < items.length; ++i) {
                        ((UpLoadResultItemInfoImpl)items[i]).setState(3);
                        ((UpLoadResultItemInfoImpl)items[i]).setExceptionMsg(a.getMessage());
                        InvokeException e = new InvokeException();
                        e.setThrowable(a);
                        e.setResultItemInfo(items[i]);
                        this.rtInfo.addException(e);
                    }
                }
                finally {
                    if (items != null) {
                        for (int i = 0; i < items.length; ++i) {
                            ((UpLoadResultItemInfoImpl)items[i]).setExcelName(this.info[i].getExcelName());
                            this.rtInfo.insertItem(items[i]);
                            this.info[i].deleteData();
                        }
                    }
                }
            }
            if (this.rtInfo.getExceptions() != null && this.rtInfo.getExceptions().length > 0) {
                this.rtInfo.asyException();
            } else {
                this.rtInfo.asyCompleted();
            }
            this.rtInfo.fireAllReportsCompletedEvent();
        }
    }
}

