/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.MapUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;

public class CompareChoosableCollection {
    private static final ILog LOG = LogFactory.getLog("UTIL", CompareChoosableCollection.class);

    public boolean exec(IObjectCollection newCollections, IObjectCollection oldCollections, String[] compareAttrNames) {
        int newIndex;
        int oldIndex = 0;
        int newSize = newCollections.size();
        int oldSize = oldCollections.size();
        Object fieldValue = null;
        Object oldFieldValue = null;
        LOG.debug("start compare choosable collection,attrNames is {0},sizes are {1} and {2}", new Object[]{compareAttrNames, newSize, oldSize});
        for (newIndex = 0; newIndex < newSize; ++newIndex) {
            if (!newCollections.getObject(newIndex).getBoolean("choose")) {
                LOG.debug("[{0},{1}]newCollection find a not-choosable object", new Object[]{newIndex, oldIndex});
                continue;
            }
            while (oldIndex < oldSize && !oldCollections.getObject(oldIndex).getBoolean("choose")) {
                ++oldIndex;
            }
            LOG.debug("[{0},{1}]oldCollection find a choosable object", new Object[]{newIndex, oldIndex});
            if (oldIndex >= oldSize) break;
            for (String attr : compareAttrNames) {
                fieldValue = MapUtil.getField(newCollections.getObject(newIndex), attr);
                oldFieldValue = MapUtil.getField(oldCollections.getObject(oldIndex), attr);
                if ((fieldValue == null || fieldValue.equals(oldFieldValue)) && (fieldValue != null || oldFieldValue == null)) continue;
                LOG.debug("[{0},{1}]match end ,newCollection and oldCollection fail to match,attrName is {2},attrValues is ({3}!={4})", new Object[]{newIndex, oldIndex, attr, fieldValue, oldFieldValue});
                return false;
            }
            ++oldIndex;
        }
        while (oldIndex != oldSize) {
            if (oldCollections.getObject(oldIndex).getBoolean("choose")) {
                LOG.debug("[{0},{1}]match end ,oldCollection find a choosable object without newCollection's object ", new Object[]{newIndex, oldIndex});
                return false;
            }
            ++oldIndex;
        }
        LOG.debug("[{0},{1}]match end ", new Object[]{newIndex, oldIndex});
        return newIndex == newSize && oldIndex == oldSize;
    }
}

